/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.memory;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.shapers.Rectangular;
import edu.xtec.util.JDomUtility;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jdom.Element;

public class MemoryGame
extends Activity
implements ActiveBagContentKit.Compatible {
    public MemoryGame(JClicProject project) {
        super(project);
        this.boxGridPos = 0;
        this.abc = new ActiveBagContent[2];
    }

    @Override
    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew(3, 2, 65);
    }

    @Override
    public Element getJDomElement() {
        if (this.abc[0] == null) {
            return null;
        }
        Element e = super.getJDomElement();
        e.addContent(this.abc[0].getJDomElement().setAttribute("id", "primary"));
        if (this.abc[1] != null) {
            e.addContent(this.abc[1].getJDomElement().setAttribute("id", "secondary"));
        }
        Element ex = new Element("scramble");
        ex.setAttribute("times", Integer.toString(this.shuffles));
        e.addContent(ex);
        ex = new Element("layout");
        ex.setAttribute("position", LAYOUT_NAMES[this.boxGridPos]);
        e.addContent(ex);
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        Element child2;
        super.setProperties(e, aux);
        this.abc[1] = null;
        for (Element child2 : e.getChildren("cells")) {
            ActiveBagContent bag = ActiveBagContent.getActiveBagContent(child2, this.project.mediaBag);
            String id = JDomUtility.getStringAttr(child2, "id", "primary", false);
            if ("primary".equals(id)) {
                this.abc[0] = bag;
                continue;
            }
            if (!"secondary".equals(id)) continue;
            this.abc[1] = bag;
        }
        if (this.abc[0] == null) {
            throw new IllegalArgumentException("Memory game without ActiveBagContent");
        }
        child2 = e.getChild("scramble");
        if (child2 != null) {
            this.shuffles = JDomUtility.getIntAttr(child2, "times", this.shuffles);
        }
        if ((child2 = e.getChild("layout")) != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr(child2, "position", LAYOUT_NAMES, this.boxGridPos);
        }
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        this.abc[0] = c3a.createActiveBagContent(0);
        this.abc[0].setBoxBase(c3a.getBoxBase(0));
        this.boxGridPos = c3a.graPos;
    }

    @Override
    public int getMinNumActions() {
        return this.abc[0] == null ? 0 : this.abc[0].getNumCells();
    }

    @Override
    public boolean hasRandom() {
        return true;
    }

    @Override
    public boolean shuffleAlways() {
        return true;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    class Panel
    extends Activity.Panel {
        ActiveBoxBag bg;

        protected Panel(PlayStation ps) {
            super(ps);
            this.bc = new BoxConnector(this);
        }

        @Override
        public void clear() {
            if (this.bg != null) {
                this.bg.end();
                this.bg = null;
            }
        }

        @Override
        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (MemoryGame.this.abc[0] != null) {
                if (MemoryGame.this.acp != null) {
                    ActiveBagContent[] activeBagContentArray;
                    if (MemoryGame.this.abc[1] == null) {
                        ActiveBagContent[] activeBagContentArray2 = new ActiveBagContent[1];
                        activeBagContentArray = activeBagContentArray2;
                        activeBagContentArray2[0] = MemoryGame.this.abc[0];
                    } else {
                        ActiveBagContent[] activeBagContentArray3 = new ActiveBagContent[2];
                        activeBagContentArray3[0] = MemoryGame.this.abc[0];
                        activeBagContentArray = activeBagContentArray3;
                        activeBagContentArray3[1] = MemoryGame.this.abc[1];
                    }
                    ActiveBagContent[] abcPass = activeBagContentArray;
                    MemoryGame.this.acp.generateContent(new ActiveBagContentKit(MemoryGame.this.abc[0].nch, MemoryGame.this.abc[0].ncw, abcPass, false), this.ps);
                }
                int ncw = MemoryGame.this.abc[0].ncw;
                int nch = MemoryGame.this.abc[0].nch;
                if (MemoryGame.this.boxGridPos == 0 || MemoryGame.this.boxGridPos == 1) {
                    ncw *= 2;
                } else {
                    nch *= 2;
                }
                this.bg = new ActiveBoxGrid(null, this, MemoryGame.this.margin, MemoryGame.this.margin, MemoryGame.this.abc[0].w * (double)ncw, MemoryGame.this.abc[0].h * (double)nch, new Rectangular(ncw, nch), MemoryGame.this.abc[0].bb);
                int nc = MemoryGame.this.abc[0].getNumCells();
                this.bg.setBorder(MemoryGame.this.abc[0].border);
                this.bg.setContent(MemoryGame.this.abc[0], null, 0, 0, nc);
                this.bg.setContent(MemoryGame.this.abc[1] != null ? MemoryGame.this.abc[1] : MemoryGame.this.abc[0], null, 0, nc, nc);
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < nc; ++j) {
                        ActiveBox bx = this.bg.getActiveBox(i * nc + j);
                        bx.setIdAss(j);
                        bx.setInactive(true);
                    }
                }
                this.bg.setVisible(true);
                this.invalidate();
            }
        }

        @Override
        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            } else {
                this.firstRun = false;
            }
            this.setAndPlayMsg(1, 0);
            if (this.bg != null) {
                this.shuffle(new ActiveBoxBag[]{this.bg}, false, true);
                this.playing = true;
            }
        }

        @Override
        public void render(Graphics2D g2, Rectangle dirtyRegion) {
            if (this.bg != null) {
                this.bg.update(g2, dirtyRegion, this);
            }
            if (this.bc.active) {
                this.bc.update(g2, dirtyRegion, this);
            }
        }

        @Override
        public Dimension setDimension(Dimension preferredMaxSize) {
            if (this.bg == null || this.getSize().equals(preferredMaxSize)) {
                return preferredMaxSize;
            }
            return BoxBag.layoutSingle(preferredMaxSize, this.bg, MemoryGame.this.margin);
        }

        @Override
        public void processMouse(MouseEvent e) {
            Point p = e.getPoint();
            if (this.playing) {
                switch (e.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        if (this.bc.active) {
                            ActiveBox bx2;
                            this.bc.end();
                            ActiveBox bx1 = this.bg.findActiveBox(this.bc.origin);
                            if (bx1 != null && (bx2 = this.bg.findActiveBox(p)) != null && bx1.idAss != -1 && bx2.idAss != -1) {
                                if (bx1 != bx2) {
                                    boolean ok = false;
                                    if (bx1.idAss == bx2.idAss || bx1.getContent().isEquivalent(bx2.getContent(), true)) {
                                        ok = true;
                                        bx1.setIdAss(-1);
                                        bx2.setIdAss(-1);
                                        bx1.setInactive(false);
                                        bx2.setInactive(false);
                                    } else {
                                        bx1.setInactive(true);
                                        if (MemoryGame.this.dragCells) {
                                            bx2.setInactive(true);
                                        } else {
                                            bx2.setInactive(false);
                                            this.bc.begin(p);
                                        }
                                    }
                                    boolean m = bx2.playMedia(this.ps);
                                    int cellsAtPlace = this.bg.countCellsWithIdAss(-1);
                                    this.ps.reportNewAction(this.getActivity(), "MATCH", bx1.getDescription(), bx2.getDescription(), ok, cellsAtPlace / 2);
                                    if (ok && cellsAtPlace == this.bg.getNumCells()) {
                                        this.finishActivity(true);
                                    } else if (!m) {
                                        this.playEvent(ok ? 3 : 2);
                                    }
                                } else {
                                    this.playEvent(1);
                                    bx1.setInactive(true);
                                }
                            } else if (bx1 != null) {
                                bx1.setInactive(true);
                            }
                            this.repaint();
                            break;
                        }
                        ActiveBox bx1 = this.bg.findActiveBox(p);
                        if (bx1 == null || bx1.idAss == -1) break;
                        if (MemoryGame.this.dragCells) {
                            this.bc.begin(p, bx1);
                        } else {
                            this.bc.begin(p);
                        }
                        boolean m = bx1.playMedia(this.ps);
                        if (!m) {
                            this.playEvent(1);
                        }
                        bx1.setInactive(false);
                        break;
                    }
                    case 503: 
                    case 506: {
                        this.bc.moveTo(p);
                    }
                }
            }
        }
    }
}

