/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.project.LibraryManager;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.LFUtil;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class PlayerSettingsDlg
extends ExtendedJDialog {
    PlayerSettings settings;
    public boolean result;
    Component parent;
    LibraryManager libraryManager;
    Messages msg;
    Map<String, Object> reporterOptions;
    private JCheckBox autoRunLibChk;
    private JTextField browserField;
    private JTextField countryField;
    private JPanel editLibPanel;
    private JRadioButton jdbcBtn;
    private JComboBox langCombo;
    private JComboBox<Object> lookCombo;
    private JRadioButton mDefaultBtn;
    private JRadioButton mJMFbtn;
    private JRadioButton mQTbtn;
    private JRadioButton otherBtn;
    private JCheckBox pwdCheck;
    private JPasswordField pwdField1;
    private JPasswordField pwdField2;
    private JCheckBox reportChk;
    private JTextField rpAddressTxt;
    private JTextField rpClassTxt;
    private JTextField rpDriverTxt;
    private JTextField rpParamsTxt;
    private JPasswordField rpPwdTxt;
    private JTextField rpUrlTxt;
    private JTextField rpUserTxt;
    private JComboBox skinCombo;
    private JCheckBox soundEnabledChk;
    private JCheckBox systemSoundsChk;
    private JRadioButton tcpBtn;
    private JTextField variantField;

    public PlayerSettingsDlg(PlayerSettings settings, Component parent) {
        super(parent, "", true);
        this.parent = parent;
        this.settings = settings;
        this.msg = settings.getMessages();
        this.setTitle(this.msg.get("settings_title"));
        try {
            this.libraryManager = LibraryManager.getLibraryManager(settings, settings.libraryManager.getJDomElement());
        }
        catch (Exception ex) {
            this.msg.showErrorWarning(this, "library_error_clone", ex);
            this.libraryManager = settings.libraryManager;
        }
        this.result = false;
        this.reporterOptions = new HashMap<String, Object>();
        Options.strToMap(settings.reporterParams, this.reporterOptions, ";", '=', false);
        this.initComponents();
        this.checkEnabled(null);
        this.centerOver(parent);
    }

    private void initComponents() {
        ButtonGroup reportGroup = new ButtonGroup();
        ButtonGroup mediaGroup = new ButtonGroup();
        JTabbedPane mainPane = new JTabbedPane();
        JPanel securityPane = new JPanel();
        this.pwdCheck = new JCheckBox();
        JLabel pwdLb1 = new JLabel();
        this.pwdField1 = new JPasswordField(this.settings.password, 20);
        JLabel pwdLb2 = new JLabel();
        this.pwdField2 = new JPasswordField(this.settings.password, 20);
        JPanel generalPane = new JPanel();
        JLabel lookLb = new JLabel();
        this.lookCombo = new JComboBox<String>(LFUtil.VALUES);
        JLabel skinLb = new JLabel();
        this.skinCombo = new JComboBox<String>(Skin.getSystemSkinList(false));
        JLabel langLb = new JLabel();
        this.langCombo = new JComboBox<String>(Messages.getDescriptiveLanguageCodes(this.msg.getLocale()));
        JLabel countryLb = new JLabel();
        this.countryField = new JTextField();
        JLabel variantLb = new JLabel();
        this.variantField = new JTextField();
        JLabel browserLb = new JLabel();
        this.browserField = new JTextField();
        JPanel reportPane = new JPanel();
        this.reportChk = new JCheckBox();
        JPanel reportOptionsPanel = new JPanel();
        this.tcpBtn = new JRadioButton();
        JLabel rpAddressLb = new JLabel();
        this.rpAddressTxt = new JTextField();
        this.jdbcBtn = new JRadioButton();
        JLabel rpDriverLb = new JLabel();
        this.rpDriverTxt = new JTextField();
        JLabel rpUrlLb = new JLabel();
        this.rpUrlTxt = new JTextField();
        JLabel rpUserLb = new JLabel();
        this.rpUserTxt = new JTextField();
        JLabel rpPwdLb = new JLabel();
        this.rpPwdTxt = new JPasswordField();
        this.otherBtn = new JRadioButton();
        JLabel rpClassLb = new JLabel();
        this.rpClassTxt = new JTextField();
        JLabel rpParamsLb = new JLabel();
        this.rpParamsTxt = new JTextField();
        JPanel mediaPane = new JPanel();
        this.soundEnabledChk = new JCheckBox();
        JPanel mediaSystemPanel = new JPanel();
        this.mDefaultBtn = new JRadioButton();
        this.mJMFbtn = new JRadioButton();
        this.mQTbtn = new JRadioButton();
        this.systemSoundsChk = new JCheckBox();
        JPanel libraryPane = new JPanel();
        this.autoRunLibChk = new JCheckBox();
        this.editLibPanel = this.libraryManager.getLibraryPane(true, true);
        JPanel btPanel = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PlayerSettingsDlg.this.closeDialog(evt);
            }
        });
        mainPane.setToolTipText(this.msg.get("settings_report_tooltip"));
        mainPane.setPreferredSize(new Dimension(500, 400));
        securityPane.setToolTipText(this.msg.get("settings_security_tooltip"));
        securityPane.setLayout(new GridBagLayout());
        this.pwdCheck.setSelected(this.settings.password != null);
        this.pwdCheck.setText(this.msg.get("settings_password_protect"));
        this.pwdCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerSettingsDlg.this.pwdCheckActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        securityPane.add((Component)this.pwdCheck, gridBagConstraints);
        pwdLb1.setText(this.msg.get("settings_new_password"));
        pwdLb1.setLabelFor(this.pwdField1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        securityPane.add((Component)pwdLb1, gridBagConstraints);
        this.pwdField1.setEnabled(this.settings.password != null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        securityPane.add((Component)this.pwdField1, gridBagConstraints);
        pwdLb2.setText(this.msg.get("settings_new_password_confirm"));
        pwdLb2.setLabelFor(this.pwdField2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        securityPane.add((Component)pwdLb2, gridBagConstraints);
        this.pwdField2.setEnabled(this.settings.password != null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        securityPane.add((Component)this.pwdField2, gridBagConstraints);
        mainPane.addTab(this.msg.get("settings_security"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/security.gif")), securityPane, "");
        generalPane.setToolTipText(this.msg.get("settings_general_tooltip"));
        generalPane.setLayout(new GridBagLayout());
        lookLb.setLabelFor(this.lookCombo);
        lookLb.setText(this.msg.get("settings_look"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)lookLb, gridBagConstraints);
        this.lookCombo.setSelectedItem(this.settings.lookAndFeel);
        this.lookCombo.setToolTipText(this.msg.get("settings_look_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add(this.lookCombo, gridBagConstraints);
        skinLb.setLabelFor(this.skinCombo);
        skinLb.setText(this.msg.get("settings_skin"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)skinLb, gridBagConstraints);
        this.skinCombo.setEditable(true);
        this.skinCombo.setSelectedItem(this.settings.skin);
        this.skinCombo.setToolTipText(this.msg.get("settings_skin_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)this.skinCombo, gridBagConstraints);
        langLb.setLabelFor(this.langCombo);
        langLb.setText(this.msg.get("settings_language"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)langLb, gridBagConstraints);
        this.langCombo.setSelectedItem(Messages.getDescriptiveLanguageCode(this.settings.language));
        this.langCombo.setToolTipText(this.msg.get("settings_language_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)this.langCombo, gridBagConstraints);
        countryLb.setLabelFor(this.countryField);
        countryLb.setText(this.msg.get("settings_country"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)countryLb, gridBagConstraints);
        this.countryField.setText(this.settings.country);
        this.countryField.setToolTipText(this.msg.get("settings_country_tooltip"));
        this.countryField.setMinimumSize(new Dimension(75, 21));
        this.countryField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)this.countryField, gridBagConstraints);
        variantLb.setLabelFor(this.variantField);
        variantLb.setText(this.msg.get("settings_variant"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)variantLb, gridBagConstraints);
        this.variantField.setText(this.settings.variant);
        this.variantField.setToolTipText(this.msg.get("settings_variant_tooltip"));
        this.variantField.setMinimumSize(new Dimension(75, 21));
        this.variantField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)this.variantField, gridBagConstraints);
        browserLb.setText(this.msg.get("settings_browser"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)browserLb, gridBagConstraints);
        this.browserField.setText(this.settings.preferredBrowser);
        this.browserField.setToolTipText(this.msg.get("settings_browser_tooltip"));
        this.browserField.setMinimumSize(new Dimension(75, 21));
        this.browserField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)this.browserField, gridBagConstraints);
        mainPane.addTab(this.msg.get("settings_general"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/settings.gif")), generalPane, "");
        reportPane.setLayout(new GridBagLayout());
        this.reportChk.setToolTipText(this.msg.get("settings_report_use_tooltip"));
        this.reportChk.setSelected(this.settings.reporterEnabled);
        this.reportChk.setText(this.msg.get("settings_report_use"));
        this.reportChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerSettingsDlg.this.reportChkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportPane.add((Component)this.reportChk, gridBagConstraints);
        reportOptionsPanel.setBorder(BorderFactory.createTitledBorder(this.msg.get("settings_report_type")));
        reportOptionsPanel.setLayout(new GridBagLayout());
        reportGroup.add(this.tcpBtn);
        this.tcpBtn.setSelected(this.settings.reporterClass.equals("TCPReporter") && (this.settings.reporterParams == null || this.settings.reporterParams.indexOf(";") < 0));
        this.tcpBtn.setText(this.msg.get("settings_report_tcp"));
        this.tcpBtn.setToolTipText(this.msg.get("settings_report_tcp_tooltip"));
        this.tcpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerSettingsDlg.this.tcpBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportOptionsPanel.add((Component)this.tcpBtn, gridBagConstraints);
        rpAddressLb.setText(this.msg.get("settings_report_address"));
        rpAddressLb.setLabelFor(this.rpAddressTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        reportOptionsPanel.add((Component)rpAddressLb, gridBagConstraints);
        this.rpAddressTxt.setText(Options.getString(this.reporterOptions, "path", "localhost:9000"));
        this.rpAddressTxt.setToolTipText(this.msg.get("settings_report_address_tooltip"));
        this.rpAddressTxt.setPreferredSize(new Dimension(80, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportOptionsPanel.add((Component)this.rpAddressTxt, gridBagConstraints);
        reportGroup.add(this.jdbcBtn);
        this.jdbcBtn.setSelected(this.settings.reporterClass.equals("JDBCReporter"));
        this.jdbcBtn.setText(this.msg.get("settings_report_jdbc"));
        this.jdbcBtn.setToolTipText(this.msg.get("settings_report_jdbc_tooltip"));
        this.jdbcBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerSettingsDlg.this.jdbcBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportOptionsPanel.add((Component)this.jdbcBtn, gridBagConstraints);
        rpDriverLb.setText(this.msg.get("settings_report_driver"));
        rpDriverLb.setLabelFor(this.rpDriverTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        reportOptionsPanel.add((Component)rpDriverLb, gridBagConstraints);
        this.rpDriverTxt.setText(Options.getString(this.reporterOptions, "driver", "sun.jdbc.odbc.JdbcOdbcDriver"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportOptionsPanel.add((Component)this.rpDriverTxt, gridBagConstraints);
        rpUrlLb.setText(this.msg.get("settings_report_url"));
        rpUrlLb.setLabelFor(this.rpUrlTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        reportOptionsPanel.add((Component)rpUrlLb, gridBagConstraints);
        this.rpUrlTxt.setText(Options.getString(this.reporterOptions, "url", "jdbc:odbc:JClic"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportOptionsPanel.add((Component)this.rpUrlTxt, gridBagConstraints);
        rpUserLb.setText(this.msg.get("settings_report_user"));
        rpUserLb.setLabelFor(this.rpUserTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        reportOptionsPanel.add((Component)rpUserLb, gridBagConstraints);
        this.rpUserTxt.setText(Options.getString(this.reporterOptions, "system_user", null));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportOptionsPanel.add((Component)this.rpUserTxt, gridBagConstraints);
        rpPwdLb.setText(this.msg.get("settings_report_pwd"));
        rpPwdLb.setLabelFor(this.rpPwdTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        reportOptionsPanel.add((Component)rpPwdLb, gridBagConstraints);
        this.rpPwdTxt.setText(Options.getString(this.reporterOptions, "system_pwd", null));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportOptionsPanel.add((Component)this.rpPwdTxt, gridBagConstraints);
        reportGroup.add(this.otherBtn);
        this.otherBtn.setSelected(!this.tcpBtn.isSelected() && !this.jdbcBtn.isSelected());
        this.otherBtn.setText(this.msg.get("settings_report_other"));
        this.otherBtn.setToolTipText(this.msg.get("settings_report_other_tooltip"));
        this.otherBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerSettingsDlg.this.otherBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportOptionsPanel.add((Component)this.otherBtn, gridBagConstraints);
        rpClassLb.setText(this.msg.get("settings_report_engine"));
        rpClassLb.setLabelFor(this.rpClassTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        reportOptionsPanel.add((Component)rpClassLb, gridBagConstraints);
        this.rpClassTxt.setText(this.otherBtn.isSelected() ? this.settings.reporterClass : null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportOptionsPanel.add((Component)this.rpClassTxt, gridBagConstraints);
        rpParamsLb.setText(this.msg.get("settings_report_params"));
        rpParamsLb.setLabelFor(this.rpParamsTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        reportOptionsPanel.add((Component)rpParamsLb, gridBagConstraints);
        this.rpParamsTxt.setText(this.otherBtn.isSelected() ? this.settings.reporterParams : null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportOptionsPanel.add((Component)this.rpParamsTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        reportPane.add((Component)reportOptionsPanel, gridBagConstraints);
        mainPane.addTab(this.msg.get("settings_reports"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/report_small.gif")), reportPane, "");
        mediaPane.setToolTipText(this.msg.get("settings_media_tooltip"));
        mediaPane.setLayout(new GridBagLayout());
        this.soundEnabledChk.setSelected(this.settings.soundEnabled);
        this.soundEnabledChk.setText(this.msg.get("settings_media_enabled"));
        this.soundEnabledChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerSettingsDlg.this.soundEnabledChkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mediaPane.add((Component)this.soundEnabledChk, gridBagConstraints);
        mediaSystemPanel.setBorder(BorderFactory.createTitledBorder(this.msg.get("settings_media_system")));
        mediaSystemPanel.setLayout(new GridBagLayout());
        mediaGroup.add(this.mDefaultBtn);
        this.mDefaultBtn.setSelected("default".equals(this.settings.mediaSystem));
        this.mDefaultBtn.setText(this.msg.get("settings_media_default"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        mediaSystemPanel.add((Component)this.mDefaultBtn, gridBagConstraints);
        mediaGroup.add(this.mJMFbtn);
        this.mJMFbtn.setSelected("Java Media Framework".equals(this.settings.mediaSystem));
        this.mJMFbtn.setText(this.msg.get("settings_media_jmf"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        mediaSystemPanel.add((Component)this.mJMFbtn, gridBagConstraints);
        mediaGroup.add(this.mQTbtn);
        this.mQTbtn.setSelected("QuickTime".equals(this.settings.mediaSystem));
        this.mQTbtn.setText(this.msg.get("settings_media_qt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        mediaSystemPanel.add((Component)this.mQTbtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mediaPane.add((Component)mediaSystemPanel, gridBagConstraints);
        this.systemSoundsChk.setSelected(this.settings.systemSounds);
        this.systemSoundsChk.setText(this.msg.get("settings_media_event_sounds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mediaPane.add((Component)this.systemSoundsChk, gridBagConstraints);
        mainPane.addTab(this.msg.get("settings_media"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/audio_on.gif")), mediaPane, "");
        libraryPane.setToolTipText(this.msg.get("settings_library_tooltip"));
        libraryPane.setLayout(new GridBagLayout());
        this.autoRunLibChk.setSelected(this.libraryManager.autoRun);
        this.autoRunLibChk.setText(this.msg.get("settings_library_autorun"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        libraryPane.add((Component)this.autoRunLibChk, gridBagConstraints);
        this.editLibPanel.setBorder(BorderFactory.createTitledBorder(this.msg.get("settings_library")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        libraryPane.add((Component)this.editLibPanel, gridBagConstraints);
        mainPane.addTab(this.msg.get("settings_library"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/database.gif")), libraryPane, "");
        this.getContentPane().add((Component)mainPane, "Center");
        okButton.setText(this.msg.get("OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerSettingsDlg.this.okButtonActionPerformed(evt);
            }
        });
        btPanel.add(okButton);
        cancelButton.setText(this.msg.get("CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerSettingsDlg.this.cancelButtonActionPerformed(evt);
            }
        });
        btPanel.add(cancelButton);
        this.getContentPane().add((Component)btPanel, "South");
        this.pack();
    }

    private void soundEnabledChkActionPerformed(ActionEvent evt) {
        this.checkEnabled(this.soundEnabledChk);
    }

    private void otherBtnActionPerformed(ActionEvent evt) {
        this.checkEnabled(this.reportChk);
    }

    private void jdbcBtnActionPerformed(ActionEvent evt) {
        this.checkEnabled(this.reportChk);
    }

    private void tcpBtnActionPerformed(ActionEvent evt) {
        this.checkEnabled(this.reportChk);
    }

    private void reportChkActionPerformed(ActionEvent evt) {
        this.checkEnabled(this.reportChk);
    }

    private void pwdCheckActionPerformed(ActionEvent evt) {
        this.checkEnabled(this.pwdCheck);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = false;
        this.closeDialog(null);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.accept()) {
            this.result = true;
            this.closeDialog(null);
        }
    }

    public boolean accept() {
        String p1 = null;
        if (this.pwdCheck.isSelected()) {
            p1 = StrUtils.nullableString(String.copyValueOf(this.pwdField1.getPassword()));
            String p2 = StrUtils.nullableString(String.copyValueOf(this.pwdField2.getPassword()));
            if (p1 == null || p2 == null || !p1.equals(p2)) {
                this.msg.showAlert((Component)this, "PASSWORD_INCORRECT");
                return false;
            }
        } else {
            this.settings.password = null;
        }
        if (this.tcpBtn.isSelected()) {
            String server = this.rpAddressTxt.getText();
            if (server == null || server.length() < 1) {
                this.msg.showAlert((Component)this, "settings_report_err_server");
                return false;
            }
            this.settings.reporterClass = "TCPReporter";
            this.settings.reporterParams = new StringBuilder("path").append("=").append(server).substring(0);
        } else if (this.jdbcBtn.isSelected()) {
            String driver = StrUtils.nullableString(this.rpDriverTxt.getText());
            String url = StrUtils.nullableString(this.rpUrlTxt.getText());
            String usr = this.rpUserTxt.getText();
            String pwd = String.copyValueOf(this.rpPwdTxt.getPassword());
            if (driver == null || url == null) {
                this.msg.showAlert((Component)this, "settings_report_err");
                return false;
            }
            this.settings.reporterClass = "JDBCReporter";
            StringBuilder sb = new StringBuilder("driver=").append(driver);
            sb.append(";url=").append(url);
            if (usr != null) {
                sb.append(";system_user=").append(usr);
                if (pwd != null) {
                    sb.append(";system_pwd=").append(pwd);
                }
            }
            this.settings.reporterParams = sb.substring(0);
        } else {
            this.settings.reporterClass = this.rpClassTxt.getText();
            this.settings.reporterParams = this.rpParamsTxt.getText();
        }
        this.settings.password = p1;
        this.settings.passwordConfirmed = false;
        this.settings.lookAndFeel = (String)this.lookCombo.getSelectedItem();
        this.settings.preferredBrowser = this.browserField.getText();
        this.settings.skin = (String)this.skinCombo.getSelectedItem();
        this.settings.language = Messages.getLanguageFromDescriptive((String)this.langCombo.getSelectedItem());
        this.settings.country = StrUtils.nullableString(this.countryField.getText());
        this.settings.variant = StrUtils.nullableString(this.variantField.getText());
        this.settings.reporterEnabled = this.reportChk.isSelected();
        this.settings.soundEnabled = this.soundEnabledChk.isSelected();
        this.settings.mediaSystem = this.mJMFbtn.isSelected() ? "Java Media Framework" : (this.mQTbtn.isSelected() ? "QuickTime" : "default");
        this.settings.systemSounds = this.systemSoundsChk.isSelected();
        this.libraryManager.autoRun = this.autoRunLibChk.isSelected();
        this.settings.libraryManager = this.libraryManager;
        return true;
    }

    private void checkEnabled(JComponent cmp) {
        if (cmp == null || cmp == this.reportChk) {
            this.enable(this.tcpBtn, this.reportChk, null);
            this.enable(this.rpAddressTxt, this.tcpBtn, this.reportChk);
            this.enable(this.jdbcBtn, this.reportChk, null);
            this.enable(this.rpDriverTxt, this.jdbcBtn, this.reportChk);
            this.enable(this.rpUrlTxt, this.jdbcBtn, this.reportChk);
            this.enable(this.rpUserTxt, this.jdbcBtn, this.reportChk);
            this.enable(this.rpPwdTxt, this.jdbcBtn, this.reportChk);
            this.enable(this.otherBtn, this.reportChk, null);
            this.enable(this.rpClassTxt, this.otherBtn, this.reportChk);
            this.enable(this.rpParamsTxt, this.otherBtn, this.reportChk);
        }
        if (cmp == null || cmp == this.pwdCheck) {
            this.enable(this.pwdField1, this.pwdCheck, null);
            this.enable(this.pwdField2, this.pwdCheck, null);
        }
        if (cmp == null || cmp == this.soundEnabledChk) {
            this.enable(this.mDefaultBtn, this.soundEnabledChk, null);
            this.enable(this.mJMFbtn, this.soundEnabledChk, null);
            this.enable(this.mQTbtn, this.soundEnabledChk, null);
            this.enable(this.systemSoundsChk, this.soundEnabledChk, null);
        }
    }

    private void enable(JComponent cmp, JToggleButton tg1, JToggleButton tg2) {
        boolean current;
        boolean b;
        if (cmp != null && tg1 != null && (b = tg1.isSelected() && (tg2 == null || tg2.isSelected())) != (current = cmp.isEnabled())) {
            cmp.setEnabled(b);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

