/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.PlayerSettingsDlg;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.LibraryManager;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.Domable;
import edu.xtec.util.Encryption;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceBridge;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;

public class PlayerSettings
implements Cloneable,
Constants,
Domable {
    public ResourceBridge rb;
    public LibraryManager libraryManager;
    public String language;
    public String country;
    public String variant;
    public String reporterClass;
    public String reporterParams;
    public boolean reporterEnabled;
    public boolean soundEnabled;
    public boolean systemSounds;
    public String lookAndFeel;
    public String skin;
    public Map<String, String> misc;
    public String rootPath;
    public String mediaSystem;
    public FileSystem fileSystem;
    public static int MAX_RECENT = 8;
    public String[] recentFiles;
    public String preferredBrowser;
    protected String password;
    protected boolean passwordConfirmed;
    public String cfgFile;
    public boolean readOnly;
    protected static String defaultCfgFile = null;
    public static final String PROJECTS_PATH = "projects";
    public static final String CFG_FILE = "jclic.cfg";
    public static final String DEFAULT_SKIN = "@default.xml";
    public static final String DEFAULT_REPORTER = "TCPReporter";
    public static final String DEFAULT_REPORTER_PARAMS = "path=localhost:9000";
    public boolean fressaEnabled;
    public static final String ELEMENT_NAME = "JClicSettings";
    public static final String REPORTER = "reporter";
    public static final String CLASS = "class";
    public static final String PARAMS = "params";
    public static final String SOUND = "sound";
    public static final String SYSTEM = "system";
    public static final String MISC = "misc";
    public static final String PATHS = "paths";
    public static final String PATH = "path";
    public static final String ROOT = "root";
    public static final String RECENT_FILES = "recentFiles";
    public static final String FILE = "file";
    public static final String PASSWORD = "password";

    public PlayerSettings(ResourceBridge rb, String fromPath) {
        File f;
        this.rb = rb;
        this.password = null;
        this.misc = new HashMap<String, String>();
        this.reporterEnabled = false;
        this.reporterClass = DEFAULT_REPORTER;
        this.reporterParams = DEFAULT_REPORTER_PARAMS;
        this.soundEnabled = true;
        this.systemSounds = true;
        this.lookAndFeel = "default";
        this.preferredBrowser = "";
        this.skin = DEFAULT_SKIN;
        this.recentFiles = new String[MAX_RECENT];
        this.mediaSystem = "default";
        this.readOnly = false;
        this.rootPath = System.getProperty("user.home");
        this.cfgFile = fromPath == null ? PlayerSettings.getDefaultCfgFile(rb.getOptions()) : fromPath;
        this.fileSystem = new FileSystem(rb);
        this.readOnly = FileSystem.isStrUrl(this.cfgFile) ? true : !(f = new File(this.cfgFile)).canWrite();
        this.libraryManager = new LibraryManager(this);
        this.passwordConfirmed = false;
    }

    public static String getDefaultCfgFile(Options options) {
        if (defaultCfgFile == null) {
            defaultCfgFile = PersistentSettings.getFilePath("JClic", CFG_FILE, options, true);
        }
        return defaultCfgFile;
    }

    public static PlayerSettings loadPlayerSettings(ResourceBridge rb) {
        PlayerSettings result = null;
        String cfgFile = rb.getOptions().getString(ELEMENT_NAME);
        if (cfgFile != null) {
            try {
                result = new PlayerSettings(rb, cfgFile);
                result.loadSettings(result.fileSystem.getXMLDocument(cfgFile).getRootElement());
            }
            catch (Exception ex) {
                result = null;
                System.err.println("Unable to read settings from " + cfgFile + "\n" + ex);
            }
        }
        if (result == null) {
            cfgFile = PlayerSettings.getDefaultCfgFile(rb.getOptions());
            result = new PlayerSettings(rb, cfgFile);
            try {
                result.loadSettings(result.fileSystem.getXMLDocument(cfgFile).getRootElement());
            }
            catch (Exception ex) {
                result.initNewSettings();
            }
        }
        rb.getOptions().syncProperties(result.getProperties(), true);
        if (!rb.getOptions().getBoolean("languageByParam") && result.language != null) {
            rb.getOptions().put("language", result.language);
            if (result.country != null) {
                rb.getOptions().put("country", result.country);
            }
            if (result.variant != null) {
                rb.getOptions().put("variant", result.variant);
            }
        }
        return result;
    }

    private void initNewSettings() {
        try {
            Messages msg = this.rb.getOptions().getMessages();
            if (this.language == null) {
                this.language = msg.getLocale().getLanguage();
                this.country = msg.getLocale().getCountry();
                this.variant = msg.getLocale().getVariant();
            }
            this.readOnly = false;
            File f = new File(new File(this.cfgFile).getParentFile(), PROJECTS_PATH);
            f.mkdirs();
            this.rootPath = f.getAbsolutePath();
            this.fileSystem = new FileSystem(this.rootPath, this.rb);
        }
        catch (Exception ex) {
            System.err.println("Unable to create new settings!\n" + ex);
        }
    }

    public void checkLibrary() {
        if (!this.readOnly && this.libraryManager.isEmpty() && this.rootPath != null && !FileSystem.isStrUrl(this.rootPath)) {
            File f = new File(new File(this.rootPath), "library.jclic");
            try {
                this.libraryManager.addNewLibrary(f.getAbsolutePath(), null);
                this.save();
            }
            catch (Exception ex) {
                System.err.println("Unable to create new project library!\n" + ex);
            }
        }
    }

    public void save() {
        if (!this.readOnly) {
            try {
                FileOutputStream fos = this.fileSystem.createSecureFileOutputStream(this.cfgFile, false);
                JDomUtility.saveDocument((OutputStream)fos, this.getJDomElement());
                fos.close();
            }
            catch (Exception ex) {
                System.err.println("unable to save settings in " + this.cfgFile + ": " + ex.getMessage());
            }
        }
    }

    @Override
    public Element getJDomElement() {
        Element child;
        Element e = new Element(ELEMENT_NAME);
        e.addContent(this.libraryManager.getJDomElement());
        if (this.password != null) {
            e.setAttribute(PASSWORD, Encryption.Encrypt(this.password));
        }
        if (this.language != null) {
            child = new Element("language");
            child.setAttribute("id", this.language);
            if (this.country != null) {
                child.setAttribute("country", this.country);
            }
            if (this.variant != null) {
                child.setAttribute("variant", this.variant);
            }
            e.addContent(child);
        }
        child = new Element(PATHS);
        Element child2 = new Element(PATH);
        child2.setAttribute("id", ROOT);
        child2.setAttribute(PATH, this.rootPath);
        child.addContent(child2);
        e.addContent(child);
        child = new Element(REPORTER);
        child.setAttribute("enabled", JDomUtility.boolString(this.reporterEnabled));
        child.setAttribute(CLASS, this.reporterClass);
        child.setAttribute(PARAMS, this.reporterParams);
        e.addContent(child);
        child = new Element(SOUND);
        child.setAttribute("enabled", JDomUtility.boolString(this.soundEnabled));
        child.setAttribute(SYSTEM, JDomUtility.boolString(this.systemSounds));
        child.setAttribute("mediaSystem", this.mediaSystem);
        e.addContent(child);
        child = new Element("lookAndFeel");
        child.setAttribute("id", this.lookAndFeel);
        e.addContent(child);
        child = new Element("browser");
        child.setAttribute("id", this.preferredBrowser);
        e.addContent(child);
        child = new Element("skin");
        child.setAttribute("id", this.skin);
        e.addContent(child);
        if (!this.misc.isEmpty()) {
            child = new Element(MISC);
            for (Map.Entry<String, String> me : this.misc.entrySet()) {
                String k = me.getKey();
                String v = me.getValue();
                if (k == null || v == null || !(v instanceof String)) continue;
                child.setAttribute(k, v);
            }
            e.addContent(child);
        }
        child = new Element(RECENT_FILES);
        for (int i = 0; i < MAX_RECENT; ++i) {
            if (this.recentFiles[i] == null) continue;
            child2 = new Element(FILE);
            child2.setAttribute(PATH, this.recentFiles[i]);
            child.addContent(child2);
        }
        e.addContent(child);
        return e;
    }

    public void loadSettings(Element e) throws Exception {
        this.setProperties(e, null);
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        Element child;
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.password = JDomUtility.getStringAttr(e, PASSWORD, this.password, false);
        if (this.password != null) {
            this.password = Encryption.Decrypt(this.password);
        }
        if ((child = e.getChild("libraryManager")) != null) {
            this.libraryManager = LibraryManager.getLibraryManager(this, child);
        }
        if ((child = e.getChild(PATHS)) != null) {
            String rp = null;
            for (Element child2 : child.getChildren(PATH)) {
                if (!ROOT.equals(child2.getAttributeValue("id"))) continue;
                rp = JDomUtility.getStringAttr(child2, PATH, this.rootPath, false);
            }
            if (rp != null) {
                this.rootPath = rp;
                if (!FileSystem.isStrUrl(this.rootPath)) {
                    this.fileSystem = new FileSystem(this.rootPath, this.rb);
                }
            }
        }
        if ((child = e.getChild("language")) != null) {
            this.language = JDomUtility.getStringAttr(child, "id", this.language, false);
            this.country = JDomUtility.getStringAttr(child, "country", this.country, false);
            this.variant = JDomUtility.getStringAttr(child, "variant", this.variant, false);
        }
        if ((child = e.getChild(REPORTER)) != null) {
            this.reporterEnabled = JDomUtility.getBoolAttr(child, "enabled", this.reporterEnabled);
            this.reporterClass = JDomUtility.getStringAttr(child, CLASS, this.reporterClass, false);
            this.reporterParams = JDomUtility.getStringAttr(child, PARAMS, this.reporterParams, false);
        }
        if ((child = e.getChild(SOUND)) != null) {
            this.soundEnabled = JDomUtility.getBoolAttr(child, "enabled", this.soundEnabled);
            this.systemSounds = JDomUtility.getBoolAttr(child, SYSTEM, this.systemSounds);
            this.mediaSystem = JDomUtility.getStringAttr(child, "mediaSystem", this.mediaSystem, false);
        }
        if ((child = e.getChild("lookAndFeel")) != null) {
            this.lookAndFeel = JDomUtility.getStringAttr(child, "id", this.lookAndFeel, false);
        }
        if ((child = e.getChild("browser")) != null) {
            this.preferredBrowser = JDomUtility.getStringAttr(child, "id", this.preferredBrowser, false);
            BrowserLauncher.setPreferredBrowser(this.preferredBrowser);
        }
        if ((child = e.getChild("skin")) != null) {
            this.skin = JDomUtility.getStringAttr(child, "id", this.skin, false);
        }
        if ((child = e.getChild(MISC)) != null) {
            for (Attribute a : child.getAttributes()) {
                this.misc.put(a.getName(), a.getValue());
            }
        }
        if ((child = e.getChild(RECENT_FILES)) != null) {
            Iterator it = child.getChildren(FILE).iterator();
            for (int i = 0; i < MAX_RECENT; ++i) {
                this.recentFiles[i] = it.hasNext() ? JDomUtility.getStringAttr((Element)it.next(), PATH, null, false) : null;
            }
        }
    }

    public Messages getMessages() {
        return this.rb.getOptions().getMessages();
    }

    public Map getProperties() {
        HashMap<String, String> prop = new HashMap<String, String>();
        String t = "true";
        String f = "false";
        if (this.language != null) {
            prop.put("language", this.language);
            prop.put("country", this.country);
            prop.put("variant", this.variant);
        }
        if (this.reporterEnabled) {
            prop.put(REPORTER, this.reporterClass);
            prop.put("reporterParams", this.reporterParams);
        }
        prop.put("systemSounds", this.systemSounds ? t : f);
        prop.put("audioEnabled", this.soundEnabled ? t : f);
        prop.put("lookAndFeel", this.lookAndFeel);
        prop.put("browser", this.preferredBrowser);
        prop.put("mediaSystem", this.mediaSystem);
        prop.put("skin", this.skin);
        prop.putAll(this.misc);
        return prop;
    }

    public boolean edit(Component parent) {
        boolean result = false;
        if (this.promptPassword(parent, null)) {
            PlayerSettingsDlg dlg = new PlayerSettingsDlg(this, parent);
            dlg.setVisible(true);
            result = dlg.result;
            if (result) {
                BrowserLauncher.setPreferredBrowser(this.preferredBrowser);
            }
        }
        return result;
    }

    public boolean promptPassword(Component parent, String[] msgKeys) {
        boolean result;
        boolean bl = result = this.passwordConfirmed || this.password == null || this.password.length() == 0;
        while (!result) {
            String r;
            if (msgKeys == null) {
                msgKeys = new String[]{"settings_passwordRequired"};
            }
            if ((r = this.getMessages().showInputDlg(parent, msgKeys, null, null, null, true)) == null) break;
            result = this.password.equals(r);
            if (!result) {
                this.getMessages().showAlert(parent, "PASSWORD_INCORRECT");
                continue;
            }
            this.passwordConfirmed = true;
        }
        return result;
    }

    public void addRecentFile(String fName) {
        if (fName != null) {
            String[] recentBak = this.recentFiles;
            this.recentFiles = new String[MAX_RECENT];
            this.recentFiles[0] = fName.trim();
            int j = 1;
            for (int i = 0; i < MAX_RECENT && j < MAX_RECENT; ++i) {
                if (recentBak[i] == null || recentBak[i].equals(fName)) continue;
                this.recentFiles[j++] = recentBak[i];
            }
        }
    }
}

