/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Player;
import edu.xtec.jclic.bags.ActivitySequence;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.JumpInfo;
import java.awt.Component;
import java.util.Stack;

public class PlayerHistory {
    protected Player player;
    protected Stack<HistoryElement> sequenceStack;
    protected boolean testMode;

    public PlayerHistory(Player player) {
        this.player = player;
        this.sequenceStack = new Stack();
    }

    public int storedElementsCount() {
        return this.sequenceStack.size();
    }

    public void clearHistory() {
        this.sequenceStack.clear();
    }

    public void push() {
        ActivitySequence ase;
        int act;
        if (this.player.project != null && this.player.project.getFullPath() != null && (act = (ase = this.player.project.activitySequence).getCurrentActNum()) >= 0) {
            if (!this.sequenceStack.isEmpty()) {
                HistoryElement last = this.sequenceStack.peek();
                if (last.projectPath.equals(this.player.project.getFullPath()) && last.activity == act) {
                    return;
                }
            }
            this.sequenceStack.push(new HistoryElement(this.player.project.getFullPath(), ase.getSequenceForElement(act), act));
        }
    }

    public boolean pop() {
        if (!this.sequenceStack.isEmpty()) {
            HistoryElement e = this.sequenceStack.pop();
            if (e.projectPath.equals(this.player.project.getFullPath())) {
                this.player.load(null, Integer.toString(e.activity), null, null);
            } else if (this.testMode && e.projectPath != null && e.projectPath.length() > 0) {
                this.player.getMessages().showAlert((Component)this.player, new String[]{this.player.getMsg("test_alert_jump_to"), e.projectPath});
            } else {
                this.player.load(e.projectPath, Integer.toString(e.activity), null, null);
            }
        }
        return true;
    }

    public boolean processJump(JumpInfo ji, boolean allowReturn) {
        boolean result = false;
        if (ji != null && this.player.project != null) {
            switch (ji.action) {
                case 1: {
                    break;
                }
                case 2: {
                    result = this.pop();
                    break;
                }
                case 3: {
                    if (this.testMode) {
                        this.player.getMessages().showAlert((Component)this.player, "test_alert_exit");
                        break;
                    }
                    this.player.exit(ji.sequence);
                    break;
                }
                case 0: {
                    if (ji.sequence == null && ji.projectPath == null) {
                        ActivitySequenceElement ase = this.player.project.activitySequence.getElement(ji.actNum, true);
                        if (ase == null) break;
                        if (allowReturn) {
                            this.push();
                        }
                        this.player.load(null, null, ase.getActivityName(), null);
                        result = true;
                        break;
                    }
                    if (this.testMode && ji.projectPath != null && ji.projectPath.length() > 0) {
                        this.player.getMessages().showAlert((Component)this.player, new String[]{this.player.getMsg("test_alert_jump_to"), ji.projectPath});
                        break;
                    }
                    result = this.jumpToSequence(ji.sequence, ji.projectPath, allowReturn);
                }
            }
        }
        return result;
    }

    private boolean jumpToSequence(String sequence, String path, boolean allowReturn) {
        if (sequence == null && path == null) {
            return false;
        }
        if (path == null) {
            path = this.player.project.getFullPath();
        }
        if (!this.sequenceStack.isEmpty()) {
            HistoryElement e = this.sequenceStack.peek();
            if (sequence != null && path.equals(e.projectPath)) {
                boolean same = sequence.equals(e.sequence);
                if (path.equals(this.player.project.getFullPath())) {
                    ActivitySequenceElement ase = this.player.project.activitySequence.getElement(e.activity, false);
                    boolean bl = same = ase != null && sequence.equals(ase.getTag());
                }
                if (same) {
                    return this.pop();
                }
            }
        }
        if (allowReturn) {
            this.push();
        }
        if (path.equals(this.player.project.getFullPath())) {
            this.player.load(null, sequence, null, null);
        } else {
            this.player.load(path, sequence, null, null);
        }
        return true;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    protected class HistoryElement {
        String projectPath;
        String sequence;
        int activity;

        HistoryElement(String path, String seq, int act) {
            this.projectPath = path;
            this.sequence = seq;
            this.activity = act;
        }
    }
}

