/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.PlayerHistory;
import edu.xtec.jclic.RunnableComponent;
import edu.xtec.jclic.accessibility.FressaFunctions;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.JumpInfo;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.boxes.Counter;
import edu.xtec.jclic.clic3.Clic3;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.media.ActiveMediaBag;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.media.JavaSoundAudioBuffer;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.Reporter;
import edu.xtec.jclic.skins.AboutWindow;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import edu.xtec.util.SwingWorker;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdom.Document;
import org.json.JSONObject;

public class Player
extends JPanel
implements Constants,
RunnableComponent,
PlayStation,
ActionListener {
    public static final String DEFAULT_SKIN = "@default.xml";
    public static final String DEFAULT_REPORTER = "Reporter";
    public static final String[] DEFAULT_EVENT_SOUNDS = new String[]{"sounds/start.wav", "sounds/click.wav", "sounds/action_error.wav", "sounds/action_ok.wav", "sounds/finished_error.wav", "sounds/finished_ok.wav"};
    public static final String[] ACTION_ICONS = new String[]{"icons/prev.gif", "icons/next.gif", "icons/return.gif", "icons/reset.gif", "icons/info_small.gif", "icons/help.gif", "icons/audio_on.gif", "icons/logo_button.gif"};
    public static final String DEFAULT_APP_NAME = "JClic";
    protected Action[] actions;
    protected Messages messages;
    protected JClicProject project;
    protected Activity.Panel actPanel;
    protected PlayerHistory history;
    protected Skin skin;
    protected Skin defaultSkin;
    protected ActiveMediaBag activeMediaBag;
    protected Reporter reporter;
    protected EventSounds eventSounds;
    protected Timer timer;
    protected boolean audioEnabled = true;
    protected boolean trace = false;
    protected boolean navButtonsDisabled = false;
    protected boolean navButtonsAlways = false;
    protected String appName = "JClic";
    Timer delayedTimer;
    Action delayedAction;
    Object currentConstraints;
    int[] counterVal = new int[3];
    Cursor[] cursors = new Cursor[3];
    Options options;
    Image splashImg;
    Point bgImageOrigin = new Point();
    private SwingWorker worker = null;

    public Player(Options options) {
        this(options, null);
    }

    public Player(Options options, JClicProject project) {
        this.options = options;
        this.project = project;
        this.init();
    }

    protected void init() {
        this.options.setLookAndFeel();
        CheckMediaSystem.check(this.options, false);
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(null);
        Utils.checkRenderingHints(this.options);
        BoxConnector.checkOptions(this.options);
        ActiveBox.checkOptions(this.options);
        for (int i = 0; i < 3; ++i) {
            this.counterVal[i] = 0;
        }
        this.setMessages();
        this.buildActions();
        this.setActionsText();
        this.history = new PlayerHistory(this);
        this.trace = this.options.getBoolean("trace");
        ActiveBox.compressImages = this.options.getBoolean("compressImages", true);
        this.audioEnabled = this.options.getBoolean("audioEnabled", true);
        this.navButtonsAlways = this.options.getBoolean("navButtonsAlways", false);
        this.setProject(this.project);
        this.activeMediaBag = new ActiveMediaBag();
        this.initSkin();
        this.setSkin(this.skin);
        this.setSystemMessage(this.getMessages().get("msg_initializing"), null);
        this.setWaitCursor(true);
        this.createCursors();
        this.createEventSounds();
        this.initTimers();
        this.splashImg = ResourceManager.getImageIcon("icons/logo.png").getImage();
        if (this.skin != null && this.skin.hasMemMonitor()) {
            this.skin.setMem(Runtime.getRuntime().freeMemory());
        }
        this.setWaitCursor(false);
        this.setWindowTitle();
        this.setSystemMessage(this.getMessages().get("msg_ready"), null);
    }

    @Override
    public boolean start(String fullPath, String sequence) {
        this.initReporter();
        if (fullPath != null) {
            return this.load(fullPath, sequence);
        }
        return false;
    }

    @Override
    public void activate() {
    }

    @Override
    public void stop() {
        this.stopMedia(-1);
    }

    protected void finalize() throws Throwable {
        try {
            this.end();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void end() {
        if (this.worker != null) {
            this.worker.interrupt();
            this.worker = null;
        }
        this.stopMedia();
        this.closeHelpWindow();
        if (this.actPanel != null) {
            this.actPanel.end();
            this.remove(this.actPanel);
            this.actPanel = null;
        }
        if (this.eventSounds != null) {
            this.eventSounds.close();
            this.eventSounds = null;
        }
        if (this.project != null) {
            this.project.end();
            this.project = null;
        }
        if (this.activeMediaBag != null) {
            this.activeMediaBag.removeAll();
        }
        if (this.reporter != null) {
            this.reporter.end();
            this.reporter = null;
        }
    }

    protected void createCursors() {
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            this.cursors[0] = tk.createCustomCursor(ResourceManager.getImageIcon("cursors/hand.gif").getImage(), new Point(8, 0), "hand");
            this.cursors[1] = tk.createCustomCursor(ResourceManager.getImageIcon("cursors/ok.gif").getImage(), new Point(0, 0), "ok");
            this.cursors[2] = tk.createCustomCursor(ResourceManager.getImageIcon("cursors/micro.gif").getImage(), new Point(15, 3), "record");
        }
        catch (Exception e) {
            System.err.println("Error creating cursor:\n" + e);
        }
    }

    protected void createEventSounds() {
        if (this.options.getBoolean("Mac")) {
            try {
                JavaSoundAudioBuffer.initialize();
            }
            catch (Exception ex) {
                System.err.println("Error initializing AudioBuffer lines:\n" + ex);
            }
        }
        this.eventSounds = new EventSounds(null);
        try {
            for (int i = 0; i < DEFAULT_EVENT_SOUNDS.length; ++i) {
                String s = DEFAULT_EVENT_SOUNDS[i];
                this.eventSounds.setDataSource(i, ResourceManager.getResourceAsByteArray(s), this.options);
            }
            this.eventSounds.realize(this.options, this.project.mediaBag);
        }
        catch (Exception ex) {
            System.err.println("Error reading system sound:\"" + ex);
        }
        EventSounds.globalEnabled = this.options.getBoolean("systemSounds", true);
    }

    protected void initReporter() {
        if (this.reporter != null) {
            this.reporter.end();
            this.reporter = null;
        }
        String reporterClassName = StrUtils.secureString(this.options.getString("reporter"), DEFAULT_REPORTER);
        try {
            this.reporter = Reporter.getReporter(reporterClassName, this.options.getString("reporterParams"), this, this.messages);
        }
        catch (Exception ex) {
            this.reporter = null;
            this.messages.showErrorWarning((Component)this, "report_err_creating", reporterClassName, ex, null);
        }
    }

    protected void initSkin() {
        String s = "";
        try {
            FileSystem fsSk = null;
            s = this.options.getString("skin");
            if (s == null) {
                s = DEFAULT_SKIN;
            } else if (!s.startsWith("@")) {
                fsSk = new FileSystem(FileSystem.getPathPartOf(s), this);
                s = FileSystem.getFileNameOf(s);
            }
            this.defaultSkin = Skin.getSkin(s, fsSk, this);
            this.actions[7].setEnabled(true);
            this.actions[6].setEnabled(true);
        }
        catch (Exception ex) {
            System.err.println("Error creating skin \"" + s + "\":\n" + ex);
        }
    }

    protected void initTimers() {
        this.timer = new Timer(1000, this);
        this.delayedTimer = new Timer(1000, this);
        this.delayedTimer.setRepeats(false);
        this.delayedAction = null;
    }

    public void closeHelpWindow() {
        if (this.skin != null) {
            if (this.skin.currentHelpWindow != null) {
                this.skin.currentHelpWindow.setVisible(false);
            }
            if (this.skin.currentAboutWindow != null) {
                this.skin.currentAboutWindow.setVisible(false);
            }
        }
    }

    protected Messages setMessages() {
        this.messages = Messages.getMessages(this.options, "messages.JClicMessages");
        this.messages.addBundle("commonSettings");
        this.setLocale(this.messages.getLocale());
        Locale.setDefault(this.messages.getLocale());
        this.setActionsText();
        if (this.skin != null) {
            this.skin.setLocale(this.messages.getLocale());
        }
        return this.messages;
    }

    public Component getTopComponent() {
        if (this.skin != null) {
            return this.skin;
        }
        return this;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(Skin newSkin) {
        if (newSkin == null) {
            newSkin = this.defaultSkin;
        }
        if (newSkin != null && !newSkin.equals(this.skin)) {
            Container top = null;
            Object[] currentSkinSettings = null;
            if (this.skin != null) {
                currentSkinSettings = this.skin.getCurrentSettings();
                this.skin.detach();
                top = this.skin.getParent();
                top.remove(this.skin);
            }
            newSkin.attach(this);
            this.skin = newSkin;
            if (top != null) {
                RootPaneContainer rpc = null;
                while (top != null && rpc == null) {
                    if (top instanceof RootPaneContainer) {
                        rpc = (RootPaneContainer)((Object)top);
                        continue;
                    }
                    top = top.getParent();
                }
                if (rpc != null) {
                    this.addTo(rpc, this.currentConstraints);
                    top.validate();
                    top.repaint();
                }
            }
            if (currentSkinSettings != null && this.skin != null) {
                this.skin.setCurrentSettings(currentSkinSettings);
            }
        }
    }

    @Override
    public void addTo(RootPaneContainer cont, Object constraints) {
        this.currentConstraints = constraints;
        if (constraints == null) {
            cont.getContentPane().add(this.getTopComponent());
        } else {
            cont.getContentPane().add(this.getTopComponent(), constraints);
        }
    }

    protected FileSystem createFileSystem() {
        return new FileSystem(this);
    }

    protected void setProject(JClicProject p) {
        if (this.project != null) {
            if (this.project != p) {
                this.project.end();
            }
            this.removeActivity();
        }
        this.project = p != null ? p : new JClicProject(this, this.createFileSystem(), null);
        this.project.realize(this.eventSounds, this);
        if (this.project.skin != null) {
            this.defaultSkin = this.project.skin;
        }
    }

    public boolean load(String fullPath, String sequence) {
        this.load(fullPath, sequence, null, null);
        return true;
    }

    public void load(final String sFullPath, final String sSequence, final String sActivity, final ActivityBagElement sAbe) {
        if (this.worker != null) {
            return;
        }
        this.worker = new SwingWorker(){
            Activity.Panel actp;
            Exception exception = null;
            Player thisPlayer = Player.this;

            @Override
            public Object construct() {
                if (Player.this.skin != null) {
                    Player.this.skin.startAnimation();
                }
                Player.this.setWaitCursor(true);
                String fullPath = Clic3.pacNameToLowerCase(sFullPath);
                String sequence = Clic3.pacNameToLowerCase(sSequence);
                Activity act = null;
                String activityName = sActivity;
                ActivityBagElement abe = sAbe;
                FileSystem fileSystem = Player.this.project.getFileSystem();
                try {
                    if (fullPath != null) {
                        Player.this.setSystemMessage(Player.this.messages.get("msg_loading_project"), FileSystem.getFileNameOf(fullPath));
                        if (sequence == null) {
                            sequence = "0";
                        }
                        if (fileSystem != null) {
                            if ((fullPath = fileSystem.getUrl(fullPath)).startsWith("file://")) {
                                fullPath = fullPath.substring(7);
                            } else if (fullPath.indexOf(63) > 0) {
                                fullPath = fullPath.substring(0, fullPath.indexOf(63));
                            }
                        }
                        String projectName = null;
                        JSONObject json = null;
                        if (fullPath.endsWith(".jclic.zip")) {
                            fileSystem = FileSystem.createFileSystem(fullPath, this.thisPlayer);
                            String[] projects = ((ZipFileSystem)fileSystem).getEntries(".jclic");
                            if (projects == null) {
                                throw new Exception("File " + fullPath + " does not contain any jclic project");
                            }
                            projectName = projects[0];
                        } else if (fullPath.endsWith(".scorm.zip")) {
                            fileSystem = FileSystem.createFileSystem(fullPath, this.thisPlayer);
                            if (fileSystem.fileExists("project.json")) {
                                json = new JSONObject(new String(fileSystem.getBytes("project.json")));
                                projectName = json.optString("mainFile", null);
                            }
                            if (projectName == null) {
                                throw new Exception("Invalid JClic SCORM file: " + fullPath);
                            }
                        } else {
                            fileSystem = new FileSystem(FileSystem.getPathPartOf(fullPath), this.thisPlayer);
                            projectName = FileSystem.getFileNameOf(fullPath);
                            if (fileSystem.fileExists("project.json")) {
                                json = new JSONObject(new String(fileSystem.getBytes("project.json")));
                            }
                        }
                        if (projectName.endsWith(".jclic")) {
                            Document doc = fileSystem.getXMLDocument(projectName);
                            JClicProject prj = JClicProject.getJClicProject(doc.getRootElement(), this.thisPlayer, fileSystem, fullPath);
                            if (json != null) {
                                prj.readJSON(json, false);
                            }
                            Player.this.setProject(prj);
                            if (Player.this.reporter != null) {
                                Player.this.reporter.newSession(Player.this.project, this.thisPlayer, Player.this.messages);
                            }
                        } else {
                            sequence = projectName;
                            Player.this.setProject(new JClicProject(this.thisPlayer, fileSystem, fullPath));
                        }
                    }
                    if (sequence != null) {
                        int i;
                        String seqName = FileSystem.stdFn(sequence);
                        Player.this.setSystemMessage(Player.this.messages.get("msg_loading_project"), FileSystem.getFileNameOf(seqName));
                        Player.this.navButtonsDisabled = false;
                        ActivitySequenceElement ase = Player.this.project.activitySequence.getElementByTag(seqName, true);
                        if (ase == null && (i = StrUtils.getAbsIntValueOf(seqName)) >= 0) {
                            ase = Player.this.project.activitySequence.getElement(i, true);
                        }
                        if (ase == null) {
                            boolean firstPac = Player.this.project.activitySequence.getSize() == 0;
                            boolean isPcc = seqName.endsWith(".pcc");
                            boolean isPac = seqName.endsWith(".pac");
                            if (isPcc || isPac) {
                                if (isPcc) {
                                    String path = fileSystem.root + seqName;
                                    fileSystem = FileSystem.createFileSystem(path, this.thisPlayer);
                                    if (firstPac) {
                                        Player.this.project.setFileSystem(fileSystem);
                                        Player.this.project.setFullPath(path);
                                    } else {
                                        Player.this.setProject(new JClicProject(this.thisPlayer, fileSystem, path));
                                    }
                                    firstPac = true;
                                    Clic3.readPccFile(Player.this.project);
                                    ase = Player.this.project.activitySequence.getCurrentAct();
                                } else if (isPac) {
                                    Clic3.addPacToSequence(Player.this.project, seqName);
                                    ase = Player.this.project.activitySequence.getElementByTag(seqName, true);
                                }
                                if (firstPac) {
                                    Player.this.project.setName(seqName);
                                    if (Player.this.reporter != null) {
                                        Player.this.reporter.newSession(Player.this.project, this.thisPlayer, Player.this.messages);
                                    }
                                }
                            }
                        }
                        if (ase != null) {
                            if (Player.this.reporter != null) {
                                Player.this.reporter.newSequence(ase);
                            }
                            activityName = ase.getActivityName();
                        }
                    }
                    if (activityName != null) {
                        String actName = FileSystem.stdFn(activityName);
                        abe = Player.this.project.activityBag.getElement(actName);
                    }
                    if (abe != null) {
                        Player.this.setSystemMessage(Player.this.messages.get("msg_loading_activity"), abe.getName());
                        act = Activity.getActivity(abe.getData(), Player.this.project);
                    }
                    if (act != null) {
                        Player.this.setSystemMessage(null, Player.this.messages.get("msg_preparing_media"));
                        if (Player.this.project.settings.eventSounds != null) {
                            act.eventSounds.setParent(Player.this.project.settings.eventSounds);
                        }
                        Player.this.project.mediaBag.waitForAllImages();
                        act.prepareMedia(this.thisPlayer);
                        Player.this.activeMediaBag.realizeAll();
                        if (abe != null) {
                            Player.this.project.activitySequence.checkCurrentActivity(abe.getName());
                        }
                        Player.this.setSystemMessage(null, Player.this.messages.get("msg_initializing"));
                        this.actp = act.getActivityPanel(this.thisPlayer);
                        this.actp.buildVisualComponents();
                    }
                }
                catch (Exception ex) {
                    this.exception = ex;
                    if (Player.this.project == null) {
                        Player.this.setProject(null);
                    }
                    this.actp = null;
                }
                return this.actp;
            }

            @Override
            public void finished() {
                Player.this.setWaitCursor(false);
                if (Player.this.actPanel != null) {
                    Player.this.actPanel.end();
                    Player.this.remove(Player.this.actPanel);
                    Player.this.actPanel = null;
                    Player.this.setCounterValue(2, 0);
                }
                if (this.actp != null && Player.this.worker != null) {
                    Player.this.setBackgroundSettings(this.actp.getActivity());
                    Player.this.actPanel = this.actp;
                    Player.this.add(Player.this.actPanel);
                    Player.this.actPanel.setCursor(null);
                    Player.this.splashImg = null;
                    if (Player.this.skin != null) {
                        Player.this.skin.resetAllCounters(false);
                    }
                    if (this.actp.skin != null) {
                        Player.this.setSkin(this.actp.skin);
                    } else if (Player.this.project.skin != null) {
                        Player.this.setSkin(Player.this.project.skin);
                    } else {
                        Player.this.setSkin(Player.this.defaultSkin);
                    }
                    if (Player.this.skin != null) {
                        int navBtnFlag;
                        boolean hasReturn;
                        boolean bl = hasReturn = Player.this.history.storedElementsCount() > 0;
                        int n = Player.this.navButtonsAlways ? 3 : (navBtnFlag = Player.this.navButtonsDisabled ? 0 : Player.this.project.activitySequence.getNavButtonsFlag());
                        if (Player.this.actions != null) {
                            Player.this.actions[1].setEnabled((navBtnFlag & 1) != 0 && Player.this.project.activitySequence.hasNextAct(hasReturn));
                            Player.this.actions[0].setEnabled((navBtnFlag & 2) != 0 && Player.this.project.activitySequence.hasPrevAct(hasReturn));
                            Player.this.actions[2].setEnabled(Player.this.history.storedElementsCount() > 0);
                            Player.this.actions[5].setEnabled(this.actp.getActivity().helpWindowAllowed());
                            Player.this.actions[3].setEnabled(this.actp.getActivity().canReinit());
                            Player.this.actions[4].setEnabled(this.actp.getActivity().hasInfo());
                        }
                    }
                    Player.this.setSystemMessage(Player.this.messages.get("msg_ready"), null);
                    Player.this.initActivity();
                } else if (this.exception != null) {
                    String sType = null;
                    ArrayList<Object> v = new ArrayList<Object>();
                    if (sFullPath != null) {
                        v.add(sFullPath);
                        sType = "msg_error_loading_project";
                    }
                    if (sSequence != null) {
                        v.add(sSequence);
                        if (sType == null) {
                            sType = "msg_error_loading_sequence";
                        }
                    }
                    if (sActivity != null) {
                        v.add(sActivity);
                        if (sType == null) {
                            sType = "msg_error_loading_activity";
                        }
                    }
                    if (sAbe != null) {
                        v.add(sAbe.getName());
                        if (sType == null) {
                            sType = "msg_error_loading_activity";
                        }
                    }
                    if (sType == null) {
                        sType = "ERROR";
                    }
                    Player.this.setSystemMessage(Player.this.messages.get(sType), null);
                    Player.this.messages.showErrorWarning((Component)this.thisPlayer, "err_reading_data", v, this.exception, null);
                    Player.this.validate();
                } else {
                    Player.this.setSystemMessage(Player.this.messages.get("msg_ready"), null);
                }
                Player.this.setWindowTitle();
                Player.this.worker = null;
                if (Player.this.skin != null) {
                    Player.this.skin.stopAnimation();
                    Player.this.skin.setEnabled(true);
                }
                Player.this.setEnabled(true);
            }
        };
        this.forceFinishActivity();
        if (this.skin != null) {
            this.skin.setEnabled(false);
        }
        this.setEnabled(false);
        this.worker.start();
    }

    public void forceFinishActivity() {
        if (this.timer != null) {
            this.timer.stop();
            this.delayedTimer.stop();
            if (this.actPanel != null) {
                this.closeHelpWindow();
                this.actPanel.forceFinishActivity();
                this.stopMedia();
                this.activeMediaBag.removeAll();
                if (Utils.lowMemoryCondition()) {
                    if (this.trace) {
                        System.out.println(">>> LOW MEMORY! cleaning...");
                    }
                    this.project.mediaBag.clearData();
                    System.runFinalization();
                    System.gc();
                }
            }
            this.setCursor(null);
        }
    }

    public void removeActivity() {
        this.forceFinishActivity();
        if (this.actPanel != null) {
            this.actPanel.end();
            this.remove(this.actPanel);
            this.setMsg(null);
            this.setBackgroundSettings(null);
            this.actPanel = null;
        }
    }

    public void initActivity() {
        this.setWaitCursor(true);
        this.setCursor(null);
        this.timer.stop();
        this.delayedTimer.stop();
        this.setCounterValue(2, 0);
        this.stopMedia();
        try {
            if (this.actPanel != null) {
                this.actPanel.initActivity();
                this.timer.start();
                if (!this.actPanel.getActivity().mustPauseSequence()) {
                    this.startAutoPassTimer();
                }
                if (this.getFressa() != null) {
                    this.getFressa().initActivity(this.actPanel);
                }
                this.setSystemMessage(this.messages.get("msg_activity_running"), null);
            }
            if (this.skin != null) {
                this.skin.setMem(Runtime.getRuntime().freeMemory());
            }
        }
        catch (Exception ex) {
            this.messages.showErrorWarning(this, "msg_error_starting_activity", ex);
            this.setSystemMessage(this.messages.get("ERROR"), null);
        }
        finally {
            this.setWaitCursor(false);
            this.validate();
            this.repaint();
        }
    }

    @Override
    public void startActivity(Activity.Panel ap) {
        this.setWaitCursor(true);
        try {
            ap.startActivity();
        }
        catch (Exception ex) {
            this.messages.showErrorWarning(this, "msg_error_starting_activity", ex);
            this.setSystemMessage(this.messages.get("ERROR"), null);
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    @Override
    public void doLayout() {
        if (this.trace) {
            System.out.println(">>> layout!");
        }
        if (this.actPanel != null) {
            BoxBase.resetAllFonts();
            Rectangle bounds = this.getBounds();
            Rectangle proposedRect = new Rectangle(6, 6, bounds.width - 12, bounds.height - 12);
            if (this.actPanel.bgImage != null && !this.actPanel.getActivity().tiledBgImg) {
                this.bgImageOrigin.x = (this.getWidth() - this.actPanel.bgImage.getWidth(this)) / 2;
                this.bgImageOrigin.y = (this.getHeight() - this.actPanel.bgImage.getHeight(this)) / 2;
                if (this.actPanel.getActivity().absolutePositioned) {
                    proposedRect.x = this.bgImageOrigin.x;
                    proposedRect.y = this.bgImageOrigin.y;
                    proposedRect.width -= this.bgImageOrigin.x - 6;
                    proposedRect.height -= this.bgImageOrigin.y - 6;
                    proposedRect.width = Math.min(proposedRect.width, bounds.width);
                    proposedRect.height = Math.min(proposedRect.height, bounds.height);
                }
            }
            this.actPanel.fitTo(proposedRect, bounds);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.splashImg != null) {
            g2.setColor(BG_COLOR);
            g2.fill(g2.getClip());
            int imgW = this.splashImg.getWidth(this);
            int imgH = this.splashImg.getHeight(this);
            int x = (this.getBounds().width - imgW) / 2;
            int y = (this.getBounds().height - imgH) / 2;
            g2.drawImage(this.splashImg, x, y, this);
            return;
        }
        Rectangle rBounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (this.actPanel == null || this.actPanel.getActivity().bgGradient == null || this.actPanel.getActivity().bgGradient.hasTransparency()) {
            super.paintComponent(g);
        }
        if (this.actPanel != null && (this.actPanel.getActivity().bgGradient != null || this.actPanel.bgImage != null)) {
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHints(DEFAULT_RENDERING_HINTS);
            if (this.actPanel.getActivity().bgGradient != null) {
                this.actPanel.getActivity().bgGradient.paint(g2, rBounds);
            }
            if (this.actPanel.bgImage != null) {
                Rectangle r = new Rectangle(0, 0, this.actPanel.bgImage.getWidth(this), this.actPanel.bgImage.getHeight(this));
                Rectangle gBounds = g2.getClipBounds();
                if (!this.actPanel.getActivity().tiledBgImg) {
                    r.setLocation(this.bgImageOrigin);
                    if (r.intersects(gBounds)) {
                        g2.drawImage(this.actPanel.bgImage, this.bgImageOrigin.x, this.bgImageOrigin.y, this);
                    }
                } else {
                    Utils.tileImage(g2, this.actPanel.bgImage, rBounds, r, this);
                }
            }
            g2.setRenderingHints(rh);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String ac = null;
        if (this.timer != null && e.getSource().equals(this.timer)) {
            this.incCounterValue(2);
            if (this.actPanel != null && this.actPanel.getActivity().maxTime > 0 && this.actPanel.isPlaying() && this.counterVal[2] >= this.actPanel.getActivity().maxTime) {
                this.actPanel.finishActivity(false);
            }
            return;
        }
        if (this.delayedTimer != null && e.getSource().equals(this.delayedTimer)) {
            this.delayedTimer.stop();
            if (this.delayedAction != null) {
                this.delayedAction.actionPerformed(null);
            }
        }
        if (ac == null && (ac = e.getActionCommand()) == null) {
            return;
        }
        this.delayedAction = null;
        this.processActionEvent(ac);
    }

    protected int getNumActions() {
        return 8;
    }

    protected void buildActions() {
        this.actions = new Action[this.getNumActions()];
        this.actions[1] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (Player.this.history != null && Player.this.project != null && Player.this.project.activitySequence != null) {
                    Player.this.history.processJump(Player.this.project.activitySequence.getJump(false, Player.this.reporter), false);
                }
            }
        };
        this.actions[0] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (Player.this.history != null && Player.this.project != null && Player.this.project.activitySequence != null) {
                    Player.this.history.processJump(Player.this.project.activitySequence.getJump(true, Player.this.reporter), false);
                }
            }
        };
        this.actions[2] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (Player.this.history != null) {
                    Player.this.history.pop();
                }
            }
        };
        this.actions[3] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (Player.this.actPanel != null && Player.this.actPanel.getActivity().canReinit()) {
                    Player.this.initActivity();
                }
            }
        };
        this.actions[5] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (Player.this.actPanel != null) {
                    Player.this.actPanel.showHelp();
                }
            }
        };
        this.actions[4] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (Player.this.actPanel != null && Player.this.actPanel.getActivity().hasInfo()) {
                    if (Player.this.actPanel.getActivity().infoUrl != null) {
                        Player.this.displayUrl(Player.this.actPanel.getActivity().infoUrl, true);
                    } else if (Player.this.actPanel.getActivity().infoCmd != null) {
                        Player.this.runCmd(Player.this.actPanel.getActivity().infoCmd);
                    }
                }
            }
        };
        this.actions[7] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Player.this.showAbout(true);
            }
        };
        this.actions[6] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Boolean vNew;
                Object vBack = this.getValue("Default");
                Player.this.audioEnabled = !Player.this.audioEnabled;
                Boolean bl = vNew = Player.this.audioEnabled ? Boolean.TRUE : Boolean.FALSE;
                if (!Player.this.audioEnabled) {
                    Player.this.stopMedia();
                    EventSounds.globalEnabled = false;
                } else {
                    EventSounds.globalEnabled = Player.this.options.getBoolean("systemSounds", true);
                }
                this.putValue("Default", vNew);
                if (this.changeSupport != null) {
                    PropertyChangeEvent evt = new PropertyChangeEvent(this, "selected", vBack, vNew);
                    this.changeSupport.firePropertyChange(evt);
                }
            }
        };
        this.actions[6].putValue("Default", this.audioEnabled ? Boolean.TRUE : Boolean.FALSE);
        for (int dynAct : DYNAMIC_ACTIONS) {
            this.actions[dynAct].setEnabled(false);
        }
        this.actions[6].setEnabled(true);
    }

    protected void setActionsText() {
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                Icon icon;
                if (this.actions[i] == null) continue;
                String s = this.messages.get("action_" + this.getActionName(i) + "_caption");
                if (!s.equals(this.actions[i].getValue("Name"))) {
                    this.actions[i].putValue("Name", s);
                }
                if (!(s = this.messages.get("action_" + this.getActionName(i) + "_tooltip")).equals(this.actions[i].getValue("ShortDescription"))) {
                    this.actions[i].putValue("ShortDescription", s);
                }
                if ((s = this.messages.get("action_" + this.getActionName(i) + "_keys")) != null && s.length() == 2) {
                    this.actions[i].putValue("MnemonicKey", new Integer(s.charAt(0)));
                    char c = s.charAt(1);
                    int kk = -1;
                    if (c == '*') {
                        switch (i) {
                            case 1: {
                                kk = 39;
                                break;
                            }
                            case 0: {
                                kk = 37;
                                break;
                            }
                            case 2: {
                                kk = 38;
                                break;
                            }
                            case 3: {
                                kk = 10;
                                break;
                            }
                        }
                    } else {
                        kk = c;
                    }
                    if (kk >= 0) {
                        this.actions[i].putValue("AcceleratorKey", KeyStroke.getKeyStroke(kk, 2));
                    }
                }
                if ((icon = this.getActionIcon(i)) == null || icon.equals(this.actions[i].getValue("SmallIcon"))) continue;
                this.actions[i].putValue("SmallIcon", icon);
            }
        }
    }

    protected String getActionName(int actionId) {
        if (actionId < 0 || actionId >= ACTION_NAME.length) {
            return null;
        }
        return ACTION_NAME[actionId];
    }

    protected Icon getActionIcon(int actionId) {
        if (actionId < 0 || actionId >= ACTION_ICONS.length) {
            return null;
        }
        return ResourceManager.getImageIcon(ACTION_ICONS[actionId]);
    }

    @Override
    public Action getAction(int id) {
        if (this.actions == null || id < 0 || id >= this.actions.length) {
            return null;
        }
        return this.actions[id];
    }

    protected boolean processActionEvent(String ac) {
        return !this.isEnabled();
    }

    protected void showAbout(boolean selectReportPane) {
        if (this.skin != null) {
            AboutWindow aw = this.skin.buildAboutWindow();
            try {
                aw.buildAboutTab(DEFAULT_APP_NAME, this.getMsg("JCLIC_VERSION"), null, null, null, null, null);
                aw.buildStandardTab(aw.getHtmlSystemInfo(), "about_window_systemInfo", "about_window_lb_system", "icons/system_small.gif");
                if (this.project != null) {
                    StringBuilder sb = new StringBuilder(4096);
                    sb.append(this.project.settings.toHtmlString(this.messages));
                    if (this.actPanel != null) {
                        sb.append("\n<BR>\n").append(this.actPanel.getActivity().toHtmlString(this));
                    }
                    aw.buildStandardTab(sb.substring(0), "about_window_projectInfo", "about_window_lb_project", "icons/info_small.gif");
                }
                if (this.reporter != null) {
                    aw.buildStandardTab(this.reporter.toHtmlString(this.messages), "about_window_reportInfo", "about_window_lb_report", "icons/report_small.gif");
                    if (selectReportPane) {
                        aw.getTabbedPane().setSelectedIndex(3);
                    }
                }
                this.skin.showAboutWindow(aw);
            }
            catch (Exception ex) {
                System.err.println("Error building about window!\n" + ex);
            }
        }
    }

    @Override
    public void playMedia(final MediaContent mediaContent, final ActiveBox mediaPlacement) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String s = mediaContent.mediaFileName;
                switch (mediaContent.mediaType) {
                    case 8: {
                        JumpInfo ji = new JumpInfo(0, FileSystem.stdFn(s));
                        ji.projectPath = mediaContent.externalParam;
                        Player.this.history.processJump(ji, true);
                        break;
                    }
                    case 7: {
                        Player.this.history.push();
                        Player.this.load(null, null, s, null);
                        break;
                    }
                    case 12: {
                        Player.this.history.pop();
                        break;
                    }
                    case 11: {
                        String exitUrl = mediaContent.mediaFileName;
                        if (exitUrl != null) {
                            exitUrl = Player.this.project.getFileSystem().getUrl(exitUrl);
                        }
                        JumpInfo ji = new JumpInfo(3, exitUrl);
                        Player.this.history.processJump(ji, false);
                        break;
                    }
                    case 9: {
                        if (mediaContent.mediaFileName == null) break;
                        StringBuilder sb = new StringBuilder(mediaContent.mediaFileName);
                        if (mediaContent.externalParam != null) {
                            sb.append(" ").append(mediaContent.externalParam);
                        }
                        Player.this.runCmd(sb.substring(0));
                        break;
                    }
                    case 10: {
                        if (mediaContent.mediaFileName == null) break;
                        Player.this.displayUrl(mediaContent.mediaFileName, true);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        ActiveMediaPlayer amp;
                        if (!Player.this.audioEnabled || (amp = Player.this.activeMediaBag.getActiveMediaPlayer(mediaContent, Player.this.project.mediaBag, Player.this)) == null) break;
                        amp.play(mediaPlacement);
                        break;
                    }
                }
            }
        });
    }

    protected void runCmd(String cmd) {
        if (this.options.get("applet") != null) {
            this.messages.showAlert((Component)this, "msg_warn_no_exec_in_applets");
            return;
        }
        try {
            Runtime.getRuntime().exec(cmd, null, new File(this.project.getFileSystem().root));
        }
        catch (Exception ex) {
            this.messages.showErrorWarning((Component)this, "msg_error_executing_external", cmd, ex, null);
        }
    }

    public void stopMedia() {
        this.stopMedia(-1);
    }

    @Override
    public void stopMedia(int level) {
        this.activeMediaBag.stopAll(level);
    }

    @Override
    public void activityFinished(boolean completedOk) {
        this.closeHelpWindow();
        if (this.getFressa() != null) {
            this.getFressa().activityFinished();
        }
        if (completedOk) {
            this.setCursor(this.getCustomCursor(1));
            this.actPanel.setCursor(null);
        }
        this.setSystemMessage(this.messages.get("msg_activity_finished"), null);
        this.timer.stop();
        this.startAutoPassTimer();
    }

    public void startAutoPassTimer() {
        ActivitySequenceElement ase = this.project.activitySequence.getCurrentAct();
        if (ase != null && ase.delay > 0 && !this.delayedTimer.isRunning() && !this.navButtonsDisabled) {
            this.delayedAction = this.actions[1];
            this.delayedTimer.setInitialDelay(ase.delay * 1000);
            this.delayedTimer.start();
        }
    }

    protected void setBackgroundSettings(Activity act) {
        this.setBackground(act != null ? act.bgColor : Color.lightGray);
        this.bgImageOrigin.setLocation(0, 0);
        this.repaint();
    }

    @Override
    public void setMsg(ActiveBoxContent abc) {
        ActiveBox ab = null;
        if (this.skin != null) {
            ab = this.skin.getMsgBox();
        }
        if (ab != null) {
            ab.clear();
            ab.setContent(abc == null ? ActiveBoxContent.getEmptyContent() : abc);
        }
    }

    @Override
    public void playMsg() {
        if (this.skin != null && this.skin.getMsgBox() != null) {
            this.skin.getMsgBox().playMedia(this);
        }
    }

    @Override
    public void incCounterValue(int counterId) {
        int n = counterId;
        this.counterVal[n] = this.counterVal[n] + 1;
        Counter c = null;
        if (this.skin != null && (c = this.skin.getCounter(counterId)) != null) {
            c.setValue(this.counterVal[counterId]);
        }
        if (counterId == 1 && this.actPanel != null && this.actPanel.getActivity().maxActions > 0 && this.actPanel.isPlaying() && this.counterVal[1] >= this.actPanel.getActivity().maxActions) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Player.this.actPanel.finishActivity(Player.this.actPanel.solved);
                }
            });
        }
    }

    @Override
    public void setCountDown(int counterId, int maxValue) {
        Counter c = null;
        if (this.skin != null && (c = this.skin.getCounter(counterId)) != null) {
            c.setCountDown(maxValue);
        }
    }

    @Override
    public void setCounterValue(int counterId, int newValue) {
        this.counterVal[counterId] = newValue;
        Counter c = null;
        if (this.skin != null && (c = this.skin.getCounter(counterId)) != null) {
            c.setValue(newValue);
        }
    }

    @Override
    public int getCounterValue(int counterId) {
        return this.counterVal[counterId];
    }

    @Override
    public void setCounterEnabled(int counterId, boolean bEnabled) {
        if (this.skin != null) {
            this.skin.enableCounter(counterId, bEnabled);
            this.setCountDown(counterId, 0);
        }
    }

    public Messages getMessages() {
        return this.messages == null ? this.setMessages() : this.messages;
    }

    @Override
    public void setWaitCursor(boolean state) {
        if (this.skin != null) {
            this.skin.setWaitCursor(state);
        }
    }

    @Override
    public void setSystemMessage(String msg1, String msg2) {
        if (this.skin != null) {
            this.skin.setSystemMessage(msg1, msg2);
        }
        if (this.trace) {
            System.out.println("MSG " + (msg1 == null ? "" : msg1 + " ") + (msg2 == null ? "" : msg2));
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public ActiveMediaPlayer getActiveMediaPlayer(MediaContent mediaContent) {
        if (this.activeMediaBag != null && mediaContent != null) {
            return this.activeMediaBag.getActiveMediaPlayer(mediaContent, this.project.mediaBag, this);
        }
        return null;
    }

    @Override
    public Cursor getCustomCursor(int type) {
        if (type >= 0 && type < this.cursors.length) {
            return this.cursors[type];
        }
        return null;
    }

    @Override
    public void reportNewActivity(Activity act, int currentScore) {
        ActivitySequenceElement ase = this.project.activitySequence.getCurrentAct();
        if (this.reporter != null) {
            if (ase.getTag() != null && !ase.getTag().equals(this.reporter.getCurrentSequenceTag())) {
                this.reporter.newSequence(ase);
            }
            if (act.includeInReports) {
                this.reporter.newActivity(act);
            }
        }
        this.setCounterValue(1, 0);
        this.setCounterValue(0, 0);
    }

    @Override
    public void reportNewAction(Activity act, String type, String source, String dest, boolean ok, int currentScore) {
        if (this.reporter != null && act.includeInReports && act.reportActions) {
            this.reporter.newAction(type, source, dest, ok);
        }
        if (currentScore >= 0) {
            this.incCounterValue(1);
            this.setCounterValue(0, currentScore);
        }
    }

    @Override
    public void reportEndActivity(Activity act, boolean solved) {
        if (this.reporter != null && act.includeInReports) {
            this.reporter.endActivity(this.counterVal[0], this.counterVal[1], solved);
        }
    }

    @Override
    public boolean showHelp(JComponent hlpComponent, String hlpMsg) {
        if (this.skin != null) {
            this.skin.showHelp(hlpComponent, hlpMsg);
            return true;
        }
        return false;
    }

    @Override
    public InputStream getProgressInputStream(InputStream is, int expectedLength, String name) {
        if (this.skin != null && is != null && !(is instanceof ByteArrayInputStream)) {
            is = this.skin.getProgressInputStream(is, expectedLength, name);
        }
        return is;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    public PlayerHistory getHistory() {
        return this.history;
    }

    @Override
    public void displayUrl(String url, boolean inFrame) {
        if (url != null) {
            url = this.project.getFileSystem().getUrl(url);
            try {
                this.displayUrl(new URL(url), inFrame);
            }
            catch (Exception ex) {
                System.err.println("Unable to invoque URL " + url + "\n" + ex);
            }
        }
    }

    public void displayUrl(URL url, boolean inFrame) {
        if (url == null) {
            return;
        }
        Applet applet = this.options.getApplet();
        try {
            if (applet != null && !this.options.getBoolean("Mac")) {
                if (inFrame) {
                    String frame = (String)this.options.get("infoUrlFrame");
                    if (frame == null) {
                        frame = "_BLANK";
                    }
                    applet.getAppletContext().showDocument(url, frame);
                } else {
                    this.end();
                    applet.getAppletContext().showDocument(url);
                }
            } else {
                BrowserLauncher.openURL(url.toExternalForm());
            }
        }
        catch (Exception ex) {
            System.err.println("Unable to invoque URL " + url + "\n" + ex);
        }
    }

    public void exit() {
        this.exit(null);
    }

    public void exit(String url) {
        final String sUrl = url == null ? this.options.getString("exitUrl") : url;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (sUrl != null) {
                    Player.this.displayUrl(sUrl, false);
                }
                if (Player.this.options.getApplet() == null) {
                    try {
                        Player.this.end();
                        Frame fr = JOptionPane.getFrameForComponent(Player.this.getTopComponent());
                        if (fr != null) {
                            fr.dispose();
                        } else {
                            System.exit(0);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("Unable to exit!\n" + ex);
                    }
                }
            }
        });
    }

    @Override
    public void requestFocus() {
        if (this.actPanel != null) {
            this.actPanel.requestFocus();
        }
    }

    @Override
    public String getMsg(String key) {
        return this.messages.get(key);
    }

    public void doAutoStart() {
    }

    @Override
    public boolean newInstanceRequest(final String param1, final String param2) {
        boolean result = false;
        if (param1 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Frame frame = JOptionPane.getFrameForComponent(Player.this);
                    if (frame != null) {
                        frame.toFront();
                    }
                    Player.this.load(param1, param2);
                }
            });
            result = true;
        }
        return result;
    }

    @Override
    public boolean windowCloseRequested() {
        return true;
    }

    public void setWindowTitle(String docTitle) {
        Window w = Options.getWindowForComponent(this);
        if (w != null) {
            StringBuilder sb = new StringBuilder();
            String s = StrUtils.nullableString(docTitle);
            if (s != null) {
                sb.append(s).append(" - ");
            }
            sb.append(this.appName);
            if (w instanceof Frame) {
                ((Frame)w).setTitle(sb.substring(0));
            } else if (w instanceof Dialog) {
                ((Dialog)w).setTitle(sb.substring(0));
            }
        }
    }

    public void setWindowTitle() {
        String actName;
        StringBuilder sb = new StringBuilder();
        String prjName = this.project == null ? null : StrUtils.nullableString(this.project.getPublicName());
        String string = actName = this.actPanel == null ? null : StrUtils.nullableString(this.actPanel.getActivity().getPublicName());
        if (actName != null) {
            sb.append(actName);
            if (prjName != null) {
                sb.append(" [");
            }
        }
        if (prjName != null) {
            sb.append(prjName);
            if (actName != null) {
                sb.append("]");
            }
        }
        this.setWindowTitle(sb.substring(0));
    }

    @Override
    public FressaFunctions getFressa() {
        return null;
    }
}

