/*
 * Decompiled with CFR 0.152.
 */
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.Player;
import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.RunnableComponent;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.jclic.project.ProjectInstallerDlg;
import edu.xtec.util.BasicResourceBridge;
import edu.xtec.util.Check;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.SwingWorker;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class JClicApplet
extends JApplet
implements Constants {
    private Options options = new Options(this);
    private RunnableComponent rc = null;
    private String activityPack = null;
    private String sequence = null;
    private boolean initiated = false;
    private boolean trace = false;
    private JLabel splashLabel = new JLabel(" ", ResourceManager.getImageIcon("icons/logo_applet.png"), 0);
    private boolean isInstaller;
    private static final String HTTP = "http:";
    private static final String HTTPS = "https";
    private static final String FILE = "file:";
    private static final String STRING = "string";
    private static final String BOOL = "boolean";
    private static final String URL = "url";
    private static final String ACTIVITY_PACK = "activityPack";
    private static final String SEQUENCE = "sequence";
    private static final int NUM_PRIVATE_PARAMS = 2;
    private static final String[][] pInfo = new String[][]{{"activityPack", "string", "absolute or relative URL of the JClic project to load"}, {"sequence", "string", "optional project's starting sequence name"}, {"language", "string", "two-char language code"}, {"country", "string", "two-char country code"}, {"variant", "string", "locale variant code"}, {"skin", "string", "skin to be used"}, {"cookie", "string", "optional session cookie value. currently not used"}, {"reporter", "string", "reporter class name"}, {"reporterParams", "string", "reporter parameters"}, {"exitUrl", "url", "URL where to redirect navigation at end"}, {"infoUrlFrame", "string", "optional frame where to display info documents. If unespecified, _BLANK will be used"}, {"systemSounds", "boolean", "to play or not system sounds"}, {"compressImages", "boolean", "to compress or not images in cells"}, {"lookAndFeel", "string", "look & feel to use"}, {"audioEnabled", "boolean", "to have audio enabled or not"}, {"mediaSystem", "string", "preferred multimedia system: 'JMF' for Java Media Framework or 'QT' for QuickTime"}, {"trace", "boolean", "show debug messages in console"}, {"myurl", "string", "URL of the document containing the applet, used as a base for relative paths"}};

    public JClicApplet() {
        this.splashLabel.setVerticalTextPosition(3);
        this.splashLabel.setHorizontalTextPosition(0);
        this.splashLabel.setBackground(BG_COLOR);
        this.splashLabel.setOpaque(true);
        this.getContentPane().add((Component)this.splashLabel, "Center");
    }

    @Override
    public void init() {
        if (this.initiated) {
            return;
        }
        this.initiated = true;
        this.trace = "true".equals(this.getParameter("trace"));
        final StringBuilder sb = new StringBuilder();
        final JClicApplet rpc = this;
        SwingWorker sw = new SwingWorker(){

            @Override
            public Object construct() {
                Messages messages;
                for (int i = 2; i < pInfo.length; ++i) {
                    JClicApplet.this.options.put(pInfo[i][0], JClicApplet.this.getParameter(pInfo[i][0]));
                    if (!JClicApplet.this.trace) continue;
                    System.out.println(">>> param " + pInfo[i][0] + " is " + JClicApplet.this.getParameter(pInfo[i][0]));
                }
                try {
                    messages = PersistentSettings.getMessages(JClicApplet.this.options, "messages.JClicMessages");
                }
                catch (Exception ex) {
                    System.err.println("Unable to get default user messages language!\n" + ex);
                    messages = Messages.getMessages(JClicApplet.this.options, "messages.JClicMessages");
                }
                messages.addBundle("commonSettings");
                if (JClicApplet.this.splashLabel != null) {
                    JClicApplet.this.splashLabel.setText(messages.get("LOADING"));
                }
                if (!Check.checkSignature(JClicApplet.this.options, true)) {
                    return null;
                }
                CheckMediaSystem.check(JClicApplet.this.options, false);
                JClicApplet.this.activityPack = JClicApplet.this.getParameter(JClicApplet.ACTIVITY_PACK);
                JClicApplet.this.sequence = JClicApplet.this.getParameter(JClicApplet.SEQUENCE);
                if (JClicApplet.this.activityPack != null) {
                    if (JClicApplet.this.activityPack.indexOf("http://") < 0 && JClicApplet.this.activityPack.indexOf("https://") < 0 && JClicApplet.this.activityPack.indexOf(":") < 1 && JClicApplet.this.activityPack.indexOf("\\\\") < 0) {
                        String s;
                        int i;
                        String base = "";
                        URL baseURL = JClicApplet.this.getDocumentBase();
                        if (baseURL != null) {
                            base = baseURL.toString();
                        } else if (JClicApplet.this.options.getString("myurl") != null) {
                            base = JClicApplet.this.options.getString("myurl");
                        }
                        if (JClicApplet.this.trace) {
                            System.out.println(">>> original base is: " + base);
                        }
                        if ((i = base.indexOf("file:/")) >= 0) {
                            base = base.substring(i + 6);
                            if (JClicApplet.this.trace) {
                                System.out.println(">>> protocol is 'file', so base is: " + base);
                            }
                            if (!JClicApplet.this.options.getBoolean("Windows") && !base.startsWith(File.pathSeparator)) {
                                base = "/" + base;
                                if (JClicApplet.this.trace) {
                                    System.out.println(">>> non-Windows and not starts with '/', so base is: " + base);
                                }
                            }
                        }
                        if (base.startsWith("/localhost/")) {
                            base = base.substring(11);
                        }
                        if (base.endsWith(".htm") || base.endsWith(".html")) {
                            i = base.lastIndexOf(47);
                            if (i < 0) {
                                i = base.lastIndexOf(92);
                            }
                            if (i > 0) {
                                base = base.substring(0, i + 1);
                            }
                        }
                        JClicApplet.this.options.put("urlBase", base);
                        if (JClicApplet.this.trace) {
                            System.out.println(">>> corrected base is: " + base);
                        }
                        JClicApplet.this.activityPack = base + JClicApplet.this.activityPack;
                        if (JClicApplet.this.trace) {
                            System.out.println(">>> project path is: " + JClicApplet.this.activityPack);
                        }
                        if (!((s = JClicApplet.this.options.getString("skin")) == null || s.startsWith("@") || s.startsWith(JClicApplet.HTTP) || s.startsWith(JClicApplet.HTTPS) || s.startsWith(JClicApplet.FILE))) {
                            JClicApplet.this.options.put("skin", base + s);
                        }
                        if (!((s = JClicApplet.this.options.getString("exitUrl")) == null || s.startsWith(JClicApplet.HTTP) || s.startsWith(JClicApplet.HTTPS) || s.startsWith(JClicApplet.FILE))) {
                            JClicApplet.this.options.put("exitUrl", base + s);
                        }
                    }
                    if (JClicApplet.this.activityPack.endsWith(".jclic.inst")) {
                        JClicApplet.this.isInstaller = true;
                        messages.addBundle("messages.PlayerMessages");
                    }
                }
                try {
                    if (JClicApplet.this.isInstaller) {
                        String installer = JClicApplet.this.activityPack;
                        JClicApplet.this.activityPack = null;
                        BasicResourceBridge rb = new BasicResourceBridge(JClicApplet.this.options);
                        PlayerSettings settings = PlayerSettings.loadPlayerSettings(rb);
                        if (settings.promptPassword(null, null)) {
                            settings.checkLibrary();
                            ProjectInstallerDlg pi = ProjectInstallerDlg.getProjectInstallerDlg(null, settings.libraryManager, installer);
                            if (pi != null) {
                                pi.setVisible(true);
                                if (!pi.cancel && pi.launchNow && pi.pathToMainProject != null) {
                                    JClicApplet.this.activityPack = pi.pathToMainProject;
                                }
                            }
                        }
                    }
                    if (JClicApplet.this.activityPack != null) {
                        JClicApplet.this.rc = new Player(JClicApplet.this.options);
                    }
                }
                catch (Exception ex) {
                    sb.append("ERROR: ").append(ex);
                }
                return JClicApplet.this.rc;
            }

            @Override
            public void finished() {
                if (this.getValue() == null) {
                    if (JClicApplet.this.isInstaller && JClicApplet.this.options.getString("exitUrl") != null) {
                        try {
                            String url = JClicApplet.this.options.getString("exitUrl");
                            if (url.indexOf(58) < 0) {
                                url = "file://" + url;
                            }
                            JClicApplet.this.getAppletContext().showDocument(new URL(url));
                        }
                        catch (Exception ex) {
                            sb.append("ERROR: ").append(ex);
                        }
                    }
                    if (JClicApplet.this.splashLabel != null) {
                        String s = sb.substring(0);
                        JClicApplet.this.splashLabel.setText(s);
                        System.err.println(s);
                    }
                } else {
                    JClicApplet.this.getContentPane().removeAll();
                    JClicApplet.this.splashLabel = null;
                    JClicApplet.this.rc.addTo(rpc, "Center");
                    JClicApplet.this.getRootPane().revalidate();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JClicApplet.this.rc.start(JClicApplet.this.activityPack, JClicApplet.this.sequence);
                        }
                    });
                }
            }
        };
        if (this.trace) {
            System.out.println(">>> initializing...");
        }
        sw.start();
    }

    @Override
    public void start() {
        if (this.trace) {
            System.out.println(">>> applet started");
        }
    }

    @Override
    public void stop() {
        if (this.rc != null) {
            this.rc.stop();
        }
        if (this.trace) {
            System.out.println(">>> applet stopped");
        }
    }

    @Override
    public void destroy() {
        if (this.rc != null) {
            if (this.trace) {
                System.out.println(">>> destroying applet...");
            }
            this.getContentPane().removeAll();
            this.rc.end();
            this.rc = null;
            this.initiated = false;
        }
        if (this.trace) {
            System.out.println(">>> applet destroyed");
        }
    }

    @Override
    public String getAppletInfo() {
        return "JClic applet";
    }

    @Override
    public String[][] getParameterInfo() {
        return pInfo;
    }
}

