/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util.db;

import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.JNDIConnectionBeanProvider;
import edu.xtec.util.db.PooledConnectionBeanProvider;
import edu.xtec.util.db.SingleConnectionBeanProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ConnectionBeanProvider {
    public static final String DB_DRIVER = "dbDriver";
    public static final String DB_SERVER = "dbServer";
    public static final String DB_LOGIN = "dbLogin";
    public static final String DB_PASSWORD = "dbPassword";
    public static final String MAP_STATEMENTS = "dbMapStatements";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    protected String dbDriver;
    protected String dbServer;
    protected String dbLogin;
    protected String dbPassword;
    protected boolean mapStatements;
    private int useCount;
    private static HashMap cbProviders;

    protected void setUp(Map map) throws Exception {
        this.dbDriver = this.getValue(map, DB_DRIVER, null);
        this.dbServer = this.getValue(map, DB_SERVER, null);
        this.dbLogin = this.getValue(map, DB_LOGIN, null);
        this.dbPassword = this.getValue(map, DB_PASSWORD, null);
        this.mapStatements = !FALSE.equals(this.getValue(map, MAP_STATEMENTS, TRUE));
        this.useCount = 0;
    }

    public abstract ConnectionBean getConnectionBean();

    public abstract String freeConnectionBean(ConnectionBean var1);

    protected abstract void destroy();

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DB_DRIVER).append(": ").append(this.dbDriver).append("<br>\n");
        stringBuffer.append(DB_SERVER).append(": ").append(this.dbServer).append("<br>\n");
        stringBuffer.append(DB_LOGIN).append(": ").append(this.dbLogin).append("<br>\n");
        stringBuffer.append(MAP_STATEMENTS).append(": ").append(this.mapStatements).append("<br>\n");
        stringBuffer.append("Use count:").append(this.useCount).append("<br>\n");
        return stringBuffer.substring(0);
    }

    public static String getGlobalInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (cbProviders == null) {
            cbProviders = new HashMap(2);
        }
        stringBuffer.append("<b>").append(cbProviders.size()).append(" ConnectionBeanProviders created</b><br>\n");
        Iterator iterator = cbProviders.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionBeanProvider connectionBeanProvider = (ConnectionBeanProvider)cbProviders.get(iterator.next());
            stringBuffer.append("<hr>\n");
            stringBuffer.append(connectionBeanProvider.getInfo());
        }
        return stringBuffer.substring(0);
    }

    public static ConnectionBeanProvider getConnectionBeanProvider(boolean bl, String string, String string2, String string3, String string4, boolean bl2) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(DB_DRIVER, string);
        hashMap.put(DB_SERVER, string2);
        hashMap.put(DB_LOGIN, string3);
        hashMap.put(DB_PASSWORD, string4);
        hashMap.put(MAP_STATEMENTS, bl2 ? TRUE : FALSE);
        return ConnectionBeanProvider.getConnectionBeanProvider(bl, hashMap);
    }

    public static ConnectionBeanProvider getConnectionBeanProvider(boolean bl, Map map) throws Exception {
        ConnectionBeanProvider connectionBeanProvider = null;
        String string = (String)map.get(DB_DRIVER);
        String string2 = (String)map.get(DB_SERVER);
        String string3 = (String)map.get(DB_LOGIN);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append("@");
        stringBuffer.append(string2).append("@");
        stringBuffer.append(string3).append("@");
        stringBuffer.append(bl ? "POOLED" : "DIRECT");
        String string4 = stringBuffer.substring(0);
        if (cbProviders == null) {
            cbProviders = new HashMap(2);
        }
        Iterator iterator = cbProviders.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k == null || !k.equals(string4)) continue;
            connectionBeanProvider = (ConnectionBeanProvider)cbProviders.get(k);
            break;
        }
        if (connectionBeanProvider == null) {
            connectionBeanProvider = "JNDI".equals(string) ? new JNDIConnectionBeanProvider() : (bl ? new PooledConnectionBeanProvider() : new SingleConnectionBeanProvider());
            ((ConnectionBeanProvider)connectionBeanProvider).setUp(map);
            cbProviders.put(string4, connectionBeanProvider);
        }
        ++connectionBeanProvider.useCount;
        return connectionBeanProvider;
    }

    public static void freeConnectionBeanProvider(ConnectionBeanProvider connectionBeanProvider) {
        if (connectionBeanProvider != null && cbProviders != null) {
            Iterator iterator = cbProviders.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ConnectionBeanProvider connectionBeanProvider2 = (ConnectionBeanProvider)cbProviders.get(string);
                if (connectionBeanProvider2 == null || !connectionBeanProvider2.equals(connectionBeanProvider) || --connectionBeanProvider.useCount > 0) continue;
                connectionBeanProvider.destroy();
                cbProviders.remove(string);
                break;
            }
        }
    }

    protected String getValue(Map map, String string, String string2) {
        String string3 = (String)map.get(string);
        if (string3 == null || string3.trim().length() == 0) {
            string3 = string2;
        }
        return string3;
    }
}

