/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.report.ActivityReg;
import edu.xtec.util.Html;
import edu.xtec.util.Messages;
import java.io.Serializable;
import java.util.Vector;

public class SequenceReg
implements Serializable {
    String name;
    String description;
    Vector activities;
    ActivityReg currentActivity;
    long totalTime;
    boolean closed;
    protected transient Info info;

    public SequenceReg(ActivitySequenceElement activitySequenceElement) {
        this.name = activitySequenceElement.getTag();
        this.description = activitySequenceElement.getDescription();
        this.activities = new Vector();
        this.currentActivity = null;
        this.totalTime = 0L;
        this.closed = false;
        this.info = new Info();
    }

    public String toHtmlString(Messages messages) {
        Html html = new Html(3000);
        int n = this.activities.size();
        String string = new Html(200).td(this.name, 0, false, "ROWSPAN=\"" + messages.getNumber(n) + "\"").toString();
        for (int i = 0; i < this.activities.size(); ++i) {
            html.append(((ActivityReg)this.activities.get(i)).toHtmlString(messages, string));
            string = null;
        }
        return html.toString();
    }

    public Info getInfo(boolean bl) {
        if (bl) {
            this.info.recalc();
        }
        return this.info;
    }

    void newActivity(Activity activity) {
        if (!this.closed) {
            this.currentActivity = new ActivityReg(activity);
            this.activities.add(this.currentActivity);
        }
    }

    void newAction(String string, String string2, String string3, boolean bl) {
        if (this.currentActivity != null) {
            this.currentActivity.newAction(string, string2, string3, bl);
        }
    }

    void endActivity(int n, int n2, boolean bl) {
        if (this.currentActivity != null) {
            this.currentActivity.endActivity(n, n2, bl);
        }
    }

    void endSequence() {
        if (this.currentActivity != null) {
            if (!this.currentActivity.closed) {
                this.currentActivity.closeActivity();
            }
            ActivityReg activityReg = this.getActivityReg(0);
            this.totalTime = this.currentActivity.startTime + this.currentActivity.totalTime - activityReg.startTime;
        }
    }

    ActivityReg getActivityReg(int n) {
        return n >= this.activities.size() ? null : (ActivityReg)this.activities.get(n);
    }

    public String toString() {
        return new StringBuffer("SEQUENCE: ").append(this.name).substring(0);
    }

    public class Info {
        public int nActivities;
        public int nActClosed;
        public int nActSolved;
        public int nActScore;
        public int percentSolved;
        public int nActions;
        public long tScore;
        public long tTime;

        protected Info() {
            this.clear();
        }

        protected void clear() {
            this.nActions = 0;
            this.percentSolved = 0;
            this.nActScore = 0;
            this.nActSolved = 0;
            this.nActClosed = 0;
            this.nActivities = 0;
            this.tTime = 0L;
            this.tScore = 0L;
        }

        public void recalc() {
            this.clear();
            this.nActivities = SequenceReg.this.activities.size();
            if (this.nActivities > 0) {
                for (int i = 0; i < this.nActivities; ++i) {
                    int n;
                    ActivityReg activityReg = SequenceReg.this.getActivityReg(i);
                    if (!activityReg.closed) continue;
                    ++this.nActClosed;
                    this.tTime += activityReg.totalTime;
                    this.nActions += activityReg.numActions;
                    if (activityReg.solved) {
                        ++this.nActSolved;
                    }
                    if ((n = activityReg.getPrecision()) < 0) continue;
                    this.tScore += (long)n;
                    ++this.nActScore;
                }
                if (this.nActClosed > 0) {
                    this.percentSolved = this.nActSolved * 100 / this.nActClosed;
                }
                if (this.nActScore > 0) {
                    this.tScore /= (long)this.nActScore;
                }
            }
        }
    }
}

