/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.activities.panels.Menu;
import edu.xtec.jclic.project.LibraryManagerElement;
import edu.xtec.jclic.project.NewLibraryDlg;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.util.Domable;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Element;

public class LibraryManager
implements Domable {
    protected DefaultListModel libraries;
    protected PlayerSettings settings;
    protected boolean modified;
    public boolean autoRun;
    public static final String AUTO_RUN = "autoRun";
    public static final String ELEMENT_NAME = "libraryManager";
    private static final String MSG_ID = "libraryManager_";

    public LibraryManager(PlayerSettings playerSettings) {
        this.settings = playerSettings;
        this.libraries = new DefaultListModel();
        this.modified = false;
        this.autoRun = true;
    }

    public static LibraryManager getLibraryManager(PlayerSettings playerSettings, Element element) throws Exception {
        LibraryManager libraryManager = new LibraryManager(playerSettings);
        libraryManager.setProperties(element, null);
        return libraryManager;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.autoRun = JDomUtility.getBoolAttr(element, AUTO_RUN, this.autoRun);
        Iterator iterator = element.getChildren("library").iterator();
        while (iterator.hasNext()) {
            this.libraries.addElement(LibraryManagerElement.getLibraryManagerElement((Element)iterator.next(), this.settings.rb.getOptions()));
        }
    }

    public void addNewLibrary(String string, String string2) throws Exception {
        File file = new File(string);
        if (file.exists()) {
            ProjectLibrary projectLibrary = ProjectLibrary.loadProjectLibrary(string, this.settings.rb);
            string2 = projectLibrary.settings.title;
        } else {
            if (string2 == null) {
                string2 = this.settings.rb.getMsg("libraryManager_mainLibraryTitle");
            }
            ProjectLibrary projectLibrary = ProjectLibrary.createNewProjectLibrary(this.settings.rb, this.settings.fileSystem);
            projectLibrary.settings.title = string2;
            projectLibrary.save(string);
        }
        this.libraries.addElement(new LibraryManagerElement(string2, string, this.settings.rb.getOptions()));
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(AUTO_RUN, JDomUtility.boolString(this.autoRun));
        for (int i = 0; i < this.libraries.size(); ++i) {
            LibraryManagerElement libraryManagerElement = (LibraryManagerElement)this.libraries.get(i);
            element.addContent(libraryManagerElement.getJDomElement());
        }
        return element;
    }

    public boolean isEmpty() {
        return this.libraries.isEmpty();
    }

    public ProjectLibrary getAutoStartProjectLibrary() throws Exception {
        ProjectLibrary projectLibrary = null;
        if (this.autoRun && !this.isEmpty()) {
            if (this.libraries.size() > 1) {
                projectLibrary = this.selectProjectLibrary(false, false);
            } else {
                Menu menu;
                projectLibrary = ProjectLibrary.loadProjectLibrary(((LibraryManagerElement)this.libraries.get((int)0)).path, this.settings.rb);
                if (projectLibrary != null && ((menu = projectLibrary.getRootMenu()) == null || menu.getMenuElementCount() < 1)) {
                    projectLibrary = null;
                }
            }
        }
        return projectLibrary;
    }

    public ProjectLibrary selectProjectLibrary(boolean bl, boolean bl2) throws Exception {
        ProjectLibrary projectLibrary = null;
        if (!this.libraries.isEmpty() || bl) {
            LibraryDialog libraryDialog = new LibraryDialog(bl, bl2);
            libraryDialog.setVisible(true);
            if (libraryDialog.result != null) {
                projectLibrary = ProjectLibrary.loadProjectLibrary(libraryDialog.result.path, this.settings.rb);
            }
        }
        return projectLibrary;
    }

    public int getNumLibraries() {
        return this.libraries.getSize();
    }

    public LibraryManagerElement locateNewProjectLibrary(String string) {
        LibraryManagerElement libraryManagerElement = null;
        ProjectLibrary projectLibrary = null;
        ResourceBridge resourceBridge = this.settings.rb;
        if (string == null) {
            int[] nArray = new int[]{0};
            String string2 = this.settings.fileSystem.chooseFile(this.settings.rootPath + File.separator + ".", false, nArray, resourceBridge.getOptions(), null, resourceBridge.getComponent(), false);
            if (string2 != null) {
                string = this.settings.fileSystem.getFullFileNamePath(string2);
            }
        }
        if (string != null && !this.elementExists(string, true)) {
            try {
                projectLibrary = ProjectLibrary.loadProjectLibrary(string, resourceBridge);
                libraryManagerElement = new LibraryManagerElement(projectLibrary.settings.title, string, resourceBridge.getOptions());
            }
            catch (Exception exception) {
                this.settings.rb.getOptions().getMessages().showErrorWarning((Component)resourceBridge.getComponent(), "FILE_ERR_READING", string, exception, null);
            }
        }
        return libraryManagerElement;
    }

    public LibraryManagerElement createNewProjectLibrary(String string, String string2) {
        Object object;
        LibraryManagerElement libraryManagerElement = null;
        ResourceBridge resourceBridge = this.settings.rb;
        if (string2 == null) {
            string2 = resourceBridge.getMsg("library_newLibraryName");
        }
        if (string == null) {
            object = new int[]{0};
            String string3 = this.settings.fileSystem.chooseFile(this.settings.rootPath + File.separator + "library.jclic", true, (int[])object, resourceBridge.getOptions(), null, resourceBridge.getComponent(), false);
            if (string3 != null) {
                string = this.settings.fileSystem.getFullFileNamePath(string3);
            }
        }
        if (string != null && !this.elementExists(string, true)) {
            object = ProjectLibrary.createNewProjectLibrary(resourceBridge, this.settings.fileSystem);
            try {
                ((ProjectLibrary)object).save(string);
                libraryManagerElement = new LibraryManagerElement(((ProjectLibrary)object).settings.title, string, resourceBridge.getOptions());
            }
            catch (Exception exception) {
                this.settings.rb.getOptions().getMessages().showErrorWarning((Component)resourceBridge.getComponent(), "FILE_ERR_SAVING", string, exception, null);
            }
        }
        return libraryManagerElement;
    }

    public boolean elementExists(String string, boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < this.libraries.size(); ++i) {
            LibraryManagerElement libraryManagerElement = (LibraryManagerElement)this.libraries.get(i);
            if (!string.equals(this.settings.fileSystem.getFullFileNamePath(libraryManagerElement.path))) continue;
            bl2 = true;
            if (!bl) break;
            this.settings.rb.getOptions().getMessages().showAlert((Component)this.settings.rb.getComponent(), "libraryManager_new_exists");
            break;
        }
        return bl2;
    }

    public LibraryPane getLibraryPane(boolean bl, boolean bl2) {
        return new LibraryPane(bl, bl2);
    }

    class LibraryDialog
    extends ExtendedJDialog
    implements ListSelectionListener {
        LibraryManagerElement result;
        Action selectAction;
        Action cancelAction;
        LibraryPane pane;
        boolean allowEdit;
        boolean onlyEditable;

        LibraryDialog(boolean bl, boolean bl2) {
            super(LibraryManager.this.settings.rb.getComponent(), LibraryManager.this.settings.rb.getMsg("libraryManager_caption"), true);
            this.result = null;
            this.allowEdit = bl;
            this.onlyEditable = bl2;
            this.pane = new LibraryPane(bl, bl2);
            this.pane.setOpaque(false);
            this.buildActions();
            this.pane.addListSelectionListener(this);
            this.getContentPane().add((Component)this.pane, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            JButton jButton = new JButton(this.selectAction);
            jButton.setDefaultCapable(true);
            jPanel.add(jButton);
            jPanel.add(new JButton(this.cancelAction));
            this.getContentPane().add((Component)jPanel, "South");
            this.getRootPane().setDefaultButton(jButton);
            this.pack();
            this.centerOver(LibraryManager.this.settings.rb.getComponent());
            this.pane.list.setSelectedIndex(0);
            this.valueChanged(new ListSelectionEvent(this.pane.list, 0, 0, false));
            this.valueChanged(null);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent != null && !listSelectionEvent.getValueIsAdjusting()) {
                LibraryManagerElement libraryManagerElement = this.pane.getCurrentSelected();
                this.selectAction.setEnabled(libraryManagerElement != null && libraryManagerElement.exists && (!this.onlyEditable || libraryManagerElement.editable));
            }
        }

        void closeDialog() {
            if (LibraryManager.this.modified) {
                LibraryManager.this.settings.save();
                LibraryManager.this.modified = false;
            }
            this.setVisible(false);
        }

        void buildActions() {
            Options options = LibraryManager.this.settings.rb.getOptions();
            this.selectAction = new AbstractAction(options.getMsg("libraryManager_select_caption"), ResourceManager.getImageIcon("icons/file_open.gif")){

                public void actionPerformed(ActionEvent actionEvent) {
                    LibraryDialog.this.result = (LibraryManagerElement)LibraryDialog.this.pane.list.getSelectedValue();
                    LibraryDialog.this.closeDialog();
                }
            };
            this.selectAction.putValue("ShortDescription", options.getMsg("libraryManager_select_tooltip"));
            this.selectAction.setEnabled(false);
            this.cancelAction = new AbstractAction(options.getMsg("libraryManager_cancel_caption"), ResourceManager.getImageIcon("icons/cancel.gif")){

                public void actionPerformed(ActionEvent actionEvent) {
                    LibraryDialog.this.result = null;
                    LibraryDialog.this.closeDialog();
                }
            };
            this.cancelAction.putValue("ShortDescription", options.getMsg("libraryManager_cancel_tooltip"));
        }
    }

    public class LibraryPane
    extends JPanel
    implements ListSelectionListener {
        Action editAction;
        Action newLibraryAction;
        Action deleteAction;
        JList list;
        boolean allowEdit;
        boolean onlyEditable;
        LibraryManagerElement current;

        LibraryPane(boolean bl, boolean bl2) {
            super(new BorderLayout());
            this.current = null;
            this.allowEdit = bl;
            this.onlyEditable = bl2;
            this.buildActions();
            this.list = new JList(LibraryManager.this.libraries);
            this.list.setSelectionMode(0);
            this.list.addListSelectionListener(this);
            if (this.list.getModel().getSize() > 0) {
                this.list.setSelectedIndex(0);
            }
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof LibraryManagerElement) {
                        LibraryManagerElement libraryManagerElement = (LibraryManagerElement)object;
                        this.setIcon(libraryManagerElement.getIcon());
                        if (!libraryManagerElement.exists || !libraryManagerElement.editable && LibraryPane.this.onlyEditable) {
                            this.setForeground(SystemColor.textInactiveText);
                        }
                    }
                    return this;
                }
            });
            this.add((Component)new JScrollPane(this.list), "Center");
            if (bl) {
                JPanel jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.add(new JButton(this.editAction));
                jPanel.add(new JButton(this.newLibraryAction));
                jPanel.add(new JButton(this.deleteAction));
                this.add((Component)jPanel, "South");
            }
        }

        void buildActions() {
            final Options options = LibraryManager.this.settings.rb.getOptions();
            this.editAction = new AbstractAction(options.getMsg("libraryManager_edit_caption"), ResourceManager.getImageIcon("icons/edit.gif")){

                public void actionPerformed(ActionEvent actionEvent) {
                    LibraryManagerElement libraryManagerElement = (LibraryManagerElement)LibraryPane.this.list.getSelectedValue();
                    if (libraryManagerElement != null) {
                        try {
                            if (!((LibraryPane)LibraryPane.this).LibraryManager.this.settings.promptPassword(LibraryPane.this, null)) {
                                return;
                            }
                            ProjectLibrary projectLibrary = ProjectLibrary.loadProjectLibrary(libraryManagerElement.path, ((LibraryPane)LibraryPane.this).LibraryManager.this.settings.rb);
                            if (projectLibrary.editProjectLibrary(LibraryPane.this) && !projectLibrary.settings.title.equals(libraryManagerElement.name)) {
                                libraryManagerElement.name = projectLibrary.settings.title;
                                ((LibraryPane)LibraryPane.this).LibraryManager.this.modified = true;
                                LibraryPane.this.list.repaint();
                            }
                        }
                        catch (Exception exception) {
                            System.err.println("Unable edit projectLibrary:\n" + exception);
                            return;
                        }
                    }
                }
            };
            this.editAction.putValue("ShortDescription", options.getMsg("libraryManager_edit_tooltip"));
            this.editAction.setEnabled(false);
            this.deleteAction = new AbstractAction(options.getMsg("libraryManager_delete_caption"), ResourceManager.getImageIcon("icons/delete.gif")){

                public void actionPerformed(ActionEvent actionEvent) {
                    LibraryManagerElement libraryManagerElement = (LibraryManagerElement)LibraryPane.this.list.getSelectedValue();
                    if (libraryManagerElement != null) {
                        int n = LibraryPane.this.list.getSelectedIndex();
                        try {
                            if (!((LibraryPane)LibraryPane.this).LibraryManager.this.settings.promptPassword(LibraryPane.this, null) || options.getMessages().showQuestionDlg(null, "libraryManager_delete_confirm", null, "yn") != 1) {
                                return;
                            }
                            ((LibraryPane)LibraryPane.this).LibraryManager.this.libraries.removeElement(libraryManagerElement);
                            ((LibraryPane)LibraryPane.this).LibraryManager.this.modified = true;
                            LibraryPane.this.list.setSelectedIndex(Math.max(0, n - 1));
                        }
                        catch (Exception exception) {
                            System.err.println("Unable to delete projectLibrary:\n" + exception);
                            return;
                        }
                    }
                }
            };
            this.deleteAction.putValue("ShortDescription", options.getMsg("libraryManager_delete_tooltip"));
            this.deleteAction.setEnabled(false);
            this.newLibraryAction = new AbstractAction(options.getMsg("libraryManager_new_caption"), ResourceManager.getImageIcon("icons/database_new.gif")){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!((LibraryPane)LibraryPane.this).LibraryManager.this.settings.promptPassword(LibraryPane.this, null)) {
                        return;
                    }
                    LibraryManagerElement libraryManagerElement = NewLibraryDlg.getLibraryManagerElement(LibraryManager.this, LibraryPane.this);
                    if (libraryManagerElement != null) {
                        ((LibraryPane)LibraryPane.this).LibraryManager.this.modified = true;
                        ((LibraryPane)LibraryPane.this).LibraryManager.this.libraries.addElement(libraryManagerElement);
                        LibraryPane.this.list.setSelectedValue(libraryManagerElement, true);
                    }
                }
            };
            this.newLibraryAction.putValue("ShortDescription", options.getMsg("libraryManager_new_tooltip"));
        }

        public LibraryManagerElement getCurrentSelected() {
            return this.current;
        }

        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
            this.list.addListSelectionListener(listSelectionListener);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent != null && !listSelectionEvent.getValueIsAdjusting()) {
                this.current = (LibraryManagerElement)this.list.getSelectedValue();
                this.editAction.setEnabled(this.current != null && this.current.editable);
                this.deleteAction.setEnabled(this.current != null);
            }
        }
    }
}

