/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.AudioPlayer;
import edu.xtec.jclic.media.QT61Tools;
import quicktime.app.time.TaskAllMovies;
import quicktime.app.view.MoviePlayer;

public class QT61AudioPlayer
implements AudioPlayer {
    MoviePlayer player = null;

    public void play() {
        if (this.player != null) {
            this.stop();
            try {
                this.player.setTime(0);
                TaskAllMovies.addMovieAndStart();
                this.player.getMovie().setActive(true);
                this.player.setRate(1.0f);
            }
            catch (Exception exception) {
                System.err.println("QT Exception:\n" + exception);
            }
        }
    }

    public boolean setDataSource(Object object) throws Exception {
        this.close();
        this.player = QT61Tools.getPlayer(object);
        return this.player != null;
    }

    public void stop() {
        if (this.player != null) {
            try {
                this.player.setRate(0.0f);
                this.player.getMovie().setActive(false);
                TaskAllMovies.removeMovie();
            }
            catch (Exception exception) {
                System.err.println("QT Error:\n" + exception);
            }
        }
    }

    public void close() {
        if (this.player != null) {
            this.stop();
            if (this.player != null) {
                try {
                    this.player.getMovie().disposeQTObject();
                }
                catch (Exception exception) {
                    System.err.println("QT Error:\n" + exception);
                }
            }
            this.player = null;
        }
    }

    public void realize(String string, MediaBag mediaBag) throws Exception {
        if (string != null) {
            this.setDataSource(mediaBag.getMediaDataSource(string));
        }
    }
}

