/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.EventSoundsElement;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.jdom.Element;

public class EventSounds
implements Domable,
Cloneable {
    public static boolean globalEnabled = true;
    public static final String ELEMENT_NAME = "eventSounds";
    public static final String ENABLED = "enabled";
    public static final int START = 0;
    public static final int CLICK = 1;
    public static final int ACTION_ERROR = 2;
    public static final int ACTION_OK = 3;
    public static final int FINISHED_ERROR = 4;
    public static final int FINISHED_OK = 5;
    public static final int NUM_EVENTS = 6;
    public static final String[] EVENT_NAMES = new String[]{"start", "click", "actionError", "actionOk", "finishedError", "finishedOk"};
    protected EventSounds parent;
    protected EventSoundsElement[] elements = new EventSoundsElement[6];
    protected int enabled = 2;

    public EventSounds(EventSounds eventSounds) {
        this.parent = eventSounds;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        boolean bl = true;
        if (this.enabled != 2) {
            element.setAttribute(ENABLED, JDomUtility.triStateString(this.enabled));
            bl = false;
        }
        for (int i = 0; i < 6; ++i) {
            Element element2;
            if (this.elements[i] == null || (element2 = this.elements[i].getJDomElement()) == null) continue;
            element.addContent(element2);
            bl = false;
        }
        return bl ? null : element;
    }

    public static EventSounds getEventSounds(Element element) throws Exception {
        EventSounds eventSounds = new EventSounds(null);
        eventSounds.setProperties(element, null);
        return eventSounds;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.enabled = JDomUtility.getTriStateAttr(element, ENABLED, this.enabled);
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            int n;
            EventSoundsElement eventSoundsElement = EventSoundsElement.getEventSoundsElement((Element)iterator.next());
            if (eventSoundsElement == null || (n = JDomUtility.getStrIndexAttr(eventSoundsElement.getId(), EVENT_NAMES, -1)) < 0 || n >= 6) continue;
            this.elements[n] = eventSoundsElement;
        }
    }

    public static void listReferences(Element element, HashMap hashMap) {
        Iterator iterator = element.getChildren("sound").iterator();
        while (iterator.hasNext()) {
            String string;
            Element element2 = (Element)iterator.next();
            if (element2 == null || (string = element2.getAttributeValue("file")) == null) continue;
            hashMap.put(string, "media");
        }
    }

    public HashMap getReferences() {
        HashMap hashMap = new HashMap();
        Element element = this.getJDomElement();
        if (element != null) {
            EventSounds.listReferences(element, hashMap);
        }
        return hashMap;
    }

    public void setParent(EventSounds eventSounds) {
        this.parent = eventSounds;
    }

    public boolean realize(Options options, MediaBag mediaBag) {
        Exception exception = null;
        try {
            for (int i = 0; i < 6; ++i) {
                if (this.elements[i] == null) continue;
                this.elements[i].realize(options, mediaBag);
            }
        }
        catch (Exception exception2) {
            System.err.println("Error realizing event sound:\n" + exception2);
            exception = exception2;
        }
        return exception == null;
    }

    public void setDataSource(int n, Object object, Options options) throws Exception {
        if (n < 0 || n >= 6) {
            return;
        }
        if (this.elements[n] == null) {
            this.elements[n] = new EventSoundsElement(EVENT_NAMES[n]);
        }
        this.elements[n].setDataSource(object, options);
    }

    public EventSoundsElement getElement(int n) {
        if (n < 0 || n >= 6) {
            return null;
        }
        return this.elements[n];
    }

    public EventSoundsElement createElement(int n) {
        if (n < 0 || n >= 6) {
            return null;
        }
        if (this.elements[n] == null) {
            this.elements[n] = new EventSoundsElement(EVENT_NAMES[n]);
        }
        return this.elements[n];
    }

    public int getEnabledChain(int n) {
        int n2 = this.enabled;
        if (n2 == 2 && n >= 0 && n < 6) {
            if (this.elements[n] == null) {
                n2 = this.parent == null ? n2 : this.parent.getEnabledChain(n);
            } else {
                n2 = this.elements[n].getEnabled();
                if (n2 == 2 && this.parent != null) {
                    n2 = this.parent.getEnabledChain(n);
                }
            }
        }
        return n2;
    }

    public EventSoundsElement getElementChain(int n) {
        EventSoundsElement eventSoundsElement = null;
        if (n < 0 || n >= 6) {
            return null;
        }
        eventSoundsElement = this.elements[n];
        if (eventSoundsElement == null && this.parent != null) {
            return this.parent.getElementChain(n);
        }
        return eventSoundsElement;
    }

    public void playNow(int n) {
        if (!globalEnabled) {
            return;
        }
        EventSoundsElement eventSoundsElement = null;
        if (this.getEnabledChain(n) != 0 && (eventSoundsElement = this.getElementChain(n)) != null) {
            eventSoundsElement.play();
        }
    }

    public void play(int n) {
        if (!globalEnabled) {
            return;
        }
        EventSoundsElement eventSoundsElement = null;
        if (this.getEnabledChain(n) != 0 && (eventSoundsElement = this.getElementChain(n)) != null) {
            final EventSoundsElement eventSoundsElement2 = eventSoundsElement;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    eventSoundsElement2.play();
                }
            });
        }
    }

    public void close() {
        for (int i = 0; i < 6; ++i) {
            if (this.elements[i] == null) continue;
            this.elements[i].close();
            this.elements[i] = null;
        }
        this.parent = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Object clone() {
        EventSounds eventSounds = new EventSounds(this.parent);
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null) continue;
            eventSounds.elements[i] = (EventSoundsElement)this.elements[i].clone();
        }
        eventSounds.enabled = this.enabled;
        return eventSounds;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int n) {
        this.enabled = n;
    }
}

