/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.edit;

import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class EditorTreePanel
extends JPanel
implements TreeSelectionListener {
    Options options;
    public Editor currentItem;
    protected HashMap editPanels;
    protected boolean onlySelect;
    protected Class selectable;
    protected EditorPanel currentPanel;
    protected JTree tree;
    protected JPanel edit;
    protected Editor root;

    public EditorTreePanel(Editor editor, Options options, boolean bl, Class clazz) {
        super(new BorderLayout());
        this.options = options;
        this.onlySelect = bl;
        this.selectable = clazz;
        this.root = editor;
        this.editPanels = new HashMap();
        this.init();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setRootEditor(Editor editor) {
        this.root = editor;
        this.tree.setModel(editor.getTreeModel());
        editor.setCurrentTree(this.tree);
    }

    protected void init() {
        this.tree = this.root.createJTree();
        if (this.onlySelect && this.selectable != null) {
            this.tree.setSelectionModel(new DefaultTreeSelectionModel(){

                public void setSelectionPath(TreePath treePath) {
                    Object object;
                    Object object2 = treePath.getLastPathComponent();
                    if (object2 instanceof Editor && EditorTreePanel.this.selectable.isInstance(object = ((Editor)object2).getUserObject())) {
                        super.setSelectionPath(treePath);
                        return;
                    }
                    this.resetRowSelection();
                }
            });
        }
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        if (this.onlySelect) {
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            jScrollPane.setPreferredSize(new Dimension(250, 300));
            this.add((Component)jScrollPane, "Center");
        } else {
            this.edit = new JPanel();
            this.edit.setLayout(new BorderLayout());
            this.edit.setPreferredSize(new Dimension(250, 300));
            JSplitPane jSplitPane = new JSplitPane(1, false, new JScrollPane(this.tree), this.edit);
            jSplitPane.setResizeWeight(1.0);
            jSplitPane.setPreferredSize(new Dimension(520, 300));
            this.add((Component)jSplitPane, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorTreePanel.this.tree.setSelectionInterval(0, 0);
                }
            });
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.currentItem = null;
        Editor editor = (Editor)this.tree.getLastSelectedPathComponent();
        if (editor == null) {
            return;
        }
        this.currentItem = editor;
        this.currentItemChanged();
    }

    protected void currentItemChanged() {
        if (this.edit != null) {
            Class clazz;
            EditorPanel editorPanel;
            if (this.currentPanel != null) {
                this.currentPanel.removeEditor(true);
            }
            if ((editorPanel = (EditorPanel)this.editPanels.get(clazz = this.currentItem.getEditorPanelClass())) == null) {
                editorPanel = this.currentItem.createEditorPanel(this.options);
                this.editPanels.put(clazz, editorPanel);
            }
            editorPanel.attachEditor(this.currentItem, true);
            if (this.currentPanel != editorPanel) {
                if (this.currentPanel != null) {
                    this.edit.remove(this.currentPanel);
                }
                this.edit.add((Component)editorPanel, "Center");
                this.edit.revalidate();
                this.edit.repaint();
            }
            this.currentPanel = editorPanel;
        }
    }

    public EditorPanel getCurrentPanel() {
        return this.currentPanel;
    }
}

