/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.edit;

import edu.xtec.jclic.edit.EditDialog;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public abstract class EditorPanel
extends CtrlPanel
implements FocusListener,
Editor.EditorListener {
    protected Editor editor;
    protected Options options;
    public static final Color titleBgColor = Color.orange;
    public static final Color titleForeColor = Color.blue;
    public static final Color panelBgColor = new Color(255, 255, 204);
    public static final Border titleBorder = new EmptyBorder(new Insets(6, 4, 6, 4));
    public static final Border panelBorder = new EmptyBorder(0, 0, 0, 0);
    public JLabel northComponent;
    public Component southComponent;

    public EditorPanel(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    protected void postInit(int n, boolean bl, boolean bl2) {
        this.setBorder(panelBorder);
        if (bl || bl2) {
            JPanel jPanel = new JPanel(new BorderLayout());
            if (bl) {
                this.northComponent = this.createTitleLabel(n);
                jPanel.add((Component)this.northComponent, "North");
            }
            if (bl2) {
                this.southComponent = this.createToolBar();
                jPanel.add(this.southComponent, "South");
            }
            this.add((Component)jPanel, "North");
        }
    }

    public abstract boolean checkIfEditorValid(Editor var1);

    public final void clear() {
        this.setModified(false);
    }

    public final void fill() {
        this.setInitializing(true);
        this.fillData();
        this.setInitializing(false);
        this.setModified(false);
        this.setEnabled(this.editor != null);
    }

    protected abstract void fillData();

    public final void save() {
        if (this.editor != null && this.isModified()) {
            this.saveData();
            this.editor.fireEditorDataChanged(this);
            this.setModified(false);
        }
    }

    protected abstract void saveData();

    public void attachEditor(Editor editor, boolean bl) {
        if (editor == this.editor) {
            if (this.editor != null && bl && this.isModified()) {
                this.editor.setModified(true);
            }
            this.fill();
        } else {
            if (this.editor != null) {
                this.removeEditor(bl);
            }
            if (this.checkIfEditorValid(editor)) {
                this.setEditor(editor);
                this.editor.addEditorListener(this);
                this.fill();
            }
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    protected synchronized void setEditor(Editor editor) {
        if (this.editor != null) {
            this.editor.clearActionsOwner();
        }
        this.editor = editor;
        if (editor != null) {
            editor.setActionsOwner();
        }
    }

    public void removeEditor(boolean bl) {
        if (this.editor != null) {
            this.editor.removeEditorListener(this);
            if (bl) {
                this.save();
            }
            this.setEditor(null);
            this.fill();
        }
    }

    public void editorDataChanged(Editor editor) {
        if (editor != null && editor.equals(this.getEditor())) {
            this.fillData();
        }
    }

    protected Icon getIcon() {
        return null;
    }

    protected String getTitle() {
        return "";
    }

    protected JLabel createTitleLabel(int n) {
        JLabel jLabel = new JLabel(this.getTitle());
        jLabel.setHorizontalAlignment(0);
        if (this.getIcon() != null) {
            jLabel.setIcon(this.getIcon());
            jLabel.setIconTextGap(10);
        }
        jLabel.setBackground(titleBgColor);
        jLabel.setForeground(titleForeColor);
        jLabel.setOpaque(true);
        jLabel.setBorder(titleBorder);
        jLabel.validate();
        Dimension dimension = jLabel.getPreferredSize();
        jLabel.setPreferredSize(new Dimension(Math.max(dimension.width, n), dimension.height));
        jLabel.setMinimumSize(jLabel.getPreferredSize());
        return jLabel;
    }

    protected void addActionsTo(Container container) {
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setOpaque(false);
        this.addActionsTo(jToolBar);
        return jToolBar;
    }

    protected String checkEmptyString(String string, boolean bl, String string2) {
        String string3 = string;
        if (string3 != null && bl) {
            string3 = string3.trim();
        }
        if (string3 == null || string3.length() == 0) {
            string3 = this.options.getMsg(string2);
        }
        return string3;
    }

    public boolean showDialog(Editor editor, String string, Component component, boolean bl) {
        if (bl && this.southComponent != null) {
            this.remove(this.southComponent);
        }
        this.attachEditor(editor, false);
        EditDialog editDialog = new EditDialog(this.options, string, JOptionPane.getFrameForComponent(component));
        editDialog.getContentPane().add((Component)this, "Center");
        if (this.northComponent != null) {
            Dimension dimension = editDialog.getContentPane().getPreferredSize();
            dimension.width = this.northComponent.getPreferredSize().width;
            this.setPreferredSize(dimension);
        }
        editDialog.showDialog();
        this.removeEditor(editDialog.result);
        return editDialog.result;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.getEditor() != null) {
            this.getEditor().setActionsOwner();
        } else {
            Editor.clearBasicActionsOwner();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

