/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.misc.Utils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class JPanelActiveBox
extends JPanel {
    Activity.Panel parentActivityPanel = null;
    PlayStation ps;
    public ActiveBox ab;
    public boolean catchMouseEvents;
    Component mouseListener = null;
    ImageObserver io;

    public JPanelActiveBox(AbstractBox abstractBox, BoxBase boxBase, ImageObserver imageObserver) {
        this.io = imageObserver;
        if (imageObserver instanceof Activity.Panel) {
            this.parentActivityPanel = (Activity.Panel)imageObserver;
            this.ps = this.parentActivityPanel.getPs();
        } else if (imageObserver instanceof PlayStation) {
            this.ps = (PlayStation)((Object)imageObserver);
        }
        this.enableEvents(16L);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.ab = new ActiveBox(abstractBox, this, boxBase);
        this.catchMouseEvents = true;
    }

    public void notifyMouseEventsTo(Component component) {
        this.mouseListener = component;
    }

    public void setPanelParent(Activity.Panel panel) {
        this.parentActivityPanel = panel;
        this.ps = panel == null ? null : panel.getPs();
        this.repaint();
    }

    public void setPlayStation(PlayStation playStation) {
        this.ps = playStation;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.catchMouseEvents && aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            if (aWTEvent.getID() == 501 && this.ab != null && this.ps != null && (this.parentActivityPanel == null || this.parentActivityPanel.isPlaying())) {
                this.ps.stopMedia(1);
                this.ab.playMedia(this.ps);
            }
            if (!(this.mouseListener == null || this.ab != null && this.ab.getContent().mediaContent != null && this.ab.getContent().mediaContent.catchMouseEvents)) {
                Point point = mouseEvent.getPoint();
                Point point2 = Utils.mapPointTo(this, point, this.mouseListener);
                mouseEvent.translatePoint(point2.x - point.x, point2.y - point.y);
                this.mouseListener.dispatchEvent(aWTEvent);
            }
            mouseEvent.consume();
            return;
        }
        super.processEvent(aWTEvent);
    }

    public JPanel setActiveBoxContent(ActiveBoxContent activeBoxContent) {
        if (activeBoxContent == null) {
            activeBoxContent = new ActiveBoxContent();
        }
        if (activeBoxContent.dimension != null) {
            this.ab.setBounds(0.0, 0.0, activeBoxContent.dimension.width, activeBoxContent.dimension.height);
        }
        this.ab.setContent(activeBoxContent);
        if (activeBoxContent.mediaContent != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(null);
        }
        this.adjustSize();
        return this;
    }

    public ActiveBoxContent getActiveBoxContent() {
        return this.ab.getContent();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.ab.setBounds(0.0, 0.0, n3, n4);
    }

    public ActiveBox getActiveBox() {
        return this.ab;
    }

    public void adjustSize() {
        if (this.ab != null) {
            Dimension dimension = this.ab.getBorderBounds().getSize();
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
        if (this.ab == null) {
            super.paintComponent(graphics2D);
        } else {
            do {
                BoxBase.flagFontReduced = false;
                this.ab.update(graphics2D, graphics2D.getClipBounds(), this.io);
            } while (BoxBase.flagFontReduced);
        }
        graphics2D.setRenderingHints(renderingHints);
    }
}

