/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.clic3.Clic3;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;

public class ActivityBag
implements Editable,
Domable,
MediaBag.Listener {
    protected JClicProject project;
    private Vector elements = new Vector(20);
    public static final String ELEMENT_NAME = "activities";

    public ActivityBag(JClicProject jClicProject) {
        this.project = jClicProject;
    }

    public JClicProject getProject() {
        return this.project;
    }

    public int size() {
        return this.elements.size();
    }

    public ActivityBagElement elementAt(int n) throws ArrayIndexOutOfBoundsException {
        return (ActivityBagElement)this.elements.elementAt(n);
    }

    public void insertElementAt(ActivityBagElement activityBagElement, int n) throws ArrayIndexOutOfBoundsException {
        this.elements.insertElementAt(activityBagElement, n);
    }

    public void removeElementAt(int n) throws ArrayIndexOutOfBoundsException {
        this.elements.removeElementAt(n);
    }

    public void addElement(ActivityBagElement activityBagElement) {
        this.elements.addElement(activityBagElement);
    }

    public boolean removeElement(ActivityBagElement activityBagElement) {
        return this.elements.removeElement(activityBagElement);
    }

    public int getElementIndex(String string) {
        String string2 = FileSystem.stdFn(string);
        int n = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.elementAt(i).getName().equals(string2)) continue;
            n = i;
            break;
        }
        return n;
    }

    public ActivityBagElement getElementByName(String string) {
        int n = this.getElementIndex(string);
        return n >= 0 ? this.elementAt(n) : null;
    }

    public ActivityBagElement getElement(String string) throws Exception {
        ActivityBagElement activityBagElement = this.getElementByName(string);
        if (activityBagElement == null && Clic3.isClic3Extension(Clic3.getExt(string))) {
            Clic3.addActivityToBag(this.project, string);
            activityBagElement = this.getElementByName(string);
        }
        return activityBagElement;
    }

    public boolean activityExists(String string) {
        return this.getElementByName(string) != null;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        for (int i = 0; i < this.size(); ++i) {
            element.addContent(this.elementAt(i).getData().detach());
        }
        return element;
    }

    public void addActivity(Activity activity) {
        if (activity != null) {
            this.addJDomElement(activity.getJDomElement());
        }
    }

    public void addJDomElement(Element element) {
        if (element != null) {
            ActivityBagElement activityBagElement = this.getElementByName(element.getAttributeValue("name"));
            if (activityBagElement != null) {
                activityBagElement.setData(element);
            } else {
                this.addElement(new ActivityBagElement(element));
            }
        }
    }

    public ActivityBagElement[] getElements() {
        Object[] objectArray = new ActivityBagElement[this.size()];
        this.elements.copyInto(objectArray);
        return objectArray;
    }

    public void sortByName() {
        Collections.sort(this.elements, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((ActivityBagElement)object).getName().compareTo(((ActivityBagElement)object2).getName());
            }
        });
    }

    public void sortByClassAndName() {
        final StringBuffer stringBuffer = new StringBuffer(200);
        final StringBuffer stringBuffer2 = new StringBuffer(200);
        Collections.sort(this.elements, new Comparator(){

            public int compare(Object object, Object object2) {
                Element element = ((ActivityBagElement)object).getData();
                Element element2 = ((ActivityBagElement)object2).getData();
                stringBuffer.setLength(0);
                stringBuffer.append(element.getAttributeValue("class"));
                stringBuffer.append(element.getAttributeValue("name"));
                stringBuffer2.setLength(0);
                stringBuffer2.append(element2.getAttributeValue("class"));
                stringBuffer2.append(element2.getAttributeValue("name"));
                return stringBuffer.substring(0).compareTo(stringBuffer2.substring(0));
            }
        });
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        List list = element.getChildren("activity");
        this.elements.ensureCapacity(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            iterator.remove();
            this.addJDomElement((Element)element2.detach());
        }
    }

    public void removeElementByName(String string) {
        ActivityBagElement activityBagElement = this.getElementByName(string);
        if (activityBagElement != null) {
            this.removeElement(activityBagElement);
        }
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, editor);
    }

    public void listReferencesTo(String string, String string2, HashMap hashMap) {
        Cloneable cloneable;
        for (int i = 0; i < this.size(); ++i) {
            cloneable = this.elementAt(i);
            HashMap hashMap2 = ((ActivityBagElement)cloneable).getReferences();
            if (hashMap2 == null || !hashMap2.containsKey(string) || string2 != null && !string2.equals(hashMap2.get(string))) continue;
            hashMap.put(((ActivityBagElement)cloneable).getName(), "activity");
        }
        EventSounds eventSounds = this.project.settings.eventSounds;
        if (eventSounds != null && (cloneable = eventSounds.getReferences()) != null && ((HashMap)cloneable).containsKey(string) && (string2 == null || string2.equals(((HashMap)cloneable).get(string)))) {
            hashMap.put("[" + this.project.getBridge().getMsg("edit_project") + "]", "project");
        }
    }

    public void listReferences(String string, HashMap hashMap) {
        for (int i = 0; i < this.size(); ++i) {
            HashMap hashMap2;
            ActivityBagElement activityBagElement = this.elementAt(i);
            if (string == null || string == "activity") {
                hashMap.put(activityBagElement.getName(), "activity");
            }
            if ((hashMap2 = activityBagElement.getReferences()) == null) continue;
            if (string == null) {
                hashMap.putAll(hashMap2);
                continue;
            }
            Iterator iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!string.equals(hashMap2.get(k))) continue;
                hashMap.put(k, string);
            }
        }
    }
}

