/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class Resizer
implements MouseListener,
MouseMotionListener {
    JComponent jc;
    Rectangle r;
    Cursor defaultCursor;
    boolean doGetBounds;
    boolean dragging;
    boolean dragCursorX;
    boolean dragCursorY;
    ResizerListener rl;
    Dimension minSize;
    Dimension maxSize;
    boolean editable;
    boolean enabled;
    public static final int MARGIN = 5;

    public Resizer(JComponent jComponent, Rectangle rectangle, boolean bl, ResizerListener resizerListener) {
        this.jc = jComponent;
        this.setRect(rectangle);
        this.editable = bl;
        if (bl) {
            this.defaultCursor = Cursor.getPredefinedCursor(12);
        }
        this.rl = resizerListener;
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
        this.minSize = new Dimension(10, 10);
        this.maxSize = new Dimension(jComponent.getPreferredSize());
        this.setEnabled(true);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.jc.setCursor(this.defaultCursor);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setMinSize(Dimension dimension) {
        this.minSize = dimension;
    }

    public void setMaxSize(Dimension dimension) {
        this.maxSize = dimension;
    }

    public void setRect(Rectangle rectangle) {
        this.r = rectangle;
        boolean bl = this.doGetBounds = rectangle == null;
        if (this.doGetBounds) {
            rectangle = this.jc.getBounds();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.enabled && this.editable && this.rl != null && this.r.contains(mouseEvent.getPoint())) {
            this.rl.editObject(this.r, this.jc, mouseEvent.getPoint());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.enabled && this.dragging) {
            this.resizeByDrag(mouseEvent.getPoint());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.dragging && this.enabled) {
            Point point = mouseEvent.getPoint();
            Cursor cursor = this.defaultCursor;
            if (this.doGetBounds) {
                this.r = this.jc.getBounds();
            }
            this.dragCursorX = Math.abs(point.x - this.r.x - this.r.width) < 5 && point.y >= this.r.y && point.y < this.r.y + this.r.height + 5;
            boolean bl = this.dragCursorY = Math.abs(point.y - this.r.y - this.r.height) < 5 && point.x >= this.r.x && point.x < this.r.x + this.r.width + 5;
            if (this.dragCursorX && this.dragCursorY) {
                cursor = Cursor.getPredefinedCursor(6);
            } else if (this.dragCursorY) {
                cursor = Cursor.getPredefinedCursor(8);
            } else if (this.dragCursorX) {
                cursor = Cursor.getPredefinedCursor(11);
            }
            this.jc.setCursor(cursor);
        } else if (this.dragging) {
            this.mouseDragged(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.enabled && (this.dragCursorX || this.dragCursorY)) {
            this.dragging = true;
            this.resizeByDrag(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.enabled && this.dragging) {
            this.resizeByDrag(mouseEvent.getPoint());
            this.dragging = false;
        }
    }

    private void resizeByDrag(Point point) {
        int n = this.r.width;
        int n2 = this.r.height;
        if (this.dragCursorX) {
            n = Math.min(this.maxSize.width, Math.max(this.minSize.width, point.x - this.r.x));
        }
        if (this.dragCursorY) {
            n2 = Math.min(this.maxSize.height, Math.max(this.minSize.height, point.y - this.r.y));
        }
        this.r = new Rectangle(this.r.x, this.r.y, n, n2);
        if (this.rl != null) {
            this.rl.resizeObjectTo(this.r, this.jc);
        }
    }

    public JComponent getComponent() {
        return this.jc;
    }

    public static interface ResizerListener {
        public void resizeObjectTo(Rectangle var1, JComponent var2);

        public void editObject(Rectangle var1, JComponent var2, Point var3);
    }
}

