/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.EditableLine2D;
import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class EditableRectangle
extends Rectangle2D.Double
implements EditableShape,
Cloneable {
    protected boolean selected = false;
    protected int border = -1;
    private int selectedBorder = -1;
    protected Point2D p1;
    protected Point2D p2;
    protected Point2D p3;
    protected Point2D p4;
    protected Point2D lastP1;
    protected Point2D lastP2;

    public EditableRectangle(Point2D point2D, Point2D point2D2) {
        this.setLimits(point2D, point2D2);
    }

    public EditableRectangle(int n, int n2, int n3, int n4) {
        this.setLimits(n, n2, n3, n4);
    }

    public void setLimits(int n, int n2, int n3, int n4) {
        if (n3 < 0) {
            n -= (n3 *= -1);
        }
        if (n4 < 0) {
            n2 -= (n4 *= -1);
        }
        this.p1 = new Point2D.Double(n, n2);
        this.p2 = new Point2D.Double(n + n3, n2 + n4);
        this.p3 = new Point2D.Double();
        this.p4 = new Point2D.Double();
        this.lastP1 = new Point2D.Double(1.0, 1.0);
        this.lastP2 = new Point2D.Double(1.0, 1.0);
        this.setRect(this.p1, this.p2);
    }

    public void setLimits(Point2D point2D, Point2D point2D2) {
        this.p1 = new Point2D.Double();
        this.p2 = new Point2D.Double();
        this.p3 = new Point2D.Double();
        this.p4 = new Point2D.Double();
        this.lastP1 = new Point2D.Double(1.0, 1.0);
        this.lastP2 = new Point2D.Double(1.0, 1.0);
        this.setRect(point2D, point2D2);
    }

    public EditableShape[] divide(double d, double d2) {
        return this.divide(d, d2, true);
    }

    public EditableShape[] divide(double d, double d2, boolean bl) {
        EditableShape[] editableShapeArray = new EditableShape[5];
        editableShapeArray[0] = new EditableLine2D(this.p1, this.p3);
        editableShapeArray[1] = new EditableLine2D(this.p3, this.p2);
        editableShapeArray[2] = new EditableLine2D(this.p2, this.p4);
        editableShapeArray[3] = new EditableLine2D(this.p4, this.p1);
        if (bl) {
            double d3 = ((EditableLine2D)editableShapeArray[0]).ptLineDistSq(d, d2);
            int n = 0;
            for (int n2 = 1; n2 < 4; n2 = (int)((short)(n2 + 1))) {
                double d4 = ((EditableLine2D)editableShapeArray[n2]).ptLineDistSq(d, d2);
                if (!(d4 < d3)) continue;
                d3 = d4;
                n = n2;
            }
            Point2D.Double double_ = new Point2D.Double(d, d2);
            Point2D point2D = ((EditableLine2D)editableShapeArray[n]).getP1();
            Point2D point2D2 = ((EditableLine2D)editableShapeArray[n]).getP2();
            editableShapeArray[n] = new EditableLine2D(point2D, double_);
            editableShapeArray[4] = new EditableLine2D(double_, point2D2);
        }
        return editableShapeArray;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public double distanceTo(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        Line2D.Double double_ = new Line2D.Double(this.p1, this.p3);
        Line2D.Double double_2 = new Line2D.Double(this.p3, this.p2);
        Line2D.Double double_3 = new Line2D.Double(this.p2, this.p4);
        Line2D.Double double_4 = new Line2D.Double(this.p4, this.p1);
        double d7 = double_.ptLineDistSq(d, d2);
        double d8 = d7 < (d6 = double_2.ptLineDistSq(d, d2)) ? d7 : d6;
        if (d8 < (d5 = (d4 = double_3.ptLineDistSq(d, d2)) < (d3 = double_4.ptLineDistSq(d, d2)) ? d4 : d3)) {
            return d8;
        }
        return d5;
    }

    public boolean hasClickedBorder(double d, double d2, boolean bl) {
        boolean bl2 = false;
        if (!bl || this.selected) {
            Rectangle rectangle = new Rectangle((int)this.p1.getX() - EditableShapeConstants.selectLength / 2, (int)this.p1.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle rectangle2 = new Rectangle((int)this.p2.getX() - EditableShapeConstants.selectLength / 2, (int)this.p2.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle rectangle3 = new Rectangle((int)this.p3.getX() - EditableShapeConstants.selectLength / 2, (int)this.p3.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle rectangle4 = new Rectangle((int)this.p4.getX() - EditableShapeConstants.selectLength / 2, (int)this.p4.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            if (rectangle.contains(d, d2)) {
                this.border = 1;
                bl2 = true;
            } else if (rectangle2.contains(d, d2)) {
                this.border = 2;
                bl2 = true;
            } else if (rectangle3.contains(d, d2)) {
                this.border = 3;
                bl2 = true;
            } else if (rectangle4.contains(d, d2)) {
                this.border = 4;
                bl2 = true;
            }
        }
        return bl2;
    }

    public void paintSelection(Graphics graphics) {
        graphics.setColor(Color.black);
        this.drawBorders(graphics);
        graphics.setColor(EditableShapeConstants.selectedColor);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void aproximateNearestBorder(double d, double d2) {
        boolean bl = this.hasClickedBorder(d, d2, false);
        this.changeBorder(d, d2);
    }

    public void paintWithColor(Graphics graphics, int n, Color color) {
        graphics.setColor(EditableShapeConstants.BORDER_COLOR);
        this.drawBorders(graphics);
        if (this.selected) {
            this.paintSelection(graphics);
        } else if (n == 4) {
            graphics.setColor(Color.red);
            this.drawBorders(graphics);
            graphics.setColor(color);
        } else {
            graphics.setColor(color);
        }
        graphics.drawRect((int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight());
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transform(this.p1, this.p1);
        affineTransform.transform(this.p2, this.p2);
        this.setRect(this.p1, this.p2);
    }

    public boolean isAdjacentTo(Point2D point2D) {
        return point2D.equals(this.p1) || point2D.equals(this.p2) || point2D.equals(this.p3) || point2D.equals(this.p4);
    }

    public boolean isInto(Rectangle2D rectangle2D) {
        return rectangle2D.intersects(this);
    }

    public Point2D getEndPoint() {
        return this.p2;
    }

    private void setRect(Point2D point2D, Point2D point2D2) {
        if (!this.lastP1.equals(point2D) || !this.lastP2.equals(point2D2)) {
            this.p1 = point2D;
            this.p2 = point2D2;
            this.p3.setLocation(this.p2.getX(), this.p1.getY());
            this.p4.setLocation(this.p1.getX(), this.p2.getY());
            double d = Math.min(this.p1.getX(), this.p2.getX());
            double d2 = Math.min(this.p1.getY(), this.p2.getY());
            double d3 = Math.abs(this.p2.getX() - this.p1.getX());
            double d4 = Math.abs(this.p2.getY() - this.p1.getY());
            this.setRect(d, d2, d3, d4);
            this.lastP1 = (Point2D)this.p1.clone();
            this.lastP2 = (Point2D)this.p2.clone();
        }
    }

    public void changeBorder(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        if (this.border == 1) {
            this.setRect(double_, this.p2);
        } else if (this.border == 2) {
            this.setRect(this.p1, double_);
        } else if (this.border == 3) {
            this.p1.setLocation(this.p1.getX(), ((Point2D)double_).getY());
            this.p2.setLocation(((Point2D)double_).getX(), this.p2.getY());
            this.setRect(this.p1, this.p2);
        } else if (this.border == 4) {
            this.p1.setLocation(((Point2D)double_).getX(), this.p1.getY());
            this.p2.setLocation(this.p2.getX(), ((Point2D)double_).getY());
            this.setRect(this.p1, this.p2);
        }
    }

    public void drawBorders(Graphics graphics) {
        graphics.drawRect((int)this.p1.getX() - EditableShapeConstants.selectLength / 2, (int)this.p1.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        graphics.drawRect((int)this.p2.getX() - EditableShapeConstants.selectLength / 2, (int)this.p2.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        graphics.drawRect((int)this.p3.getX() - EditableShapeConstants.selectLength / 2, (int)this.p3.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        graphics.drawRect((int)this.p4.getX() - EditableShapeConstants.selectLength / 2, (int)this.p4.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        graphics.setColor(EditableShapeConstants.SELECTED_BORDER_COLOR);
        if (this.selectedBorder == 1) {
            graphics.fillRect((int)this.p1.getX() - EditableShapeConstants.selectLength / 2, (int)this.p1.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        } else if (this.selectedBorder == 2) {
            graphics.fillRect((int)this.p2.getX() - EditableShapeConstants.selectLength / 2, (int)this.p2.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        } else if (this.selectedBorder == 3) {
            graphics.fillRect((int)this.p3.getX() - EditableShapeConstants.selectLength / 2, (int)this.p3.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        } else if (this.selectedBorder == 4) {
            graphics.fillRect((int)this.p4.getX() - EditableShapeConstants.selectLength / 2, (int)this.p4.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
    }

    public Point2D getInitialPoint() {
        return this.getLocation();
    }

    public void paint(Graphics graphics, int n) {
        this.paintWithColor(graphics, n, EditableShapeConstants.defaultColor);
    }

    public Point2D getNearestBorder(double d, double d2) {
        double d3 = this.p1.distance(d, d2);
        double d4 = this.p2.distance(d, d2);
        double d5 = this.p3.distance(d, d2);
        double d6 = this.p4.distance(d, d2);
        Point2D point2D = d3 < d4 ? this.p1 : this.p2;
        Point2D point2D2 = d5 < d6 ? this.p3 : this.p4;
        if (point2D.distance(d, d2) < point2D2.distance(d, d2)) {
            return point2D;
        }
        return point2D2;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public Object clone() {
        return new EditableRectangle(this.getLocation(), new Point2D.Double(this.getLocation().getX() + this.getWidth(), this.getLocation().getY() + this.getHeight()));
    }

    public Point2D[] getBorders() {
        return new Point2D[]{this.p1, this.p2, this.p3, this.p4};
    }

    public void selectBorder(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.selectedBorder = this.p1.equals(double_) ? 1 : (this.p2.equals(double_) ? 2 : (this.p3.equals(double_) ? 3 : (this.p4.equals(double_) ? 4 : -1)));
    }

    public void deselectBorder() {
        this.selectedBorder = -1;
    }

    public boolean hasSelectedBorder() {
        return this.selectedBorder != -1;
    }

    public Point2D getNotSelectedBorder() {
        if (this.selectedBorder == 1) {
            return this.p1;
        }
        if (this.selectedBorder == 2) {
            return this.p2;
        }
        if (this.selectedBorder == 3) {
            return this.p3;
        }
        return this.p4;
    }
}

