/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class EditableCubicCurve2D
extends CubicCurve2D.Double
implements EditableShape {
    private boolean selected = false;
    private int border = -1;
    private int selectedBorder = -1;

    public EditableCubicCurve2D(CubicCurve2D cubicCurve2D) {
        this.setCurve(cubicCurve2D);
    }

    public EditableCubicCurve2D(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        super(d, d2, d3, d4, d5, d6, d7, d8);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isInto(Rectangle2D rectangle2D) {
        return rectangle2D.contains(this.getP1()) || rectangle2D.contains(this.getP2()) || rectangle2D.contains(this.getCtrlP1()) || rectangle2D.contains(this.getCtrlP2());
    }

    public void drawBorders(Graphics graphics) {
        if (this.getP1().getX() != -1.0) {
            graphics.drawRect((int)this.getP1().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP1().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
        if (this.getP2().getX() != -1.0) {
            graphics.drawRect((int)this.getP2().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP2().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
        if (this.getCtrlP1().getX() != -1.0) {
            graphics.fillRect((int)this.getCtrlP1().getX() - EditableShapeConstants.selectLength / 2, (int)this.getCtrlP1().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
        if (this.getCtrlP2().getX() != -1.0) {
            graphics.fillRect((int)this.getCtrlP2().getX() - EditableShapeConstants.selectLength / 2, (int)this.getCtrlP2().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
        graphics.setColor(EditableShapeConstants.SELECTED_BORDER_COLOR);
        if (this.selectedBorder == 1) {
            graphics.fillRect((int)this.getP1().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP1().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        } else if (this.selectedBorder == 2) {
            graphics.fillRect((int)this.getP2().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP2().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
    }

    public boolean hasClickedBorder(double d, double d2, boolean bl) {
        boolean bl2 = false;
        if (!bl || this.selected) {
            Rectangle rectangle = new Rectangle((int)this.getP1().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP1().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle rectangle2 = new Rectangle((int)this.getP2().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP2().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle rectangle3 = new Rectangle((int)this.getCtrlP1().getX() - EditableShapeConstants.selectLength / 2, (int)this.getCtrlP1().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle rectangle4 = new Rectangle((int)this.getCtrlP2().getX() - EditableShapeConstants.selectLength / 2, (int)this.getCtrlP2().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            if (rectangle.contains(d, d2)) {
                this.border = 1;
                bl2 = true;
            } else if (rectangle2.contains(d, d2)) {
                this.border = 2;
                bl2 = true;
            } else if (rectangle3.contains(d, d2)) {
                this.border = 3;
                bl2 = true;
            } else if (rectangle4.contains(d, d2)) {
                this.border = 4;
                bl2 = true;
            }
        }
        return bl2;
    }

    public void aproximateNearestBorder(double d, double d2) {
        if (this.hasClickedBorder(d, d2, false)) {
            this.changeBorder(d, d2);
        }
    }

    public Point2D getNearestBorder(double d, double d2) {
        double d3 = this.getP1().distance(d, d2);
        double d4 = this.getP2().distance(d, d2);
        double d5 = this.getCtrlP1().distance(d, d2);
        double d6 = this.getCtrlP2().distance(d, d2);
        Point2D point2D = d3 < d4 ? this.getP1() : this.getP2();
        Point2D point2D2 = d5 < d6 ? this.getCtrlP1() : this.getCtrlP2();
        if (point2D.distance(d, d2) < point2D2.distance(d, d2)) {
            return point2D;
        }
        return point2D2;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void changeBorder(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        if (this.border == 1) {
            this.setCurve(double_, this.getCtrlP1(), this.getCtrlP2(), this.getP2());
        } else if (this.border == 2) {
            this.setCurve(this.getP1(), this.getCtrlP1(), this.getCtrlP2(), double_);
        } else if (this.border == 3) {
            this.setCurve(this.getP1(), double_, this.getCtrlP2(), this.getP2());
        } else {
            this.setCurve(this.getP1(), this.getCtrlP1(), double_, this.getP2());
        }
    }

    public double distanceTo(double d, double d2) {
        double d3 = this.getNearestBorder(d, d2).distance(d, d2);
        double d4 = new Line2D.Double(this.getP1(), this.getP2()).ptSegDist(d, d2);
        return Math.min(d3, d4);
    }

    public void paintWithColor(Graphics graphics, int n, Color color) {
        graphics.setColor(EditableShapeConstants.BORDER_COLOR);
        this.drawBorders(graphics);
        if (this.selected) {
            this.paintSelection(graphics);
        } else if (n == 4) {
            graphics.setColor(Color.red);
            this.drawBorders(graphics);
            graphics.setColor(color);
        } else {
            graphics.setColor(color);
        }
        ((Graphics2D)graphics).draw(this);
    }

    public void paint(Graphics graphics, int n) {
        this.paintWithColor(graphics, n, EditableShapeConstants.defaultColor);
    }

    public void paintSelection(Graphics graphics) {
        graphics.setColor(Color.black);
        this.drawBorders(graphics);
        graphics.setColor(EditableShapeConstants.selectedColor);
    }

    public void move(double d, double d2) {
        this.setCurve(this.getP1().getX() + d, this.getP1().getY() + d2, this.getCtrlX1() + d, this.getCtrlY1() + d2, this.getCtrlX2() + d, this.getCtrlY2() + d2, this.getP2().getX() + d, this.getP2().getY() + d2);
    }

    public void transform(AffineTransform affineTransform) {
        Point2D point2D = this.getP1();
        Point2D point2D2 = this.getCtrlP1();
        Point2D point2D3 = this.getCtrlP2();
        Point2D point2D4 = this.getP2();
        affineTransform.transform(point2D, point2D);
        affineTransform.transform(point2D2, point2D2);
        affineTransform.transform(point2D3, point2D3);
        affineTransform.transform(point2D4, point2D4);
        this.setCurve(point2D, point2D2, point2D3, point2D4);
    }

    public EditableShape[] divide(double d, double d2) {
        EditableShape[] editableShapeArray = new EditableShape[2];
        CubicCurve2D.Double double_ = new CubicCurve2D.Double();
        CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
        this.subdivide(double_, double_2);
        editableShapeArray[0] = new EditableCubicCurve2D(double_2);
        editableShapeArray[1] = new EditableCubicCurve2D(double_);
        return editableShapeArray;
    }

    public boolean isAdjacentTo(Point2D point2D) {
        if (this.getP1().equals(point2D)) {
            return true;
        }
        if (this.getP2().equals(point2D)) {
            this.setCurve(this.getP2(), this.getCtrlP2(), this.getCtrlP1(), this.getP1());
            return true;
        }
        return false;
    }

    public Point2D getEndPoint() {
        return this.getP2();
    }

    public Point2D getInitialPoint() {
        return this.getP1();
    }

    public Object clone() {
        return new EditableCubicCurve2D(this);
    }

    public Point2D[] getBorders() {
        return new Point2D[]{this.getP1(), this.getP2(), this.getCtrlP1(), this.getCtrlP2()};
    }

    public void selectBorder(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.selectedBorder = this.getP1().equals(double_) ? 1 : (this.getP2().equals(double_) ? 2 : -1);
    }

    public void deselectBorder() {
        this.selectedBorder = -1;
    }

    public boolean hasSelectedBorder() {
        return this.selectedBorder != -1;
    }

    public Point2D getNotSelectedBorder() {
        if (this.selectedBorder == 1) {
            return this.getP2();
        }
        return this.getP1();
    }
}

