/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewProjectDlg
extends JPanel {
    ResourceBridge rb;
    Options options;
    public String name;
    public String fileName;
    public String folder;
    String baseFolder;
    private JFileChooser chooser;
    DocumentListener dl = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            this.changeName(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changeName(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changeName(documentEvent);
        }

        protected void changeName(DocumentEvent documentEvent) {
            String string = null;
            boolean bl = false;
            if (NewProjectDlg.this.nameText.getDocument() == documentEvent.getDocument()) {
                string = NewProjectDlg.this.nameText.getText();
                bl = true;
            } else {
                string = NewProjectDlg.this.fileNameText.getText();
            }
            string = FileSystem.getValidFileName(string.trim());
            if (bl) {
                NewProjectDlg.this.fileNameText.setText(string);
            }
            if (string.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer(NewProjectDlg.this.baseFolder);
                if (!NewProjectDlg.this.baseFolder.endsWith(File.separator)) {
                    stringBuffer.append(File.separatorChar);
                }
                stringBuffer.append(string);
                NewProjectDlg.this.folderText.setText(stringBuffer.substring(0));
            }
        }
    };
    private JLabel extLb;
    private JLabel fileNameLb;
    private JTextField fileNameText;
    private JButton folderBtn;
    private JLabel folderLb;
    private JTextField folderText;
    private JLabel nameLb;
    private JTextField nameText;
    private JLabel spacer;

    public NewProjectDlg(ResourceBridge resourceBridge, String string) {
        this.rb = resourceBridge;
        this.options = resourceBridge.getOptions();
        this.baseFolder = string.replace('/', File.separatorChar);
        this.folder = string;
        this.initComponents();
    }

    private void initComponents() {
        this.nameLb = new JLabel();
        this.nameText = new JTextField();
        this.nameText.getDocument().addDocumentListener(this.dl);
        this.spacer = new JLabel();
        this.fileNameLb = new JLabel();
        this.fileNameText = new JTextField();
        this.fileNameText.getDocument().addDocumentListener(this.dl);
        this.extLb = new JLabel();
        this.folderLb = new JLabel();
        this.folderText = new JTextField();
        this.folderBtn = new JButton();
        this.setLayout(new GridBagLayout());
        this.nameLb.setLabelFor(this.nameText);
        this.nameLb.setText(this.options.getMsg("edit_new_project_name"));
        this.nameLb.setToolTipText(this.options.getMsg("edit_new_project_name_tooltip"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.nameLb, gridBagConstraints);
        this.nameText.setToolTipText(this.options.getMsg("edit_new_project_name_tooltip"));
        this.nameText.setPreferredSize(new Dimension(100, 20));
        this.nameText.setMinimumSize(new Dimension(100, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 1);
        this.add((Component)this.nameText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.spacer, gridBagConstraints);
        this.fileNameLb.setText(this.options.getMsg("edit_new_project_filename"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.fileNameLb, gridBagConstraints);
        this.fileNameText.setToolTipText(this.options.getMsg("edit_new_project_filename_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 1);
        this.add((Component)this.fileNameText, gridBagConstraints);
        this.extLb.setText(".jclic.zip");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 1, 4, 4);
        this.add((Component)this.extLb, gridBagConstraints);
        this.folderLb.setLabelFor(this.folderText);
        this.folderLb.setText(this.options.getMsg("edit_new_project_folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.folderLb, gridBagConstraints);
        this.folderText.setToolTipText(this.options.getMsg("edit_new_project_folder_tooltip"));
        this.folderText.setPreferredSize(new Dimension(280, 21));
        this.folderText.setMinimumSize(new Dimension(280, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.folderText, gridBagConstraints);
        this.folderBtn.setText(this.options.getMsg("edit_new_project_folder_browse"));
        this.folderBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewProjectDlg.this.folderBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.folderBtn, gridBagConstraints);
    }

    private void folderBtnActionPerformed(ActionEvent actionEvent) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser(this.baseFolder);
            this.chooser.setDialogType(1);
        }
        if (this.chooser.showOpenDialog(this) == 0) {
            this.baseFolder = this.chooser.getCurrentDirectory().getAbsolutePath();
            this.folderText.setText(this.baseFolder);
        }
    }

    public void fillData() {
        this.nameText.setText(this.name == null ? "" : this.name);
        this.fileNameText.setText(this.fileName == null ? "" : this.fileName);
        this.folderText.setText(this.folder == null ? "" : this.folder);
    }

    public void getData() {
        this.name = StrUtils.nullableString(this.nameText.getText());
        this.fileName = StrUtils.nullableString(this.fileNameText.getText());
        this.folder = StrUtils.nullableString(this.folderText.getText());
    }

    public static JClicProject prompt(ResourceBridge resourceBridge, Component component, FileSystem fileSystem) {
        JClicProject jClicProject = null;
        NewProjectDlg newProjectDlg = new NewProjectDlg(resourceBridge, fileSystem.root);
        Messages messages = resourceBridge.getOptions().getMessages();
        newProjectDlg.fillData();
        while (jClicProject == null && messages.showInputDlg(component, newProjectDlg, "edit_new_project_title")) {
            newProjectDlg.getData();
            if (newProjectDlg.name == null || newProjectDlg.fileName == null || newProjectDlg.folder == null) {
                messages.showErrorWarning(component, "edit_new_project_err_empty", null);
                continue;
            }
            try {
                Object object;
                boolean bl = true;
                File file = new File(newProjectDlg.folder);
                if (file.exists() && file.isDirectory()) {
                    object = Utils.getFileFilter(6, messages).getFilenameFilter();
                    if (file.list((FilenameFilter)object).length > 0) {
                        bl = messages.showQuestionDlg(component, "edit_new_project_warning_noEmptyFolder", null, "yn") == 1;
                    }
                } else if (!file.mkdirs()) {
                    messages.showErrorWarning(component, "edit_new_project_err_folderCreation", null);
                    bl = false;
                }
                if (!bl || messages.confirmOverwriteFile(component, (File)(object = new File(file, newProjectDlg.fileName + ".jclic.zip")), "yn") != 1) continue;
                jClicProject = new JClicProject(resourceBridge, new FileSystem(file.getAbsolutePath(), resourceBridge), ((File)object).getAbsolutePath());
                jClicProject.settings.title = newProjectDlg.name;
                jClicProject.setName(newProjectDlg.fileName);
                jClicProject.saveProject(((File)object).getAbsolutePath());
            }
            catch (Exception exception) {
                messages.showErrorWarning(component, "ERROR", exception);
            }
        }
        return jClicProject;
    }
}

