/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagSelector;
import edu.xtec.jclic.beans.MediaContentButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;

public class MediaContentEditor
extends CtrlPanel {
    MediaContent mc;
    Options options;
    MediaBagEditor mbe;
    public static final String PROP_MC = "mediaContent";
    private static final String[] LOCATION_FROM_MSG_CODES = new String[]{"box", "window", "frame"};
    Vector locationFromNames;
    private JTextField[] textFields;
    private JCheckBox autostartChk;
    private JCheckBox catchMouseChk;
    private JTextField externalTxt;
    private JPanel filePanel;
    private JTextField fileTxt;
    private JButton findFileBtn;
    private JPanel fragmentPanel;
    private JTextField fromTxt;
    private JLabel lbExternal;
    private JLabel lbFile;
    private JLabel lbFrom;
    private JLabel lbLength;
    private JLabel lbLevel;
    private JLabel lbLocFrom;
    private JLabel lbRecbuffer;
    private JLabel lbTo;
    private JLabel lbX;
    private JLabel lbY;
    private SmallIntEditor lengthEditor;
    private SmallIntEditor levelEditor;
    private JComboBox locFromCombo;
    private JPanel locationPanel;
    private JCheckBox loopChk;
    private JPanel mainPanel;
    private JPanel mediaTypePanel;
    private ButtonGroup mediaTypes;
    private JRadioButton posAbsoluteRadio;
    private JRadioButton posCellRadio;
    private ButtonGroup posTypes;
    private JRadioButton posWindowRadio;
    private SmallIntEditor recBufferEditor;
    private JCheckBox stretchChk;
    private JTextField toTxt;
    private JToggleButton toggleType01;
    private JToggleButton toggleType02;
    private JToggleButton toggleType03;
    private JToggleButton toggleType04;
    private JToggleButton toggleType05;
    private JToggleButton toggleType06;
    private JToggleButton toggleType07;
    private JToggleButton toggleType08;
    private JToggleButton toggleType09;
    private JToggleButton toggleType10;
    private JToggleButton toggleType11;
    private JToggleButton toggleType12;
    private JTextField xTxt;
    private JTextField yTxt;
    private static HashMap panels = new HashMap();

    public MediaContentEditor(Options options, MediaContent mediaContent, MediaBagEditor mediaBagEditor) {
        this.options = options;
        this.pre_init();
        this.initComponents();
        this.post_init();
        this.setMediaBagEditor(mediaBagEditor);
        this.setMediaContent(mediaContent);
    }

    private void pre_init() {
        this.locationFromNames = new Vector();
        for (int i = 0; i < LOCATION_FROM_MSG_CODES.length; ++i) {
            this.locationFromNames.add(this.options.getMsg("edit_mc_location_from_" + LOCATION_FROM_MSG_CODES[i]));
        }
    }

    private void post_init() {
        this.textFields = new JTextField[]{this.fileTxt, this.externalTxt, this.fromTxt, this.toTxt, this.xTxt, this.yTxt};
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].getDocument().addDocumentListener(this);
        }
        Enumeration<AbstractButton> enumeration = this.mediaTypes.getElements();
        while (enumeration.hasMoreElements()) {
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            jToggleButton.addActionListener(this);
        }
    }

    public void setMediaBagEditor(MediaBagEditor mediaBagEditor) {
        this.mbe = mediaBagEditor;
    }

    private void checkAndFirePropertyChange(MediaContent mediaContent) {
        boolean bl;
        MediaContent mediaContent2 = this.getMc();
        boolean bl2 = bl = mediaContent == null && mediaContent2 == null || mediaContent != null && mediaContent.equals(mediaContent2);
        if (!bl) {
            this.firePropertyChange(PROP_MC, mediaContent, mediaContent2);
        }
    }

    public void setMediaContent(MediaContent mediaContent) {
        if (mediaContent == null) {
            mediaContent = new MediaContent();
        }
        this.setInitializing(true);
        this.mc = (MediaContent)mediaContent.clone();
        Enumeration<AbstractButton> enumeration = this.mediaTypes.getElements();
        JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
        for (int i = 0; i < this.mc.mediaType; ++i) {
            jToggleButton = (JToggleButton)enumeration.nextElement();
        }
        jToggleButton.setSelected(true);
        this.levelEditor.setValue(this.mc.level);
        this.recBufferEditor.setValue(this.mc.recBuffer);
        this.fileTxt.setText(this.mc.mediaFileName);
        this.externalTxt.setText(this.mc.externalParam);
        this.fromTxt.setText(Integer.toString(this.mc.from));
        this.toTxt.setText(Integer.toString(this.mc.to));
        this.lengthEditor.setValue(this.mc.length);
        this.stretchChk.setSelected(this.mc.stretch);
        if (this.mc.absLocation != null) {
            this.posAbsoluteRadio.setSelected(true);
        } else if (this.mc.free) {
            this.posWindowRadio.setSelected(true);
        } else {
            this.posCellRadio.setSelected(true);
        }
        this.syncPointValues();
        this.loopChk.setSelected(this.mc.loop);
        this.autostartChk.setSelected(this.mc.autoStart);
        this.catchMouseChk.setSelected(this.mc.catchMouseEvents);
        this.checkEnabled();
        this.setInitializing(false);
    }

    public boolean check(Component component) {
        boolean bl = false;
        switch (this.mc.mediaType) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                bl = StrUtils.nullableString(this.mc.mediaFileName) != null;
                break;
            }
            case 5: 
            case 6: {
                bl = this.mc.recBuffer >= 0 && this.mc.recBuffer < 10;
                break;
            }
            case 8: {
                bl = StrUtils.nullableString(this.mc.mediaFileName) != null || StrUtils.nullableString(this.mc.externalParam) != null;
                break;
            }
            case 11: 
            case 12: {
                bl = true;
            }
        }
        if (!bl) {
            this.options.getMessages().showAlert(component, "edit_mc_err_nullContent");
        }
        return bl;
    }

    public MediaContent getMc() {
        return this.mc;
    }

    public MediaContent getMcClone() {
        return this.mc == null ? null : (MediaContent)this.mc.clone();
    }

    private void initComponents() {
        this.mediaTypes = new ButtonGroup();
        this.posTypes = new ButtonGroup();
        this.mediaTypePanel = new JPanel();
        JToggleButton jToggleButton = new JToggleButton();
        this.toggleType01 = new JToggleButton();
        this.toggleType02 = new JToggleButton();
        this.toggleType03 = new JToggleButton();
        this.toggleType04 = new JToggleButton();
        this.toggleType05 = new JToggleButton();
        this.toggleType06 = new JToggleButton();
        this.toggleType07 = new JToggleButton();
        this.toggleType08 = new JToggleButton();
        this.toggleType09 = new JToggleButton();
        this.toggleType10 = new JToggleButton();
        this.toggleType11 = new JToggleButton();
        this.toggleType12 = new JToggleButton();
        this.mainPanel = new JPanel();
        this.lbLevel = new JLabel();
        this.levelEditor = new SmallIntEditor();
        this.loopChk = new JCheckBox();
        this.autostartChk = new JCheckBox();
        this.filePanel = new JPanel();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.lbFile = new JLabel();
        this.fileTxt = new JTextField();
        this.findFileBtn = new JButton();
        JPanel jPanel3 = new JPanel();
        this.lbRecbuffer = new JLabel();
        this.recBufferEditor = new SmallIntEditor();
        this.lbLength = new JLabel();
        this.lengthEditor = new SmallIntEditor();
        this.fragmentPanel = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        this.lbFrom = new JLabel();
        this.fromTxt = new JTextField();
        this.lbTo = new JLabel();
        this.toTxt = new JTextField();
        JPanel jPanel6 = new JPanel();
        this.lbExternal = new JLabel();
        this.externalTxt = new JTextField();
        this.locationPanel = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        this.posCellRadio = new JRadioButton();
        this.posWindowRadio = new JRadioButton();
        this.posAbsoluteRadio = new JRadioButton();
        this.lbX = new JLabel();
        this.xTxt = new JTextField();
        this.lbY = new JLabel();
        this.yTxt = new JTextField();
        this.lbLocFrom = new JLabel();
        this.locFromCombo = new JComboBox(this.locationFromNames);
        this.catchMouseChk = new JCheckBox();
        this.stretchChk = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.setBorder(new EtchedBorder());
        this.mediaTypePanel.setLayout(new GridBagLayout());
        this.mediaTypePanel.setBorder(new TitledBorder(this.options.getMsg("edit_mc_type")));
        jToggleButton.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[0]));
        jToggleButton.setText(this.options.getMsg("edit_mc_type_unknown"));
        jToggleButton.setToolTipText(this.options.getMsg("edit_mc_type_unknown"));
        this.mediaTypes.add(jToggleButton);
        jToggleButton.setHorizontalAlignment(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)jToggleButton, gridBagConstraints);
        this.toggleType01.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[1]));
        this.toggleType01.setText(this.options.getMsg("edit_mc_type_sound"));
        this.toggleType01.setToolTipText(this.options.getMsg("edit_mc_type_sound"));
        this.mediaTypes.add(this.toggleType01);
        this.toggleType01.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType01, gridBagConstraints);
        this.toggleType02.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[2]));
        this.toggleType02.setText(this.options.getMsg("edit_mc_type_video"));
        this.toggleType02.setToolTipText(this.options.getMsg("edit_mc_type_video"));
        this.mediaTypes.add(this.toggleType02);
        this.toggleType02.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType02, gridBagConstraints);
        this.toggleType03.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[3]));
        this.toggleType03.setText(this.options.getMsg("edit_mc_type_midi"));
        this.toggleType03.setToolTipText(this.options.getMsg("edit_mc_type_midi"));
        this.mediaTypes.add(this.toggleType03);
        this.toggleType03.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType03, gridBagConstraints);
        this.toggleType04.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[4]));
        this.toggleType04.setText(this.options.getMsg("edit_mc_type_cdaudio"));
        this.toggleType04.setToolTipText(this.options.getMsg("edit_mc_type_cdaudio"));
        this.mediaTypes.add(this.toggleType04);
        this.toggleType04.setHorizontalAlignment(2);
        this.toggleType04.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType04, gridBagConstraints);
        this.toggleType05.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[5]));
        this.toggleType05.setText(this.options.getMsg("edit_mc_type_record"));
        this.toggleType05.setToolTipText(this.options.getMsg("edit_mc_type_record"));
        this.mediaTypes.add(this.toggleType05);
        this.toggleType05.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType05, gridBagConstraints);
        this.toggleType06.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[6]));
        this.toggleType06.setText(this.options.getMsg("edit_mc_type_play_recorded"));
        this.toggleType06.setToolTipText(this.options.getMsg("edit_mc_type_play_recorded"));
        this.mediaTypes.add(this.toggleType06);
        this.toggleType06.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType06, gridBagConstraints);
        this.toggleType07.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[7]));
        this.toggleType07.setText(this.options.getMsg("edit_mc_type_run_activity"));
        this.toggleType07.setToolTipText(this.options.getMsg("edit_mc_type_run_activity"));
        this.mediaTypes.add(this.toggleType07);
        this.toggleType07.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType07, gridBagConstraints);
        this.toggleType08.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[8]));
        this.toggleType08.setText(this.options.getMsg("edit_mc_type_run_sequence"));
        this.toggleType08.setToolTipText(this.options.getMsg("edit_mc_type_run_sequence"));
        this.mediaTypes.add(this.toggleType08);
        this.toggleType08.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType08, gridBagConstraints);
        this.toggleType09.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[9]));
        this.toggleType09.setText(this.options.getMsg("edit_mc_type_run_external"));
        this.toggleType09.setToolTipText(this.options.getMsg("edit_mc_type_run_external"));
        this.mediaTypes.add(this.toggleType09);
        this.toggleType09.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType09, gridBagConstraints);
        this.toggleType10.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[10]));
        this.toggleType10.setText(this.options.getMsg("edit_mc_type_url"));
        this.toggleType10.setToolTipText(this.options.getMsg("edit_mc_type_url"));
        this.mediaTypes.add(this.toggleType10);
        this.toggleType10.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType10, gridBagConstraints);
        this.toggleType11.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[11]));
        this.toggleType11.setText(this.options.getMsg("edit_mc_type_exit"));
        this.toggleType11.setToolTipText(this.options.getMsg("edit_mc_type_exit"));
        this.mediaTypes.add(this.toggleType11);
        this.toggleType11.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType11, gridBagConstraints);
        this.toggleType12.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[12]));
        this.toggleType12.setText(this.options.getMsg("edit_mc_type_return"));
        this.toggleType12.setToolTipText(this.options.getMsg("edit_mc_type_return"));
        this.mediaTypes.add(this.toggleType12);
        this.toggleType12.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType12, gridBagConstraints);
        this.add((Component)this.mediaTypePanel, "West");
        this.mainPanel.setLayout(new GridBagLayout());
        this.lbLevel.setText(this.options.getMsg("edit_mc_level"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.lbLevel, gridBagConstraints);
        this.levelEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.levelEditor, gridBagConstraints);
        this.loopChk.setText(this.options.getMsg("edit_mc_loop"));
        this.loopChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.loopChk, gridBagConstraints);
        this.autostartChk.setText(this.options.getMsg("edit_mc_autostart"));
        this.autostartChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.autostartChk, gridBagConstraints);
        this.filePanel.setLayout(new CardLayout());
        this.filePanel.add((Component)jPanel, "card0");
        jPanel2.setLayout(new GridBagLayout());
        this.lbFile.setText(this.options.getMsg("edit_mc_file"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this.lbFile, gridBagConstraints);
        this.fileTxt.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this.fileTxt, gridBagConstraints);
        this.findFileBtn.setText("...");
        this.findFileBtn.addActionListener(this);
        jPanel2.add((Component)this.findFileBtn, new GridBagConstraints());
        this.filePanel.add((Component)jPanel2, "card1");
        jPanel3.setLayout(new GridBagLayout());
        this.lbRecbuffer.setText(this.options.getMsg("edit_mc_recBuffer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel3.add((Component)this.lbRecbuffer, gridBagConstraints);
        this.recBufferEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel3.add((Component)this.recBufferEditor, gridBagConstraints);
        this.lbLength.setText(this.options.getMsg("edit_mc_length"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel3.add((Component)this.lbLength, gridBagConstraints);
        this.lengthEditor.setMax(15);
        this.lengthEditor.setValue(5);
        this.lengthEditor.setMin(1);
        this.lengthEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel3.add((Component)this.lengthEditor, gridBagConstraints);
        this.filePanel.add((Component)jPanel3, "card2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.filePanel, gridBagConstraints);
        this.fragmentPanel.setLayout(new CardLayout());
        this.fragmentPanel.add((Component)jPanel4, "card0");
        jPanel5.setLayout(new GridBagLayout());
        this.lbFrom.setLabelFor(this.fromTxt);
        this.lbFrom.setText(this.options.getMsg("edit_mc_from"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel5.add((Component)this.lbFrom, gridBagConstraints);
        this.fromTxt.setHorizontalAlignment(4);
        this.fromTxt.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel5.add((Component)this.fromTxt, gridBagConstraints);
        this.lbTo.setLabelFor(this.toTxt);
        this.lbTo.setText(this.options.getMsg("edit_mc_to"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel5.add((Component)this.lbTo, gridBagConstraints);
        this.toTxt.setHorizontalAlignment(4);
        this.toTxt.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel5.add((Component)this.toTxt, gridBagConstraints);
        this.fragmentPanel.add((Component)jPanel5, "card1");
        jPanel6.setLayout(new GridBagLayout());
        this.lbExternal.setLabelFor(this.externalTxt);
        this.lbExternal.setText(this.options.getMsg("edit_mc_externalParam"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel6.add((Component)this.lbExternal, gridBagConstraints);
        this.externalTxt.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel6.add((Component)this.externalTxt, gridBagConstraints);
        this.fragmentPanel.add((Component)jPanel6, "card2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.fragmentPanel, gridBagConstraints);
        this.locationPanel.setLayout(new CardLayout());
        this.locationPanel.add((Component)jPanel7, "card0");
        jPanel8.setLayout(new GridBagLayout());
        jPanel9.setLayout(new GridBagLayout());
        jPanel9.setBorder(new TitledBorder(this.options.getMsg("edit_mc_location")));
        this.posCellRadio.setText(this.options.getMsg("edit_mc_pos_cell"));
        this.posTypes.add(this.posCellRadio);
        this.posCellRadio.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        jPanel9.add((Component)this.posCellRadio, gridBagConstraints);
        this.posWindowRadio.setText(this.options.getMsg("edit_mc_pos_window"));
        this.posTypes.add(this.posWindowRadio);
        this.posWindowRadio.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel9.add((Component)this.posWindowRadio, gridBagConstraints);
        this.posAbsoluteRadio.setText(this.options.getMsg("edit_mc_pos_absolute"));
        this.posTypes.add(this.posAbsoluteRadio);
        this.posAbsoluteRadio.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel9.add((Component)this.posAbsoluteRadio, gridBagConstraints);
        this.lbX.setText(this.options.getMsg("edit_mc_location_x"));
        this.lbX.setLabelFor(this.xTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel9.add((Component)this.lbX, gridBagConstraints);
        this.xTxt.setHorizontalAlignment(4);
        this.xTxt.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel9.add((Component)this.xTxt, gridBagConstraints);
        this.lbY.setText(this.options.getMsg("edit_mc_location_y"));
        this.lbY.setLabelFor(this.yTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel9.add((Component)this.lbY, gridBagConstraints);
        this.yTxt.setHorizontalAlignment(4);
        this.yTxt.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel9.add((Component)this.yTxt, gridBagConstraints);
        this.lbLocFrom.setText(this.options.getMsg("edit_mc_location_from"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel9.add((Component)this.lbLocFrom, gridBagConstraints);
        this.locFromCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel9.add((Component)this.locFromCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel8.add((Component)jPanel9, gridBagConstraints);
        this.catchMouseChk.setText(this.options.getMsg("edit_mc_catchmouse"));
        this.catchMouseChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel8.add((Component)this.catchMouseChk, gridBagConstraints);
        this.stretchChk.setText(this.options.getMsg("edit_mc_stretch"));
        this.stretchChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel8.add((Component)this.stretchChk, gridBagConstraints);
        this.locationPanel.add((Component)jPanel8, "card1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.locationPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    public boolean documentChangePerformed(DocumentEvent documentEvent) {
        int n;
        Document document = documentEvent.getDocument();
        for (n = 0; n < this.textFields.length && this.textFields[n].getDocument() != document; ++n) {
        }
        if (n < this.textFields.length) {
            return this.eventPerformed(new EventObject(this.textFields[n]));
        }
        return false;
    }

    public boolean eventPerformed(EventObject eventObject) {
        if (eventObject != null && eventObject.getSource() != null) {
            this.setInitializing(true);
            MediaContent mediaContent = this.getMcClone();
            Object object = eventObject.getSource();
            if (object == this.levelEditor) {
                this.mc.level = this.levelEditor.getValue();
            } else if (object == this.recBufferEditor) {
                this.mc.recBuffer = this.recBufferEditor.getValue();
            } else if (object == this.lengthEditor) {
                this.mc.length = this.lengthEditor.getValue();
            } else if (object == this.fileTxt) {
                String string = this.fileTxt.getText();
                this.mc.mediaFileName = string.length() > 0 ? string : null;
            } else if (object == this.externalTxt) {
                String string = this.externalTxt.getText();
                this.mc.externalParam = string.length() > 0 ? string : null;
            } else if (object == this.fromTxt) {
                this.mc.from = this.getIntValue(this.fromTxt, -1);
            } else if (object == this.toTxt) {
                this.mc.to = this.getIntValue(this.toTxt, -1);
            } else if (object == this.stretchChk) {
                this.mc.stretch = this.stretchChk.isSelected();
            } else if (object == this.posCellRadio) {
                this.mc.free = false;
                this.mc.absLocation = null;
                this.syncPointValues();
                this.checkEnabled();
            } else if (object == this.posWindowRadio) {
                this.mc.free = true;
                this.mc.absLocation = null;
                this.syncPointValues();
                this.checkEnabled();
            } else if (object == this.posAbsoluteRadio) {
                this.mc.free = false;
                this.mc.absLocation = new Point();
                this.syncPointValues();
                this.checkEnabled();
            } else if (object == this.locFromCombo) {
                this.mc.absLocationFrom = Math.max(0, this.locFromCombo.getSelectedIndex());
            } else if (object == this.xTxt && this.mc.absLocation != null) {
                this.mc.absLocation.x = this.getIntValue(this.xTxt, 0);
            } else if (object == this.yTxt && this.mc.absLocation != null) {
                this.mc.absLocation.y = this.getIntValue(this.yTxt, 0);
            } else if (object == this.loopChk) {
                this.mc.loop = this.loopChk.isSelected();
            } else if (object == this.autostartChk) {
                this.mc.autoStart = this.autostartChk.isSelected();
            } else if (object == this.catchMouseChk) {
                this.mc.catchMouseEvents = this.catchMouseChk.isSelected();
            } else if (object == this.findFileBtn) {
                this.selectBtnPressed();
            } else if (object instanceof JToggleButton) {
                Enumeration<AbstractButton> enumeration = this.mediaTypes.getElements();
                int n = -1;
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
                    if (jToggleButton == object) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                if (n >= 0) {
                    int n3 = this.mc.mediaType;
                    this.mc.mediaType = n;
                    if (this.mc.mediaType != n3) {
                        MediaContent mediaContent2 = new MediaContent();
                        mediaContent2.mediaType = this.mc.mediaType;
                        this.setMediaContent(mediaContent2);
                    }
                }
            }
            this.checkAndFirePropertyChange(mediaContent);
            this.setInitializing(false);
        }
        return true;
    }

    protected void selectBtnPressed() {
        String string = null;
        JList jList = null;
        String string2 = null;
        if (this.mc.mediaType == 7) {
            jList = new JList(this.mbe.getProjectEditor().getActivityBagEditor().getListModel());
            string2 = "edit_mc_activity_selection";
        } else if (this.mc.mediaType == 8) {
            jList = new JList(this.mbe.getProjectEditor().getActivitySequenceEditor().getTagList());
            string2 = "edit_mc_sequence_selection";
        }
        if (jList != null) {
            Object e;
            JScrollPane jScrollPane = new JScrollPane(jList);
            if (this.options.getMessages().showInputDlg(this, jScrollPane, string2) && (e = jList.getSelectedValue()) != null) {
                string = e.toString();
            }
        } else {
            int n = this.mc.mediaType == 1 ? 13 : (this.mc.mediaType == 3 ? 14 : (this.mc.mediaType == 2 ? 15 : 20));
            string = MediaBagSelector.getMediaName(this.mc.mediaFileName, this.options, this, this.mbe, n);
        }
        if (string != null) {
            this.mc.mediaFileName = string;
            this.fileTxt.setText(string);
        }
    }

    protected void checkEnabled() {
        String string;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = true;
        boolean bl12 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        switch (this.mc.mediaType) {
            case 2: {
                bl8 = true;
                bl9 = true;
                bl12 = true;
                n3 = 1;
            }
            case 1: 
            case 3: {
                bl4 = true;
                bl6 = true;
                bl7 = true;
                bl10 = true;
                n = 1;
                n2 = 1;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                bl3 = true;
            }
            case 6: {
                bl2 = true;
                n = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                bl5 = true;
            }
            case 10: {
                bl4 = true;
                bl = false;
                n = 1;
                n2 = 2;
                break;
            }
            case 11: 
            case 12: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        this.levelEditor.setEnabled(bl);
        this.recBufferEditor.setEnabled(bl2);
        this.lengthEditor.setEnabled(bl3);
        this.fileTxt.setEnabled(bl4);
        this.findFileBtn.setEnabled(bl4);
        this.externalTxt.setEnabled(bl5);
        this.fromTxt.setEnabled(bl6);
        this.toTxt.setEnabled(bl7);
        this.stretchChk.setEnabled(bl8);
        this.posCellRadio.setEnabled(bl9);
        this.posWindowRadio.setEnabled(bl9);
        this.posAbsoluteRadio.setEnabled(bl9);
        this.locFromCombo.setEnabled(bl9 && this.mc.absLocation != null);
        this.xTxt.setEnabled(bl9 && this.mc.absLocation != null);
        this.yTxt.setEnabled(bl9 && this.mc.absLocation != null);
        this.loopChk.setEnabled(bl10);
        this.autostartChk.setEnabled(bl11);
        this.catchMouseChk.setEnabled(bl12);
        CardLayout cardLayout = (CardLayout)this.filePanel.getLayout();
        cardLayout.show(this.filePanel, "card" + Integer.toString(n));
        if (n == 1) {
            string = this.mc.mediaType == 7 ? "edit_mc_activity" : (this.mc.mediaType == 8 ? "edit_mc_sequence" : (this.mc.mediaType == 10 ? "edit_mc_url" : "edit_mc_file"));
            this.lbFile.setText(this.options.getMsg(string));
            boolean bl13 = this.mc.mediaType != 10 && this.mc.mediaType != 9;
            this.findFileBtn.setVisible(bl13);
            this.filePanel.revalidate();
        }
        cardLayout = (CardLayout)this.fragmentPanel.getLayout();
        cardLayout.show(this.fragmentPanel, "card" + Integer.toString(n2));
        if (n2 == 2) {
            string = this.mc.mediaType == 7 || this.mc.mediaType == 8 ? "edit_mc_project" : "edit_mc_externalParam";
            this.lbExternal.setText(this.options.getMsg(string));
            this.fragmentPanel.revalidate();
        }
        cardLayout = (CardLayout)this.locationPanel.getLayout();
        cardLayout.show(this.locationPanel, "card" + Integer.toString(n3));
    }

    private void syncPointValues() {
        Point point = this.mc.absLocation;
        if (point == null) {
            point = new Point();
        }
        this.xTxt.setText(Integer.toString(point.x));
        this.yTxt.setText(Integer.toString(point.y));
        this.locFromCombo.setSelectedIndex(this.mc.absLocationFrom);
    }

    protected int getIntValue(JTextField jTextField, int n) {
        String string = jTextField.getText();
        int n2 = n;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public static MediaContent getMediaContent(MediaContent mediaContent, Component component, Options options, MediaBagEditor mediaBagEditor) {
        MediaContent mediaContent2 = null;
        Messages messages = options.getMessages();
        MediaContentEditor mediaContentEditor = (MediaContentEditor)panels.get(options);
        if (mediaContentEditor == null) {
            mediaContentEditor = new MediaContentEditor(options, mediaContent, mediaBagEditor);
            panels.put(options, mediaContentEditor);
        } else {
            mediaContentEditor.setMediaBagEditor(mediaBagEditor);
            mediaContentEditor.setMediaContent(mediaContent);
        }
        if (messages.showInputDlg(component, mediaContentEditor, "edit_mc_title") && mediaContentEditor.check(component)) {
            mediaContent2 = mediaContentEditor.getMc();
        }
        return mediaContent2;
    }

    public static boolean nameChanged(MediaContent mediaContent, int n, String string, String string2) {
        boolean bl = false;
        if ((n & 0x47F6) != 0 && string.equals(mediaContent.mediaFileName)) {
            mediaContent.mediaFileName = string2;
            bl = true;
        }
        return bl;
    }
}

