/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import edu.xtec.jclic.beans.CheckBoxTreeObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    public CheckBoxTree() {
        this.initComponents();
    }

    private void initComponents() {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CheckBoxTree.this.treeMouseClicked(mouseEvent);
            }
        });
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath != null && treePath.getLastPathComponent() instanceof CheckBoxTreeObject) {
            ((CheckBoxTreeObject)treePath.getLastPathComponent()).switchSelected();
            this.repaint(this.getPathBounds(treePath));
        }
    }

    class CellRenderer
    extends DefaultTreeCellRenderer {
        JCheckBox checkBox = new JCheckBox(){

            public void paint(Graphics graphics) {
                Color color;
                if (CellRenderer.this.hasFocus && (color = CellRenderer.this.getBorderSelectionColor()) != null) {
                    graphics.setColor(color);
                    graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
                super.paint(graphics);
            }
        };

        public CellRenderer() {
            this.checkBox.setBackground(this.getBackground());
            this.checkBox.setOpaque(this.isOpaque());
            this.checkBox.setFont(this.getFont());
            this.checkBox.setForeground(this.getForeground());
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof CheckBoxTreeObject) {
                CheckBoxTreeObject checkBoxTreeObject = (CheckBoxTreeObject)object;
                this.checkBox.setText(checkBoxTreeObject.getLabel());
                this.checkBox.setSelected(checkBoxTreeObject.isSelected());
                this.checkBox.setEnabled(jTree.isEnabled());
                this.checkBox.setComponentOrientation(jTree.getComponentOrientation());
                component = this.checkBox;
            }
            return component;
        }
    }
}

