/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import edu.xtec.jclic.beans.NullableObject;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.BoxBaseEditor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JButton;

public class BoxBaseButton
extends NullableObject {
    public static final String PROP_BOX_BASE = "boxBase";
    public static final String SAMPLE_STR = "abc";
    AbstractBox preview;

    protected String getObjectType() {
        return PROP_BOX_BASE;
    }

    public BoxBase getBoxBase() {
        return (BoxBase)this.getObject();
    }

    public void setBoxBase(BoxBase boxBase) {
        this.setObject(boxBase);
    }

    public void setObject(Object object) {
        super.setObject(object);
    }

    protected AbstractButton buildButton() {
        return new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                BoxBase boxBase = BoxBaseButton.this.getBoxBase();
                if (boxBase != null) {
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    rectangle.grow(-3, -3);
                    graphics.setColor(boxBase.backColor);
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.setColor(boxBase.textColor);
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n = rectangle.y + rectangle.height - (rectangle.height - fontMetrics.getAscent()) / 2 - fontMetrics.getDescent();
                    int n2 = rectangle.x + (rectangle.width - fontMetrics.stringWidth(BoxBaseButton.SAMPLE_STR)) / 2;
                    graphics.drawString(BoxBaseButton.SAMPLE_STR, n2, n);
                }
            }
        };
    }

    public void setPreview(AbstractBox abstractBox) {
        this.preview = abstractBox;
    }

    protected Object createObject() {
        return new BoxBase();
    }

    protected Object editObject(Object object) {
        BoxBase boxBase = (BoxBase)(object == null ? this.createObject() : object);
        return BoxBaseEditor.getBoxBase(boxBase, this, this.options, this.preview);
    }
}

