/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MediaBagSelector
extends JPanel {
    Options options;
    MediaBagEditor mbe;
    MediaBagElementEditor current;
    int filters;
    private ListSelectionListener selListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent != null && !listSelectionEvent.getValueIsAdjusting()) {
                MediaBagSelector.this.setSelected((MediaBagElementEditor)MediaBagSelector.this.mediaList.getSelectedValue());
            }
        }
    };
    private static HashMap dlgPanels = new HashMap(1);
    private JPanel elementPanel;
    private JLabel fileLb;
    private JLabel fileText;
    private JList mediaList;
    private JLabel nameLb;
    private JLabel nameText;
    private JLabel previewLabel;
    private JScrollPane scrollList;
    private JLabel sizeTx;
    private JLabel typeTx;

    public MediaBagSelector(Options options) {
        this.options = options;
        this.initComponents();
        this.mediaList.addListSelectionListener(this.selListener);
    }

    private void initComponents() {
        this.scrollList = new JScrollPane();
        this.mediaList = new JList();
        this.elementPanel = new JPanel();
        this.previewLabel = new JLabel();
        this.nameLb = new JLabel();
        this.nameText = new JLabel();
        this.fileLb = new JLabel();
        this.fileText = new JLabel();
        JLabel jLabel = new JLabel();
        this.typeTx = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.sizeTx = new JLabel();
        this.setLayout(new GridBagLayout());
        this.scrollList.setPreferredSize(new Dimension(120, 120));
        this.scrollList.setMinimumSize(new Dimension(120, 120));
        this.scrollList.setViewportView(this.mediaList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.scrollList, gridBagConstraints);
        this.elementPanel.setLayout(new GridBagLayout());
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setPreferredSize(new Dimension(100, 100));
        this.previewLabel.setBorder(new EtchedBorder());
        this.previewLabel.setMinimumSize(new Dimension(100, 100));
        this.previewLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MediaBagSelector.this.previewLabelMousePressed(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 7, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.elementPanel.add((Component)this.previewLabel, gridBagConstraints);
        this.nameLb.setText(this.options.getMsg("edit_name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.nameLb, gridBagConstraints);
        this.nameText.setPreferredSize(new Dimension(100, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.elementPanel.add((Component)this.nameText, gridBagConstraints);
        this.fileLb.setText(this.options.getMsg("edit_file"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.fileLb, gridBagConstraints);
        this.fileText.setPreferredSize(new Dimension(100, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.fileText, gridBagConstraints);
        jLabel.setText(this.options.getMsg("edit_media_type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)jLabel, gridBagConstraints);
        this.typeTx.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.typeTx, gridBagConstraints);
        jLabel2.setText(this.options.getMsg("edit_media_size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)jLabel2, gridBagConstraints);
        this.sizeTx.setText("0 Kb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.elementPanel.add((Component)this.sizeTx, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.elementPanel, gridBagConstraints);
    }

    private void previewLabelMousePressed(MouseEvent mouseEvent) {
        if (this.current != null) {
            this.current.testMedia(this, this.options);
        }
    }

    protected void setMediaBagEditor(MediaBagEditor mediaBagEditor, int n) {
        this.mbe = mediaBagEditor;
        this.filters = n;
        this.setSelected(null);
        this.mediaList.setListData(mediaBagEditor == null ? new Vector() : mediaBagEditor.getChildrenList(n));
    }

    protected void setSelected(MediaBagElementEditor mediaBagElementEditor) {
        this.current = mediaBagElementEditor;
        this.nameText.setText(this.current == null ? "" : this.current.getName());
        this.fileText.setText(this.current == null ? "" : this.current.getMediaBagElement().getFileName());
        this.typeTx.setText(mediaBagElementEditor == null ? "" : mediaBagElementEditor.getDescription(this.options));
        long l = -1L;
        if (mediaBagElementEditor != null) {
            l = mediaBagElementEditor.getFileSize();
        }
        this.sizeTx.setText(l < 0L ? "" : this.options.getMessages().fileSize(l));
        this.previewLabel.setIcon(mediaBagElementEditor == null ? null : mediaBagElementEditor.getMediaBagElement().getThumbNail(90, 90, mediaBagElementEditor.getMediaBag().getProject().getFileSystem()));
    }

    protected MediaBagElementEditor getSelected() {
        return this.current;
    }

    public static String getMediaName(String string, Options options, Component component, MediaBagEditor mediaBagEditor, int n) {
        MediaBagElementEditor mediaBagElementEditor;
        String string2 = null;
        Messages messages = options.getMessages();
        MediaBagSelector mediaBagSelector = (MediaBagSelector)dlgPanels.get(options);
        if (mediaBagSelector == null) {
            mediaBagSelector = new MediaBagSelector(options);
            mediaBagSelector.setPreferredSize(new Dimension(400, 300));
            dlgPanels.put(options, mediaBagSelector);
        }
        mediaBagSelector.setMediaBagEditor(mediaBagEditor, n);
        MediaBagElementEditor mediaBagElementEditor2 = string == null ? null : (MediaBagElementEditor)mediaBagEditor.getChildByName(string);
        mediaBagSelector.setSelected(mediaBagElementEditor2);
        mediaBagSelector.mediaList.setSelectedValue(mediaBagElementEditor2, true);
        boolean bl = messages.showInputDlg(component, mediaBagSelector, "edit_media_dlg_title");
        if (bl && (mediaBagElementEditor = mediaBagSelector.getSelected()) != null) {
            string2 = mediaBagElementEditor.getName();
        }
        mediaBagSelector.setMediaBagEditor(null, -1);
        return string2;
    }
}

