/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceEditor;
import edu.xtec.jclic.bags.ActivitySequenceEditorPanel;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.ActivitySequenceElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceJump;
import edu.xtec.jclic.bags.ConditionalJumpInfo;
import edu.xtec.jclic.bags.ConditionalJumpPanel;
import edu.xtec.jclic.bags.JumpInfo;
import edu.xtec.jclic.beans.NullableObject;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.CustomListCellRenderer;
import edu.xtec.util.ListComboModel;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;

public class ActivitySequenceElementEditorPanel
extends EditorPanel {
    String[] fwdOptions;
    String[] backOptions;
    Icon[] fwdIcons;
    Icon[] backIcons;
    protected ListComboModel actModel;
    protected ListComboModel jmpTagModel;
    protected JComboBox tagCombo;
    protected JTextField prjEdit;
    protected JComponent[] prompt_objects;
    protected String[] prompt_keys;
    protected String[] prompt_msg;
    private static final String[] FWD_OPTIONS_KEYS = new String[]{"edit_seq_action_fwd", "edit_seq_action_jump", "edit_seq_action_stop", "edit_seq_action_return", "edit_seq_action_exit"};
    private static final String[] FWD_OPTIONS_ICONS = new String[]{"seq_next", "seq_next_jump", "seq_next_stop", "seq_next_return", "seq_exit"};
    private static final String[] BACK_OPTIONS_KEYS = new String[]{"edit_seq_action_back", "edit_seq_action_jump", "edit_seq_action_stop", "edit_seq_action_return", "edit_seq_action_exit"};
    private static final String[] BACK_OPTIONS_ICONS = new String[]{"seq_prev", "seq_prev_jump", "seq_prev_stop", "seq_prev_return", "seq_exit"};
    private JComboBox actCombo;
    private JCheckBox autoChk;
    private JComboBox backActionCombo;
    private JCheckBox backEnabledChk;
    private JButton backJumpBtn;
    private JLabel backJumpLb;
    private SmallIntEditor delayEditor;
    private JTextArea descText;
    private JButton editActBtn;
    private JComboBox fwdActionCombo;
    private JCheckBox fwdEnabledChk;
    private JButton fwdJumpBtn;
    private JLabel fwdJumpLb;
    private NullableObject lowerBtn;
    private JPanel mainPanel;
    private JScrollPane scroll;
    private JTextField tagText;
    private NullableObject upperBtn;

    public ActivitySequenceElementEditorPanel(Options options) {
        super(options);
        this.initObjects();
        this.initComponents();
        this.postInit(250, false, false);
        this.setEnabled(false);
    }

    private void initObjects() {
        int n = FWD_OPTIONS_KEYS.length;
        this.fwdOptions = new String[n];
        this.fwdIcons = new Icon[n];
        this.backOptions = new String[n];
        this.backIcons = new Icon[n];
        for (int i = 0; i < FWD_OPTIONS_KEYS.length; ++i) {
            this.fwdOptions[i] = this.options.getMsg(FWD_OPTIONS_KEYS[i]);
            this.fwdIcons[i] = ResourceManager.getImageIcon("icons/" + FWD_OPTIONS_ICONS[i] + ".gif");
            this.backOptions[i] = this.options.getMsg(BACK_OPTIONS_KEYS[i]);
            this.backIcons[i] = ResourceManager.getImageIcon("icons/" + BACK_OPTIONS_ICONS[i] + ".gif");
        }
        this.tagCombo = new JComboBox();
        this.tagCombo.setEditable(true);
        this.tagCombo.addActionListener(this);
        this.prjEdit = new JTextField();
        this.prompt_objects = new JComponent[]{this.tagCombo, this.prjEdit};
        this.prompt_keys = new String[]{"edit_seq_tag", "edit_seq_project"};
        this.prompt_msg = new String[]{"edit_seq_jump_msg"};
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.actCombo = new JComboBox();
        this.editActBtn = new JButton();
        this.editActBtn.addActionListener(this);
        JLabel jLabel2 = new JLabel();
        this.tagText = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.scroll = new JScrollPane();
        this.descText = new JTextArea();
        JPanel jPanel = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.fwdEnabledChk = new JCheckBox();
        JLabel jLabel5 = new JLabel();
        this.fwdActionCombo = new JComboBox<String>(this.fwdOptions);
        this.fwdJumpBtn = new JButton();
        this.fwdJumpLb = new JLabel();
        this.autoChk = new JCheckBox();
        JLabel jLabel6 = new JLabel();
        this.delayEditor = new SmallIntEditor();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel7 = new JLabel();
        this.upperBtn = new CondJumpBtn(true);
        JLabel jLabel8 = new JLabel();
        this.lowerBtn = new CondJumpBtn(false);
        JPanel jPanel3 = new JPanel();
        JLabel jLabel9 = new JLabel();
        this.backEnabledChk = new JCheckBox();
        JLabel jLabel10 = new JLabel();
        this.backActionCombo = new JComboBox<String>(this.backOptions);
        this.backJumpBtn = new JButton();
        this.backJumpLb = new JLabel();
        JLabel jLabel11 = new JLabel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        jLabel.setText(this.options.getMsg("edit_seq_activity"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        this.actCombo.setToolTipText(this.options.getMsg("edit_seq_activity_tooltip"));
        this.actCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.actCombo, gridBagConstraints);
        this.editActBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/miniclic.png")));
        this.editActBtn.setToolTipText(this.options.getMsg("edit_act_editActivity_tooltip"));
        this.editActBtn.setText(this.options.getMsg("edit_act_editActivity"));
        this.editActBtn.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.editActBtn, gridBagConstraints);
        jLabel2.setText(this.options.getMsg("edit_seq_tag"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        this.tagText.setToolTipText(this.options.getMsg("edit_seq_tag_tooltip"));
        this.tagText.setPreferredSize(new Dimension(130, 21));
        this.tagText.setMinimumSize(new Dimension(130, 21));
        this.tagText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.tagText, gridBagConstraints);
        jLabel3.setText(this.options.getMsg("edit_seq_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        this.scroll.setPreferredSize(new Dimension(200, 60));
        this.scroll.setMinimumSize(new Dimension(200, 40));
        this.descText.setWrapStyleWord(true);
        this.descText.setToolTipText(this.options.getMsg("edit_seq_description_tooltip"));
        this.descText.setLineWrap(true);
        this.descText.setRows(2);
        this.descText.getDocument().addDocumentListener(this);
        this.scroll.setViewportView(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.scroll, gridBagConstraints);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.options.getMsg("edit_seq_arrow_fwd")));
        jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/next.gif")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        this.fwdEnabledChk.setToolTipText(this.options.getMsg("edit_seq_button_enabled_tooltip"));
        this.fwdEnabledChk.setText(this.options.getMsg("edit_seq_button_enabled"));
        this.fwdEnabledChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.fwdEnabledChk, gridBagConstraints);
        jLabel5.setText(this.options.getMsg("edit_seq_action"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel5, gridBagConstraints);
        this.fwdActionCombo.setToolTipText(this.options.getMsg("edit_seq_action_tooltip_fw"));
        this.fwdActionCombo.setRenderer(new CustomListCellRenderer(this.fwdOptions, this.fwdIcons));
        this.fwdActionCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.fwdActionCombo, gridBagConstraints);
        this.fwdJumpBtn.setText("...");
        this.fwdJumpBtn.setToolTipText(this.options.getMsg("edit_seq_jump_tooltip"));
        this.fwdJumpBtn.setMargin(new Insets(0, 3, 0, 3));
        this.fwdJumpBtn.setEnabled(false);
        this.fwdJumpBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.fwdJumpBtn, gridBagConstraints);
        this.fwdJumpLb.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.fwdJumpLb, gridBagConstraints);
        this.autoChk.setText(this.options.getMsg("edit_seq_auto"));
        this.autoChk.setToolTipText(this.options.getMsg("edit_seq_auto_tooltip"));
        this.autoChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.autoChk, gridBagConstraints);
        jLabel6.setText(this.options.getMsg("edit_seq_delay"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel6, gridBagConstraints);
        this.delayEditor.setToolTipText(this.options.getMsg("edit_seq_delay_tooltip"));
        this.delayEditor.setMax(999);
        this.delayEditor.setMin(1);
        this.delayEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.delayEditor, gridBagConstraints);
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(this.options.getMsg("edit_seq_condJump")));
        jPanel2.setToolTipText(this.options.getMsg("edit_seq_condJump_tooltip"));
        jLabel7.setLabelFor(this.upperBtn);
        jLabel7.setText(this.options.getMsg("edit_seq_condJump_upper"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)jLabel7, gridBagConstraints);
        this.upperBtn.setToolTipText(this.options.getMsg("edit_seq_condJump_upper_tooltip"));
        this.upperBtn.setText("<Not Set>");
        this.upperBtn.addPropertyChangeListener("customObject", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this.upperBtn, gridBagConstraints);
        jLabel8.setLabelFor(this.lowerBtn);
        jLabel8.setText(this.options.getMsg("edit_seq_condJump_lower"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)jLabel8, gridBagConstraints);
        this.lowerBtn.setToolTipText(this.options.getMsg("edit_seq_condJump_lower_tooltip"));
        this.lowerBtn.setText("<Not Set>");
        this.lowerBtn.addPropertyChangeListener("customObject", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this.lowerBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(this.options.getMsg("edit_seq_arrow_back")));
        jLabel9.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/prev.gif")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)jLabel9, gridBagConstraints);
        this.backEnabledChk.setToolTipText(this.options.getMsg("edit_seq_button_enabled_tooltip"));
        this.backEnabledChk.setText(this.options.getMsg("edit_seq_button_enabled"));
        this.backEnabledChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.backEnabledChk, gridBagConstraints);
        jLabel10.setText(this.options.getMsg("edit_seq_action"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)jLabel10, gridBagConstraints);
        this.backActionCombo.setToolTipText(this.options.getMsg("edit_seq_action_tooltip_bk"));
        this.backActionCombo.setRenderer(new CustomListCellRenderer(this.backOptions, this.backIcons));
        this.backActionCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.backActionCombo, gridBagConstraints);
        this.backJumpBtn.setText("...");
        this.backJumpBtn.setToolTipText(this.options.getMsg("edit_seq_jump_tooltip"));
        this.backJumpBtn.setMargin(new Insets(0, 3, 0, 3));
        this.backJumpBtn.setEnabled(false);
        this.backJumpBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.backJumpBtn, gridBagConstraints);
        this.backJumpLb.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.backJumpLb, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)jLabel11, gridBagConstraints);
        this.add((Component)this.mainPanel, "West");
    }

    public boolean checkIfEditorValid(Editor editor) {
        return editor instanceof ActivitySequenceElementEditor;
    }

    protected ActivitySequenceElement getActivitySequenceElement() {
        if (this.editor == null) {
            return null;
        }
        return ((ActivitySequenceElementEditor)this.editor).getActivitySequenceElement();
    }

    protected int getRealDelayValue() {
        return this.autoChk.isSelected() ? this.delayEditor.getValue() : 0;
    }

    protected int getBtnValue() {
        boolean bl = this.fwdEnabledChk.isSelected();
        boolean bl2 = this.backEnabledChk.isSelected();
        return bl ? (bl2 ? 3 : 1) : (bl2 ? 2 : 0);
    }

    protected void fillData() {
        JClicProjectEditor jClicProjectEditor;
        ActivitySequenceElement activitySequenceElement = this.getActivitySequenceElement();
        JClicProjectEditor jClicProjectEditor2 = jClicProjectEditor = activitySequenceElement == null ? null : ((ActivitySequenceElementEditor)this.getEditor()).getProjectEditor();
        if (jClicProjectEditor != null) {
            AbstractListModel abstractListModel = jClicProjectEditor.getActivityBagEditor().getListModel();
            if (this.actModel == null || this.actModel.getListModel() != abstractListModel) {
                this.actModel = new ListComboModel(abstractListModel);
                this.actCombo.setModel(this.actModel);
            }
            this.actCombo.setSelectedItem(jClicProjectEditor.getActivityBagEditor().getChildByName(activitySequenceElement.getActivityName()));
        } else {
            this.actModel = new ListComboModel();
            this.actCombo.setModel(this.actModel);
            this.actCombo.setSelectedItem(null);
        }
        this.fwdEnabledChk.setSelected(activitySequenceElement == null ? true : (activitySequenceElement.navButtons & 1) != 0);
        this.fwdActionCombo.setSelectedIndex(activitySequenceElement == null || activitySequenceElement.fwdJump == null ? 0 : activitySequenceElement.fwdJump.action + 1);
        this.backEnabledChk.setSelected(activitySequenceElement == null ? true : (activitySequenceElement.navButtons & 2) != 0);
        this.backActionCombo.setSelectedIndex(activitySequenceElement == null || activitySequenceElement.backJump == null ? 0 : activitySequenceElement.backJump.action + 1);
        this.tagText.setText(StrUtils.secureString(activitySequenceElement == null ? null : activitySequenceElement.getTag()));
        this.descText.setText(StrUtils.secureString(activitySequenceElement == null ? null : activitySequenceElement.getDescription()));
        this.autoChk.setSelected(activitySequenceElement != null && activitySequenceElement.delay > 0);
        this.delayEditor.setValue(Math.max(1, activitySequenceElement == null ? 0 : activitySequenceElement.delay));
        ((CondJumpBtn)this.upperBtn).setConditionalJumpInfo(activitySequenceElement == null || activitySequenceElement.fwdJump == null ? null : activitySequenceElement.fwdJump.upperJump);
        ((CondJumpBtn)this.lowerBtn).setConditionalJumpInfo(activitySequenceElement == null || activitySequenceElement.fwdJump == null ? null : activitySequenceElement.fwdJump.lowerJump);
        this.setJumpLabels();
        this.checkEnabled();
        this.repaint();
    }

    public boolean eventPerformed(EventObject eventObject) {
        Object object = eventObject == null ? null : eventObject.getSource();
        ActivitySequenceElement activitySequenceElement = this.getActivitySequenceElement();
        if (object == null || activitySequenceElement == null) {
            return false;
        }
        if (object == this.tagCombo) {
            if (this.tagCombo.getSelectedIndex() >= 0) {
                this.tagCombo.getEditor().setItem(this.tagCombo.getSelectedItem());
            }
            return false;
        }
        if (object == this.editActBtn && this.getEditor() != null && this.actCombo.getSelectedItem() != null) {
            JClicProjectEditor jClicProjectEditor = ((ActivitySequenceElementEditor)this.getEditor()).getProjectEditor();
            if (jClicProjectEditor != null && jClicProjectEditor.getTestPlayerContainer() != null) {
                jClicProjectEditor.getTestPlayerContainer().editActivity(this.actCombo.getSelectedItem().toString());
            }
            return false;
        }
        if (object == this.fwdActionCombo || object == this.fwdJumpBtn) {
            activitySequenceElement.fwdJump = (ActivitySequenceJump)this.checkJump(activitySequenceElement.fwdJump, this.fwdActionCombo, true, object == this.fwdJumpBtn);
            this.setJumpLabels();
        } else if (object == this.backActionCombo || object == this.backJumpBtn) {
            activitySequenceElement.backJump = (ActivitySequenceJump)this.checkJump(activitySequenceElement.backJump, this.backActionCombo, true, object == this.backJumpBtn);
            this.setJumpLabels();
        }
        this.checkEnabled();
        this.repaint();
        this.updateTable();
        return true;
    }

    public boolean documentChangePerformed(DocumentEvent documentEvent) {
        if (documentEvent != null && documentEvent.getDocument().equals(this.tagText.getDocument())) {
            this.updateTable();
        }
        return true;
    }

    private void updateTable() {
        Container container = this.getAWTAncestor(ActivitySequenceEditorPanel.class);
        if (container != null) {
            this.setInitializing(true);
            this.saveData();
            int n = ((ActivitySequenceEditorPanel)container).seqTable.getSelectionModel().getAnchorSelectionIndex();
            ((ActivitySequenceEditorPanel)container).tableModel.fireTableDataChanged();
            ((ActivitySequenceEditorPanel)container).seqTable.getSelectionModel().setSelectionInterval(n, n);
            this.setInitializing(false);
        }
    }

    protected JumpInfo checkJump(JumpInfo jumpInfo, JComboBox jComboBox, boolean bl, boolean bl2) {
        int n = bl ? 1 : 0;
        int n2 = jComboBox.getSelectedIndex();
        if (n2 == 0 && bl) {
            jumpInfo = null;
        } else {
            boolean bl3;
            if (jumpInfo == null) {
                jumpInfo = new ActivitySequenceJump(n2 - n);
            } else {
                jumpInfo.action = n2 - n;
            }
            if (jumpInfo.action == 0 && (bl2 || jumpInfo.sequence == null && jumpInfo.projectPath == null) && (!(bl3 = this.promptJumpParams(jumpInfo, this)) || jumpInfo.sequence == null && jumpInfo.projectPath == null)) {
                if (bl) {
                    jumpInfo = null;
                } else {
                    jumpInfo.action = 2;
                }
                this.setInitializing(true);
                jComboBox.setSelectedIndex(jumpInfo == null ? 0 : jumpInfo.action + n);
                this.setInitializing(false);
            }
        }
        return jumpInfo;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.actCombo.setEnabled(bl);
        this.fwdEnabledChk.setEnabled(bl);
        this.backEnabledChk.setEnabled(bl);
        this.tagText.setEnabled(bl);
        this.descText.setEnabled(bl);
        this.autoChk.setEnabled(bl);
        this.checkEnabled();
    }

    public void checkEnabled() {
        boolean bl = this.isEnabled();
        boolean bl2 = this.fwdEnabledChk.isSelected() || this.autoChk.isSelected();
        boolean bl3 = bl2 && this.fwdActionCombo.getSelectedIndex() == 1;
        boolean bl4 = bl2 && this.fwdActionCombo.getSelectedIndex() > 0;
        boolean bl5 = this.backEnabledChk.isSelected();
        boolean bl6 = bl5 && this.backActionCombo.getSelectedIndex() == 1;
        this.fwdActionCombo.setEnabled(bl && bl2);
        this.fwdJumpBtn.setEnabled(bl && bl3);
        this.delayEditor.setEnabled(bl && this.autoChk.isSelected());
        this.backActionCombo.setEnabled(bl && bl5);
        this.backJumpBtn.setEnabled(bl && bl6);
        this.upperBtn.setEnabled(bl && bl4);
        this.lowerBtn.setEnabled(bl && bl4);
    }

    protected void saveData() {
        ActivitySequenceElement activitySequenceElement = this.getActivitySequenceElement();
        ActivityBagElementEditor activityBagElementEditor = (ActivityBagElementEditor)this.actCombo.getSelectedItem();
        if (activitySequenceElement != null && activityBagElementEditor != null) {
            activitySequenceElement.setActivityName(activityBagElementEditor.toString());
            String string = StrUtils.nullableString(this.tagText.getText());
            if (!StrUtils.compareObjects(string, activitySequenceElement.getTag())) {
                ActivitySequenceEditor activitySequenceEditor = (ActivitySequenceEditor)this.getEditor().getEditorParent();
                if (activitySequenceElement.getTag() != null && activitySequenceEditor != null && activitySequenceEditor.tagList != null) {
                    activitySequenceEditor.tagList.removeElement(activitySequenceEditor.getTag(activitySequenceElement.getTag()));
                }
                activitySequenceElement.setTag(string);
                if (string != null && activitySequenceEditor != null && activitySequenceEditor.tagList != null) {
                    activitySequenceEditor.tagList.addElement(string);
                }
            }
            activitySequenceElement.setTag(StrUtils.nullableString(this.tagText.getText()));
            activitySequenceElement.setDescription(StrUtils.nullableString(this.descText.getText()));
            activitySequenceElement.navButtons = this.getBtnValue();
            activitySequenceElement.delay = this.getRealDelayValue();
            if (activitySequenceElement.fwdJump != null) {
                activitySequenceElement.fwdJump.upperJump = ((CondJumpBtn)this.upperBtn).getConditionalJumpInfo();
                activitySequenceElement.fwdJump.lowerJump = ((CondJumpBtn)this.lowerBtn).getConditionalJumpInfo();
            }
        }
    }

    protected Icon getIcon() {
        return ActivitySequenceElementEditor.getIcon();
    }

    protected String getTitle() {
        return "Activity sequence element";
    }

    protected boolean promptJumpParams(JumpInfo jumpInfo, Component component) {
        JClicProjectEditor jClicProjectEditor;
        boolean bl = false;
        ActivitySequenceElement activitySequenceElement = this.getActivitySequenceElement();
        if (activitySequenceElement != null && (jClicProjectEditor = ((ActivitySequenceElementEditor)this.getEditor()).getProjectEditor()) != null) {
            ListModel listModel = jClicProjectEditor.getActivitySequenceEditor().getTagList();
            if (this.jmpTagModel == null || this.jmpTagModel.getListModel() != listModel) {
                this.jmpTagModel = new ListComboModel(listModel);
            }
            this.tagCombo.setModel(this.jmpTagModel);
            this.tagCombo.setSelectedItem(jumpInfo.sequence);
            String string = jumpInfo.projectPath;
            this.prjEdit.setText(string == null ? "" : string);
            bl = this.options.getMessages().showInputDlg(component, this.prompt_msg, this.prompt_keys, this.prompt_objects, "edit_seq_jump_title");
            if (bl) {
                jumpInfo.sequence = StrUtils.nullableString(this.tagCombo.getEditor().getItem());
                jumpInfo.projectPath = StrUtils.nullableString(this.prjEdit.getText());
            }
        }
        return bl;
    }

    private void setJumpLabels() {
        StringBuffer stringBuffer = new StringBuffer();
        ActivitySequenceElement activitySequenceElement = this.getActivitySequenceElement();
        if (activitySequenceElement != null && activitySequenceElement.fwdJump != null) {
            if (activitySequenceElement.fwdJump.sequence != null) {
                stringBuffer.append(activitySequenceElement.fwdJump.sequence);
            }
            if (activitySequenceElement.fwdJump.projectPath != null) {
                stringBuffer.append(" (").append(activitySequenceElement.fwdJump.projectPath).append(")");
            }
        }
        this.fwdJumpLb.setText(stringBuffer.append(' ').substring(0));
        stringBuffer.setLength(0);
        if (activitySequenceElement != null && activitySequenceElement.backJump != null) {
            if (activitySequenceElement.backJump.sequence != null) {
                stringBuffer.append(activitySequenceElement.backJump.sequence);
            }
            if (activitySequenceElement.backJump.projectPath != null) {
                stringBuffer.append(" (").append(activitySequenceElement.backJump.projectPath).append(")");
            }
        }
        this.backJumpLb.setText(stringBuffer.append(' ').substring(0));
    }

    class CondJumpBtn
    extends NullableObject {
        boolean upper;
        ConditionalJumpPanel cjp;

        CondJumpBtn(boolean bl) {
            this.upper = bl;
            this.setOptions(ActivitySequenceElementEditorPanel.this.options);
        }

        ConditionalJumpInfo getConditionalJumpInfo() {
            return (ConditionalJumpInfo)this.getObject();
        }

        void setConditionalJumpInfo(ConditionalJumpInfo conditionalJumpInfo) {
            this.setObject(conditionalJumpInfo);
            this.checkIcon();
        }

        protected Object createObject() {
            return new ConditionalJumpInfo(2, null, this.upper ? 80 : 20);
        }

        protected Object editObject(Object object) {
            if (object == null) {
                object = this.createObject();
            }
            ConditionalJumpInfo conditionalJumpInfo = (ConditionalJumpInfo)object;
            if (this.cjp == null) {
                this.cjp = new ConditionalJumpPanel(this.options, ActivitySequenceElementEditorPanel.this, this.upper);
            }
            this.cjp.setJumpInfo((ConditionalJumpInfo)object, this.upper);
            boolean bl = this.options.getMessages().showInputDlg(this, this.cjp, "edit_seq_condJump_" + (this.upper ? "upper" : "lower"));
            return bl ? this.cjp.getJumpInfo() : null;
        }

        public void changeObject(Object object) {
            super.changeObject(object);
            this.checkIcon();
        }

        private void checkIcon() {
            ConditionalJumpInfo conditionalJumpInfo = this.getConditionalJumpInfo();
            if (conditionalJumpInfo == null || ActivitySequenceElementEditorPanel.this.fwdIcons == null) {
                this.setIcon(null);
            } else {
                this.setIcon(ActivitySequenceElementEditorPanel.this.fwdIcons[conditionalJumpInfo.action + 1]);
            }
            this.repaint();
        }
    }
}

