/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.automation.arith;

import edu.xtec.jclic.automation.arith.Operator;
import edu.xtec.jclic.beans.TextListEditor;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class OperatorEditorPanel
extends CtrlPanel {
    protected static final Integer[] LIST_OF_VALUES = new Integer[Operator.LIMITS.length];
    Options options;
    private ButtonGroup decGrp;
    private JComboBox fromCombo;
    private JCheckBox fromListChk;
    private JTextField listTxt;
    private JRadioButton opDec0;
    private JRadioButton opDec1;
    private JRadioButton opDec2;
    private JPanel opPanel;
    private JPanel rangePanel;
    private JComboBox toCombo;
    private JCheckBox withMinusOneChk;
    private JCheckBox withOneChk;
    private JCheckBox withZeroChk;

    public OperatorEditorPanel(Options options) {
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        this.decGrp = new ButtonGroup();
        this.rangePanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.fromCombo = new JComboBox<Integer>(LIST_OF_VALUES);
        JLabel jLabel2 = new JLabel();
        this.toCombo = new JComboBox<Integer>(LIST_OF_VALUES);
        JLabel jLabel3 = new JLabel();
        this.opPanel = new JPanel();
        this.withZeroChk = new JCheckBox();
        this.withOneChk = new JCheckBox();
        this.withMinusOneChk = new JCheckBox();
        this.fromListChk = new JCheckBox();
        this.listTxt = new JTextField();
        JPanel jPanel = new JPanel();
        this.opDec0 = new JRadioButton();
        this.opDec1 = new JRadioButton();
        this.opDec2 = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.rangePanel.setLayout(new GridBagLayout());
        jLabel.setLabelFor(this.fromCombo);
        jLabel.setText(this.options.getMsg("edit_arith_op_from"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.rangePanel.add((Component)jLabel, gridBagConstraints);
        this.fromCombo.setToolTipText(this.options.getMsg("edit_arith_op_from_tooltip"));
        this.fromCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.rangePanel.add((Component)this.fromCombo, gridBagConstraints);
        jLabel2.setLabelFor(this.toCombo);
        jLabel2.setText(this.options.getMsg("edit_arith_op_to"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.rangePanel.add((Component)jLabel2, gridBagConstraints);
        this.toCombo.setToolTipText(this.options.getMsg("edit_arith_op_to_tooltip"));
        this.toCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.rangePanel.add((Component)this.toCombo, gridBagConstraints);
        jLabel3.setText(this.options.getMsg("edit_arith_op_with"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.rangePanel.add((Component)jLabel3, gridBagConstraints);
        this.withZeroChk.setText("0");
        this.withZeroChk.setToolTipText(this.options.getMsg("edit_arith_op_with_tooltip"));
        this.withZeroChk.addActionListener(this);
        this.opPanel.add(this.withZeroChk);
        this.withOneChk.setText("1");
        this.withOneChk.setToolTipText(this.options.getMsg("edit_arith_op_with_tooltip"));
        this.withOneChk.addActionListener(this);
        this.opPanel.add(this.withOneChk);
        this.withMinusOneChk.setText("-1");
        this.withMinusOneChk.setToolTipText(this.options.getMsg("edit_arith_op_with_tooltip"));
        this.withMinusOneChk.addActionListener(this);
        this.opPanel.add(this.withMinusOneChk);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.rangePanel.add((Component)this.opPanel, gridBagConstraints);
        this.fromListChk.setText(this.options.getMsg("edit_arith_op_fromList"));
        this.fromListChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.rangePanel.add((Component)this.fromListChk, gridBagConstraints);
        this.listTxt.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.rangePanel.add((Component)this.listTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.rangePanel, gridBagConstraints);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.options.getMsg("edit_arith_op_decimals")));
        this.opDec0.setText(this.options.getMsg("edit_arith_op_dec0"));
        this.decGrp.add(this.opDec0);
        this.opDec0.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.opDec0, gridBagConstraints);
        this.opDec1.setText(this.options.getMsg("edit_arith_op_dec1"));
        this.decGrp.add(this.opDec1);
        this.opDec1.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.opDec1, gridBagConstraints);
        this.opDec2.setText(this.options.getMsg("edit_arith_op_dec2"));
        this.decGrp.add(this.opDec2);
        this.opDec2.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.opDec2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)jPanel, gridBagConstraints);
    }

    private TextListEditor buildNumList() {
        TextListEditor textListEditor = new TextListEditor(){

            protected Object editItem(Object object, boolean bl) {
                Object object2 = super.editItem(object, bl);
                if (object2 != null) {
                    boolean bl2 = false;
                    try {
                        int n = Integer.parseInt(object2.toString());
                        bl2 = Math.abs(n) < 100000000;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (!bl2) {
                        OperatorEditorPanel.this.options.getMessages().showAlert((Component)this, "BAD_NUMBER");
                        object2 = null;
                    }
                }
                return object2;
            }
        };
        textListEditor.setOptions(this.options);
        textListEditor.setMaxItems(20);
        return textListEditor;
    }

    public void setOperator(Operator operator) {
        this.setInitializing(true);
        this.fromCombo.setSelectedIndex(operator.limInf);
        this.toCombo.setSelectedIndex(operator.limSup);
        this.withZeroChk.setSelected(operator.wZero);
        this.withOneChk.setSelected(operator.wOne);
        this.withMinusOneChk.setSelected(operator.wMinusOne);
        if (operator.numDec == 1) {
            this.opDec1.setSelected(true);
        } else if (operator.numDec == 2) {
            this.opDec2.setSelected(true);
        } else {
            this.opDec0.setSelected(true);
        }
        this.fromListChk.setSelected(operator.fromList > 0);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < operator.fromList; ++i) {
            stringBuffer.append(operator.lst[i]).append(" ");
        }
        this.listTxt.setText(stringBuffer.substring(0).trim());
        this.checkEnabled();
        this.setInitializing(false);
        this.setModified(false);
    }

    public Operator getOperator() {
        Operator operator = new Operator();
        operator.limInf = this.fromCombo.getSelectedIndex();
        operator.limSup = this.toCombo.getSelectedIndex();
        operator.wZero = this.withZeroChk.isSelected();
        operator.wOne = this.withOneChk.isSelected();
        operator.wMinusOne = this.withMinusOneChk.isSelected();
        operator.numDec = this.opDec1.isSelected() ? 1 : (this.opDec2.isSelected() ? 2 : 0);
        operator.fromList = 0;
        if (this.fromListChk.isSelected()) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.listTxt.getText());
            String string = "";
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens() && operator.fromList < 20) {
                try {
                    operator.lst[operator.fromList] = Integer.parseInt(stringTokenizer.nextToken());
                    ++operator.fromList;
                }
                catch (NumberFormatException numberFormatException) {
                    if (bl) continue;
                    this.options.getMessages().showAlert((Component)this, "BAD_NUMBER");
                    bl = true;
                }
            }
        }
        return operator;
    }

    protected void checkEnabled() {
        boolean bl = this.fromListChk.isSelected();
        this.listTxt.setEnabled(bl);
        this.fromCombo.setEnabled(!bl);
        this.toCombo.setEnabled(!bl);
        this.withZeroChk.setEnabled(!bl);
        this.withOneChk.setEnabled(!bl);
        this.withMinusOneChk.setEnabled(!bl);
    }

    public boolean eventPerformed(EventObject eventObject) {
        this.checkEnabled();
        return eventObject != null;
    }

    static {
        for (int i = 0; i < Operator.LIMITS.length; ++i) {
            OperatorEditorPanel.LIST_OF_VALUES[i] = new Integer(Operator.LIMITS[i]);
        }
    }
}

