/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.util.FontCheck;
import edu.xtec.util.Options;
import edu.xtec.util.StreamIO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class TextStyleEditorPanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
ChangeListener {
    Options options;
    StyleContext sc;
    private static StyleContext emptySc;
    private ColorButton bgColorBtn;
    private JToggleButton boldBtn;
    private ColorButton errorBgColor;
    private ColorButton errorFgColor;
    private JComboBox fontFaceCombo;
    private JComboBox fontSizeCombo;
    private JToggleButton italicBtn;
    private JTextPane previewPanel;
    private JSlider tabSlider;
    private ColorButton targetBgColor;
    private ColorButton targetFgColor;
    private ColorButton textColorBtn;
    private JToggleButton underlineBtn;
    private static HashMap panels;

    public TextStyleEditorPanel(Options options, StyleContext styleContext) {
        this.options = options;
        this.initComponents();
        this.setStyleContext(styleContext);
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.fontFaceCombo = new JComboBox<String>(FontCheck.getFontList(false));
        this.fontSizeCombo = new JComboBox<String>(FontCheck.fontSizes);
        this.boldBtn = new JToggleButton();
        this.italicBtn = new JToggleButton();
        this.underlineBtn = new JToggleButton();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.textColorBtn = new ColorButton();
        this.textColorBtn.setOptions(this.options);
        JLabel jLabel4 = new JLabel();
        this.bgColorBtn = new ColorButton();
        this.bgColorBtn.setOptions(this.options);
        JLabel jLabel5 = new JLabel();
        this.tabSlider = new JSlider();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.targetFgColor = new ColorButton();
        this.targetFgColor.setOptions(this.options);
        JLabel jLabel8 = new JLabel();
        this.targetBgColor = new ColorButton();
        this.targetBgColor.setOptions(this.options);
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        this.errorFgColor = new ColorButton();
        this.errorFgColor.setOptions(this.options);
        JLabel jLabel11 = new JLabel();
        this.errorBgColor = new ColorButton();
        this.errorBgColor.setOptions(this.options);
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.previewPanel = new JTextPane();
        this.setLayout(new GridBagLayout());
        jLabel.setText(this.options.getMsg("edit_text_act_mainStyle"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, gridBagConstraints);
        this.fontFaceCombo.setEditable(true);
        this.fontFaceCombo.setPreferredSize(new Dimension(125, this.fontFaceCombo.getPreferredSize().height));
        this.fontFaceCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.fontFaceCombo, gridBagConstraints);
        this.fontSizeCombo.setEditable(true);
        this.fontSizeCombo.setPreferredSize(new Dimension(50, this.fontSizeCombo.getPreferredSize().height));
        this.fontSizeCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.add((Component)this.fontSizeCombo, gridBagConstraints);
        this.boldBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_bold.gif")));
        this.boldBtn.setToolTipText(this.options.getMsg("edit_font_bold"));
        this.boldBtn.setPreferredSize(new Dimension(27, 27));
        this.boldBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)this.boldBtn, gridBagConstraints);
        this.italicBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_italic.gif")));
        this.italicBtn.setToolTipText(this.options.getMsg("edit_font_italic"));
        this.italicBtn.setPreferredSize(new Dimension(27, 27));
        this.italicBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.italicBtn, gridBagConstraints);
        this.underlineBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_underline.gif")));
        this.underlineBtn.setToolTipText(this.options.getMsg("edit_font_italic"));
        this.underlineBtn.setPreferredSize(new Dimension(27, 27));
        this.underlineBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.add((Component)this.underlineBtn, gridBagConstraints);
        jLabel2.setText(this.options.getMsg("edit_text_act_colors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        jLabel3.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)jLabel3, gridBagConstraints);
        this.textColorBtn.setToolTipText(this.options.getMsg("edit_act_textColor_tooltip"));
        this.textColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.textColorBtn, gridBagConstraints);
        jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        jLabel4.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)jLabel4, gridBagConstraints);
        this.bgColorBtn.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.bgColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.add((Component)this.bgColorBtn, gridBagConstraints);
        jLabel5.setText(this.options.getMsg("edit_text_act_tabSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel5, gridBagConstraints);
        this.tabSlider.setMinorTickSpacing(5);
        this.tabSlider.setPaintLabels(true);
        this.tabSlider.setPaintTicks(true);
        this.tabSlider.setMajorTickSpacing(10);
        this.tabSlider.setMaximum(50);
        this.tabSlider.setValue(12);
        this.tabSlider.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.tabSlider, gridBagConstraints);
        jLabel6.setText(this.options.getMsg("edit_text_act_targetStyle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel6, gridBagConstraints);
        jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        jLabel7.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)jLabel7, gridBagConstraints);
        this.targetFgColor.setToolTipText(this.options.getMsg("edit_act_textColor_tooltip"));
        this.targetFgColor.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.targetFgColor, gridBagConstraints);
        jLabel8.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        jLabel8.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)jLabel8, gridBagConstraints);
        this.targetBgColor.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.targetBgColor.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.add((Component)this.targetBgColor, gridBagConstraints);
        jLabel9.setText(this.options.getMsg("edit_text_act_errorStyle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel9, gridBagConstraints);
        jLabel10.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        jLabel10.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)jLabel10, gridBagConstraints);
        this.errorFgColor.setToolTipText(this.options.getMsg("edit_act_textColor_tooltip"));
        this.errorFgColor.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.errorFgColor, gridBagConstraints);
        jLabel11.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        jLabel11.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)jLabel11, gridBagConstraints);
        this.errorBgColor.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.errorBgColor.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.add((Component)this.errorBgColor, gridBagConstraints);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(this.options.getMsg("edit_text_act_preview")));
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        this.previewPanel.setEditable(false);
        jScrollPane.setViewportView(this.previewPanel);
        jPanel.add((Component)jScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jPanel, gridBagConstraints);
    }

    private static StyleContext getEmptySc() {
        if (emptySc == null) {
            emptySc = new StyleContext();
            TextActivityDocument.checkStyleContext(emptySc);
        }
        return emptySc;
    }

    public void setStyleContext(StyleContext styleContext) {
        this.sc = styleContext == null ? TextStyleEditorPanel.getEmptySc() : styleContext;
        TextActivityDocument.checkStyleContext(this.sc);
        Style style = this.sc.getStyle("default");
        this.fontFaceCombo.setSelectedItem(StyleConstants.getFontFamily(style));
        this.fontSizeCombo.setSelectedItem(Integer.toString(StyleConstants.getFontSize(style)));
        this.boldBtn.setSelected(StyleConstants.isBold(style));
        this.italicBtn.setSelected(StyleConstants.isItalic(style));
        this.underlineBtn.setSelected(StyleConstants.isUnderline(style));
        this.bgColorBtn.setColor(StyleConstants.getBackground(style));
        this.textColorBtn.setColor(StyleConstants.getForeground(style));
        int n = 12;
        Object object = style.getAttribute("tabWidth");
        if (object != null) {
            try {
                n = Math.max(1, Math.min(Integer.parseInt(object.toString()), 50));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tabSlider.setValue(n);
        Style style2 = this.sc.getStyle("target");
        this.targetBgColor.setColor(StyleConstants.getBackground(style2));
        this.targetFgColor.setColor(StyleConstants.getForeground(style2));
        Style style3 = this.sc.getStyle("targetError");
        this.errorBgColor.setColor(StyleConstants.getBackground(style3));
        this.errorFgColor.setColor(StyleConstants.getForeground(style3));
        this.updatePreview(null);
    }

    public StyleContext getStyleContext(EventObject eventObject) {
        Color color;
        Color color2;
        Color color3;
        String string;
        Color color4;
        Color color5;
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string2;
        Object object = eventObject == null ? null : eventObject.getSource();
        Style style = this.sc.getStyle("default");
        if (!(object != null && object != this.fontFaceCombo || (string2 = (String)this.fontFaceCombo.getSelectedItem()) == null || string2.length() <= 0 || string2.equals(StyleConstants.getFontFamily(style)))) {
            StyleConstants.setFontFamily(style, string2);
        }
        if ((object == null || object == this.fontSizeCombo) && (string2 = (String)this.fontSizeCombo.getSelectedItem()) != null && string2.length() > 0) {
            try {
                int n = Integer.parseInt(string2);
                if (n != StyleConstants.getFontSize(style)) {
                    StyleConstants.setFontSize(style, n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object == null || object == this.boldBtn) && (bl3 = this.boldBtn.isSelected()) != StyleConstants.isBold(style)) {
            StyleConstants.setBold(style, bl3);
        }
        if ((object == null || object == this.italicBtn) && (bl2 = this.italicBtn.isSelected()) != StyleConstants.isItalic(style)) {
            StyleConstants.setItalic(style, bl2);
        }
        if ((object == null || object == this.underlineBtn) && (bl = this.underlineBtn.isSelected()) != StyleConstants.isUnderline(style)) {
            StyleConstants.setUnderline(style, bl);
        }
        if (!(object != null && object != this.bgColorBtn || (color5 = this.bgColorBtn.getColor()).equals(StyleConstants.getBackground(style)))) {
            StyleConstants.setBackground(style, color5);
        }
        if (!(object != null && object != this.textColorBtn || (color4 = this.textColorBtn.getColor()).equals(StyleConstants.getForeground(style)))) {
            StyleConstants.setForeground(style, color4);
        }
        if (!(object != null && object != this.tabSlider || (string = Integer.toString(Math.max(1, this.tabSlider.getValue()))).equals(style.getAttribute("tabWidth")))) {
            style.removeAttribute("tabWidth");
            style.addAttribute("tabWidth", string);
        }
        Style style2 = this.sc.getStyle("target");
        if (!(object != null && object != this.targetFgColor || (color3 = this.targetFgColor.getColor()).equals(StyleConstants.getForeground(style2)))) {
            StyleConstants.setForeground(style2, color3);
        }
        if (!(object != null && object != this.targetBgColor || (color2 = this.targetBgColor.getColor()).equals(StyleConstants.getBackground(style2)))) {
            StyleConstants.setBackground(style2, color2);
        }
        Style style3 = this.sc.getStyle("targetError");
        if (!(object != null && object != this.errorFgColor || (color = this.errorFgColor.getColor()).equals(StyleConstants.getForeground(style3)))) {
            StyleConstants.setForeground(style3, color);
        }
        if (!(object != null && object != this.errorBgColor || (color = this.errorBgColor.getColor()).equals(StyleConstants.getBackground(style3)))) {
            StyleConstants.setBackground(style3, color);
        }
        return this.sc;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updatePreview(actionEvent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updatePreview(propertyChangeEvent);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent != null && changeEvent.getSource() == this.tabSlider && !this.tabSlider.getValueIsAdjusting()) {
            this.updatePreview(changeEvent);
        }
    }

    private void updatePreview(EventObject eventObject) {
        if (eventObject != null) {
            this.getStyleContext(eventObject);
        }
        try {
            int n;
            Style style = this.sc.getStyle("default");
            DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument((StyleContext)StreamIO.cloneObject(this.sc));
            Object object = style.getAttribute("tabWidth");
            if (object != null) {
                int n2 = Math.max(1, Integer.parseInt(object.toString()));
                TextActivityDocument.setStyledDocumentTabSpc(n2, defaultStyledDocument, this.sc);
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < 5; ++n) {
                stringBuffer.append("T").append(n).append("\t");
            }
            defaultStyledDocument.insertString(0, stringBuffer.append("\n").toString(), style);
            for (n = 0; n < 2; ++n) {
                stringBuffer.setLength(0);
                stringBuffer.append(this.options.getMsg("edit_text_act_styleSample_default_start")).append(" ");
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), stringBuffer.toString(), style);
                stringBuffer.setLength(0);
                stringBuffer.append(this.options.getMsg("edit_text_act_styleSample_target"));
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), stringBuffer.toString(), this.sc.getStyle("target"));
                stringBuffer.setLength(0);
                stringBuffer.append(" ").append(this.options.getMsg("edit_text_act_styleSample_default_fill")).append(" ");
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), stringBuffer.toString(), style);
                stringBuffer.setLength(0);
                stringBuffer.append(this.options.getMsg("edit_text_act_styleSample_error"));
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), stringBuffer.toString(), this.sc.getStyle("targetError"));
                stringBuffer.setLength(0);
                stringBuffer.append(" ").append(this.options.getMsg("edit_text_act_styleSample_default_end")).append("\n");
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), stringBuffer.toString(), style);
            }
            this.previewPanel.setStyledDocument(defaultStyledDocument);
            this.previewPanel.setBackground(StyleConstants.getBackground(style));
        }
        catch (Exception exception) {
            System.err.println("Internal error:\n" + exception);
        }
    }

    public static StyleContext editStyleContext(Options options, StyleContext styleContext, Component component) {
        TextStyleEditorPanel textStyleEditorPanel;
        StyleContext styleContext2 = null;
        StyleContext styleContext3 = null;
        if (styleContext != null) {
            try {
                styleContext3 = (StyleContext)StreamIO.cloneObject(styleContext);
            }
            catch (Exception exception) {
                System.err.println("Internal error: cannot clone object: " + styleContext + "\n" + exception);
            }
        }
        if ((textStyleEditorPanel = (TextStyleEditorPanel)panels.get(options)) == null) {
            textStyleEditorPanel = new TextStyleEditorPanel(options, styleContext3);
            panels.put(options, textStyleEditorPanel);
        } else {
            textStyleEditorPanel.setStyleContext(styleContext3);
        }
        if (options.getMessages().showInputDlg(component, textStyleEditorPanel, "edit_style_title")) {
            styleContext2 = textStyleEditorPanel.getStyleContext(null);
        }
        return styleContext2;
    }

    static {
        panels = new HashMap(1);
    }
}

