/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.AuthorSettings;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.LFUtil;
import edu.xtec.util.Messages;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AuthorSettingsDlg
extends ExtendedJDialog {
    AuthorSettings settings;
    public boolean result;
    Component parent;
    Messages msg;
    private JTextField browserField;
    private JTextField codebaseTxt;
    private ColorButton colorButton;
    private JTextField countryField;
    private JLabel countryLb;
    private JTextField heightText;
    private JComboBox langCombo;
    private JComboBox lookCombo;
    private JRadioButton mDefaultBtn;
    private JRadioButton mJMFbtn;
    private JRadioButton mQTbtn;
    private JTextField variantField;
    private JLabel variantLb;
    private JTextField widthText;

    public AuthorSettingsDlg(AuthorSettings authorSettings, Component component) {
        super(component, "", true);
        this.parent = component;
        this.settings = authorSettings;
        this.msg = authorSettings.rb.getOptions().getMessages();
        this.setTitle(this.msg.get("settings_title"));
        this.result = false;
        this.initComponents();
        this.centerOver(component);
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.lookCombo = new JComboBox<String>(LFUtil.VALUES);
        JLabel jLabel2 = new JLabel();
        this.langCombo = new JComboBox<String>(Messages.getDescriptiveLanguageCodes(this.msg.getLocale()));
        this.countryLb = new JLabel();
        this.countryField = new JTextField();
        this.variantLb = new JLabel();
        this.variantField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.browserField = new JTextField();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.mDefaultBtn = new JRadioButton();
        this.mJMFbtn = new JRadioButton();
        this.mQTbtn = new JRadioButton();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.codebaseTxt = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.colorButton = new ColorButton();
        this.colorButton.setOptions(this.settings.rb.getOptions());
        JLabel jLabel6 = new JLabel();
        this.widthText = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.heightText = new JTextField();
        JPanel jPanel5 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AuthorSettingsDlg.this.closeDialog(windowEvent);
            }
        });
        jTabbedPane.setToolTipText(this.msg.get("settings_report_tooltip"));
        jTabbedPane.setPreferredSize(new Dimension(500, 400));
        jPanel.setLayout(new GridBagLayout());
        jPanel.setToolTipText(this.msg.get("settings_general_tooltip"));
        jLabel.setLabelFor(this.lookCombo);
        jLabel.setText(this.msg.get("settings_look"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.lookCombo.setSelectedItem(this.settings.lookAndFeel);
        this.lookCombo.setToolTipText(this.msg.get("settings_look_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.lookCombo, gridBagConstraints);
        jLabel2.setLabelFor(this.langCombo);
        jLabel2.setText(this.msg.get("settings_language"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.langCombo.setSelectedItem(Messages.getDescriptiveLanguageCode(this.settings.language));
        this.langCombo.setToolTipText(this.msg.get("settings_language_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.langCombo, gridBagConstraints);
        this.countryLb.setLabelFor(this.countryField);
        this.countryLb.setText(this.msg.get("settings_country"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.countryLb, gridBagConstraints);
        this.countryField.setText(this.settings.country);
        this.countryField.setToolTipText(this.msg.get("settings_country_tooltip"));
        this.countryField.setMinimumSize(new Dimension(75, 21));
        this.countryField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.countryField, gridBagConstraints);
        this.variantLb.setLabelFor(this.variantField);
        this.variantLb.setText(this.msg.get("settings_variant"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.variantLb, gridBagConstraints);
        this.variantField.setText(this.settings.variant);
        this.variantField.setToolTipText(this.msg.get("settings_variant_tooltip"));
        this.variantField.setMinimumSize(new Dimension(75, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.variantField, gridBagConstraints);
        jLabel3.setText(this.msg.get("settings_browser"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.browserField.setText(this.settings.preferredBrowser);
        this.browserField.setToolTipText(this.msg.get("settings_browser_tooltip"));
        this.browserField.setMinimumSize(new Dimension(75, 21));
        this.browserField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.browserField, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_general"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/settings.gif")), jPanel, "");
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setToolTipText(this.msg.get("settings_media_tooltip"));
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(this.msg.get("settings_media_system")));
        this.mDefaultBtn.setSelected("default".equals(this.settings.mediaSystem));
        this.mDefaultBtn.setText(this.msg.get("settings_media_default"));
        buttonGroup2.add(this.mDefaultBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        jPanel3.add((Component)this.mDefaultBtn, gridBagConstraints);
        this.mJMFbtn.setSelected("Java Media Framework".equals(this.settings.mediaSystem));
        this.mJMFbtn.setText(this.msg.get("settings_media_jmf"));
        buttonGroup2.add(this.mJMFbtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        jPanel3.add((Component)this.mJMFbtn, gridBagConstraints);
        this.mQTbtn.setSelected("QuickTime".equals(this.settings.mediaSystem));
        this.mQTbtn.setText(this.msg.get("settings_media_qt"));
        buttonGroup2.add(this.mQTbtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel3.add((Component)this.mQTbtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_media"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/audio_on.gif")), jPanel2, "");
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.setToolTipText(this.msg.get("settings_applet_tooltip"));
        jLabel4.setLabelFor(this.codebaseTxt);
        jLabel4.setText(this.msg.get("applet_codebase"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)jLabel4, gridBagConstraints);
        this.codebaseTxt.setToolTipText(this.msg.get("applet_codebase_tooltip"));
        this.codebaseTxt.setText(this.settings.appletCodeBase);
        this.codebaseTxt.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)this.codebaseTxt, gridBagConstraints);
        jLabel5.setLabelFor(this.colorButton);
        jLabel5.setText(this.msg.get("applet_bgcolor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)jLabel5, gridBagConstraints);
        this.colorButton.setToolTipText(this.msg.get("applet_bgcolor_tooltip"));
        this.colorButton.setColor(this.settings.appletBgColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)this.colorButton, gridBagConstraints);
        jLabel6.setLabelFor(this.widthText);
        jLabel6.setText(this.msg.get("WIDTH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)jLabel6, gridBagConstraints);
        this.widthText.setToolTipText(this.msg.get("applet_width_tooltip"));
        this.widthText.setText(this.settings.appletWidth);
        this.widthText.setHorizontalAlignment(4);
        this.widthText.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)this.widthText, gridBagConstraints);
        jLabel7.setLabelFor(this.heightText);
        jLabel7.setText(this.msg.get("HEIGHT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)jLabel7, gridBagConstraints);
        this.heightText.setToolTipText(this.msg.get("applet_height_tooltip"));
        this.heightText.setText(this.settings.appletHeight);
        this.heightText.setHorizontalAlignment(4);
        this.heightText.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel4.add((Component)this.heightText, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_applet"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/html_doc.gif")), jPanel4);
        this.getContentPane().add((Component)jTabbedPane, "Center");
        jButton.setText(this.msg.get("OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AuthorSettingsDlg.this.okButtonActionPerformed(actionEvent);
            }
        });
        jPanel5.add(jButton);
        jButton2.setText(this.msg.get("CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AuthorSettingsDlg.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        jPanel5.add(jButton2);
        this.getContentPane().add((Component)jPanel5, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.result = false;
        this.closeDialog(null);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.accept()) {
            this.result = true;
            this.closeDialog(null);
        }
    }

    public boolean accept() {
        Object var1_1 = null;
        this.settings.lookAndFeel = (String)this.lookCombo.getSelectedItem();
        this.settings.preferredBrowser = this.browserField.getText();
        this.settings.language = Messages.getLanguageFromDescriptive((String)this.langCombo.getSelectedItem());
        this.settings.country = StrUtils.nullableString(this.countryField.getText());
        this.settings.variant = StrUtils.nullableString(this.variantField.getText());
        this.settings.mediaSystem = this.mJMFbtn.isSelected() ? "Java Media Framework" : (this.mQTbtn.isSelected() ? "QuickTime" : "default");
        this.settings.appletCodeBase = StrUtils.secureString(this.codebaseTxt.getText(), "http://clic.xtec.cat/dist/jclic");
        this.settings.appletWidth = StrUtils.secureString(this.widthText.getText(), "700");
        this.settings.appletHeight = StrUtils.secureString(this.heightText.getText(), "450");
        this.settings.appletBgColor = this.colorButton.getColor();
        return true;
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

