/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.AuthorSettingsDlg;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceBridge;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;

public class AuthorSettings
implements Constants {
    public ResourceBridge rb;
    public String language;
    public String country;
    public String variant;
    public String lookAndFeel;
    public String preferredBrowser;
    public String rootPath;
    public String mediaSystem;
    public FileSystem fileSystem;
    public String appletCodeBase;
    public String appletWidth;
    public String appletHeight;
    public Color appletBgColor;
    public HashMap misc;
    public static final int MAX_RECENT = 8;
    public String[] recentFiles;
    public String cfgFile;
    public boolean readOnly;
    protected static String defaultCfgFile = null;
    public static final String PROJECTS_PATH = "projects";
    public static final String CFG_FILE = "jclic_author.cfg";
    public static final String DEFAULT_APPLET_CODEBASE = "http://clic.xtec.cat/dist/jclic";
    public static final String DEFAULT_APPLET_WIDTH = "700";
    public static final String DEFAULT_APPLET_HEIGHT = "450";
    public static final Color DEFAULT_APPLET_BGCOLOR = Color.white;
    public static final String ELEMENT_NAME = "JClicAuthorSettings";
    public static final String APPLET = "applet";
    public static final String CODEBASE = "codebase";
    public static final String BGCOLOR = "bgcolor";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String SOUND = "sound";
    public static final String SYSTEM = "system";
    public static final String MISC = "misc";
    public static final String PATHS = "paths";
    public static final String PATH = "path";
    public static final String ROOT = "root";
    public static final String RECENT_FILES = "recentFiles";
    public static final String FILE = "file";

    public AuthorSettings(ResourceBridge resourceBridge, String string) {
        File file;
        this.rb = resourceBridge;
        this.misc = new HashMap();
        this.lookAndFeel = SYSTEM;
        this.preferredBrowser = "";
        this.recentFiles = new String[8];
        this.mediaSystem = "default";
        this.readOnly = false;
        this.rootPath = System.getProperty("user.home");
        this.cfgFile = string == null ? AuthorSettings.getDefaultCfgFile(resourceBridge.getOptions()) : string;
        this.fileSystem = new FileSystem(resourceBridge);
        this.readOnly = FileSystem.isStrUrl(this.cfgFile) ? true : !(file = new File(this.cfgFile)).canWrite();
        this.appletCodeBase = DEFAULT_APPLET_CODEBASE;
        this.appletWidth = DEFAULT_APPLET_WIDTH;
        this.appletHeight = DEFAULT_APPLET_HEIGHT;
        this.appletBgColor = DEFAULT_APPLET_BGCOLOR;
    }

    public static String getDefaultCfgFile(Options options) {
        if (defaultCfgFile == null) {
            defaultCfgFile = PersistentSettings.getFilePath("JClic", CFG_FILE, options);
        }
        return defaultCfgFile;
    }

    public static AuthorSettings loadAuthorSettings(ResourceBridge resourceBridge) {
        AuthorSettings authorSettings = null;
        String string = resourceBridge.getOptions().getString(ELEMENT_NAME);
        if (string != null) {
            try {
                authorSettings = new AuthorSettings(resourceBridge, string);
                authorSettings.loadSettings(authorSettings.fileSystem.getXMLDocument(string).getRootElement());
            }
            catch (Exception exception) {
                authorSettings = null;
                System.err.println("Unable to read settings from " + string + "\n" + exception);
            }
        }
        if (authorSettings == null) {
            string = AuthorSettings.getDefaultCfgFile(resourceBridge.getOptions());
            authorSettings = new AuthorSettings(resourceBridge, string);
            try {
                authorSettings.loadSettings(authorSettings.fileSystem.getXMLDocument(string).getRootElement());
            }
            catch (Exception exception) {
                authorSettings.initNewSettings();
            }
        }
        Options options = resourceBridge.getOptions();
        options.syncProperties(authorSettings.getProperties(), true);
        if (!options.getBoolean("languageByParam") && authorSettings.language != null) {
            options.put("language", authorSettings.language);
            if (authorSettings.country != null) {
                options.put("country", authorSettings.country);
            }
            if (authorSettings.variant != null) {
                options.put("variant", authorSettings.variant);
            }
        }
        return authorSettings;
    }

    private void initNewSettings() {
        try {
            Messages messages = this.rb.getOptions().getMessages();
            if (this.language == null) {
                this.language = messages.getLocale().getLanguage();
                this.country = messages.getLocale().getCountry();
                this.variant = messages.getLocale().getVariant();
            }
            this.readOnly = false;
            File file = new File(new File(this.cfgFile).getParentFile(), PROJECTS_PATH);
            file.mkdirs();
            this.rootPath = file.getAbsolutePath();
            this.fileSystem = new FileSystem(this.rootPath, this.rb);
        }
        catch (Exception exception) {
            System.err.println("Unable to create new settings!\n" + exception);
        }
    }

    public void save() {
        if (!this.readOnly) {
            try {
                FileOutputStream fileOutputStream = this.fileSystem.createSecureFileOutputStream(this.cfgFile);
                JDomUtility.saveDocument((OutputStream)fileOutputStream, this.getJDomElement());
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println("unable to save settings " + this.cfgFile);
                exception.printStackTrace();
            }
        }
    }

    public Element getJDomElement() {
        Element element;
        Element element2 = new Element(ELEMENT_NAME);
        if (this.language != null) {
            element = new Element("language");
            element.setAttribute("id", this.language);
            if (this.country != null) {
                element.setAttribute("country", this.country);
            }
            if (this.variant != null) {
                element.setAttribute("variant", this.variant);
            }
            element2.addContent(element);
        }
        element = new Element(PATHS);
        Element element3 = new Element(PATH);
        element3.setAttribute("id", ROOT);
        element3.setAttribute(PATH, this.rootPath);
        element.addContent(element3);
        element2.addContent(element);
        element = new Element(APPLET);
        element.setAttribute(CODEBASE, this.appletCodeBase);
        element.setAttribute(WIDTH, this.appletWidth);
        element.setAttribute(HEIGHT, this.appletHeight);
        element.setAttribute(BGCOLOR, JDomUtility.colorToString(this.appletBgColor));
        element2.addContent(element);
        element = new Element(SOUND);
        element.setAttribute("mediaSystem", this.mediaSystem);
        element2.addContent(element);
        element = new Element("lookAndFeel");
        element.setAttribute("id", this.lookAndFeel);
        element2.addContent(element);
        element = new Element("browser");
        element.setAttribute("id", this.preferredBrowser);
        element2.addContent(element);
        if (!this.misc.isEmpty()) {
            element = new Element(MISC);
            Iterator iterator = this.misc.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (string == null || v == null || !(v instanceof String)) continue;
                element.setAttribute(string, (String)v);
            }
            element2.addContent(element);
        }
        element = new Element(RECENT_FILES);
        for (int i = 0; i < 8; ++i) {
            if (this.recentFiles[i] == null) continue;
            element3 = new Element(FILE);
            element3.setAttribute(PATH, this.recentFiles[i]);
            element.addContent(element3);
        }
        element2.addContent(element);
        return element2;
    }

    protected void loadSettings(Element element) throws Exception {
        Object object;
        Iterator iterator;
        JDomUtility.checkName(element, ELEMENT_NAME);
        Element element2 = element.getChild(PATHS);
        if (element2 != null) {
            iterator = null;
            object = element2.getChildren(PATH).iterator();
            while (object.hasNext()) {
                Element element3 = (Element)object.next();
                if (!ROOT.equals(element3.getAttributeValue("id"))) continue;
                iterator = JDomUtility.getStringAttr(element3, PATH, this.rootPath, false);
            }
            if (iterator != null) {
                this.rootPath = iterator;
                if (!FileSystem.isStrUrl(this.rootPath)) {
                    this.fileSystem = new FileSystem(this.rootPath, this.rb);
                }
            }
        }
        if ((element2 = element.getChild(APPLET)) != null) {
            this.appletCodeBase = JDomUtility.getStringAttr(element2, CODEBASE, DEFAULT_APPLET_CODEBASE, false);
            this.appletWidth = JDomUtility.getStringAttr(element2, WIDTH, DEFAULT_APPLET_WIDTH, false);
            this.appletHeight = JDomUtility.getStringAttr(element2, HEIGHT, DEFAULT_APPLET_HEIGHT, false);
            this.appletBgColor = JDomUtility.getColorAttr(element2, BGCOLOR, DEFAULT_APPLET_BGCOLOR);
        }
        if ((element2 = element.getChild("language")) != null) {
            this.language = JDomUtility.getStringAttr(element2, "id", this.language, false);
            this.country = JDomUtility.getStringAttr(element2, "country", this.country, false);
            this.variant = JDomUtility.getStringAttr(element2, "variant", this.variant, false);
        }
        if ((element2 = element.getChild(SOUND)) != null) {
            this.mediaSystem = JDomUtility.getStringAttr(element2, "mediaSystem", this.mediaSystem, false);
        }
        if ((element2 = element.getChild("lookAndFeel")) != null) {
            this.lookAndFeel = JDomUtility.getStringAttr(element2, "id", this.lookAndFeel, false);
        }
        if ((element2 = element.getChild("browser")) != null) {
            this.preferredBrowser = JDomUtility.getStringAttr(element2, "id", this.preferredBrowser, false);
            BrowserLauncher.setPreferredBrowser(this.preferredBrowser);
        }
        if ((element2 = element.getChild(MISC)) != null) {
            iterator = element2.getAttributes().iterator();
            while (iterator.hasNext()) {
                object = (Attribute)iterator.next();
                this.misc.put(((Attribute)object).getName(), ((Attribute)object).getValue());
            }
        }
        if ((element2 = element.getChild(RECENT_FILES)) != null) {
            iterator = element2.getChildren(FILE).iterator();
            for (int i = 0; i < 8; ++i) {
                this.recentFiles[i] = iterator.hasNext() ? JDomUtility.getStringAttr((Element)iterator.next(), PATH, null, false) : null;
            }
        }
    }

    public HashMap getProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "true";
        String string2 = "false";
        if (this.language != null) {
            hashMap.put("language", this.language);
            hashMap.put("country", this.country);
            hashMap.put("variant", this.variant);
        }
        hashMap.put("lookAndFeel", this.lookAndFeel);
        hashMap.put("mediaSystem", this.mediaSystem);
        hashMap.putAll(this.misc);
        return hashMap;
    }

    public boolean edit(Component component) {
        AuthorSettingsDlg authorSettingsDlg = new AuthorSettingsDlg(this, component);
        authorSettingsDlg.setVisible(true);
        if (authorSettingsDlg.result) {
            BrowserLauncher.setPreferredBrowser(this.preferredBrowser);
        }
        return authorSettingsDlg.result;
    }

    public void addRecentFile(String string) {
        String[] stringArray = this.recentFiles;
        this.recentFiles = new String[8];
        this.recentFiles[0] = string;
        int n = 1;
        for (int i = 0; i < 8 && n < 8; ++i) {
            if (stringArray[i] == null || stringArray[i].equals(string)) continue;
            this.recentFiles[n++] = stringArray[i];
        }
    }
}

