/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.AuthorSettings;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AppletHtmlCreator
extends JPanel
implements ActionListener {
    Options options;
    AuthorSettings settings;
    private ButtonGroup bg;
    private JCheckBox centeredChk;
    private ColorButton colorButton;
    private JTextField exitUrlTxt;
    private JRadioButton fullPageOption;
    private JTextField heightText;
    private JRadioButton mixedContentOption;
    private JTextArea postTextEdit;
    private JTextArea prevTextEdit;
    private JPanel sizePanel;
    private JTextField titleTxt;
    private JTextField widthText;
    private static AppletHtmlCreator panel;

    public AppletHtmlCreator(Options options, AuthorSettings authorSettings) {
        this.options = options;
        this.settings = authorSettings;
        this.initComponents();
        this.fullPageOption.addActionListener(this);
        this.mixedContentOption.addActionListener(this);
        this.checkEnabled();
    }

    private void initComponents() {
        this.bg = new ButtonGroup();
        JLabel jLabel = new JLabel();
        this.titleTxt = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.exitUrlTxt = new JTextField();
        this.fullPageOption = new JRadioButton();
        this.mixedContentOption = new JRadioButton();
        this.sizePanel = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.colorButton = new ColorButton();
        this.colorButton.setOptions(this.options);
        JLabel jLabel4 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.prevTextEdit = new JTextArea();
        JLabel jLabel5 = new JLabel();
        this.widthText = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.heightText = new JTextField();
        this.centeredChk = new JCheckBox();
        JLabel jLabel7 = new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.postTextEdit = new JTextArea();
        this.setLayout(new GridBagLayout());
        jLabel.setLabelFor(this.titleTxt);
        jLabel.setText(this.options.getMsg("applet_page_title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, gridBagConstraints);
        this.titleTxt.setToolTipText(this.options.getMsg("applet_page_title_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.titleTxt, gridBagConstraints);
        jLabel2.setLabelFor(this.exitUrlTxt);
        jLabel2.setText(this.options.getMsg("applet_exitUrl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel2, gridBagConstraints);
        this.exitUrlTxt.setToolTipText(this.options.getMsg("applet_exitUrl_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.exitUrlTxt, gridBagConstraints);
        this.fullPageOption.setSelected(true);
        this.fullPageOption.setText(this.options.getMsg("applet_page_full"));
        this.bg.add(this.fullPageOption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.fullPageOption, gridBagConstraints);
        this.mixedContentOption.setText(this.options.getMsg("applet_page_mixed"));
        this.bg.add(this.mixedContentOption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.mixedContentOption, gridBagConstraints);
        this.sizePanel.setLayout(new GridBagLayout());
        this.sizePanel.setBorder(new TitledBorder(this.options.getMsg("applet_size")));
        this.sizePanel.setToolTipText(this.options.getMsg("applet_size_tooltip"));
        jLabel3.setLabelFor(this.colorButton);
        jLabel3.setText(this.options.getMsg("applet_bgcolor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)jLabel3, gridBagConstraints);
        this.colorButton.setToolTipText(this.options.getMsg("applet_bgcolor_tooltip"));
        this.colorButton.setColor(this.settings.appletBgColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)this.colorButton, gridBagConstraints);
        jLabel4.setLabelFor(this.prevTextEdit);
        jLabel4.setText(this.options.getMsg("applet_prev_text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)jLabel4, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(200, 60));
        jScrollPane.setMinimumSize(new Dimension(200, 60));
        this.prevTextEdit.setWrapStyleWord(true);
        this.prevTextEdit.setToolTipText(this.options.getMsg("applet_prev_text_tooltip"));
        this.prevTextEdit.setLineWrap(true);
        jScrollPane.setViewportView(this.prevTextEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)jScrollPane, gridBagConstraints);
        jLabel5.setLabelFor(this.widthText);
        jLabel5.setText(this.options.getMsg("WIDTH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)jLabel5, gridBagConstraints);
        this.widthText.setToolTipText(this.options.getMsg("applet_width_tooltip"));
        this.widthText.setText(this.settings.appletWidth);
        this.widthText.setHorizontalAlignment(4);
        this.widthText.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)this.widthText, gridBagConstraints);
        jLabel6.setLabelFor(this.heightText);
        jLabel6.setText(this.options.getMsg("HEIGHT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)jLabel6, gridBagConstraints);
        this.heightText.setToolTipText(this.options.getMsg("applet_height_tooltip"));
        this.heightText.setText(this.settings.appletHeight);
        this.heightText.setHorizontalAlignment(4);
        this.heightText.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)this.heightText, gridBagConstraints);
        this.centeredChk.setToolTipText(this.options.getMsg("applet_centered_tooltip"));
        this.centeredChk.setSelected(true);
        this.centeredChk.setText(this.options.getMsg("applet_centered"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)this.centeredChk, gridBagConstraints);
        jLabel7.setLabelFor(this.postTextEdit);
        jLabel7.setText(this.options.getMsg("applet_post_text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)jLabel7, gridBagConstraints);
        jScrollPane2.setPreferredSize(new Dimension(200, 60));
        jScrollPane2.setMinimumSize(new Dimension(200, 60));
        this.postTextEdit.setWrapStyleWord(true);
        this.postTextEdit.setToolTipText(this.options.getMsg("applet_post_text_tooltip"));
        this.postTextEdit.setLineWrap(true);
        jScrollPane2.setViewportView(this.postTextEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 2, 2, 2);
        this.add((Component)this.sizePanel, gridBagConstraints);
    }

    public void setValues(JClicProject jClicProject) {
        this.titleTxt.setText(jClicProject.settings.title);
    }

    public static void createHtml(JClicProject jClicProject, AuthorSettings authorSettings, Component component) {
        Options options = jClicProject.getBridge().getOptions();
        Messages messages = options.getMessages();
        if (panel == null) {
            panel = new AppletHtmlCreator(options, authorSettings);
        }
        jClicProject.getFileSystem();
        String string = FileSystem.getFileNameOf(jClicProject.getFullPath());
        panel.setValues(jClicProject);
        if (messages.showInputDlg(component, panel, "applet_create_title")) {
            String string2;
            boolean bl = AppletHtmlCreator.panel.fullPageOption.isSelected();
            String string3 = AppletHtmlCreator.panel.titleTxt.getText();
            String string4 = AppletHtmlCreator.panel.widthText.getText();
            String string5 = AppletHtmlCreator.panel.heightText.getText();
            String string6 = AppletHtmlCreator.panel.prevTextEdit.getText();
            String string7 = AppletHtmlCreator.panel.postTextEdit.getText();
            Color color = AppletHtmlCreator.panel.colorButton.getColor();
            boolean bl2 = AppletHtmlCreator.panel.centeredChk.isSelected();
            StringBuffer stringBuffer = new StringBuffer();
            String string8 = StrUtils.nullableString(AppletHtmlCreator.panel.exitUrlTxt.getText());
            if (string8 != null) {
                stringBuffer.append("\r\nsetExitUrl('").append(string8).append("');");
            }
            int[] nArray = new int[]{21};
            FileSystem fileSystem = jClicProject.getFileSystem();
            String string9 = fileSystem.chooseFile(string2 = "index.htm", true, nArray, options, null, component, false);
            if (string9 != null) {
                try {
                    File file = new File(jClicProject.getFileSystem().getFullFileNamePath(string9));
                    FileOutputStream fileOutputStream = jClicProject.getFileSystem().createSecureFileOutputStream(string9);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                    PrintWriter printWriter = new PrintWriter(outputStreamWriter);
                    String string10 = ResourceManager.getResourceText("html/applet.html", true);
                    string10 = StrUtils.replace(string10, "%ENCODING", "UTF-8");
                    string10 = StrUtils.replace(string10, "%JAR_BASE", authorSettings.appletCodeBase);
                    string10 = StrUtils.replace(string10, "%TITLE", string3);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (bl) {
                        stringBuffer2.append("leftmargin=\"0\" topmargin=\"0\" marginwidth=\"0\" marginheight=\"0\" onLoad=\"window.focus();\"");
                    } else {
                        stringBuffer2.append("bgcolor=#");
                        stringBuffer2.append(Integer.toHexString(color.getRed()));
                        stringBuffer2.append(Integer.toHexString(color.getGreen()));
                        stringBuffer2.append(Integer.toHexString(color.getBlue()));
                    }
                    string10 = StrUtils.replace(string10, "%BODYPARAMS", stringBuffer2.substring(0));
                    stringBuffer2.setLength(0);
                    if (!bl) {
                        if (bl2) {
                            stringBuffer2.append("<div align=\"center\">");
                        }
                        if (string6.length() > 0) {
                            stringBuffer2.append(string6).append("<br>");
                        }
                    }
                    string10 = StrUtils.replace(string10, "%PRE_APPLET", stringBuffer2.substring(0));
                    string10 = StrUtils.replace(string10, "%OTHER", stringBuffer.substring(0));
                    string10 = StrUtils.replace(string10, "%WIDTH", bl ? "100%" : string4);
                    string10 = StrUtils.replace(string10, "%HEIGHT", bl ? "100%" : string5);
                    string10 = StrUtils.replace(string10, "%PROJECT", string);
                    stringBuffer2.setLength(0);
                    if (!bl) {
                        if (string7.length() > 0) {
                            stringBuffer2.append("<br>").append(string7);
                        }
                        if (bl2) {
                            stringBuffer2.append("</div>");
                        }
                    }
                    string10 = StrUtils.replace(string10, "%POST_APPLET", string7);
                    printWriter.print(string10);
                    printWriter.flush();
                    printWriter.close();
                    String string11 = StrUtils.replace(messages.get("applet_created_info"), "%s", string9);
                    if (messages.showQuestionDlgObj(component, string11 + "\n" + messages.get("applet_created_prompt"), null, "yn") == 1) {
                        BrowserLauncher.openURL(jClicProject.getFileSystem().getUrl(string9));
                    }
                }
                catch (Exception exception) {
                    options.getMessages().showErrorWarning(component, "ERROR", exception);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.checkEnabled();
    }

    public void checkEnabled() {
        boolean bl = this.mixedContentOption.isSelected();
        this.colorButton.setEnabled(bl);
        this.widthText.setEnabled(bl);
        this.heightText.setEnabled(bl);
        this.centeredChk.setEnabled(bl);
        this.prevTextEdit.setEnabled(bl);
        this.postTextEdit.setEnabled(bl);
    }
}

