/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.ReportUtils;
import edu.xtec.jclic.report.rp.Basic;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateManager {
    public static final String FROM = "from";
    public static final String TO = "to";
    protected Date dFrom;
    protected Date dTo;
    protected Date firstDate;
    protected Date today;
    private GregorianCalendar calendar;
    protected Basic rp;

    public DateManager(Basic basic) {
        this.rp = basic;
    }

    public boolean init() throws Exception {
        this.firstDate = Basic.bridge.getMinSessionDate();
        this.today = new Date();
        if (this.firstDate == null || this.firstDate.compareTo(this.today) > 0) {
            this.firstDate = this.today;
        }
        this.dFrom = this.rp.getDateParam(FROM, this.firstDate, false);
        this.dTo = this.rp.getDateParam(TO, this.today, true);
        if (this.dFrom.compareTo(this.dTo) > 0) {
            this.dFrom = this.dTo;
        }
        System.out.println("From: " + this.dFrom + " To: " + this.dTo);
        return true;
    }

    public GregorianCalendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar();
        }
        return this.calendar;
    }

    public void writeHiddenFields(StringBuffer stringBuffer) throws Exception {
        stringBuffer.append("<input type=\"hidden\" name=\"").append(FROM).append("\" value=\"").append(ReportUtils.dateToStr(this.dFrom)).append("\">\n");
        stringBuffer.append("<input type=\"hidden\" name=\"").append(TO).append("\" value=\"").append(ReportUtils.dateToStr(this.dTo)).append("\">\n");
    }

    public void writeDateScript(StringBuffer stringBuffer) {
        stringBuffer.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        stringBuffer.append("<!--\n");
        stringBuffer.append(" function updateDateFrom(){\n");
        stringBuffer.append("     mainForm.from.value=\n");
        stringBuffer.append("       \"\"+mainForm.yearFrom.options[mainForm.yearFrom.selectedIndex].value+\n");
        stringBuffer.append("       \"-\"+mainForm.monthFrom.options[mainForm.monthFrom.selectedIndex].value+\n");
        stringBuffer.append("       \"-\"+mainForm.dayFrom.options[mainForm.dayFrom.selectedIndex].value;\n");
        stringBuffer.append(" };\n");
        stringBuffer.append(" function updateDateTo(){\n");
        stringBuffer.append("     mainForm.to.value=\n");
        stringBuffer.append("       \"\"+mainForm.yearTo.options[mainForm.yearTo.selectedIndex].value+\n");
        stringBuffer.append("       \"-\"+mainForm.monthTo.options[mainForm.monthTo.selectedIndex].value+\n");
        stringBuffer.append("       \"-\"+mainForm.dayTo.options[mainForm.dayTo.selectedIndex].value;\n");
        stringBuffer.append(" };\n");
        stringBuffer.append("//-->\n");
        stringBuffer.append("</script>\n");
    }

    protected void zonaData(StringBuffer stringBuffer, String string) {
        this.liniaData(stringBuffer, true);
        this.liniaData(stringBuffer, false);
        if (string != null) {
            stringBuffer.append("<p>").append(string).append("</p>");
        }
    }

    protected void liniaData(StringBuffer stringBuffer, boolean bl) {
        int n;
        DateManager dateManager = this;
        String[] stringArray = dateManager.rp.getFormattedNumbers();
        String string = bl ? "report_from" : "report_to";
        String string2 = bl ? "From" : "To";
        String string3 = "mainForm" + "." + string2;
        String string4 = "\" onChange=updateDate" + string2 + "()";
        GregorianCalendar gregorianCalendar = this.getCalendar();
        gregorianCalendar.setTime(this.firstDate);
        int n2 = gregorianCalendar.get(1);
        gregorianCalendar.setTime(this.today);
        int n3 = gregorianCalendar.get(1);
        gregorianCalendar.setTime(bl ? this.dFrom : this.dTo);
        stringBuffer.append("<p><strong>").append(Basic.toNbsp(this.rp.getMsg(string))).append("</strong> ");
        stringBuffer.append("<select name=\"day").append(string2).append("\"  onChange=\"updateDate").append(string2).append("()\">\n");
        int n4 = gregorianCalendar.get(5);
        for (n = 1; n <= 31; ++n) {
            stringBuffer.append("<option");
            if (n == n4) {
                stringBuffer.append(" selected");
            }
            stringBuffer.append(" value=\"").append(stringArray[n]).append("\">").append(stringArray[n]).append("</option>\n");
        }
        stringBuffer.append("</select> <select name=\"month").append(string2).append("\"  onChange=\"updateDate").append(string2).append("()\">\n");
        n4 = gregorianCalendar.get(2);
        for (n = 0; n < 12; ++n) {
            stringBuffer.append("<option");
            if (n == n4) {
                stringBuffer.append(" selected");
            }
            stringBuffer.append(" value=\"").append(stringArray[n + 1]).append("\">").append(Basic.filter(this.rp.months[n])).append("</option>\n");
        }
        stringBuffer.append("</select> <select name=\"year").append(string2).append("\"  onChange=\"updateDate").append(string2).append("()\">\n");
        n4 = gregorianCalendar.get(1);
        for (n = n2; n <= n3; ++n) {
            stringBuffer.append("<option");
            if (n == n4) {
                stringBuffer.append(" selected");
            }
            stringBuffer.append(" value=\"").append(n).append("\">").append(n).append("</option>\n");
        }
        stringBuffer.append("</select></p>\n");
    }
}

