/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class SessionData
implements Serializable {
    public String id;
    public Date date;
    public String project;
    public int numActs;
    public int actsSolved;
    public int totalPrec;
    public int totalTime;
    public int sessionCount;
    public HashSet users;
    public Vector actData;

    public SessionData(String string, String string2, String string3, Date date, int n, int n2, int n3, int n4) {
        this.id = string != null ? string.trim() : null;
        this.users = new HashSet(1);
        this.users.add(string2 != null ? string2.trim() : null);
        this.project = string3 != null ? string3.trim() : null;
        this.date = date;
        this.numActs = n;
        this.actsSolved = n2;
        this.totalPrec = n3;
        this.totalTime = Math.max(0, n4);
        this.sessionCount = 1;
    }

    public void acumula(SessionData sessionData) {
        this.actsSolved += sessionData.actsSolved;
        this.totalPrec += sessionData.totalPrec;
        this.numActs += sessionData.numActs;
        this.totalTime += sessionData.totalTime;
        this.users.addAll(sessionData.users);
        if (this.project != null && !this.project.equals(sessionData.project)) {
            this.project = "";
        }
        this.id = "";
        this.sessionCount += sessionData.sessionCount;
        if (this.actData == null) {
            this.actData = sessionData.actData;
        } else if (sessionData.actData != null) {
            this.actData.addAll(sessionData.actData);
        }
    }

    public boolean sameDate(SessionData sessionData) {
        return this.date != null && sessionData != null && this.date.equals(sessionData.date);
    }

    public int percentSolved() {
        return this.numActs > 0 ? 100 * this.actsSolved / this.numActs : 0;
    }

    public int percentPrec() {
        return this.numActs > 0 ? this.totalPrec / this.numActs : 0;
    }

    public String getUsr() {
        String string = "";
        if (this.users.size() > 1) {
            string = "*";
        } else {
            Iterator iterator = this.users.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
            }
        }
        return string;
    }
}

