/*
 * Decompiled with CFR 0.152.
 */
import edu.xtec.jclic.ReportServerConstants;
import edu.xtec.util.LFUtil;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ReportServerSettingsDlg
extends JDialog
implements ReportServerConstants {
    Options options;
    Messages msg;
    public boolean result;
    private JTextField browserField;
    private JCheckBox createChk;
    private JPanel dbPanel;
    private JTextField driverField;
    private JLabel driverLb;
    private JComboBox langCombo;
    private JLabel langLb;
    private JButton logFileWebBtn;
    private JComboBox lookCombo;
    private JTextField prefixFld;
    private JLabel prefixLb;
    private JPasswordField pwdField;
    private JLabel pwdLb;
    private JTextField sessionLifetimeField;
    private JLabel sessionLifetimeLb;
    private JCheckBox tooltipChk;
    private JTextField urlField;
    private JLabel urlLb;
    private JTextField usrField;
    private JLabel usrLb;
    private JCheckBox webAutostartChk;
    private JTextField webLogField;
    private JLabel webLogLb;
    private JPanel webPanel;
    private JTextField webPortField;
    private JLabel webPortLb;
    private JTextField webTimeoutField;
    private JLabel webTimeoutLb;

    public ReportServerSettingsDlg(Frame frame, boolean bl, Options options) {
        super(frame, bl);
        this.options = options;
        this.msg = options.getMessages();
        this.initComponents();
        this.result = false;
        Point point = frame.getLocationOnScreen();
        this.setLocation(point.x + 80, point.y + 30);
    }

    private void initComponents() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        this.langLb = new JLabel();
        this.langCombo = new JComboBox<String>(Messages.getDescriptiveLanguageCodes(this.msg.getLocale()));
        JLabel jLabel = new JLabel();
        this.lookCombo = new JComboBox<String>(LFUtil.VALUES);
        this.tooltipChk = new JCheckBox();
        JLabel jLabel2 = new JLabel();
        this.browserField = new JTextField();
        this.dbPanel = new JPanel();
        this.driverLb = new JLabel();
        this.driverField = new JTextField();
        this.urlLb = new JLabel();
        this.urlField = new JTextField();
        this.usrLb = new JLabel();
        this.usrField = new JTextField();
        this.pwdLb = new JLabel();
        this.pwdField = new JPasswordField(this.options.getString("dbPassword", ""), 20);
        this.prefixLb = new JLabel();
        this.prefixFld = new JTextField();
        this.createChk = new JCheckBox();
        this.webPanel = new JPanel();
        this.webAutostartChk = new JCheckBox();
        this.webPortLb = new JLabel();
        this.webPortField = new JTextField();
        this.webTimeoutLb = new JLabel();
        this.webTimeoutField = new JTextField();
        this.sessionLifetimeLb = new JLabel();
        this.sessionLifetimeField = new JTextField();
        this.webLogLb = new JLabel();
        this.webLogField = new JTextField();
        this.logFileWebBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.setTitle(this.msg.get("settings_title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ReportServerSettingsDlg.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new GridBagLayout());
        this.langLb.setText(this.msg.get("settings_options_language"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.langLb, gridBagConstraints);
        this.langCombo.setSelectedItem(Messages.getDescriptiveLanguageCode(this.msg.getLocale().getLanguage()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.langCombo, gridBagConstraints);
        jLabel.setText(this.msg.get("settings_options_look"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.lookCombo.setSelectedItem(this.options.getString("lookAndFeel", "default"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.lookCombo, gridBagConstraints);
        this.tooltipChk.setSelected(this.options.getBoolean("tooltips", true));
        this.tooltipChk.setText(this.msg.get("settings_options_tooltips"));
        this.tooltipChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServerSettingsDlg.this.tooltipChkActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.tooltipChk, gridBagConstraints);
        jLabel2.setLabelFor(this.browserField);
        jLabel2.setText(this.msg.get("settings_browser"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.browserField.setText(this.options.getString("browser", ""));
        this.browserField.setToolTipText("msg.get(\"settings_browser_tooltip\")");
        this.browserField.setMinimumSize(new Dimension(75, 21));
        this.browserField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.browserField, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_options_title"), jPanel);
        this.dbPanel.setLayout(new GridBagLayout());
        this.dbPanel.setPreferredSize(new Dimension(440, 200));
        this.driverLb.setText(this.msg.get("settings_db_driver"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.driverLb, gridBagConstraints);
        this.driverField.setText(this.options.getString("dbDriver", ""));
        this.driverField.setMinimumSize(new Dimension(75, 21));
        this.driverField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.driverField, gridBagConstraints);
        this.urlLb.setText(this.msg.get("settings_db_url"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.urlLb, gridBagConstraints);
        this.urlField.setText(this.options.getString("dbServer", ""));
        this.urlField.setMinimumSize(new Dimension(75, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.urlField, gridBagConstraints);
        this.usrLb.setText(this.msg.get("settings_db_usr"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.usrLb, gridBagConstraints);
        this.usrField.setText(this.options.getString("dbLogin", ""));
        this.usrField.setMinimumSize(new Dimension(75, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.usrField, gridBagConstraints);
        this.pwdLb.setText(this.msg.get("settings_db_pwd"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.pwdLb, gridBagConstraints);
        this.pwdField.setMinimumSize(new Dimension(75, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.pwdField, gridBagConstraints);
        this.prefixLb.setText(this.msg.get("settings_tablePrefix"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.prefixLb, gridBagConstraints);
        this.prefixFld.setText(this.options.getString("tablePrefix", ""));
        this.prefixFld.setMinimumSize(new Dimension(75, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.prefixFld, gridBagConstraints);
        this.createChk.setSelected(this.options.getBoolean("createTables", true));
        this.createChk.setText(this.options.getMsg("settings_createTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dbPanel.add((Component)this.createChk, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_db_title"), this.dbPanel);
        this.webPanel.setLayout(new GridBagLayout());
        this.webPanel.setPreferredSize(new Dimension(300, 112));
        this.webAutostartChk.setSelected(this.options.getBoolean("http_autostart", false));
        this.webAutostartChk.setText(this.msg.get("settings_server_autostart"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webPanel.add((Component)this.webAutostartChk, gridBagConstraints);
        this.webPortLb.setLabelFor(this.webPortField);
        this.webPortLb.setText(this.msg.get("settings_server_port"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webPanel.add((Component)this.webPortLb, gridBagConstraints);
        this.webPortField.setText(this.options.getString("http_port", ""));
        this.webPortField.setMinimumSize(new Dimension(70, 21));
        this.webPortField.setPreferredSize(new Dimension(80, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webPanel.add((Component)this.webPortField, gridBagConstraints);
        this.webTimeoutLb.setLabelFor(this.webTimeoutField);
        this.webTimeoutLb.setText(this.msg.get("settings_server_timeout"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webPanel.add((Component)this.webTimeoutLb, gridBagConstraints);
        this.webTimeoutField.setText(this.options.getString("http_timeout", ""));
        this.webTimeoutField.setMinimumSize(new Dimension(70, 21));
        this.webTimeoutField.setPreferredSize(new Dimension(80, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webPanel.add((Component)this.webTimeoutField, gridBagConstraints);
        this.sessionLifetimeLb.setLabelFor(this.sessionLifetimeField);
        this.sessionLifetimeLb.setText(this.msg.get("settings_session_lifetime"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webPanel.add((Component)this.sessionLifetimeLb, gridBagConstraints);
        this.sessionLifetimeField.setText(this.options.getString("session_lifetime", ""));
        this.sessionLifetimeField.setMinimumSize(new Dimension(70, 21));
        this.sessionLifetimeField.setPreferredSize(new Dimension(80, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webPanel.add((Component)this.sessionLifetimeField, gridBagConstraints);
        this.webLogLb.setLabelFor(this.webLogField);
        this.webLogLb.setText(this.msg.get("settings_server_logFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webPanel.add((Component)this.webLogLb, gridBagConstraints);
        this.webLogField.setText(this.options.getString("http_logFile", ""));
        this.webLogField.setMinimumSize(new Dimension(70, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webPanel.add((Component)this.webLogField, gridBagConstraints);
        this.logFileWebBtn.setText(this.msg.get("settings_file"));
        this.logFileWebBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServerSettingsDlg.this.logFileWebBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webPanel.add((Component)this.logFileWebBtn, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_web_title"), this.webPanel);
        this.getContentPane().add((Component)jTabbedPane, "Center");
        jButton.setText(this.msg.get("OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServerSettingsDlg.this.btOkActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jButton2.setText(this.msg.get("CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServerSettingsDlg.this.btCancelActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
    }

    private void logFileWebBtnActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = null;
        File file = null;
        String string = this.webLogField.getText();
        if (string != null && string.length() > 0) {
            file = new File(string);
            jFileChooser = new JFileChooser(file.getParent());
            jFileChooser.setSelectedFile(file);
        } else {
            jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File("jclic_webserver.log"));
        }
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            this.webLogField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void tooltipChkActionPerformed(ActionEvent actionEvent) {
    }

    private void btCancelActionPerformed(ActionEvent actionEvent) {
        this.closeDialog(null);
    }

    private void btOkActionPerformed(ActionEvent actionEvent) {
        this.readValues();
        this.result = true;
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    protected void readValues() {
        this.options.put("language", Messages.getLanguageFromDescriptive(this.langCombo.getSelectedItem().toString()));
        this.options.put("lookAndFeel", this.lookCombo.getSelectedItem().toString());
        this.options.put("tooltips", this.tooltipChk.isSelected() ? "true" : "false");
        this.options.put("dbDriver", this.driverField.getText());
        this.options.put("dbServer", this.urlField.getText());
        this.options.put("dbLogin", this.usrField.getText());
        this.options.put("dbPassword", new String(this.pwdField.getPassword()));
        this.options.put("tablePrefix", this.prefixFld.getText());
        this.options.put("createTables", this.createChk.isSelected() ? "true" : "false");
        this.options.put("http_port", this.webPortField.getText());
        this.options.put("http_timeout", this.webTimeoutField.getText());
        this.options.put("session_lifetime", this.sessionLifetimeField.getText());
        this.options.put("http_autostart", this.webAutostartChk.isSelected() ? "true" : "false");
        this.options.put("http_logFile", this.webLogField.getText());
        this.options.put("browser", this.browserField.getText());
    }
}

