BEGIN {
    use vars '$console';
    select NULL; # ugly
    eval q{
	use Irssi;
	Irssi::version();
    };
    select STDOUT;
    $console = ! ! $@;
}

use strict;
use vars qw($VERSION %IRSSI);

$VERSION = '2.11';
%IRSSI = (
    authors	=> 'Juerd',
    contact	=> 'juerd@juerd.nl',
    name	=> 'Sysinfo',
    description	=> 'Linux system information',
    license	=> 'Public Domain',
    url		=> 'http://juerd.nl/irssi/',
    changed	=> 'Sat Jun 29 13:30 CET 2002',
);


sub sysinfo {
    my $ret = `uname -snr`;
    chomp $ret;
    $ret .= ' - ';

    open FOO, '/proc/cpuinfo';
    while (<FOO>){
        /^processor\s*:\s*(\d+)/         ? $ret .= "Cpu$1: "
      : /^model name\s*:\s*(\w+[ A-Za-z]*)/ ? do { my $t = $1; $t =~ s/\s+$//; $ret .= "$t " }
      : /^cpu MHz\s*:\s*([\.\d]+)/       ? $ret .= int(.5+$1) . 'MHz '
      : undef;
    }
    close FOO;
    $ret =~ s/( ?)$/;$1/;

    open FOO, '/proc/meminfo';
    while (<FOO>){
        /^(Mem|Swap):\s*(\d+)/ and $ret .= "$1: " . int(.5 + ($2/2**20)) . 'M; ';
    }
    close FOO;

    for (`df -h`){
	next unless m!^/!;
	my @foo = split;
       	$ret .= "$foo[5]: $foo[1](f=$foo[3]); ";
    }

    my @pci;
    open FOO, '/proc/pci';
    while (<FOO>) {
	
        /^    (?! |host|pci)(?:multimedia )?(.*?)( storage| compatible)? (?:controller|bridge|interface)/i and push @pci, $1;
    }
    close FOO;
    $ret .= 'PCI: ' . join(',', map ucfirst, @pci) . '; ' if @pci;

    my ($usr, $avg, $up);
    if (`uptime` =~ /^.*?up\s*(.*?),\s*(\d+) users?,.*: ([\d\.]+)/){
	($usr, $avg) = ($2, $3);
	($up = $1) =~ s/\s*days?,\s*|\+/d+/;
	$ret .= "Up: $up; Users: $usr; Load: $avg; ";
    }
    if ($console){
	print "$ret\n";
    }else{
	$_[2]->command("say $ret");
    }
} #end of sub

if ($console){
    sysinfo();
}else{
    Irssi::command_bind('sysinfo' => 'sysinfo');
}
