/* vmlinuz.h */
#ifndef VMLINUZ_H
#define VMLINUZ_H

/* Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 * This work is registered with the UK Copyright Service: Registration No:299755
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*
 * Description of vmlinuz files, and of memory parameters
 * passed to kernel (they are similar):
 *  (see linux/Documentation/i386/zero-page.txt)
 */
#ifndef VESABIOS_H
struct vesa_mode_attribute_str {
    /* VESA: */
    unsigned short mode_supported : 1;	/* e.g. enought RAM for it */
    unsigned short optional_info_available : 1;
    unsigned short BIOS_output_supported : 1;
    unsigned short color_mode : 1;		/* else monochrome */
    unsigned short graphic_mode : 1;	/* else text mode */

    /* VBE 2.0: */
    unsigned short mode_not_VGA_compatible : 1;
    unsigned short no_VGA_compatible_window : 1;
    unsigned short linear_framebuffer_supported : 1;
    unsigned short reserved : 8;
    } __attribute__ ((packed)) ModeAttributes;

typedef struct {
    unsigned char padding[8];
    struct {
	unsigned short padding : 1;	/* mapping right ? */
	unsigned short first_letter : 5;
	unsigned short second_letter : 5;
	unsigned short third_letter : 5;
	} __attribute__ ((packed)) manufacturer_id;
    unsigned short monitor_model;
    unsigned serial_number;
    unsigned char manufacture_week;
    unsigned char manufacture_year; /* base: 1990 */
    unsigned char version;
    unsigned char revision;
    unsigned char video_input_type; /* bitfield */
    unsigned char max_horizontal_size_cm;
    unsigned char max_vertical_size_cm;
    unsigned char gamma_factor; /* gamma = 1.0 + gamma_factor/100 */
    struct {
	unsigned char unused : 3;
	unsigned char RBGcolor : 1;
	unsigned char unused2 : 1;
	unsigned char active_off_supported : 1;
	unsigned char suspend_supported : 1;
	unsigned char standby_supported : 1;
	} __attribute__ ((packed)) DPMS;
    unsigned char chroma_green_and_red;
    unsigned char chroma_white_and_blue;
    unsigned char chroma_red_Y;
    unsigned char chroma_red_X;
    unsigned char chroma_green_Y;
    unsigned char chroma_green_X;
    unsigned char chroma_blue_Y;
    unsigned char chroma_blue_X;
    unsigned char chroma_white_Y;
    unsigned char chroma_white_X;
    struct {
	unsigned short _720_400_70Hz :1;
	unsigned short _720_400_88Hz :1;
	unsigned short _640_480_60Hz :1;
	unsigned short _640_480_67Hz :1;
	unsigned short _640_480_72Hz :1;
	unsigned short _640_480_75Hz :1;
	unsigned short _800_600_56Hz :1;
	unsigned short _800_600_60Hz :1;

	unsigned short _800_600_72Hz :1;
	unsigned short _800_600_75Hz :1;
	unsigned short _832_624_75Hz :1;
	unsigned short _1024_768_i87Hz :1;
	unsigned short _1024_768_60Hz :1;
	unsigned short _1024_768_70Hz :1;
	unsigned short _1024_768_75Hz :1;
	unsigned short _1280_1024_75Hz :1;
	} __attribute__ ((packed)) established_timing;
    unsigned char manufacturer_timing;
    struct {
	unsigned short	resolution : 8;	/* X resolution = (field+31)*8 */
	unsigned short	vertical_refresh_freq :6; /* add 60Hz */
	unsigned short	aspect_ratio : 2; /* 01: 0.75 */
	} __attribute__ ((packed)) standard_timing[8];
    union {
	struct {
	    unsigned short	wordmarker_0;
	    unsigned char	bytemarker_0;
	    enum { serial_number = 0xFF,
		   vendor_name = 0xFE,
		   vertical_horizontal_frequency_range = 0xFD,
		   model_name = 0xFC
// RB Interrupt List say that but I read something else...
//		} str_type : 8;
//	    char		string[14];
		} str_type : 16;
	    char		string[13];
	    } __attribute__ ((packed)) strings;
	struct {
	    unsigned char	horizontal_freq_Khz;	/* != 0 */
	    unsigned char	vertical_freq_Hz;	/* != 0 */
	    unsigned char	horizontal_active_time_pix; /* != 0 */
	    unsigned char	horizontal_blanking_time_pix;
	    unsigned char	horizontal_active2_time;
	    unsigned char	vertical_active_time_line;
	    unsigned char	vertical_blanking_time_line;
	    unsigned char	vertical_active_time2;
	    unsigned char	horizontal_sync_offset;
	    unsigned char	horizontal_sync_pulsewidth_pix;
	    unsigned char	vertical_sync_pulsewidth;
	    unsigned char	horizontal_vertical_sync_offset2;
	    unsigned char	horizontal_image_size_mm;
	    unsigned char	vertical_image_size_mm;
	    unsigned char	horizontal_image_size_2;
	    unsigned char	horizontal_border_pix;
	    unsigned char	vertical_border_pix;
	    struct {
		unsigned char unused : 1;
		unsigned char horizontal_sync_pol : 1;
		unsigned char vertical_sync_pol : 1;
		unsigned char sync_type : 2;
		enum { no_sound, stereo_right,
			stereo_left, undefined } sound : 2;
		unsigned char interlaced : 1;
		} __attribute__ ((packed)) display_t;
	    } __attribute__ ((packed)) timings;
	} __attribute__ ((packed)) detailed_timing[4];
    unsigned char unused;
    unsigned char checksum;
    } __attribute__ ((packed)) VBE_EDID_t;

#endif

struct screen_info { /* stolen from linux/include/linux/tty.h */
    unsigned char  orig_x;
    unsigned char  orig_y;
    unsigned short EXT_MEM_K;		/* general info */
    unsigned char  undefined;
    unsigned char  orig_video_page;
    unsigned char  orig_video_mode;
    unsigned char  orig_video_cols;
    unsigned short unused2;
    unsigned short orig_video_ega_bx;
    unsigned short unused3;
    unsigned char  orig_video_lines;
    unsigned char  orig_video_isVGA;
    unsigned short orig_font_height;
    /* VESA graphic mode -- linear frame buffer */
    unsigned short lfb_width;
    unsigned short lfb_height;
    unsigned short lfb_depth;
    unsigned       lfb_base;
    unsigned       lfb_size;
    unsigned short CL_MAGIC;	/* 0xA33F */	/* general info */
    unsigned short CL_OFFSET;			/* general info */
    unsigned short lfb_linelength;
	/* see instboot.h, vesabios.h, user.h, vmlinuz.h: */
    struct vesa_color_layout_str layout;
    unsigned short vesapm_seg;
    unsigned short vesapm_off;
    unsigned short lfb_pages;
    struct vesa_mode_attribute_str vesa_attrib;
    struct vesa_capabilities_str capabilities;
    /* 0x3a -- 0x3f reserved for future expansion */
    unsigned char reserved[6];
    } __attribute__ ((packed));

struct apm_bios_info {
    unsigned short   version;
    unsigned short   cseg;
    unsigned         offset;
    unsigned short   cseg_16;
    unsigned short   dseg;
    unsigned short   flags;
    unsigned short   cseg_len;
    unsigned short   unused; /* cseg_16_len */
    unsigned short   dseg_len;
    } __attribute__ ((packed));

/* See probe_cmos_for_drives() in linux/drivers/ide/ide-geometry.c */
/* rarely used, also check for CMOS address 0x12 (int 0x41, 0x46) */
union drive_info {
    struct FDPT_str {
	unsigned short phy_cyl;
	unsigned char  phy_head;
	unsigned short start_reduced_write_current_cyl;	/* PC XT only */
	unsigned short start_write_precomp_cyl;
	unsigned char  max_ECC_burst_length;	/* PC XT only */
	union drive_ctl_byte_u {
	    struct {
		unsigned char drive_step_speed		: 3;
		unsigned char unused			: 3;
		unsigned char disable_ecc_retry		: 1;
		unsigned char disable_access_retry	: 1;
		} __attribute__ ((packed)) xt;
	    struct {
		unsigned char unused		: 1;
		unsigned char disable_irq	: 1;	/* 0 */
		unsigned char no_reset		: 1;	/* 0 */
		unsigned char more_than_8_heads	: 1;
		unsigned char always_0		: 1;
		unsigned char manuf_defect_map_on_maxcyl: 1; /* AT + */
		unsigned char disable_ecc_retry		: 1;
		unsigned char disable_access_retry	: 1;
		} __attribute__ ((packed)) at;
	    unsigned char all;
	    } drive_ctl_byte;
	unsigned char  standard_timeout;	/* PC XT only */
	unsigned char  formating_timeout;	/* PC XT only */
	unsigned char  check_drive_timeout;	/* PC XT only */
	unsigned short landing_zone_cylinder;	/* PC AT+ */
	unsigned char  phy_sect;		/* PC AT+ */
	unsigned char  reserved;
	} __attribute__ ((packed)) fdpt;
    /* For translating BIOSes: */
    struct EDPT_str {
	unsigned short log_cyl;		/* max 1024 */
	unsigned char  log_head;	/* max 256 */
	unsigned char  signature_0xA0;
	unsigned char  phy_sect;
	unsigned short start_write_precomp_cyl; /* obsolete */
	unsigned char  reserved;
	union drive_ctl_byte_u  drive_ctl_byte;
	unsigned short phy_cyl;		/* max 65536 */
	unsigned char  phy_head;	/* max 16 */
	unsigned short landing_zone_cylinder; /* obsolete */
	unsigned char  log_sect;	/* max 63 */
	unsigned char  checksum;
	} __attribute__ ((packed)) edpt;
    } __attribute__ ((packed));

struct sys_desc_table_info {
    unsigned short length;
    unsigned char table[14];
    } __attribute__ ((packed));

struct in_out_info {
    unsigned char  setup_sects; /* default 4 */
    struct root_flags_str {
	unsigned short read_only : 1;
	unsigned short unused    : 15;
	} root_flags;
    unsigned kernel_compressed_size; /* 16 bytes unit, rounded up; since 2.04 */
    struct ramdisk_str {
	unsigned short	size   : 11;
	unsigned short	unused : 3;
	unsigned short	load   : 1;
	unsigned short	prompt : 1;
	} __attribute__ ((packed)) ramdisk;	/* RAMDISK, default 0 */
    unsigned short vid_mode;    /* Store mode for use in acpi_wakeup.S */
    union {
	struct {
	    unsigned char  minor_root;  /* ROOT_DEV */
	    unsigned char  major_root;  /* ROOT_DEV */
	    } __attribute__ ((packed)) fields;
	unsigned short minor_major;
	} __attribute__ ((packed)) root;
    unsigned char  AUX_DEVICE_INFO; /* ignored */
    unsigned char  jmp_trampoline[3];
    union header_signature_u {
	unsigned char  bytes[4];   /* "HdrS" */
	unsigned       longword;
	} __attribute__ ((packed)) header_signature;
    unsigned short header_version_number; /* 0x0204 */
    unsigned short realmode_swtch[2]; /* hook to plug in a A20-open func */
    unsigned short start_sys_seg;  /* SYSSEG */
    unsigned short kernel_version; /* char pointer */
    struct loader_t {
	enum { LILO = 0, Loadlin, bootsect,
		SYSLINUX, ETHERBOOT, ELILO, UNKNOWN,
		GRUB, UBOOT, XEN, GUJIN, QEMU, ANuCb,
		UndefinedB, ExtendedB, SpecialB
		} type:4;
	unsigned char version : 4;
	} __attribute__ ((packed)) type_of_loader;
    struct {
	unsigned char LOADED_HIGH  : 1;
	unsigned char unused       : 6;
	unsigned char CAN_USE_HEAP : 1; /* heap_end_ptr is set */
	} __attribute__ ((packed)) loadflags;
    unsigned short setup_move_size; /* 0x8000 */
    unsigned       code32_start;
    unsigned       ramdisk_image;
    unsigned       ramdisk_size; /* in bytes */
    unsigned short bootsect_kludge[2];
    unsigned short heap_end_ptr; /* modelist+1024, version >= 0x0201 */
    unsigned char ext_loader_ver;
    unsigned char ext_loader_type;
    unsigned       cmd_line_ptr; /* default 0x0800, version >= 0x0202 */
    unsigned       ramdisk_max;	/* Protocol 2.03, Kernel 2.4.18-pre1 */
    unsigned       kernel_alignment; /* Protocol 2.05 */
    unsigned char  relocatable_kernel;
    unsigned char  min_alignment; /* as a power of 2 */
    unsigned char  pad[2];
    unsigned       cmdline_size; /* Protocol 2.06 */
    unsigned       hardware_subarch;
    unsigned long long hardware_subarch_data;
    unsigned       payload_offset;
    unsigned       payload_length;
    unsigned long long setup_data;
    unsigned long long pref_address;
    unsigned       init_size;
    unsigned char  free[44];	/* includes "trampoline" */
    } __attribute__ ((packed));

#if 0 /* in bios.h */
struct e820map_info {
    long long addr;	/* start of memory segment */
    long long size;	/* size of memory segment */
    long type;		/* type of memory segment */
    } __attribute__ ((packed));
#endif

struct edd_device_params {
    unsigned short	length;
    unsigned short	info_flags;
    unsigned		num_default_cylinders;
    unsigned		num_default_heads;
    unsigned		sectors_per_track;
    unsigned long long	number_of_sectors;
    unsigned short	bytes_per_sector;
    unsigned		dpte_ptr;           /* 0xFFFFFFFF for our purposes */
    unsigned short	key;                /* = 0xBEDD */
    unsigned char	device_path_info_length;     /* = 44 */
    unsigned char	reserved2;
    unsigned short	reserved3;
    unsigned char	host_bus_type[4];
    unsigned char	interface_type[8];
    union {
	struct {
	    unsigned short	base_address;
	    unsigned short	reserved1;
	    unsigned reserved2;
	    } __attribute__ ((packed)) isa;
	struct {
	    unsigned char	bus;
	    unsigned char	slot;
	    unsigned char	function;
	    unsigned char	channel;
	    unsigned		reserved;
	    } __attribute__ ((packed)) pci;
	/* pcix is same as pci */
	struct {
	    unsigned long long	reserved;
	    } __attribute__ ((packed)) ibnd;
	struct {
	    unsigned long long	reserved;
	    } __attribute__ ((packed)) xprs;
	struct {
	    unsigned long long	reserved;
	    } __attribute__ ((packed)) htpt;
	struct {
	    unsigned long long	reserved;
	    } __attribute__ ((packed)) unknown;
	} interface_path;
    union {
	struct {
	    unsigned char	device;
	    unsigned char	reserved1;
	    unsigned short	reserved2;
	    unsigned		reserved3;
	    unsigned long long	reserved4;
	    } __attribute__ ((packed)) ata;
	struct {
	    unsigned char	device;
	    unsigned char	lun;
	    unsigned char	reserved1;
	    unsigned char	reserved2;
	    unsigned		reserved3;
	    unsigned long long	reserved4;
	    } __attribute__ ((packed)) atapi;
	struct {
	    unsigned short	id;
	    unsigned long long	lun;
	    unsigned short	reserved1;
	    unsigned		reserved2;
	    } __attribute__ ((packed)) scsi;
	struct {
	    unsigned long long	serial_number;
	    unsigned long long	reserved;
	    } __attribute__ ((packed)) usb;
	struct {
	    unsigned long long	eui;
	    unsigned long long	reserved;
	    } __attribute__ ((packed)) i1394;
	struct {
	    unsigned long long	wwid;
	    unsigned long long	lun;
	    } __attribute__ ((packed)) fibre;
	struct {
	    unsigned long long	identity_tag;
	    unsigned long long	reserved;
	    } __attribute__ ((packed)) i2o;
	struct {
	    unsigned		array_number;
	    unsigned		reserved1;
	    unsigned long long	reserved2;
	    } __attribute((packed)) raid;
	struct {
	    unsigned char	device;
	    unsigned char	reserved1;
	    unsigned short	reserved2;
	    unsigned		reserved3;
	    unsigned long long	reserved4;
	    } __attribute__ ((packed)) sata;
	struct {
	    unsigned long long	reserved1;
	    unsigned long long	reserved2;
	    } __attribute__ ((packed)) unknown;
	} device_path;
    unsigned char	reserved4;
    unsigned char	checksum;
    } __attribute__ ((packed));

struct edd_info {
    unsigned char		device;
    unsigned char		version;
    unsigned short		interface_support;
    unsigned short		max_cyl;
    unsigned char		max_head;
    unsigned char		max_sect;
    struct edd_device_params	params;
    } __attribute__ ((packed));

/*
 * Well, I do not know what that does, but because it is included in Linux
 * kernel it has to be GPL - source code given in its most readable form...
 */
struct X86SpeedStepSmi_s {
    unsigned data1, data2, data3, data4;
    };

typedef struct {
    unsigned system_table_pointer;
    unsigned memory_descriptor_size;
    unsigned memory_descriptor_version;
    unsigned memory_descriptor_map_pointer;
    unsigned memory_descriptor_map_size;
    } EFI_t;

struct linux_param {
    struct screen_info		screen_info;
    struct apm_bios_info	apm_bios_info;
    unsigned char		free1a[12];
    struct X86SpeedStepSmi_s	X86SpeedStepSmi;
    unsigned char		free1b[16];
    union drive_info		drive1, drive2;
    struct sys_desc_table_info	sys_desc_table;
    unsigned char		free2[144];
    VBE_EDID_t			edid_data;
    unsigned			unused;
    EFI_t			EFI;
    unsigned char		free2a[8];
    unsigned			ALT_MEM_K;
    unsigned char		free3[4];
    unsigned char		nb_E820_entries;
    unsigned char		nb_EDD_entries;
    unsigned char		nb_MBRSIG_entries;
    unsigned char		free4[6];
    /* 512 bytes bootsector limit */
    /* "in_out" is mostly init'ed in vmlinuz file: */
    struct in_out_info		in_out;
    unsigned			MBRSIG[16];   /* at 0x290 */
//#define EDID_REMOVED
#ifndef EDID_REMOVED
    struct e820map_info		e820map[18]; /* 20 bytes each */
    unsigned char		free6a[8];  /* at 0x438 i.e. 1080 */
    VBE_EDID_t			old_edid_data; /* 0x80 i.e. 128 bytes at 0x440 */
    unsigned char		free6b[144];
#else
    struct e820map_info		e820map[32]; /* 20 bytes each, at 0x2D0 */
#endif
    unsigned char		free7[176];
    struct edd_info		old_edd[6];		/* at 0x600 */
    unsigned char		free8[20];
    unsigned char		command_line[1024];
    unsigned char		free9[256];
    struct edd_info		edd[6];		/* at 0xD00 */
    unsigned char		free10[276];
    } __attribute__ ((packed));

extern inline void test_linux_param_struct (void)
  {
  if (offsetof(struct linux_param, screen_info.EXT_MEM_K) != 0x02)
      __ERROR();
  if (offsetof(struct linux_param, apm_bios_info) != 0x40)
      __ERROR();
  if (offsetof(struct linux_param, X86SpeedStepSmi) != 96)
      __ERROR();
  if (offsetof(struct linux_param, drive1) != 0x80)
      __ERROR();
  if (offsetof(struct linux_param, drive2) != 0x80 + 16)
      __ERROR();
  if (offsetof(struct linux_param, sys_desc_table) != 0xA0)
      __ERROR();
  if (offsetof(struct linux_param, edid_data) != 0x140)
      printf ("0x%X ", (unsigned)&((struct linux_param *)0)->edid_data), /* comma! */
      __ERROR();
  if (offsetof(struct linux_param, ALT_MEM_K) != 0x1E0)
      __ERROR();
  if (offsetof(struct linux_param, nb_E820_entries) != 0x1E8)
      __ERROR();
  if (offsetof(struct linux_param, nb_EDD_entries) != 0x1E9)
      __ERROR();
  if (offsetof(struct linux_param, in_out.setup_sects) != 0x1F1)
      __ERROR();
  if (offsetof(struct linux_param, in_out.root_flags) != 0x1F2)
      __ERROR();
  if (offsetof(struct linux_param, in_out.kernel_compressed_size) != 0x1F4)
      __ERROR();
  if (offsetof(struct linux_param, in_out.header_version_number) != 0x206)
      __ERROR();
  if (offsetof(struct linux_param, in_out.code32_start) != 0x214)
      __ERROR();
  if (offsetof(struct linux_param, in_out.heap_end_ptr) != 0x224)
      __ERROR();
  if (offsetof(struct linux_param, e820map) != 0x2D0)
      __ERROR();
#ifndef EDID_REMOVED
  /* MayDay: edid at 0x440 ??? and it is not even documented in Documentation/i386/zero-page.txt
     That makes a maximum of (0x440 - 0x2D0) / 20 = 18.4 = 18 memory blocks */
  if (offsetof(struct linux_param, free6a) != 0x438) /* 0x2D0 + 20 * 18 = 0x438 */
      printf ("0x%X ", (unsigned)&((struct linux_param *)0)->free6a), /* comma! */
      __ERROR();
  if (offsetof(struct linux_param, old_edid_data) != 0x440)
      printf ("0x%X ", (unsigned)&((struct linux_param *)0)->old_edid_data), /* comma! */
      __ERROR();
#endif
  if (offsetof(struct linux_param, free7) != 0x550) /* 0x2D0 + 20 * 32 = 0x550 */
      printf ("0x%X ", (unsigned)&((struct linux_param *)0)->free7), /* comma! */
      __ERROR();
  if (offsetof(struct linux_param, old_edd) != 0x600)
      __ERROR();
  if (offsetof(struct linux_param, command_line) != 0x800)
      __ERROR();
  if (offsetof(struct linux_param, edd) != 0xd00)
      __ERROR();
  }

/*
 * The structure exchanged between fs.c::system_file_load()
 * and vmlinuz.c::menu_load_system()
 */
extern struct LOADER_str {
    unsigned short sizeof_loader_str, sizeof_fileload_str;
    struct fileload_str {
	/* input: */
	unsigned load_address, max_size_or_crc32;
	/* only for XMS use: */
	unsigned KBalloced;
	unsigned short handle;
	/* For reference: */
	unsigned short BOOTWAY_desc_index;
	/* output: */
	unsigned compressed_size, uncompressed_size;
	} fileload[3], *curfileload; /* kernel and initrd */
    int initrd_index;
    unsigned short minor_major_root;
    unsigned char license_compliant;
    unsigned char kernel_64bits;
    unsigned gzip_byte_treated; /* how many bytes used to decompress GZIP, if multiple GZIP concat in same file */
    unsigned uncompressed_signature;
    unsigned ramdisk_max;
    // (accept_uncompressed_filesize & 0x80000000) != 0 => never uncompress, even if 0x8B1F (compressed initramfs)
    // accept_uncompressed_filesize == 0 => do not accept non-compressed files
    // else filesize of loaded file if not starting by GZIP signature
    unsigned accept_uncompressed_filesize;
    unsigned char post_comment_row, post_comment_col;
    unsigned short setup_sects;
    unsigned char adjust_runadr;
    unsigned char edit_cmdline_b4_run;
    unsigned char reserved_char[2];
    unsigned reserved[4];
	/* Initialise from the "comment" line of the GZIP file */
    union {
	unsigned array[32];
	struct {
	    unsigned NONGPL_productID;
	    unsigned NONGPL_productNB;
	    unsigned min_gujin_version;	/* 0x100 for 1.0 */
	    unsigned late_relocation_address;
	    unsigned runadr;
	    unsigned paramadr;	/* usually 0x00080000 */
	    unsigned realfct_size; /* in bytes */
	    unsigned minram; /* in kilobytes */
	    unsigned option;	/* see "struct freeze_IDE_s" in disk.h */

	    unsigned maskcpu;
	/* If most significant bit is not set (but maskcpu != 0) it means that
		this kernel file is not for PC (but for Mac, Alpha, ARM ...)
		Do not even try to load it then. */
#define MASKCPU_BIOSIA32 (1 << 31) /* refuse to start if no IA32 BIOS (not a PC) */
#define MASKCPU_BIOSONLY (1 << 30) /* refuse to start from DOS/windows */
#define MASKCPU_REALONLY (1 << 29) /* refuse to start from EMM386/virtual environment */

#define MASKCPU_8086	(1 << 0)
#define MASKCPU_8186	(1 << 1)
#define MASKCPU_8286	(1 << 2)
#define MASKCPU_386	(1 << 3) /* if bit 3 set, cannot run on 386 */
#define MASKCPU_486	(1 << 4) /* most 486s, AMD 5x86, Cyrix 5x86 */
#define MASKCPU_586	(1 << 5) /* Intel P5, P54C, P55C, P24T,
					NextGen Nx586, Cyrix M1, AMD K5, K6,
					Centaur C6, C2, C3, Rise mP6 */
#define MASKCPU_686	(1 << 6) /* Intel P6, P2, P3, AMD K7,
					Cyrix M2, VIA Cyrix III */
#define MASKCPU_786	(1 << 7) /* IA-64 */
#define MASKCPU_F86	(1 << 0xF) /* family 0xF, extended family 0 */
#define MASKCPU_G86	(1 << 0x10) /* family 0xF, extended family 1 */

	    unsigned maskDflags; /* request those bits set, cpuid 0x00000001 in edx (usual) */
	    unsigned maskCflags; /* request those bits set, cpuid 0x00000001 in ecx (new) */
	    unsigned maskBflags; /* unused on PCs */
	    unsigned maskAflags; /* request those bits set, cpuid 0x80000001 */
	    unsigned maskvesa;   /* if bit (8-1) set, VESA 8BPP supported */
#define MASKVESA_1BPP	(1 << 0)
#define MASKVESA_2BPP	(1 << 1)
#define MASKVESA_4BPP	(1 << 3)
#define MASKVESA_8BPP	(1 << 7)
#define MASKVESA_15BPP	(1 << 14)
#define MASKVESA_16BPP	(1 << 15)
#define MASKVESA_24BPP	(1 << 23)
#define MASKVESA_32BPP	(1 << 31)

#define MASKVESA_TEXT	(1 << 16)	/* able to boot in text mode */
#define MASKVESA_WIN	(1 << 17)	/* able to boot in VESA1 mode */
#define MASKVESA_LIN	(1 << 18)	/* able to boot in VESA2 linear mode */
#define MASKVESA_LIN2WIN	(1 << 19)	/* force VESA1 if in VESA2 */
#define MASKVESA_NOGRAPHICVGA	(1 << 20)	/* Cannot handle VGA graphic modes */
 /* none of them => no check */
#define MASKVESA_TYPE	(MASKVESA_TEXT|MASKVESA_WIN|MASKVESA_LIN)
	    unsigned maskresolution;	/* bit set => exclude those modes */
#define MASKRESOLUTION_40cols		(1 << 0)
#define MASKRESOLUTION_80cols		(1 << 1)
#define MASKRESOLUTION_100cols		(1 << 2)
#define MASKRESOLUTION_132cols		(1 << 3)
#define MASKRESOLUTION_160cols		(1 << 4)

#define MASKRESOLUTION_24rows		(1 << 5)	/* mostly VT/serial */
#define MASKRESOLUTION_25rows		(1 << 6)
#define MASKRESOLUTION_30rows		(1 << 7)
#define MASKRESOLUTION_36rows		(1 << 8)	/* mostly VT/serial */
#define MASKRESOLUTION_43rows		(1 << 9)
#define MASKRESOLUTION_44rows		(1 << 10)
#define MASKRESOLUTION_48rows		(1 << 11)	/* mostly VT/serial */
#define MASKRESOLUTION_50rows		(1 << 12)
#define MASKRESOLUTION_60rows		(1 << 13)
#define MASKRESOLUTION_64rows		(1 << 14)

#define MASKRESOLUTION_320x200		(1 << 15)
#define MASKRESOLUTION_320x400		(1 << 16)
#define MASKRESOLUTION_640x200		(1 << 17)
#define MASKRESOLUTION_640x350		(1 << 18)
#define MASKRESOLUTION_640x400		(1 << 19)
#define MASKRESOLUTION_640x480		(1 << 20)
#define MASKRESOLUTION_720x400		(1 << 21)
#define MASKRESOLUTION_768x1024		(1 << 22)
#define MASKRESOLUTION_800x600		(1 << 23)
#define MASKRESOLUTION_832x624		(1 << 24)
#define MASKRESOLUTION_1024x768		(1 << 25)
#define MASKRESOLUTION_1152x864		(1 << 26)
#define MASKRESOLUTION_1280x960		(1 << 27)
#define MASKRESOLUTION_1280x1024	(1 << 28)
#define MASKRESOLUTION_1600x1200	(1 << 29)
#define MASKRESOLUTION_2048x1540	(1 << 30)
#define MASKRESOLUTION_UNLISTED		(1 << 31)	/* not listed invalid */
	    } elem;
	} comment;
	/* related to LINUX version: */
    char     cmdline_extraparam[512];
    char     cmdline_name[128];
    } LOADER;

/*
 * The structure given to GPL compliant kernel:
 */
#if !defined (MOUSE_H) || !(USER_SUPPORT & (BIOS_MOUSE_SUPPORT|SERIAL_MOUSE_SUPPORT|JOYSTICK_SUPPORT))
struct mousefieldattr_str {
    unsigned short fullscreenfield	: 1;	/* for "Press a key to continue" */
    unsigned short upperfield		: 1;
    unsigned short mainfield		: 1;
    unsigned short active		: 1;
    unsigned short pressed		: 1;
    unsigned short checkbox		: 1;
    unsigned short greyed		: 1;
    } attr;
#endif
#if !defined (USER_H) || (USER_SUPPORT == 0)
typedef struct {
    unsigned short x, y;
    } __attribute__ ((packed)) coord;
struct attribute_str {
    unsigned char underline	: 1;
    unsigned char reverse	: 1;
    unsigned char blink		: 1;
    unsigned char brighter	: 1;
    unsigned char darker	: 1;
    unsigned char transparent	: 1; /* no background drawn in VESA */
    unsigned char reserved	: 2;
    } __attribute__ ((packed));
#endif

struct gpl_compliant_str {
    unsigned signature;
    unsigned version;
    unsigned feature;
    unsigned size;

    setjmp_buf jmpbuf;

    /* those are linear address: */
    /* first filename_array, last BOOTWAY hard coded for farptr2linear() */
    unsigned filename_array, gdt, regs, fourKbuffer;
    unsigned LOADER, STATE, UI, MOUSE, DI, UTIL, BOOTWAY;

    /* Those are real mode seg:off addresses: */
    farptr font8x8_farptr, font8x14_farptr, font8x16_farptr,
	 font10x20_farptr, font12x24_farptr, reserved_farptr[3];

    struct real_mode_fct { /* Those are for real-mode *.kgz use, to call only by lcallw */
	void     (*putstr) (const char *str);
	int      (*printf) (const char *format, ...);
	unsigned (*getkey) (unsigned timeout); /* timeout in ticks, 18/s, 0 = none */
	unsigned (*get_number) (unsigned deflt, unsigned max);
	void     (*reset_field) (struct mousefieldattr_str attr);
	void     (*print_field) (const char *str, struct mousefieldattr_str attr,
		unsigned short key, unsigned short row, unsigned short col);
	void     (*clearscreen) (void);
	void     (*draw_bg_box) (unsigned baserow, unsigned height, unsigned color);
	/* Cursor: home at (0,0) */
	unsigned (*setcursor) (unsigned char row, unsigned char col);
	unsigned (*getcursor) (unsigned char *row, unsigned char *col);
	/* Colors are set by functions, and get directly from structure: */
	unsigned (*setfgcolor) (unsigned color);
	unsigned (*setbgcolor) (unsigned color);
	void     (*setattribute) (struct attribute_str attr);

	/* WARNING: NO range check is done (on xy or xend) to be quicker: */
	void     (*setpixel) (coord xy, unsigned color) FASTCALL;
	unsigned (*getpixel) (coord xy) FASTCALL;
	void     (*plotHline) (coord xy, unsigned short xend, unsigned color);

	/* This function ptr is null if (and only if) we are on a serial interface: */
	unsigned __attribute__ ((const)) (*VESA_color) (unsigned char _red, unsigned char _green, unsigned char _blue);
	unsigned (*final_loadrun) (unsigned index, struct registers *regs, struct gujin_param_attrib gujin_attr);
	unsigned (*get_line) (char *buffer, unsigned maxlen, char display, unsigned char lowlimit, unsigned char highlimit); /* Gujin-1.6+ */
	unsigned reserved[6];
	} fct;

    /* Those are simply local address: */
    const struct {
	unsigned        identification; /* do not have linear or clear bit */
	unsigned        nbcolor;
	unsigned short  width, height;
	unsigned	base_address;
	unsigned char   row, col;
	unsigned char   nbrow, nbcol;
	unsigned char   charwidth, charheight;
	struct {
	    unsigned char isgraphic		: 1;
	    /*
	     * Some VGA cards, in VGA mode, can accept 256 colors background,
	     * color given by the "page" parameter, VESA card have always
	     * this flag set when graphic (at least >= 16 colors):
	     */
	    unsigned char graphicbgcolor	: 1;
	    /* Else only the PC font is available, always set for serial: */
	    unsigned char ansi_font		: 1;
	    /* null used for text mode mouse, del used as a ticker for tick-box */
	    unsigned char null_del_available	 : 1;
	    } attr;
	/* rest of the structure video_parameter_str undocumented */
	} *current_param;
    struct mouse_color_str *mouse_colors;
    void *reserved_ptr[6];
    };

unsigned menu_load_system (unsigned system_index, struct registers *regs, unsigned char edit_cmdline_b4_run);
awk_farcall (menu_load_system);
void treat_gzip_comment (const char *ptr);
awk_farcall (treat_gzip_comment);
void treat_gzip_name (const char *ptr);
awk_farcall (treat_gzip_name);

#if defined (LINUZNAME1) || defined (LINUZNAME2) || defined (LINUZNAME3)
unsigned vmlinuz_header_treat (const struct linux_param *param, unsigned gzlib_avail_in);
awk_farcall (vmlinuz_header_treat);
#endif

/*
 * ELF structures:
 * For more values, see binutils/include/elf/common.h or /usr/include/elf.h
 */
struct ELF32_header {
    unsigned char EI_MAG0_0x7F;
    unsigned char EI_MAG1_E;
    unsigned char EI_MAG2_L;
    unsigned char EI_MAG3_F;
    enum elf_class { ELFCLASSNONE = 0, ELFCLASS32 = 1, ELFCLASS64 = 2 } EI_CLASS : 8;
    enum elf_data { ELFDATANONE = 0, ELFDATA2LSB = 1, ELFDATA_LITTLEENDIAN = 1,
		ELFDATA2MSB = 2, ELFDATA_BIGENDIAN = 2 } EI_DATA : 8;
    enum elf_version { EV_NONE = 0, EV_CURRENT = 1 } EI_VERSION : 8;
    enum elf_osabi { ELFOSABI_NONE = 0, ELFOSABI_SYSV = 0, ELFOSABI_HPUX = 1,
		ELFOSABI_NETBSD = 2, ELFOSABI_LINUX = 3, ELFOSABI_SOLARIS = 6,
		ELFOSABI_AIX = 7, ELFOSABI_IRIX = 8, ELFOSABI_FREEBSD = 9,
		ELFOSABI_TRU64 = 10, ELFOSABI_MODESTO = 11, ELFOSABI_OPENBSD = 12,
		ELFOSABI_ARM = 97, ELFOSABI_STANDALONE = 255,
		} ELFOSABI : 8;
    unsigned char ABIVERSION;
    unsigned char EI_PAD[7];
    enum elf_type { ET_NONE = 0, ET_REL = 1, ET_EXEC = 2, ET_DYN = 3, ET_CORE = 4,
		ET_NUM = 5, ET_LOOS = 0xfe00, ET_HIOS = 0xfeff,
		ET_LOPROC = 0xFF00, ET_HIPROC = 0xFFFF } e_type : 16;
    enum elf_machine { EM_NONE = 0, EM_M32 = 1, EM_SPRAC = 2, EM_I386 = 3, EM_68K = 4,
		EM_88K = 5, EM_860 = 7, EM_MIPS = 8, EM_MIPS_RS4_BE = 10,
		EM_IA_64 = 50, EM_X86_64 = 62 /* a lot more */ } e_machine : 16;
    unsigned e_version;		// enum as EI_VERSION but 32 bits.
    unsigned e_entry;
    unsigned e_phoff;
    unsigned e_shoff;
    unsigned e_flags;
    unsigned short e_ehsize;
    unsigned short e_phentsize;
    unsigned short e_phnum;
    unsigned short e_shentsize;
    unsigned short e_shnum;
    unsigned short e_shstrndx;
    } __attribute__ ((packed));

struct ELF64_header {
    unsigned char EI_MAG0_0x7F;
    unsigned char EI_MAG1_E;
    unsigned char EI_MAG2_L;
    unsigned char EI_MAG3_F;
    enum elf_class EI_CLASS : 8;
    enum elf_data EI_DATA : 8;
    enum elf_version EI_VERSION : 8;
    enum elf_osabi ELFOSABI : 8;
    unsigned char ABIVERSION;
    unsigned char EI_PAD[7];
    enum elf_type e_type : 16;
    enum elf_machine e_machine : 16;
    unsigned e_version;		// enum as EI_VERSION but 32 bits.
    unsigned long long e_entry;
    unsigned long long e_phoff;
    unsigned long long e_shoff;
    unsigned e_flags;
    unsigned short e_ehsize;
    unsigned short e_phentsize;
    unsigned short e_phnum;
    unsigned short e_shentsize;
    unsigned short e_shnum;
    unsigned short e_shstrndx;
    } __attribute__ ((packed));

struct ELF32_pgm_header {
    enum elf_pgmtype { PT_NULL = 0, PT_LOAD = 1, PT_DYNAMIC = 2, PT_INTERP = 3, PT_NOTE = 4, PT_SHLIB = 5,
		PT_PHDR = 6, PT_TLS = 7, PT_NUM = 8, PT_LOPROC = 0x70000000, PT_HIPROC = 0x7FFFFFFF } p_type : 32;
    unsigned p_offset;
    unsigned p_vaddr;
    unsigned p_paddr;
    unsigned p_filesz;
    unsigned p_memsz;
    struct elf_pgmflags {
	unsigned PF_X	: 1;
	unsigned PF_W	: 1;
	unsigned PF_R	: 1;
	unsigned PF_RESERVED	: 25;
	unsigned PF_MASKPROC	: 4;
	} __attribute__ ((packed)) p_flags;
    unsigned p_align;
    } __attribute__ ((packed));

struct ELF64_pgm_header {
    enum elf_pgmtype	p_type;
    struct elf_pgmflags	p_flags;
    unsigned long long	p_offset;
    unsigned long long	p_vaddr;
    unsigned long long	p_paddr;
    unsigned long long	p_filesz;
    unsigned long long	p_memsz;
    unsigned long long	p_align;
    } __attribute__ ((packed));

struct ELF32_sect_header {
    unsigned	sh_name;
    enum elf_shtype { SHT_NULL = 0, SHT_PROGBITS, SHT_SYMTAB, SHT_STRTAB, SHT_RELA, SHT_HASH,
	SHT_DYNAMIC, SHT_NOTE, SHT_NOBITS, SHT_REL, SHT_SHLIB, SHT_DYNSYM,
	SHT_INIT_ARRAY = 14, SHT_FINI_ARRAY = 15, SHT_PREINIT_ARRAY = 16, SHT_GROUP = 17,
	SHT_SYMTAB_SHNDX = 18, SHT_NUM = 19, /* and more... */
	SHT_LOWPROC = 0x70000000, SHT_HIGHPROC = 0x7FFFFFFF,
	SHT_LOUSER = 0x80000000, SHT_HIUSER = 0xFFFFFFFF
	}	sh_type;
    struct elf_shflags {
	unsigned SHF_WRITE	: 1;
	unsigned SHF_ALLOC	: 1;
	unsigned SHF_EXECINSTR	: 1;
	unsigned unknown	: 1;
	unsigned SHF_MERGE	: 1;
	unsigned SHF_STRINGS	: 1;
	unsigned SHF_INFO_LINK	: 1;
	unsigned SHF_LINK_ORDER	: 1;
	unsigned SHF_OS_NONCONFORMING	: 1;
	unsigned SHF_GROUP	: 1;
	unsigned SHF_TLS	: 1;
	unsigned SHF_RESERVED	: 17;
	unsigned SHF_MASKPROC	: 4;
	} __attribute__ ((packed)) sh_flags;
    unsigned	sh_addr;
    unsigned	sh_offset;
    unsigned	sh_size;
    unsigned	sh_link;
    unsigned	sh_info;
    unsigned	sh_addralign;
    unsigned	sh_entsize;
    } __attribute__ ((packed));

struct ELF64_sect_header {
    unsigned		sh_name;
    enum elf_shtype	sh_type;
    struct elf_shflags	sh_flags;
    unsigned		sh_flags_msb;
    unsigned long long	sh_addr;
    unsigned long long	sh_offset;
    unsigned long long	sh_size;
    unsigned		sh_link;
    unsigned		sh_info;
    unsigned long long	sh_addralign;
    unsigned long long	sh_entsize;
    } __attribute__ ((packed));

struct ELF32_reloca {
    unsigned addr;
    enum elf_reloctype {
	R_386_32 = 1, R_386_PC32 = 2, R_386_16 = 20, R_386_PC16 = 21, R_386_8 = 22, R_386_PC8 = 23,
	R_X86_64_64 = 1, R_X86_64_PC32 = 2, R_X86_64_RELATIVE = 8, R_X86_64_32 = 10, R_X86_64_32S = 11,
		R_X86_64_16 = 12, R_X86_64_PC16 = 13, R_X86_64_8 = 14, R_X86_64_PC8 = 15
	} type : 8;
    unsigned symbol : 24;
    unsigned addend;
    } __attribute__ ((packed));

struct ELF64_reloca {
    unsigned long long	addr;
    enum elf_reloctype	type : 32;
    unsigned symbol;
    unsigned long long addend;
    } __attribute__ ((packed));

/*
 * For gzlib.c:
 */
#define GZLIB_TREAT_NAME(ptr) { \
    void treat_gzip_name (const char *);	\
    treat_gzip_name (ptr);			\
    }

#define GZLIB_TREAT_COMMENT(ptr) { \
    void treat_gzip_comment (const char *);	\
    treat_gzip_comment (ptr);			\
    }

#endif /* VMLINUZ_H */

