/* messages.h *** THIS FILE SHOULD BE EDITED WITH AN UTF-8 AWARE EDITOR *** */

/* Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


 /* Italian messages translated by benny59, released under the FreeBSD license:
    German messages corrected by Jörg Jenderek (jj) , released under the GPL license:

Copyright 2010 benny59. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
*/

#include "make.h"

#if !(SETUP & MULTILINGUAL)

/* We do not need multi languages for debugging, we need to save space: */
#define MLTSTR(ENGLISH, FRENCH, RUSSIAN, SPANISH, ITALIAN, PORTUGESE, GERMAN, DUTCH) ENGLISH
#define MLTSTR2 MLTSTR
#define MltStr(x)	x

#else
/* To save space for multiple language, use my "multistring": each message has a single pointer,
  * and is composed of a fixed number of concat'ed zero terminated string.
  * The first string (in english) is required and is used as default if the selected language string is an empty string.
  * The order and number of language is constant, each multistring has at least 8 null chars, to
  * be able to add very few other language easily. The strings are UTF-8 encoded.
  * For instance, the "language" string representing the current language (including last null) is:
  *      "english\0french\0russian\0spanish\0\0\0\0"
  * The function MltStr(multistring) will extract the right pointer depending of the global variable
  * MltStrLanguage -and if this pointer points to an empty string will extract the default english string.
  *
  * 8 languages seems to be the maximum to fit into 64 Kbytes, if we need more, add parameters
  * to macro MLTSTR() but do not use some of its parameters in the MltStr () call, there will
  * be two Gujin sub-versions each supporting english + 7 languages. Only UTF-8 with max
  * char value 0x600 is supported up to now, most higher values cannot fit into 8 bits wide chars.
  */
extern enum MltStr_e { MLTSTR_ENGLISH = 0, MLTSTR_FRENCH, MLTSTR_RUSSIAN, MLTSTR_SPANISH,
	MLTSTR_ITALIAN, MLTSTR_PORTUGESE, MLTSTR_GERMAN, MLTSTR_DUTCH
	} MltStrLanguage;

#define MLTSTR_DEFAULT_ENGLISH		""
#define MLTSTR_DEFAULT_RUSSIAN		""
#define MLTSTR_DEFAULT_SPANISH		""
#define MLTSTR_DEFAULT_FRENCH		""
#define MLTSTR_DEFAULT_ITALIAN		""
#define MLTSTR_DEFAULT_PORTUGESE	""
#define MLTSTR_DEFAULT_GERMAN		""
#define MLTSTR_DEFAULT_DUTCH		""

#if !(SETUP & XSTRING_SEGMENT) /* only fewer languages will fit, maybe only one or two... */

#define NB_TOTAL_LANGUAGE 2
#define MLTSTR(ENGLISH, FRENCH, RUSSIAN, SPANISH, ITALIAN, PORTUGESE, GERMAN, DUTCH) \
    MltStr (ENGLISH "\0" FRENCH "\0" "\0" "\0" "\0" "\0" "\0")
#define MLTSTR2 MLTSTR
  /*
const char *MltStr(const char *multistring) __attribute__ (( fastcall, pure )) {
    enum MltStr_e cptlang;
    const char *ptr = multistring;
    for (cptlang = MLTSTR_ENGLISH; cptlang < MltStrLanguage; cptlang++)
	while (*ptr++)
	    continue;
    return (*ptr)? ptr : multistring;
    }
  */
#else
/* should be, if we had enough memory in .data segment:
#define MLTSTR(ENGLISH, FRENCH, RUSSIAN, SPANISH, ITALIAN, PORTUGESE, GERMAN, DUTCH) \
    MltStr (ENGLISH "\0" FRENCH "\0" RUSSIAN "\0" SPANISH "\0" ITALIAN "\0" \
	PORTUGESE "\0" GERMAN "\0" DUTCH )
*/
#if 1
/*
 * With all these languages, the .xstring segment is bigger than 64Kb, and that cannot work...
 * So we create two of them, the limit in between MLTSTR2() and MLTSTR() should be approx in the middle,
 * the error message if one of these segment is too big is:
 * address 0x12d00 of boot.elf section `.xstring[12]' is not within region `ram'
 */
#define NB_TOTAL_LANGUAGE 8
#define MLTSTR(ENGLISH, FRENCH, RUSSIAN, SPANISH, ITALIAN, PORTUGESE, GERMAN, DUTCH) MltStr (({ \
	static const char MLTSTR ## __LINE__ [] __attribute__((section(".xstring1.str"))) = ENGLISH "\0" FRENCH "\0"		\
		RUSSIAN "\0" SPANISH "\0" ITALIAN "\0" PORTUGESE "\0" GERMAN "\0" DUTCH ;					\
	static const struct { char marker; const char *str; } __attribute__((packed)) fptr = { '\xFF', MLTSTR ## __LINE__ };	\
	/* return */ &fptr.marker;												\
	}))

#define MLTSTR2(ENGLISH, FRENCH, RUSSIAN, SPANISH, ITALIAN, PORTUGESE, GERMAN, DUTCH) MltStr (({ \
	static const char MLTSTR ## __LINE__ [] __attribute__((section(".xstring2.str"))) = ENGLISH "\0" FRENCH "\0"			\
		RUSSIAN "\0" SPANISH "\0" ITALIAN "\0" PORTUGESE "\0" GERMAN "\0" DUTCH ;					\
	static const struct { char marker; const char *str; } __attribute__((packed)) fptr = { '\xFE', MLTSTR ## __LINE__ };	\
	/* return */ &fptr.marker;												\
	}))
#else
#define NB_TOTAL_LANGUAGE 6
#define MLTSTR(ENGLISH, FRENCH, RUSSIAN, SPANISH, ITALIAN, PORTUGESE, GERMAN, DUTCH) MltStr (({ \
	static const char MLTSTR ## __LINE__ [] __attribute__((section(".xstring.str"))) = ENGLISH "\0" FRENCH "\0"		\
	RUSSIAN "\0" SPANISH "\0" ITALIAN "\0" PORTUGESE "\0" "\0" ;								\
	static const struct { char marker; const char *str; } __attribute__((packed)) fptr = { '\xFF', MLTSTR ## __LINE__ };	\
	/* return */ &fptr.marker;												\
	}))
#define MLTSTR2 MLTSTR
#endif
#endif

/* examples:
#define answer_to_life_universe_everything MLTSTR ( \
	"42",					\
	MLTSTR_DEFAULT_FRENCH,			\
	MLTSTR_DEFAULT_RUSSIAN,			\
	MLTSTR_DEFAULT_SPANISH,			\
	MLTSTR_DEFAULT_ITALIAN,			\
	MLTSTR_DEFAULT_PORTUGESE,		\
	MLTSTR_DEFAULT_GERMAN,			\
	MLTSTR_DEFAULT_DUTCH			\
	)

#define language_in_english MLTSTR ( \
	"english",	\
	"french",	\
	"russian",	\
	"spanish",	\
	"italian",	\
	"portugese",	\
	"german",	\
	"dutch"	\
	)

#define x	MLTSTR ("en", "fr", "ru", "sp", "it", "pt", "de", "nl")
  */
extern const char *MltStr(const char *multistring) __attribute__ (( fastcall, pure ));
awk_farcall (MltStr);
#endif

/**
 ** The Linux command line parameter:
 ** Need to cut & paste that into instboot.c (for "--lang=" parameter) and main.c (for mingujin.exe environment variable LANG=)!
 **/
#define LANG_CMDLINE	MLTSTR ("lang=en", "lang=fr", "lang=ru", "lang=sp", "lang=it", "lang=pt", "lang=de", "lang=nl")

/**
 ** Completely untested / maybe useless / not a message:
 ** A string to send at initialisation of a serial line
 ** interface, to initialise a modem and make it dial a
 ** number - a kind of ATDT string.
 ** It could also initialise the terminal in VT compatible mode?
 ** Undefine it to disable the feature.
 **/
#if USER_SUPPORT & SERIAL_SUPPORT
#define SERIAL_INIT_MODEM_STRING "<String to initialise modem>\r\n"
#endif

/**
 ** The strings without language:
 **/
#define MSG_BEEP	"\007"
#define CRLF		"\r\n"
#define LANG_CODE	MLTSTR ("en", "fr", "ru", "sp", "it", "pt", "de", "nl")

/**
 ** The real short messages:
 **/
#define MSG_ERROR	MLTSTR ( \
	"ERROR: ",		\
	"ERREUR: ",		\
	"ОШИБКА: ",		\
	"",			\
	"ERRORE: ",		\
	"ERRO: ",		\
	"Fehler: ",	/* jj */	\
	"FOUT: "		\
	)

#define MSG_WARNING	MLTSTR ( \
	"Warning: ",		\
	"Attention: ",		\
	"Предупреждение: ",	\
	"Advertencia: ",	\
	"Avviso: ",	/* by Benny */	\
	"Aviso: ",		\
	"Warnung: ",		\
	"Waarschuwen: "		\
	)

#define MSG_FULL_STOP	MLTSTR ( \
	"stop.",		\
	"fin.",			\
	"стоп.",		\
	"parada.",		\
	"arresto.",		\
	"batente.",		\
	"stoppen.",		\
	""			\
	)

#define MSG_POWERING_OFF	MLTSTR ( \
	"Power OFF",		\
	"Arrêt",		\
	"Сила",			\
	"Accione lejos",	\
	"Arresto",	/* by Benny */	\
	"O poder fora",		\
	"Ausschalten",	/* jj */	\
	"Uitschakeel"		\
	)

#define MSG_NONE	MLTSTR ( \
	"none",			\
	"aucun",		\
	"никакие",		\
	"ningunos",		\
	"nessun",		\
	"nenhuns",		\
	"kein",	/* jj */	\
	"niets"			\
	)

#define MSG_COLON_FAILED	MLTSTR ( \
	": failed.",		\
	": échoué.",		\
	": неудачно.",		\
	": fallado.",		\
	": fallito.",	/* by Benny */	\
	": falhado.",		\
	": gescheitert.",	/* jj */	\
	": verstoorde."		\
	)

#define MSG_COLON_FAILED_ERROR	MLTSTR ( \
	": failed (error %d).",		\
	": échoué (erreur %d).",	\
	": неудачно (ошибка %d).",	\
	": fallado (error %d).",	\
	": fallito (errore %d).",	/* by Benny */	\
	": falhado (erro %d).",		\
	": gescheitert (Fehler %d).",	/* jj */	\
	": verstoorde (fout %d)."	\
	)

#define MSG_READING	MLTSTR ( \
	"reading",		\
	"lecture",		\
	"чтение",		\
	"lectura",		\
	"lettura",		\
	"leitura",		\
	"Messwert",		\
	"lezen"			\
	)

#define MSG_WRITING	MLTSTR ( \
	"writing",		\
	"écriture",		\
	"сочинительство",	\
	"escritura",		\
	"scrittura",		\
	"escrita",		\
	"Schreiben",		\
	"schrijven"		\
	)

#define MSG_CHECKING	MLTSTR ( \
	"checking",		\
	"vérification",		\
	"проверяя",		\
	"verificación",		\
	"controllo",		\
	"verificação",		\
	"Überprüfung",		\
	"controleren"		\
	)

#define MSG_ABORTED	MLTSTR ( \
	", aborted.",		\
	", annulé.",		\
	", выкинуто.",		\
	", abortado.",		\
	", abbandonato.",	\
	", abortado.",		\
	", abgebrochen.",	\
	", geaborteerde."	\
	)

#define MSG_CHECKING_CRC32	MLTSTR ( \
	" checking CRC32, ",		\
	" vérifie CRC32, ",		\
	" проверять CRC32, ",		\
	" la comprobación de CRC32, ",	\
	" controllo del CRC32, ",	\
	" verific CRC32, ",		\
	" Prüfung von CRC32, ",		\
	" het controleren van CRC32, "	\
	)

#define MSG_LOADING	MLTSTR ( \
	"loading ",		\
	"chargement ",		\
	"нагружая ",		\
	"cargamento ",		\
	"caricamento ",		\
	"carregamento ",	\
	"Laden ",		\
	"lading "		\
	)

#define MSG_RELOCATING	MLTSTR ( \
	"relocating, ",			\
	"relocation, ",			\
	"передислоцировать, ",		\
	"volviendo a poner, ",		\
	"riassegnare, ",		\
	"relocating, ",			\
	"verlagernd, ",			\
	"zich opnieuw vestigt, "	\
	)

#define WORD_ERROR	MLTSTR ( \
	"ERROR",	\
	"ERREUR",	\
	"ОШИБКА",	\
	"",		\
	"ERRORE",	\
	"ERRO",		\
	"Fehler",	/* jj */	\
	"FOUT"		\
	)

#define WORD_IGNORED	MLTSTR ( \
	"ignored",		\
	"ignoré",		\
	"проигнорировано",	\
	"no hizo caso",		\
	"ignorato",	/* by Benny */	\
	"ignorado",		\
	"ignoriert",		\
	"genegeerd"		\
	)

/* we are using a strait "" instead of MLTSTR_DEFAULT_* to say that
    the traduction is valid (english word imported into local language): */
#define WORD_OK		MLTSTR ( \
	"OK",		\
	"",		\
	"ОДОБРЕНО",	\
	"",		\
	"",		\
	"",		\
	"",		\
	""		\
	)

#define WORD_READONLY	MLTSTR ( \
	"read-only",		\
	"protégé en écriture",	\
	"только для чтения",	\
	"inalterable",		\
	"sola lettura",	/* by Benny */	\
	"de leitura apenas",	\
	"schreibgeschützt",	\
	""			\
	)

/**
 ** The real long messages:
 **/

/*
 * General messages:
 */
#define PRESS_KEY_TO_CONTINUE MLTSTR ( \
	"Press a key to continue",			\
	"Pressez une touche pour continuer",		\
	"Отожмите ключа для того чтобы продолжать",	\
	"Presione una llave para continuar",		\
	"Premi una tasto per continuare",		\
	"Pressione uma chave para continuar",		\
	"Drücken Sie eine Taste, um fortzusetzen",	\
	"Versnellen te grenzen aan voor voortzetten"	\
	)

/* MSG_EXITING_OK and MSG_EXITING_ERR are used to overwrite
    msg_exiting_ok[] and msg_exiting_err[],so have to be shorter
    than 80 chars - UTF-8 counted double */
#define MSG_EXITING_OK MLTSTR ( \
	CRLF "Exiting Gujin without error..." CRLF,		\
	CRLF "Sortie de Gujin sans erreur..." CRLF,		\
	CRLF "Выходящ Gujin без ошибки..." CRLF,		\
	CRLF "Salir de Gujin sin error..." CRLF,		\
	CRLF "Gujin termina senza errori..." CRLF,	/* by Benny */	\
	CRLF "Retirando Gujin sem erro..." CRLF,		\
	CRLF "Ende von Gujin ohne Störung..." CRLF,	/* jj */	\
	CRLF "Uitweg zowat Gujin zonder vergissing..." CRLF	\
	)

#define MSG_EXITING_ERR MLTSTR ( \
	CRLF "Exiting Gujin with error..." CRLF,		\
	CRLF "Sortie de Gujin avec erreur..." CRLF,		\
	CRLF "Выходящ Gujin с ошибкой..." CRLF,			\
	CRLF "Salir de Gujin con error..." CRLF,		\
	CRLF "Gujin termina con errori..." CRLF,	/* by Benny */	\
	CRLF "Retirando Gujin com erro..." CRLF,		\
	CRLF "Ende von Gujin mit Fehler..." CRLF,	/* jj */	\
	CRLF "Uitweg zowat Gujin van vergissing..." CRLF	\
	)

#define CMDLINE_TOO_LONG MLTSTR ( \
	"Command line too long, truncated.",				\
	"Ligne de commande trop longue, tronquée.",			\
	"Линия передачи команд слишком длиной, усечено.",		\
	"Línea de comando demasiado de largo, truncado.",		\
	"Linea di comando troppo lunga, troncata.",	/* by Benny */	\
	"Linha de comando demasiado por muito tempo, truncado.",	\
	"Kommandozeile zu lang, abgeschnitten.",	/* jj */	\
	"Beveel lijn ook lang, beknote."				\
	)

/* Note for translation: "Pause" is what is written on the keyboard key
   located on the right of "scroll lock" and "print screen/System Request"
   (User can press once Pause, OR hold the control key down) */
#define PRESS_PAUSE_TO_STOP_DISPLAY MLTSTR ( \
	CRLF "Press \"Pause\" or hold \"Control\" if you want to temporary stop display...\r",			\
	CRLF "Appuyer sur \"Pause\" ou \"Control\" pour figer temporairement l'écran...\r",			\
	CRLF "Отожмите \"Pause\"/\"Control\" если вы хотите к временному дисплею стопа...\r",			\
	CRLF "Presione la \"pausa\"/\"Control\" si usted desea a la exhibición temporal de la parada...\r",	\
	CRLF "Premi \"Pausa\"/\"Control\" se desiderate arrestare temporaneamente lo scorrimento del testo...\r",	/* by Benny */	\
	CRLF "Pressione a \"pausa\"/\"Control\" se você quiser à exposição provisória do batente...\r",		\
	CRLF "Drücke \"Pause\"/\"Control\", wenn sie Anzeige temporär anhalten möchten...\r",	/* ?? */	\
	CRLF "Pers \"Pauze\"/\"Control\" als u aan tijdelijke eindevertoning wilt...\r"				\
	)

/*
 * Disk messages:
 */
// We do not use those two because changing language would change the names of the disks, embedded in the diskparam...
//#define IDE_MASTER	MLTSTR ("master", "maître", "Оригинал", "amo", "padrone", "mestre", "meister", "")
//#define IDE_SLAVE	MLTSTR ("slave", "esclave", "невольник", "esclavo", "schiavo", "escravo", "sklave", "")
#define MSG_TRYING_LBA	MLTSTR ( \
	"trying: %llU",		\
	"essai: %llU",		\
	"пробовать: %llU",	\
	"el intentar: %llU",	\
	"provare: %llU",	\
	"tentar: %llU",		\
	"Versuche: %llU",	/* ?? */ \
	"stoffen: %llU"	\
	)

#define DISK_NAME_REMARK_SIZE_NBPARTITION MLTSTR ( \
	" %u: %s%s%s, size %u %s, %u partitions",		\
	" %u: %s%s%s, taille %u %s, %u partitions",		\
	" %u: %s%s%s, диска %u %s, %u перегородки",		\
	" %u: %s%s%s, tamaño %u %s, %u particiones",		\
	" %u: %s%s%s, dimensione %u %s, %u partizioni",	/* by Benny */	\
	" %u: %s%s%s, tamanho %u %s, %u divisórias",		\
	" %u: %s%s%s, Größe %u %s, %u Partitionen",	/* jj */	\
	" %u: %s%s%s, grootte %u %s, %u verdelingen"		\
	)

#define DISK_HPA	MLTSTR ( \
	" (HPA: %u%s)",		\
	"",			\
	"",			\
	"",			\
	"",			\
	"",			\
	"",			\
	""			\
	)

#define DISK_CONFIG_LOCKED	MLTSTR ( \
	" (failconf)",		\
	"",			\
	"",			\
	"",			\
	"",			\
	"",			\
	"",			\
	""			\
	)

#define DISK_BYTES_PER_SECTOR	MLTSTR ( \
	"bytes/sectors",	\
	"octets/secteurs",	\
	"байта/участок",	\
	"octetos/sector",	\
	"byte/settore",		\
	"bytes/setor",		\
	"Bytes/Sektor",		\
	""			\
	)

#define DISK_NAME_NO_MEDIA MLTSTR ( \
	" %u: %s, no media detected." CRLF,		\
	" %u: %s, media abscent." CRLF,			\
	" %u: %s, никакие обнаруженные средства." CRLF,	\
	" %u: %s, ningunos medios detectaron." CRLF,	\
	" %u: %s, nessun media rilevato." CRLF,	/* by Benny */	\
	" %u: %s, nenhum meio detectou." CRLF,		\
	" %u: %s, kein Medium ermittelt." CRLF,	/* jj */	\
	" %u: %s, geen ontdekte media." CRLF		\
	)

#define DISK_US_LOCKED_PASSWORD	MLTSTR ( \
	"Drive %u, %s, locked by password" CRLF,			\
	"Disque %u, %s, vérrouillé par mot de passe" CRLF,		\
	"Диск %u, %s, зафиксирован паролем" CRLF,			\
	"Disco duro %u, %s, se trabó por contraseña" CRLF,		\
	"Disco %u, %s, bloccato dalla password di accesso" CRLF,	/* by Benny */	\
	"Disco duro %u, %s, travou pela senha" CRLF,			\
	"Festplatte %u, %s, gesperrt durch Kennwort" CRLF,	/* jj "sperre" instead "riegel" ?? */	\
	"Schijf %u, %s, gesloten door wachtwoord" CRLF			\
	)

#define DISK_TRY_DEFAULT_PASSWORD MLTSTR ( \
	"Try default password:",			\
	"Essai du mot de passe par défaut:",		\
	"Паролем значения по умолчанию попытки:",	\
	"Contraseña de defecto del intento:",		\
	"Prova la password di default:",	/* by Benny */	\
	"Senha de defeito da tentativa:",		\
	"Versuchrückstellungskennwort:",	/* ?? */	\
	"Probeer standaardwachtwoord:"			\
	)

#define RECOGNIZE_KEYBOARD MLTSTR ( \
	"Detect keyboard mapping: ",			\
	"Détection de la langue du clavier: ",		\
	"Обнаружьте составлять карту клавиатуры: ",	\
	"Detecte traz del teclado: ",			\
	"Rilevamento della lingua della tastiera: ",	/* by Benny */	\
	"Detecte traçar do teclado: ",			\
	"Ermittle die Tastaturbelegung: ",		/* ?? */	\
	"Ontdek toetsenbordafbeelding: "		\
	)

#define WARNING_MASTER_PASSWORD_X MLTSTR ( \
	CRLF "MASTER PASSWORD (rev. 0x%X): ",		\
	CRLF "MOT DE PASSE MAITRE (rev. 0x%X): ",	\
	CRLF "УПРАВЛЯЙТЕ ПАРОЛЕМ (возбудите. 0x%X): ",	\
	CRLF "CONTRASEÑA PRINCIPAL (rev. 0x%X): ",	\
	CRLF "PASSWORD PRINCIPALE (rev. 0x%X): ",	/* by Benny */	\
	CRLF "SENHA MESTRA (rev. 0x%X): ",		\
	CRLF "HAUPT-KENNWORT (rev. 0x%X): ",		/* ?? */ \
	CRLF "HOOFD WACHTWOORD (toer 0x%X): "		\
	)

#define TYPE_PASSWORD_OR_ESC MLTSTR ( \
	"Type your password or ESC: ",				\
	"Entrez votre mot de passe ou ESC: ",			\
	"Напечатайте ваш пароль или ESC на машинке: ",		\
	"Mecanografíe su contraseña o ESC: ",			\
	"Scrivi la tua password o ESC: ",	/* by Benny */	\
	"Datilografe sua senha ou ESC: ",			\
	"Schreiben Sie Ihr Kennwort oder ESC: ",/* ?? */	\
	"Typ uw wachtwoord of ESC: "				\
	)

#define CONFIRM_PASSWORD MLTSTR ( \
	CRLF "Confirm your password: ",		\
	CRLF "Confirmez votre mot de passe: ",	\
	CRLF "Подтвердите ваш пароль: ",	\
	CRLF "Confirm contraseña: ",		\
	CRLF "Confirma la tua password: ",	/* by Benny */	\
	CRLF "Confirm sua senha: ",		\
	CRLF "Bestätigen sie ihr Kennwort: ",	/* jj */	\
	CRLF "Bevestig uw wachtwoord: "	\
	)

#define ERROR_PASSWORD_RETRY MLTSTR ( \
	" BAD PASSWORD, retry:",			\
	" ERREUR DE MOT DE PASSE, recommencer:",	\
	" ПОВТОРЕННАЯ попытка:",			\
	" MALA CONTRASEÑA, recomprobación:",		\
	" PASSWORD NON VALIDA, prova ancora:",	/* by Benny */ \
	" SENHA MÁ, nova tentativa:",			\
	" SCHLECHTES KENNWORT, Wiederholung:",	/* jj */	\
	" HET SLECHTE WACHTWOORD, probeert opnieuw:"	\
	)

#define OK_DISK_UNLOCKED MLTSTR ( \
	" OK, disk unlocked.",			\
	" OK, disque dévérrouillé.",		\
	" О'КЕЙ, открынный диск.",		\
	" OK, disco abierto.",			\
	" OK, il disco è sbloccato.",	/* by Benny */	\
	" OK, disco destravado.",		\
	" OK, Festplatte entsperren.",	/* jj */	\
	" OK, geopende schijf."			\
	)

#define FAIL_DISK_IGNORED MLTSTR ( \
	" FAILED %d, disk ignored." CRLF,			\
	" ERREUR %d, disque ignoré." CRLF,			\
	" НЕУДАЧНЫЕ %d, проигнорированный диск." CRLF,		\
	" FALLADO %d, disco no hecho caso." CRLF,		\
	" ERRORE %d, disc ignorato." CRLF,	/* by Benny */	\
	" FALHADO %d, o disco ignorou." CRLF,			\
	" AUSGEFALLEN %d, Festplatte ignoriert." CRLF,	/* ?? */	\
	" ONTBROKEN %d, genegeerde schijf." CRLF		\
	)

#define DISK_S_LOCKED_PASSWORD_IGNORED MLTSTR ( \
	"Drive %s locked by password, ignored." CRLF,				\
	"disque %s vérrouillé par mot de passe, ignoré." CRLF,			\
	"Привод %s зафиксировал проигнорированным паролем." CRLF,		\
	"Disco duro %s se trabó por la contraseña, no hecha caso." CRLF,	\
	"Disco %s bloccato dalla password, ignorata." CRLF,	/* by Benny */	\
	"Disco duro %s travou pela senha, ignorada." CRLF,			\
	"Festplatte %s gesperrt durch das Kennwort, ignoriert." CRLF,	/* jj */	\
	"Aandrijving %s die door wachtwoord wordt de gesloten, negeerde." CRLF	\
	)

/* Using B.E.E.R (http://www.t13.org/project/d1367r3.pdf) means we maintain a backup, B.E.E.R used only when "./gujin /dev/sda0" */
#define DISK_BEERBOOT_DIFF_BACKUP MLTSTR ( \
	"Disk %s: %s differ from backup." CRLF "Press Return [Esc: ignore | Ret: update backup | Space: restore MBR] ",						\
	"Disque %s: %s est different de la sauvegarde." CRLF "Appuyer sur Entrée [Esc: ignorer | Entrée: mise à jour sauvegarde | Espace: restauration MBR] ",	\
	"Диск %s: %s отличает от подпорки." CRLF "Отожмите возвращение [Esc: проигнорируйте | Ret: уточните подпорку | Космос: восстановление MBR] ",		\
	"Disco duro %s: %s diferencia de reserva." CRLF "Presione La Vuelta [Salida: no haga caso | vuelta: ponga al día la reserva | espacio: restaure MBR] ",	\
	"disco %s: %s differisce dal salvataggio." CRLF "Premi Ritorno [ESC: ignori | ritorno: aggiorni il salvataggio | spazio: ristabilisci MBR] ",	/* by Benny */	\
	"Disco duro %s: %s difere do apoio." CRLF "Pressione O Retorno [Esc: ignore | retorno: atualize o apoio | espaço: restaure MBR] ",			\
	"Festplatte %s: %s unterscheidet sich von Sicherung." CRLF "Drücken Sie Eingabe [ESC: ignorieren | Eingabe-Taste: aktualisiere Sicherung  | Leer-Taste: MBR wiederherstellen] ",	/* ?? */	\
	"Schijf %s: %s verschil van file." CRLF "Druk Terugkeer [Esc: negeer | Root: werk file bij | Ruimte: herstel MBR] "					\
	)

#define INVALID_IDE_INTERFACE_AT_X_X MLTSTR ( \
	"Invalid IDE interface at 0x%X, 0x%X!" CRLF,		\
	"Interface IDE invalide à 0x%X, 0x%X !" CRLF,		\
	"Инвалидный интерфейс IDE на 0x%X, 0x%X!" CRLF,		\
	"¡Interfaz inválido del IDE en 0x%X, 0x%X!" CRLF,	\
	"Interfaccia IDE non valida a 0x%X, 0x%X!" CRLF,	/* by Benny */	\
	"Relação inválida do IDE em 0x%X, 0x%X!" CRLF,		\
	"Unzulässige IDE-Schnittstelle an 0x%X, 0x%X!" CRLF,	\
	"De ongeldige interface van winde bij 0x%X, 0x%X!" CRLF	\
	)

#define DISK_BEERBOOT_CODE MLTSTR ( \
	"boot code",				\
	"code de démarrage",			\
	"Кода ботинка",				\
	"código del cargador",			\
	"codice di boot",	/* by Benny */	\
	"código do carregador",			\
	"Boot-Code",		/* ?? */	\
	"laars code"				\
	)

#define DISK_BEERBOOT_PARTITION MLTSTR ( \
	"partition table",		\
	"table de partition",		\
	"таблица перегородки",		\
	"tabla de la partición",	\
	"tabella della partizione",	/* by Benny */	\
	"tabela da divisória",		\
	"Partitionstabelle",		/* jj */	\
	"verdelingslijst"		\
	)

#define DISK_BEERBOOT_CONFIRM_RESTORE_S MLTSTR ( \
	CRLF "CONFIRM you want to RESTORE the %s from Gujin backup: type return. ",						\
	CRLF "CONFIRMER que vous voulez RESTORER le %s à partir du backup de Gujin: taper Entrer. ",				\
	CRLF "ПОДТВЕРДИТЕ вас те ВОССТАНОВИТЬ %s от подпорки Gujin: напечатайте возвращение на машинке. ",			\
	CRLF "CONFÍRMELE quieren RESTAURAR el %s del respaldo de Gujin: mecanografíe la vuelta. ",				\
	CRLF "CONFERMA che vuoi RISTABILIRE il %s dal backup di Gujin: premi INVIO. ",	/* by Benny */				\
	CRLF "CONFIRME-O querem RESTAURAR o %s do apoio de Gujin: datilografe o retorno. ",					\
	CRLF "BESTÄTIGEN sie, dass das %s von der Gujin Sicherung WIEDERHERSTELLEN möchten: Drücken der Eingabetaste. ",	/* jj */	\
	CRLF "BEVESTIG u %s van file wilt HERSTELLEN Gujin: typ terugkeer. "							\
	)

#define DISK_BEERBOOT_CONFIRM_UPDATE_S MLTSTR ( \
	CRLF "CONFIRM you want to update Gujin backup of the %s: type return. ",				\
	CRLF "CONFIRMER que vous voulez mettre à jour le backup du %s de Gujin: taper Entrer. ",		\
	CRLF "ПОДТВЕРДИТЕ вас те уточнить подпорку Gujin %s: напечатайте возвращение на машинке. ",		\
	CRLF "CONFÍRMELE quieren poner al día el respaldo de Gujin del %s: mecanografíe la vuelta. ",		\
	CRLF "CONFERMA che vuoi aggiornare il backup di Gujin del %s: premi INVIO. ",	/* by Benny */		\
	CRLF "CONFIRME-O querem actualizar o apoio de Gujin do %s: datilografe o retorno. ",			\
	CRLF "BESTÄTIGEN sie, dass sie Gujin Sicherung von %s aktualisieren möchten: Drücken der Eingabetaste. ",	/* jj */	\
	CRLF "BEVESTIG u file Gujin van %s wilt bijwerken: typ terugkeer. "					\
	)

#define INFO_ADJUSTING_PARAMETERS_FROM_BOOTSECTOR_S MLTSTR ( \
	"Info: adjusting parameters from bootsector %s." CRLF,			\
	"Info: adjustement des paramètres suite au bootsecteur %s." CRLF,	\
	"Info: регулировать параметры от bootsector %s." CRLF,			\
	"Info: ajustando parámetro de bootsector %s." CRLF,			\
	"Info: aggiustando i parametri da bootsector %s." CRLF,	/* by Benny */	\
	"Info: ajustando parâmetros de bootsector %s." CRLF,			\
	"Info: Einstellung der Parameter vom Bootsektor %s." CRLF,	/* jj */	\
	"Info: verstellen variabele vanuit bootsector %s." CRLF			\
	)

#define INFO_ADJUSTING_SIZE_FROM_BOOTSECTOR_S MLTSTR ( \
	"Info: adjusting disk size from bootsector %s." CRLF,				\
	"Info: adjustement de la taille du disque suite au bootsecteur %s." CRLF,	\
	"Info: регулировать размер диска от bootsector %s." CRLF,			\
	"Info: ajustando parámetro de bootsector %s." CRLF,				\
	"Info: aggiustando la dimensione del disco da bootsector %s." CRLF,	/* by Benny */	\
	"Info: ajustando parâmetros de bootsector %s." CRLF,				\
	"Info: Einstellung der Laufwerkgröße vom Bootsektor %s." CRLF,		/* jj */	\
	"Info: verstellen variabele vanuit bootsector %s." CRLF				\
	)

#define WARNING_EXTENDED_PARTITION_BLOCK_NOT_FOUND_AT_LLU MLTSTR ( \
	"Warning: Extended partition block not found at LBA = %llu, ",			\
	"Attention: bloc de partition étendue non trouvé à LBA = %llu, ",		\
	"Предупреждение: Выдвинутый блок перегородки не найденный на LBA = %llu, ",	\
	"Advertencia: Alargada parte bloque no fundar a LBA = %llu, ",			\
	"Avviso: Blocco della partizione estesa non trovata a LBA = %llu, ",	/* by Benny */	\
	"Aviso: Estendido partição bloco não achado em LBA = %llu, ",			\
	"Warnung: Erweiterter Partitionsblock nicht gefunden an LBA = %llu, ",	/* jj */	\
	"Waarschuwen: Uitgebouwd verdeling takel niet stichten ter LBA = %llu, "	\
	)

#define WARNING_TWO_PARTITION_WITH_SAME_LABEL MLTSTR ( \
	"WARNING: partition %u of disk %s and partition %u of disk %s have the same label: \"%s\"" CRLF,	\
	"ATTENTION: partition %u du disque %s et partition %u du disque %s ont le meme nom: \"%s\"" CRLF,	\
	"WARNING: partition %u of disk %s and partition %u of disk %s have the same label: \"%s\"" CRLF,	\
	"WARNING: partition %u of disk %s and partition %u of disk %s have the same label: \"%s\"" CRLF,	\
	"ATTENZIONE: la partizione %u del disco %s ha la stessa etichetta della partizione %u o disco %s: \"%s\"" CRLF,	/* by Benny */	\
	"WARNING: partition %u of disk %s and partition %u of disk %s have the same label: \"%s\"" CRLF,	\
	"WARNING: Partition %u von Laufwerk %s und Partition %u von Laufwerk %s haben dasselbe Label: \"%s\"" CRLF,	/* jj?? */	\
	"WARNING: partition %u of disk %s and partition %u of disk %s have the same label: \"%s\"" CRLF	\
	)

#define WARNING_BEER_PARTITION_IN_EXTENDED_SPACE MLTSTR ( \
	"Warning: B.E.E.R. partition in extended partition",			\
	"Attention: partition B.E.E.R. dans la partition étendue",		\
	"Предупреждение: Перегородка B.E.E.R. в выдвинутой перегородке",	\
	"Advertencia: partición B.E.E.R. en la partición extendida",		\
	"Avviso: Partizione B.E.E.R. in partizione estesa",	/* by Benny */	\
	"Aviso: Divisória de B.E.E.R. em divisória prolongada",			\
	"Warnung: B.E.E.R. Partition in erweiterter Partition",	/* jj */	\
	"Het waarschuwen: B.E.E.R. verdeling in uitgebreide verdeling"		\
	)

#define ERROR_BEER_PARTITION_IN_USED_SPACE MLTSTR ( \
	"ERROR: B.E.E.R. partition outside free area",		\
	"ERREUR: partition B.E.E.R. dans une autre partition",	\
	"ОШИБКА: Перегородка B.E.E.R. вне свободной области",	\
	"ERROR: Partición de B.E.E.R. fuera del área libre",	\
	"ERRORE: Partizione B.E.E.R. fuori dalla zona libera",	/* by Benny */	\
	"ERRO: Divisória de B.E.E.R. fora da área livre",	\
	"STÖRUNG: B.E.E.R. Partition außerhalb des freien Bereichs",	/* jj */	\
	"FOUT: B.E.E.R. verdeling buiten vrij gebied"		\
	)

#define DISK_S_PARTITION_U_OVERLAP_DETECTED MLTSTR ( \
	"ERROR: %s partition %u, overlap detected!" CRLF,			\
	"ERREUR: %s chevauchement detecté sur la partition %u !" CRLF,		\
	"ОШИБКА: %s перегородка %u, обнаруженное перекрытие!" CRLF,		\
	"ERROR: ¡disco duro %s parte %u, superponer detectado!" CRLF,		\
	"ERRORE: disco %s partizione %u, rilevata sovrapposizione !" CRLF,	/* by Benny */	\
	"ERRO: disco duro %s partição %u, sobrepor-se detectado!" CRLF,		\
	"Fehler: Festplatte %s Partition %u, Überschneidung entdeckt!" CRLF,	/* jj */	\
	"FOUT: vaste schijf %s verdeling %u overlapping speurder!" CRLF		\
	)

#define DISK_S_PARTITION_U_FILESYS_BIGGER_PARTITION MLTSTR ( \
	"Warning: %s partition %u, filesystem bigger than partition!" CRLF,				\
	"Attention: %s système de fichier plus grand que la partition %u !" CRLF,			\
	"Предупреждение: %s перегородка %u, система файлов более большая чем перегородка!" CRLF,	\
	"Advertencia: ¡disco duro %s parte %u, filesystem mejor dar gracias parte!" CRLF,		\
	"Avviso: Disco %s partizione %u, filesystem più grande della partizione!" CRLF,	/* by Benny */	\
	"Aviso: disco duro %s partição %u, filesystem maior do que do que partição!" CRLF,		\
	"Warnung: Festplatte %s Partition %u, Dateisystem größer als Partition!" CRLF,	/* jj */	\
	"Het waarschuwen: %s verdeling %u, filesystem groter dan verdeling!" CRLF			\
	)

#define DISK_S_PARTITION_U_WASTES_U_SECTOR MLTSTR ( \
	"Warning: %s partition %u wastes %u sectors!" CRLF,			\
	"Attention: %s partition %u gaspille %u secteurs!" CRLF,		\
	"Предупреждение: перегородка %s %u расточительствует участки %u!" CRLF,	\
	"Advertencia: ¡%s partición %u pierde sectores de %u!" CRLF,		\
	"Avviso: %s partizione %u spreca i settori di %u!" CRLF,	/* by Benny syntax to be checked */	\
	"Aviso: %s divisória %u desperdiça setores de %u!" CRLF,		\
	"Warnung: %s Partition %u vergeudet %u Sektoren!" CRLF,		/* jj */	\
	"Het waarschuwen: schijf %s verdeling %u vaste %u sectoren!" CRLF	\
	)

#define PARTITION_CHS_MISMATCH_BIOS_CHS MLTSTR ( \
	"Disk %s: heads, sect/track mismatch: MBR %u/%u, BIOS %u/%u!" CRLF,				\
	"Disque %s: têtes, sect/piste différence: MBR %u/%u, BIOS %u/%u!" CRLF,				\
	"Диск %s: головки, участок/рассогласование следа: MBR %u/%u, BIOS %u/%u!" CRLF,			\
	"disco duro %s: ¡cabezas, área/pista mismatch: MBR %u/%u, BIOS %u/%u!" CRLF,			\
	"Disco %s: testa, settore/traccia non coincidenti: MBR %u/%u, BIOS %u/%u!" CRLF,	/* by Benny */	\
	"disco duro %s: cabeças, sector/caminho discrepância: MBR %u/%u, BIOS %u/%u!" CRLF,		\
	"Festplatte %s: Köpfe, Sektoren/Spur falsch angepasst: MBR %u/%u, BIOS %u/%u!" CRLF,	/* ?? */	\
	"Schijf %s: hoofden, sector/spoorwanverhouding: MBR %u/%u, BIOS %u/%u!" CRLF			\
	)

#define S_S_LAST_PARTITION_OVER_DISK_LIMIT_DETECTED_U_KB MLTSTR ( \
	"%s%s last partition over disk limit detected (%u Kb)!" CRLF,			\
	"%s%s la dernière partition déborde du disque (%u Ko)!" CRLF,			\
	"%s%s последняя перегородка над пределом диска обнаружила (Kb %u)!" CRLF,	\
	"¡%s%s último parte por disco confín detectado (%u Kb)!" CRLF,			\
	"%s%s rilevata ultima partizione oltre il limite del disco (%u Kb)!" CRLF,	/* by Benny */	\
	"%s%s último partição acima de disco limitar detectado (%u Kb)!" CRLF,		\
	"%s%s letzte Partition über Plattenlimit entdeckt (%u Kb)!" CRLF,		/* jj */	\
	"%s%s laatste verdeling over ontdekte schijfgrens (%u Kb)!" CRLF		\
	)

#define INFO_DISK_X_EXTENDED_BIOS_WITHOUT_EXTENDED_FCT_USE_BIOS MLTSTR ( \
	"Info: Disk 0x%X with EBIOS but without extended function, using BIOS." CRLF,					\
	"Info: Disque 0x%X avec EBIOS mais sans fonctions étendues, utilise BIOS." CRLF,				\
	"Info: Диск 0x%X с EBIOS но без выдвинутой функции, используя BIOS." CRLF,					\
	"Info: Disk 0x%X con EBIOS pero sin alargada función, usando BIOS." CRLF,					\
	"Info: Disco 0x%X con EBIOS ma senza funzione estesa, uso il BIOS." CRLF,	/* by Benny */			\
	"Info: Disco 0x%X com EBIOS mas sem estendido função, usando BIOS." CRLF,					\
	"Info: Festplatte 0x%X mit EBIOS aber ohne erweiterte Funktionen, benutze BIOS." CRLF,	/* ??!! */	\
	"Info: Disk 0x%X van EBIOS slechts zonder uitgebouwd verrichting using Standaard in- en uitvoersysteem." CRLF	\
	)

#define INFO_DISK_X_EXTENDED_BIOS_WITHOUT_EXTENDED_FCT_BUT_WORKS MLTSTR ( \
	"Info: Disk 0x%X with EBIOS claims without extended function, but EBIOS works." CRLF,		\
	"Info: Disque 0x%X avec EBIOS prétend sans fonctions étendues, mais EBIOS marche." CRLF,	\
	"Info: Диск 0x%X с претензиями EBIOS без расширенных функций, но EBIOS работ." CRLF,		\
	"Info: Disk 0x%X de las reclamaciones EBIOS sin función ampliada, pero EBIOS obras." CRLF,	\
	"Info: Disco 0x%X con EBIOS senza funzione estesa, ma EBIOS funziona." CRLF,	/* by Benny */	\
	"Info: Disco 0x%X com reivindicações EBIOS sem função estendida, mas EBIOS obras." CRLF,	\
	"Info: Festplatte 0x%X mit EBIOS angeblich ohne erweiterte Funktion, aber EBIOS funktioniert." CRLF,	/* ??!! */	\
	"Info: Disk 0x%X met EBIOS vorderingen zonder uitgebreid functie, maar EBIOS werken." CRLF		\
	)

#define DETECTING_DISKS_BOOTED_FROM MLTSTR ( \
	CRLF "Detecting disks (booted from BIOS 0x%X):",				\
	CRLF "Détection des disques (booté par BIOS 0x%X):",				\
	CRLF "Обнаруживать диски (booted от BIOS 0x%X):",				\
	CRLF "Detección de los discos (pateados de BIOS 0x%X):",			\
	CRLF "Rilevazione dei dischi (partito dal BIOS 0x%X):",	/* by Benny */		\
	CRLF "Detectando os discos (carreg de BIOS 0x%X):",				\
	CRLF "Entdecke Laufwerke (gebootet von BIOS 0x%X):",	/* jj */		\
	CRLF "Het ontdekken van schijven (die van BIOS 0x%X worden geïnitialiseerdf):"	\
	)

#define DETECTING_DISKS MLTSTR ( \
	CRLF "Detecting disks:",		\
	CRLF "Détection des disques:",		\
	CRLF "Обнаруживать диски:",		\
	CRLF "Detección de los discos:",	\
	CRLF "Rilevazione dei dischi:",	/* by Benny */	\
	CRLF "Detectando os discos:",		\
	CRLF "Entdecke Laufwerke:",	/* jj */	\
	CRLF "Het ontdekken van schijven:"	\
	)

#define CDROM_EMULATION_STOP MLTSTR ( \
	" (CDROM emulation on BIOS 0x%X stopped)",		\
	" (émulation CDROM sur BIOS 0x%X arrêté)",		\
	" (CDROM эмуляции по BIOS 0x%X остановлен)",		\
	" (Emulación del CD-ROM en BIOS 0x%X parado)",		\
	" (Emulazione del CDROM sul BIOS 0x%X arrestato)",	/* col o sul ? by Benny */	\
	" (A emulation do CDROM em BIOS 0x%X parou)",		\
	" (CD-ROM Emulation auf BIOS 0x%X gestoppt)",		/* jj */	\
	" (De wedijver van CD-rom op tegengehouden BIOS 0x%X)"	\
	)

#define CDROM_EMULATION_KEPT MLTSTR ( \
	" (keeping CDROM emulation on BIOS 0x%X)",			\
	" (émulation CDROM sur BIOS 0x%X active)",			\
	" (хранение эмуляции CDROM на BIOS 0x%X)",			\
	" (custodia de la emulación del CD-ROM en BIOS 0x%X)",		\
	" (conservazione dell'emulazione del CDROM sul BIOS 0x%X)",	/* tbc by Benny */	\
	" (mantendo a emulation do CDROM em BIOS 0x%X)",		\
	" (Beibehalten von CD-ROM Emulation auf BIOS 0x%X)",		/* jj */	\
	" (het houden van de wedijver van CD-rom op BIOS 0x%X)"		\
	)

#define HAVE_FOUND_U_DISKS MLTSTR ( \
	"Have found %u disks:" CRLF,		\
	"%u disques trouvés:" CRLF,		\
	"Найдите %u диска:" CRLF,		\
	"Han encontrado %u discos:" CRLF,	\
	"Ho trovato %u dischi:" CRLF,	/* by Benny */	\
	"Encontraram %u discos:" CRLF,		\
	"Habe %u Laufwerke gefunden:" CRLF,	/* jj */	\
	"%u schijven hebben gevonden:" CRLF	\
	)

#define ANALYSE_FILESYSTEM MLTSTR ( \
	"Analyse filesystems:",			\
	"Analyse les systèmes de fichiers:",	\
	"Проанализируйте системы файлов:",	\
	"Analice los sistemas de ficheros:",	\
	"Analizzo i filesystems:",	/* by Benny */	\
	"Analise filesystems:",			\
	"Analysiere Dateisysteme:",	/* jj */	\
	"Analyseer filesystems:"		\
	)

#define FILE_S_TOO_MANY_FRAGMENTS MLTSTR ( \
	" File %s has too many fragments." CRLF,		\
	" Fichier %s est trop fragmenté." CRLF,			\
	" %s файлов имеет слишком много осколков." CRLF,	\
	" Archivo %s ha fragmentos demasiado." CRLF,		\
	" Il File %s ha troppi frammenti." CRLF,	/* by Benny */	\
	" Arquivo tem %s fragmentos demais." CRLF,		\
	" Datei %s hat zu viele Fragmente." CRLF,	/* jj */	\
	" Bestand %s heeft te veel fragmenten." CRLF		\
	)

#define FOUND_D_ISO_D_WAY_TO_BOOT_U_INITRD MLTSTR ( \
	"   found %d ISO, %d ways to boot and %u initial RAM disks." CRLF,			\
	"   %d ISO, %d façons de booter; %u disques RAM initiaux." CRLF,			\
	"   нашл %d ISO, %d путя boot и %u начальных псевдодиска." CRLF,			\
	"   encontró %d ISO, %d maneras de patear y %u discos de RAM iniciales." CRLF,		\
	"   ha trovato %d ISO, %d modi di caricamento del sistema e %u RAMDISK iniziali." CRLF,	/* by Benny */	\
	"   encontrou %d ISO, %d maneiras carreg e %u discos de RAM iniciais." CRLF,		\
	"   %d ISO gefunden, %d Wege zu starten und %u initial RAM disks." CRLF,		/* ???? */	\
	"   vond %d ISO, %d manieren aan laars en %u aanvankelijke schijven van de RAM." CRLF	\
	)

#define FOUND_D_WAY_TO_BOOT_U_INITRD MLTSTR ( \
	"   found %d ways to boot and %u initial RAM disks." CRLF,			\
	"   %d façons de booter; %u disques RAM initiaux." CRLF,			\
	"   нашл %d путя boot и %u начальных псевдодиска." CRLF,			\
	"   encontró %d maneras de patear y %u discos de RAM iniciales." CRLF,		\
	"   ha trovato %d modi di caricamento del sistema e %u RAMDISK iniziali." CRLF,	/* by Benny */	\
	"   encontrou %d maneiras carreg e %u discos de RAM iniciais." CRLF,		\
	"   %d Wege gefunden zu starten und %u initial RAM disks." CRLF,		/* ???? */	\
	"   vond %d manieren aan laars en %u aanvankelijke schijven van de RAM." CRLF	\
	)

#define SMART_REPORT MLTSTR ( \
	"SMART report ",	\
	"SMART rapporte ",	\
	"SMART доклад ",	\
	"informes del SMART ",	\
	"rapporti di SMART ",	/* by Benny */	\
	"relatórios do SMART ",	\
	"SMART Report ",	/* jj */	\
	"SMART rapporten "	\
	)

#define SMART_THRESHOLD_EXCEED MLTSTR ( \
	": threshold exceeded condition!",		\
	": niveau d'alerte dépassé!",			\
	": порог превышен условие!",			\
	": ¡el umbral excedió la condición!",		\
	": la condizione ha superato la soglia!",	/* by Benny */	\
	": o ponto inicial excedeu a circunstância!",	\
	": Schwelle überstieg Bedingung!",		\
	": drempel overschreden voorwaarde!"		\
	)

#define SMART_DISABLED MLTSTR ( \
	": present and disabled!",		\
	": présent et désactivés!",		\
	": Настоящий и инвалидов!",		\
	": ¡presente e inhabilitado!",		\
	": presente e disabilitato !",	/* by Benny */	\
	": o presente e incapacitou!",		\
	": anwesend und gesperrt!",	/* jj?? */	\
	": heden en gehandicapten!"		\
	)

#define MSG_NO_BACKUP_OF MLTSTR ( \
	"no backup of",				\
	"pas de sauvegarde du",			\
	"Нет резервной копии",			\
	"ninguÌn respaldo",			\
	"nessun salvataggio di",	/* by Benny */	\
	"nenhum of alternativo",		\
	"keine Sicherung von",		/* jj */	\
	"geen reserve of"			\
	)

#define MSG_UNINSTALL_MBR_ERROR MLTSTR ( \
	"ERROR: %s the uninstall MBR" CRLF,		\
	"ERREUR: %s MBR de désinstallation" CRLF,	\
	"Ошибка: %s удаления MBR" CRLF,			\
	"ERROR: %s del desinstalar MBR" CRLF,		\
	"ERRORE: %s il disinstallare MBR" CRLF,	/* by Benny tbc */	\
	"ERRO: %s desinstalar MBR" CRLF,		\
	"FEHLER: %s Deinstallitions-MBR" CRLF,	/* jj?? */		\
	"FOUT: %s de desinstallatie MBR" CRLF		\
	)

#define MSG_UNINSTALL_MBR_SUCCESS MLTSTR ( \
	"The uninstall MBR has been successfully restored",		\
	"MBR de désinstallation restauré avec succès",			\
	"Удаления MBR был успешно восстановлен",			\
	"El desinstalar MBR se ha restaurado con éxito",		\
	"Il disinstallare MBR è stato ristabilito con successo",	/* by Benny ok */	\
	"Desinstalar MBR foi restaurado com sucesso",			\
	"Deinstallitions-MBR ist erfolgreich wieder hergestellt worden",	/* jj?? */ \
	"De desinstallatie MBR is met succes hersteld"			\
	)

/*
 * User Interface messages:
 */
#define NON_EDID_SCREEN MLTSTR ( \
	"Warning: no EDID from screen, assumes 13 inches diagonal." CRLF	\
"Your screen may become black if you ask a too high resolution.",		\
	"Attention: pas d'EDID d'écran, assume 13 pouces de diagonale." CRLF	\
"Votre écran peut devenir noir si vous passez à une trop grande resolution.",	\
	"Предупреждение: не EDID от экрана, предполагает 13 дюймов диагонали." CRLF	\
"На экране может стать черным, если вы попросите слишком высоким разрешением.",		\
	"Advertencia: ninguÌn EDID de la pantalla, asume 13 pulgadas de diagonal." CRLF	\
"Su pantalla puede llegar a ser negra si usted pide también la alta resolución.",	\
	"Avviso: nessun EDID dallo schermo, presuppone una diagonale di 13 pollici." CRLF	/* by Benny */	\
"Il vostro schermo può diventare nero se chiedete una risoluzione troppo alta.",	\
	"Aviso: nenhum EDID da tela, supor 13 polegadas diagonal." CRLF		\
"Sua tela pode tornar-se preta se você pede demasiado a alta resolução.",	\
	"Warnung: kein EDID vom Bildschirm, gehe von 13 Zoll Diagonale aus." CRLF	/* jj */	\
"Ihr Schirm kann schwarz werden, wenn sie eine zu hohe Auflösung anfordern.",	\
	"Het waarschuwen: geen EDID van het scherm, veronderstelt 13 duim diagonaal." CRLF	\
"Het uw scherm kan zwart worden als u te hoge resolutie vraagt."				\
	)

#define NEED_VGA_SUPPORT MLTSTR ( \
	"ERROR: This video card needs VGA support compiled-in.",			\
	"ERREUR: Cette carte vidéo a besoin du support VGA (recompiler).",		\
	"Ошибка: Эта видеокарта нуждается в поддержке VGA составлен.",			\
	"ERROR: Esta tarjeta video necesita la ayuda del VGA compilar-en.",		\
	"ERRORE: Questa scheda video ha bisogno del supporto VGA compilato.",	/* by Benny */	\
	"ERRO: Este cartão video precisa a sustentação do VGA compilar-em.",		\
	"Fehler: Diese Videokarte benötigt einkompilierte VGA-Unterstützung.",	/* jj */	\
	"FOUT: Deze videokaart vergt compileren-binnen VGA steun."			\
	)

#define VIDEO_CARD_CHANGED MLTSTR ( \
	"New video card, VGA parameters reseted.",		\
	"Nouvelle carte vidéo, paramètres VGA ré-initialisés.",	\
	"Новые видеокарты, VGA параметров reseted.",		\
	"La nueva tarjeta video, parámetros del VGA reseted.",	\
	"Nuova scheda video, parametri VGA reinizializzati.",	/* by Benny */	\
	"O cartão video novo, parâmetros do VGA reseted.",	\
	"Neue Videokarte, VGA-Parameter zurückgesetzt.",	/* jj */	\
	"De nieuwe videokaart, VGA parameters reseted."		\
	)

#define SCREEN_INTERFACE MLTSTR ( \
	"Screen interface: ",			\
	"Interface écran: ",			\
	"Интерфейс экрана: ",			\
	"Interfaz de la pantalla: ",		\
	"Interfaccia schermo: ",	/* by Benny */	\
	"Relação da tela: ",			\
	"Bildschirm-Schnittstelle: ",	/* jj */	\
	"De interface van het scherm: "		\
	)

#define UNKNOWN_SCREEN MLTSTR ( \
	"unknown screen." CRLF,		\
	"inconnu." CRLF,		\
	"Неизвестный экрана." CRLF,	\
	"pantalla desconocida." CRLF,	\
	"schermo sconosciuto." CRLF,	/* by Benny ok */	\
	"tela desconhecida." CRLF,	\
	"unbekannter Bildschirm." CRLF,	\
	"het onbekende scherm." CRLF	\
	)

#define BLACKWHITE_SCREEN MLTSTR ( \
	"B&W screen." CRLF,			\
	"noir et blanc." CRLF,			\
	"Черно-белый экран." CRLF,		\
	"pantalla blanco y negro." CRLF,	\
	"schermo in bianco e nero." CRLF,	/* by Benny ok */	\
	"tela preto e branco." CRLF,		\
	"Schwarzweiss-Bildschirm." CRLF,	/* jj */	\
	"het zwart-witte scherm." CRLF		\
	)

#define MONOCHROME_SCREEN MLTSTR ( \
	"monochrome screen." CRLF,		\
	"monochrome." CRLF,			\
	"Монохромный экран." CRLF,		\
	"pantalla monocromática." CRLF,		\
	"schermo monocromatico." CRLF,	/* by Benny ok */	\
	"tela monocromática." CRLF,		\
	"einfarbiger Bildschirm." CRLF,	/* jj */	\
	"het zwart-wit scherm." CRLF		\
	)

#define COLOR_SCREEN MLTSTR ( \
	"color screen." CRLF,			\
	"couleur." CRLF,			\
	"цвет экрана." CRLF,			\
	"pantalla del color." CRLF,		\
	"schermo a colori." CRLF,	/* by Benny */	\
	"tela da cor." CRLF,			\
	"Farbbildschirm." CRLF,		/* jj */	\
	"kleurenscherm." CRLF			\
	)

#define COLOR_SCREEN_TYPE_X MLTSTR ( \
	"color screen type 0x%X." CRLF,			\
	"couleur, type 0x%X." CRLF,			\
	"цвет экрана типа 0x%X." CRLF,			\
	"tipo 0x%X de la pantalla del color." CRLF,	\
	"tipo 0x%X dello schermo a colori." CRLF,	/* by Benny */	\
	"tipo 0x%X da tela da cor." CRLF,		\
	"Farbbildschirm-Typ 0x%X." CRLF,		/* jj */	\
	"het type 0x%X van kleurenscherm." CRLF	\
	)

#define EDID_TYPE MLTSTR ( \
	"        EDID: %ux%u @ %u Hz on a %u inches viewable monitor." CRLF,		\
	"        EDID: %ux%u @ %u Hz sur un moniteur de %u pouces visibles." CRLF,	\
	"        EDID: %ux%u @ %u Гц на мониторе дюймах диагонали %u." CRLF,		\
	"        EDID: %ux%u @ %u Hz en un monitor visible de %u pulgadas." CRLF,	\
	"        EDID: %ux%u @ %u Hz su un monitor osservabile da %u pollici." CRLF,	/* tbc by Benny */	\
	"        EDID: %ux%u @ %u Hz em um monitor viewable de %u polegadas." CRLF,	\
	"        EDID: %ux%u @ %u Hz auf einem %u-Zoll Monitor." CRLF,	/* jj?? */ \
	"        EDID: %ux%u @ %u Hz op een %u duim viewable monitor." CRLF		\
	)

#define EDID_FREQ MLTSTR ( \
	"        EDID frequency range: horizontal: %u-%u kHz, vertical: %u-%u Hz." CRLF,		\
	"        EDID zone de fréquence: horizontale: %u-%u kHz, verticale: %u-%u Hz." CRLF,		\
	"        EDID частотный диапазон: горизонтальная: %u-%u кГц, вертикальная: %u-%u Гц." CRLF,	\
	"        EDID gama de frecuencia: horizontal: %u-%u kilociclo, vertical: %u-%u Hz." CRLF,	\
	"        EDID gamma di frequenza: orizzontale: %u-%u chilohertz, verticale: %u-%u Hz." CRLF,	/* by Benny */	\
	"        EDID escala de freqüência: horizontal: %u-%u quilohertz, vertical: %u-%u Hz." CRLF,	\
	"        EDID Frequenzbereich: horizontal: %u-%u kHz, vertikal: %u-%u Hz." CRLF,		/* jj */	\
	"        EDID frequentie waaier: horizontaal: %u-%u kHz, verticaal: %u-%u Hz." CRLF		\
	)

/*
 * Menu messages:
 */
#define MSG_TOPLINE MLTSTR ( \
	"mode 0x%X: %s %s%s",		\
	"",				\
	"режима 0x%X: %s %s%s",		\
	"modo 0x%X: %s %s%s",		\
	"modo 0x%X: %s %s%s",	/* by Benny ok */	\
	"modalidade 0x%X: %s %s%s",	\
	"Modus 0x%X: %s %s%s",		\
	"wijze 0x%X: %s %s%s"		\
	)

#define MSG_GRAPHIC MLTSTR ( \
	"graphic",	\
	"graphique",	\
	"график",	\
	"gráfico",	\
	"grafico",	/* by Benny ok */	\
	"gráfico",	\
	"grafisch",	/* jj */	\
	"grafische"	\
	)

#define MSG_TEXT MLTSTR ( \
	"text",		\
	"texte",	\
	"текст",	\
	"texto",	\
	"testo",	/* by Benny ok */	\
	"texto",	\
	"text",		\
	"tekst"		\
	)

#define TOPLINE_CHARSIZE MLTSTR ( \
	", %ux%u font",			\
	", fonte %ux%u",		\
	", купель %ux%u",		\
	", fuente %ux%u",		\
	", fonte %ux%u",	/* font o fonte by Benny */	\
	", pia batismal %ux%u",		\
	", Schrift %ux%u",	/* jj Schriftgröße?? */	\
	", %ux%u doopvont"		\
	)

#define TOPLINE_NBMODES MLTSTR ( \
	", %u modes",		\
	"",			\
	", %u режима",		\
	", %u modo",		\
	", modo %u",	/* by Benny ok */	\
	", %u modalidade",	\
	", %u Modi",	/* jj */		\
	", %u wijze"		\
	)

#define TOPLINE_REFRESH MLTSTR ( \
	", refresh %u Hz",		\
	", rafraîchissement %u Hz",	\
	", освежите %u Hz",		\
	", restaure %u Hz",		\
	", frequenza di quadro a %u Hz",	/* by Benny */	\
	", refresque %u Hz",		\
	", Bildwiederholfrequenz %u Hz",	/* jj */	\
	", verfris %u Hz"		\
	)

#define MENU_SETUP MLTSTR ( \
	"Setup < >",			\
	"Config < >",			\
	"Установка < >",		\
	"Disposición < >",		\
	"Configurazione < >",	/* by Benny */	\
	"Instalação < >",		\
	"Einstellung < >",	/* Konfiguration ??! */	\
	"Opstelling < >"		\
	)

#define MENU_APPLICATION MLTSTR ( \
	"Appli < >",			\
	"",				\
	"применение < >",		\
	"uso < >",			\
	"applicazione < >",	/* by Benny ok */	\
	"aplicação < >",		\
	"Anwendung < >",		\
	"Toepassing < >"		\
	)

#define MENU_RESOLUTION MLTSTR ( \
	"Resolution: ",		\
	"Résolution: ",		\
	"Разрешение: ",		\
	"Resolución: ",		\
	"Risoluzione: ",	/* by Benny ok */	\
	"Definição: ",		\
	"Auflösung: ",		/* jj */	\
	"Resolutie: "		\
	)

#define MENU_COLORS MLTSTR ( \
	"Colors: ",		\
	"Couleurs: ",		\
	"цветы: ",		\
	"colores: ",		\
	"Colori: ",	/* by Benny ok */	\
	"cores: ",		\
	"Farben: ",		\
	"Kleuren: "		\
	)

#define MENU_DISPLAY_COLORS MLTSTR ( \
	"%u bpp ",	\
	"",		\
	"bpp %u ",	\
	"bpp %u ",	\
	"%u bpp",	/* by Benny ok */	\
	"bpp %u ",	\
	"bpp %u ",	\
	"bpp %u "	\
	)

/* Better not to translate "Lang" and "Lang/kbd", I can't read them in Russian: */
#define MENU_LANGUAGE    MLTSTR ( \
	"Lang: %s ",	\
	"",	\
	"",	\
	"",	\
	"",	\
	"",	\
	"",	\
	""	\
	)

#define MENU_LANGUAGE_KEYBOARD    MLTSTR ( \
	"Lang/kbd: %s/%s ",	\
	"",	\
	"",	\
	"",	\
	"",	\
	"",	\
	"",	\
	""	\
	)

#define MENU_NEXTLANG MLTSTR ( \
	"next <^T>",		\
	"suivant <^T>",		\
	"затем <^T>",		\
	"después <^T>",		\
	"successiva <^T>",	/* by Benny */	\
	"em seguida <^T>",	\
	"Nächste <^T>",	\
	"daarna <^T>"		\
	)

#define MENU_TO_TEXT MLTSTR ( \
	"go to text <.>",	\
	"va en texte <.>",	\
	"пойдите к тексту <.>",	\
	"vaya al texto <.>",	\
	"Modalità testo <.>",	/* by Benny */	\
	"vá ao texto <.>",	\
	"Zum Textmodus <.>",	/* jj */	\
	"ga naar tekst <.>"	\
	)


#define MENU_TO_GRAPHIC MLTSTR ( \
	"go to graphic <.>",		\
	"va en graphique <.>",		\
	"пойдите к графику <.>",	\
	"vaya al gráfico <.>",		\
	"Modalità grafica <.>",	/* by Benny ok */	\
	"vá ao gráfico <.>",		\
	"Zum Grafikmodus <.>",	/* jj */ \
	"ga naar grafisch <.>"		\
	)

/* There can be two modes with same definition and BPP, only one working: */
#define MENU_ALTERNATE MLTSTR ( \
	"Alternate <Tab>",	\
	"Autre <Tab>",		\
	"Дублирование <Tab>",	\
	"Suplente <Tab>",	\
	"Alternativa <Tab>",	/* by Benny ok */	\
	"Substituição <Tab>",	\
	"Alternate <Tab>",	/* ?? */ \
	"Vervanging <Tab>"	\
	)

#define HOME_KEYNAME MLTSTR ( \
	"<Home>",	\
	"<Début>",	\
	"<дома>",	\
	"<Casa>",	\
	"<Inizio>",		\
	"<Casa>",	\
	"<Pos 1>",	/* jj */	\
	"<Thuis>"	\
	)

#define END_KEYNAME MLTSTR ( \
	"<End>",	\
	"<Fin>",	\
	"<клавиатуры>",	\
	"<Final>",	\
	"<Fine>",	\
	"<Final>",	\
	"<Ende>",	\
	""		\
	)

#define PAGEUP_KEYNAME MLTSTR ( \
	"<PageUp>",		\
	"<Page Précédente>",	\
	"<страницы up>",	\
	"<Página-up>",		\
	"<Pagina-su>",	/* by Benny */	\
	"<Página-up>",		\
	"<Bild-Auf>",	/* jj */	\
	""			\
	)

#define PAGEDOWN_KEYNAME MLTSTR ( \
	"<PageDown>",		\
	"<Page Suivante>",	\
	"<страницы вниз>",	\
	"<Página-Down>",	\
	"<Pagina-giù>",	/* by Benny */	\
	"<Página-Down>",	\
	"<Bild-Ab>",	/* jj */	\
	""			\
	)

/* Todo: "Type ESC to run previous bootloader" */
#define NOT_EVEN_ONE_SELECTABLE_ITEM MLTSTR ( \
	"Not even one selectable item!",		\
	"Pas une seule sélection disponible !",		\
	"Не даже один дискретный деталь!",		\
	"¡No incluso un artículo seleccionable!",	\
	"Neppure un elemento selezionabile!",	/* by Benny */	\
	"Não mesmo um artigo selecionável!",		\
	"Sogar kein auswählbares Element!",	/* jj?? */	\
	"Niet zelfs één verkiesbaar punt!"		\
	)

      /*may be displayed on a 40 columns screen, keep short!*/
      /*1234567890123456789012345678901234567890*/
#define SMENU_verbose MLTSTR ( \
	"verbose",	\
	"bavard",	\
	"подробный",	\
	"prolijo",	\
	"prolisso",	/* by Benny */	\
	"",		\
	"ausführlich",	\
	"breedsprakig"	\
	)

#define SMENU_lock_bpp MLTSTR ( \
	"BPP locked when +/-",		\
	"BPP vérrouillé quand +/-",	\
	"BPP locked когда +/-",		\
	"BPP bloqueado cuando +/-",	\
	"BPP bloccato quando +/-",	/* by Benny ok */	\
	"BPP fechado quando +/-",	\
	"BPP gesperrt wenn +/-",	/* jj */	\
	"BPP sloot toen +/-"		\
	)

#define SMENU_lock_text_graphic MLTSTR ( \
	"text/graphic locked when +/-",			\
	"texte/graphique vérrouillé quand +/-",		\
	"тексту/графику locked когда +/-",		\
	"texto/gráfico bloqueado cuando +/-",		\
	"testo/grafico bloccato quando +/-",	/* by Benny ok */	\
	"texto/gráfico fechado quando +/-",		\
	"Text-/Grafik-Modus gesperrt wenn +/-",	/* jj */		\
	"tekst/grafisch sloot toen +/-"			\
	)

#define SMENU_menu_with_disk MLTSTR ( \
	"display disk in menu",			\
	"affiche les disques dans le menu",	\
	"диск дисплея в меню",			\
	"disco de la exhibición en menú",	\
	"mostra i dischi nel menu",	/* by Benny */	\
	"disco da exposição no menu",		\
	"Festplatte anzeigen im Menü",	/* jj */	\
	"vertonings schijf in menu"		\
	)

#define SMENU_menu_with_parttype MLTSTR ( \
	"display partition type in menu",					\
	"affiche le type des partitions dans le menu",				\
	"перегородка дисплея печатает внутри меню на машинке",			\
	"la partición de la exhibición mecanografía adentro el menú",		\
	"mostra i tipi di partizione nel menu",	/* by Benny */		\
	"a divisória da exposição datilografa dentro o menu",			\
	"Partitionstypen anzeigen im Menü",			/* jj */	\
	"het type van vertoningsverdeling in menu"				\
	)

#define SMENU_menu_with_partition MLTSTR ( \
	"display partition in menu",		\
	"affiche les partitions dans le menu",	\
	"перегородка дисплея в меню",		\
	"partición de la exhibición en menú",	\
	"mostra le partizioni nel menu",	/* by Benny */	\
	"divisória da exposição no menu",	\
	"Partitionen anzeigen im Menü",		/* jj */	\
	"vertonings verdeling in menu"		\
	)

#define SMENU_menu_with_initrd MLTSTR ( \
	"display initial RAM disks in menu",			\
	"affiche les disques RAM initiaux dans le menu",	\
	"псевдодиски дисплея начальные в меню",			\
	"discos de RAM iniciales en menú",			\
	"mostra i RAM disk iniziali nel menu",	/* by Benny */	\
	"discos de RAM iniciais no menu",			\
	"Initial RAM-Disks anzeigen im Menü",	/* ?? */	\
	"vertonings de aanvankelijke RAM in menu"		\
	)

#define SMENU_force_textmode MLTSTR ( \
	"force last text mode at startup",			\
	"force le dernier mode texte au démarrage",		\
	"режим текста усилия последний на запуске",		\
	"modo de texto pasado de la fuerza en el arranque",	\
	"forza l'ultima modalità testo alla partenza",	/* by Benny */	\
	"modalidade de texto da força última na partida",	\
	"Erzwinge letzten Textmodus beim Start",	/* ?? */	\
	"wijze van de kracht de laatste tekst bij opstarten"	\
	)

#define SMENU_probe_file_in_iso_image MLTSTR ( \
	"search files in ISO images",			\
	"cherche les fichiers dans les images ISO",	\
	"архивы поиска в изображениях ISO",		\
	"lime di ricerca nelle immagini di ISO",	\
	"cerca i files nelle immagini ISO",	/* by Benny */	\
	"limas da busca em imagens do ISO",		\
	"Suche Dateien in den ISO-Abbildern",	/* jj */	\
	"onderzoeks dossiers in de beelden van ISO"	\
	)

/* Shall we use the "root" embedded inside vmlinuz file, "man rdev", very often
   the root of the PC which compiled the kernel (think distributions) */
#define SMENU_force_probe_root MLTSTR ( \
	"force root probing",			\
	"force la détection de la racine",	\
	"зондировать корня усилия",		\
	"el sondar de la raíz de la fuerza",	\
	"forza la ricerca nella root",	/* by Benny */	\
	"sondagem da raiz da força",		\
	"Erzwinge root-Prüfung",	/* ?? */	\
	"kracht wortel het sonderen"		\
	)

#define SMENU_IDE_in_BIOS_order MLTSTR ( \
	"keep IDE in the BIOS order",		\
	"garde les IDEs dans l'ordre BIOS",	\
	"держите IDE в заказе BIOS",		\
	"mantenga el IDE la orden del BIOS",	\
	"mantieni IDE nell'ordine BIOS",	/* by Benny */	\
	"mantenha o IDE na ordem do BIOS",	\
	"Behalte IDE in der BIOS-Anordnung",	/* ?? */ \
	"houd winde in de BIOS orde"		\
	)

#define SMENU_ignore_kernel_option MLTSTR ( \
	"ignore kernel IDE options",				\
	"ignore les options IDE du noyau",			\
	"проигнорируйте варианты IDE стерженя",			\
	"no haga caso de las opciones del IDE del núcleo",	\
	"ignora l'IDE nelle opzioni del kernel",	/* by Benny */	\
	"ignore opções do IDE da semente",			\
	"Ignoriere Kernel IDE-Optionen",		/* jj */	\
	"negeer de opties van pitwinde"				\
	)

#define SMENU_disk_write_enable MLTSTR ( \
	"enable disk write",			\
	"autorise l'écriture des disques",	\
	"включите диск напишите",		\
	"permita el disco escriben",		\
	"abilita la scrittura su disco",	/* by Benny */	\
	"permita o disco escrevem",		\
	"Ermögliche Beschreiben des Laufwerkes",	/* jj */	\
	"laat schijf toe schrijven"		\
	)

#define SMENU_disk_write_enable_but_bootdevice MLTSTR ( \
	"enable disk write (boot device read only)",					\
	"autorise l'écriture des disques (disque de boot ininscriptible)",		\
	"включите диск напишите (прибор ботинка прочитанный только)",			\
	"permita el disco escriben (el dispositivo de cargador leído solamente)",	\
	"abilita la scrittura su disco (dispositivo di boot in sola lettura)",	/* by Benny */	\
	"permita o disco escrevem (o dispositivo de carregador lido somente)",		\
	"Ermögliche Beschreiben des Laufwerkes (Boot-Laufwerke schreibgeschützt)",	/* ?? */ \
	"laat schijf toe schrijven (slechts gelezen laarsapparaat)"			\
	)

#define SMENU_hide_unhide_partitions MLTSTR ( \
	"manage visible/hidden partitions",			\
	"Gère les partitions vues/cachées",			\
	"управляйте видимыми/спрятанными перегородками",	\
	"maneje las particiones visibles/ocultadas",		\
	"gestisci le partizioni visibili/nascoste",	/* by Benny */	\
	"controle divisórias visíveis/escondidas",		\
	"Handhabe sichtbare/versteckte Partitionen",	/* ?? */ \
	"leid zichtbare/verborgen verdelingen"			\
	)

#define SMENU_VGA_interface MLTSTR ( \
	"VGA interface",		\
	"interface VGA",		\
	"Интерфейс VGA",		\
	"Interfaz del VGA",		\
	"interfaccia VGA",	/* by Benny */	\
	"Relação do VGA",		\
	"VGA-Schnittstelle",		\
	""				\
	)

#define SMENU_use_gujin_embedded_font MLTSTR ( \
	"use Gujin's embedded font",			\
	"utilise la police de Gujin",			\
	"используйте врезанную купель Gujin",		\
	"utilice la fuente encajada de Gujin",		\
	"usa il font di base di Gujin",	/* by Benny */	\
	"usi la fonte incastonata di Gujin",		\
	"Benutze eingebettete Schriftart von Gujin",	/* jj */	\
	"gebruik ingebedde doopvont van Gujin"		\
	)

#define SMENU_VESA_interface MLTSTR ( \
	"VESA interface",		\
	"interface VESA",		\
	"Интерфейс VESA",		\
	"Interfaz del VESA",		\
	"Interfaccia VESA",	/* by Benny */	\
	"Relação do VESA",		\
	"VESA-Schnittstelle",		\
	""				\
	)

#define SMENU_enable_VESA_hardwin MLTSTR ( \
	"VESA window I/O detection",		\
	"détection I/O fenêtre VESA",		\
	"VESA I/O окно обнаружения",		\
	"detección ventana I/O VESA",		\
	"rilevazione I/O della finestra VESA",	/* by Benny */	\
	"deteção janela I/O VESA",		\
	"VESA Fenster I/O Erkennung",		/* jj */	\
	"VESA I/O venster opsporing"		\
	)

#define SMENU_VESA2_interface MLTSTR ( \
	"VESA linear interface",	\
	"interface linéaire VESA",	\
	"VESA Линейная интерфейса",	\
	"Interfaz linear VESA",		\
	"interfaccia lineare VESA",	/* by Benny */	\
	"Relação linear VESA",		\
	"VESA lineare Schnittstelle",	\
	"Lineaire interface VESA"	\
	)

#define SMENU_enable_joystick MLTSTR ( \
	"enable Joystick",			\
	"active le Joystick",			\
	"включить джойстик",			\
	"permita la palanca de mando",		\
	"abilita il Joystick",	/* by Benny */	\
	"permita o manche",			\
	"Ermögliche Joystick-Steuerung",	/* ?? */	\
	"laat Bedieningshendel toe"		\
	)

#define SMENU_search_disk_mbr MLTSTR ( \
	"search disk's MBR",		\
	"cherche les MBRs des disques",	\
	"Поиск диска MBR",		\
	"búsqueda disco MBR",		\
	"ricerca l'MBR del disco",	/* by Benny */	\
	"busca disco MBR",		\
	"Suche Laufwerks-MBR",		/* ?? */ \
	"onderzoeks schijf MBR"		\
	)

#define SMENU_search_part_mbr MLTSTR ( \
	"search partition's PBR",		\
	"cherche les PBRs des partitions",	\
	"Поиск секции PBR",			\
	"búsqueda partición PBR",		\
	"ricerca il PBR della partizione",	/* by Benny */	\
	"busca divisória PBR",			\
	"Suche Partitions-PBR",			/* jj?? */	\
	"onderzoeks verdeling PBR"		\
	)

#define SMENU_keep_all_part_mbr MLTSTR ( \
	"keep all partition's PBR",		\
	"garde tous les PBR des partitions",	\
	"сохранить все секции PBR",		\
	"guarde toda la PBR de partición",	\
	"mantieni i PBR di tutte le partizioni",	/* by Benny */	\
	"mantenha toda a PBR de divisória",	\
	"Behalte alle Partitions-PBR",			/* jj?? */	\
	"houd al PBR schijfverdeling"		\
	)

#define SMENU_search_el_torito MLTSTR ( \
	"search El-Torito sessions",		\
	"cherche les sessions El-Torito",	\
	"Поиск сессий El-Torito",		\
	"búsqueda sesiones de EL-Torito",	\
	"ricerca sessioni EL-Torito",	/* by Benny */	\
	"busca sessões de EL-Torito",		\
	"Suche El-Torito Sitzungen",	/* ?? */	\
	"zittingen van onderzoeks El-Torito"	\
	)

#define SMENU_search_topdir_files MLTSTR ( \
	"search files in root",			\
	"cherche les fichiers dans la racine",	\
	"Поиск файлов в корневом",		\
	"búsqueda archivos en raíz",		\
	"ricerca i files nella radice",	/* by Benny */	\
	"busca limas na raiz",			\
	"Suche Dateien im Hauptverzeichnis",	/* jj?? */	\
	"onderzoeks dossiers in wortel"		\
	)

#define SMENU_search_subdir_files MLTSTR ( \
	"search files in directory",			\
	"cherche les fichiers dans le répertoire",	\
	"Поиск файлов в каталоге",			\
	"búsqueda archivos en directorio",		\
	"ricerca i file nella directory",	/* by Benny */	\
	"busca limas no diretório",			\
	"Suche Dateien im Verzeichnis",		/* jj */	\
	"onderzoeks dossiers in folder"			\
	)

#define SMENU_probe_bios_floppy_disk MLTSTR ( \
	"probe BIOS floppy disks",		\
	"détecte les disquettes BIOS",		\
	"зонда BIOS гибких дисков",		\
	"detecte diskettes del BIOS",		\
	"rileva floppy BIOS",	/* by Benny */	\
	"detecte discos flexíveis do BIOS",	\
	"Probiere BIOS-Disketten",	/* jj */	\
	"ontdek BIOS diskettes"			\
	)

#define SMENU_probe_bios_hard_disk MLTSTR ( \
	"probe BIOS hard disks",		\
	"détecte les disques durs BIOS",	\
	"зонда BIOS жесткие диски",		\
	"detecte discos duros del BIOS",	\
	"rileva hard disks BIOS",	/* by Benny */	\
	"detecte discos rígidos do BIOS",	\
	"Probiere BIOS-Festplatten",	/* jj */	\
	"ontdek BIOS harde schijven"		\
	)

#define SMENU_probe_ide_disk MLTSTR ( \
	"probe IDE disks",			\
	"détecte les disques IDE",		\
	"зонда IDE дисков",			\
	"detecte discos duros del IDE",		\
	"rileva hard disks IDE",	/* by Benny */	\
	"detecte discos rígidos do IDE",	\
	"Probiere IDE-Festplatten",	/* jj */	\
	"ontdek IDE harde schijven"		\
	)

#define SMENU_probe_cdrom MLTSTR ( \
	"probe CDROMs and DVDs",	\
	"détecte les CDROMs et DVDs",	\
	"зонда CDROMs и DVD",		\
	"detecte los CD-ROM y DVDs",	\
	"rileva i CDROMs e DVDs",	/* by Benny */	\
	"detecte os CDROMs e o DVDs",	\
	"Probiere CD-ROMs und DVDs",	/* jj */	\
	"ontdek CD-roms en DVDs"	\
	)

#define SMENU_probe_dos_disk MLTSTR ( \
	"probe DOS disks",			\
	"détecte les disques DOS",		\
	"зонд DOS диски",			\
	"detecte discos duros del DOS",		\
	"rileva dischi DOS",	/* by Benny */	\
	"detecte discos rígidos do DOS",	\
	"Probiere DOS-Festplatten",	/* jj */	\
	"ontdek DOS harde schijven"		\
	)

#define SMENU_probe_BDI_FILE MLTSTR ( \
	"probe BDI image files",		\
	"détecte les fichiers images BDI",	\
	"зонда BDI файлов изображений",		\
	"detecte los archivos de imagen BDI",	\
	"rileva file immagine BDI",	/* by Benny */	\
	"detecte limas de imagem BDI",		\
	"Probiere BDI Abbilddateien",	/* jj */	\
	"ontdek BDI beelddossiers"		\
	)

#define SMENU_PROBE_VESA MLTSTR ( \
	"probe VESA modes 0..0x7F",			\
	"analyse les modes VESA 0..0x7F",		\
	"зонда режимы VESA 0x14..0x7F",			\
	"analice los modos 0..0x7F de VESA",		\
	"rileva modalità VESA 0..0x7F",	/* by Benny */	\
	"analise as modalidades 0..0x7F de VESA",	\
	"Analysiere VESA Modi 0..0x7F",	/* ?? */	\
	"analyseer VESA wijzen 0..0x7F"			\
	)

#define SMENU_PROBE_VGA_0_13 MLTSTR ( \
	"probe VGA modes 0..0x13",			\
	"analyse les modes VGA  0..0x13",		\
	"зонда режимы VGA 0..0x13",			\
	"analice los modos 0..0x13 de VGA",		\
	"rileva modalità VGA 0..0x13",	/* by Benny */	\
	"analise as modalidades 0..0x13 de VGA",	\
	"Analysiere VGA Modi 0..0x13",	/* ?? */	\
	"analyseer VGA wijzen 0..0x13"			\
	)

#define SMENU_PROBE_VGA_14_127 MLTSTR ( \
	"probe VGA modes 0x14..0x7F",			\
	"analyse les modes VGA 0x14..0x7F",		\
	"зонда режимы VGA 0x14..0x7F",			\
	"analice los modos 0x14..0x7F de VGA",		\
	"rileva modalità VGA 0x14..0x7F",	/* by Benny */	\
	"analise as modalidades 0x14..0x7F de VGA",	\
	"Analysiere VGA Modi 0x14..0x7F",	/* ?? */	\
	"analyseer VGA wijzen 0x14..0x7F"		\
	)

#define SMENU_RESET_VGA_MODES MLTSTR ( \
	"reset VGA/VESA modes 0..0x7F",			\
	"réinitialise les modes VGA/VESA 0..0x7F",	\
	"сбросить 0..0x7F режимы VGA/VESA",		\
	"reajuste los modos de VGA/VESA",		\
	"ripristina modalità VGA/VESA 0..0x7F",	/* by Benny */	\
	"restaure modalidades de VGA/VESA",		\
	"Stellt VGA/VESA Modi 0..0x7F zurück",	/* jj */	\
	"het terugstellen VGA/VESA wijzen"		\
	)

#define SMENU_RESET_ALL_PARAMS MLTSTR ( \
	"reset all saved parameters",				\
	"réinitialise tous les paramètres",			\
	"сбросить все сохраненные параметры",			\
	"reajuste todos los parámetros ahorrados",		\
	"ripristina tutti i parametri salvati",	/* by Benny */	\
	"restaure todos os parâmetros conservados",		\
	"Stellt alle gespeicherten Parameter zurück",	/* jj */	\
	"stel alle bewaarde parameters terug"			\
	)

#define SMENU_POWER_DOWN MLTSTR ( \
	"turn power off",		\
	"éteind l'ordinateur",		\
	"Отключение питания",		\
	"corte la corriente",		\
	"spegni il computer",	/* by Benny */	\
	"desligue o poder",		\
	"Ausschalten",		/* jj */	\
	"draai macht weg"		\
	)

#define SMENU_EXIT_TO_DOS MLTSTR ( \
	"exit to DOS",				\
	"sortie vers DOS",			\
	"Выйдите в DOS",			\
	"salga al DOS",				\
	"esci a DOS",	/* by Benny */		\
	"retire ao DOS",			\
	"Ausgang zu DOS",	/* jj?? */	\
	"uitgang aan DOS"			\
	)

#define SMENU_STOP_CDROMEMUL MLTSTR ( \
	"set stop CDROM FD/HD emulation",			\
	"configure arrêt émulation FD/HD CDROM",		\
	"Установка стоп эмуляции CDROM FD/HD",			\
	"emulación determinada del CD-ROM FD/HD de la parada",	\
	"ferma l' emulazione del CDROM FD/HD",	/* by Benny */	\
	"emulation ajustada do CDROM FD/HD do batente",		\
	"Setze Beendigung der Emulation CD-ROM FD/HD",	/* jj */	\
	"de vastgestelde wedijver van eindeCD-rom FD/HD"	\
	)

#define SMENU_SET_MIN_INIRTD_CHAR MLTSTR ( \
	"set min nb char initrd",			\
	"configure min nb char initrd",			\
	"Set минимальное число символов initrd",	\
	"Minuto NOTA del carbón de leña para initrd",	\
	"definisci il minimo di caratteri di initrd",	/* by Benny to be verified */	\
	"Número mínimo de carvão animal para initrd",	\
	"Mindestzeichenanzahl für initrd",		/* ?? */	\
	"Min aantal klusje voor initrd"			\
	)

#define SMENU_SET_TIME_OFFSET MLTSTR ( \
	"set time offset",			\
	"configure le décalage horaire",	\
	"Установка времени смещение",		\
	"fije la compensación de tiempo",	\
	"fissa l'offset di tempo",	/* by Benny */	\
	"ajuste o offset de tempo",		\
	"Setze Stundenversatz",		/* jj */	\
	"vastgestelde tijdcompensatie"		\
	)

#define SMENU_SET_TIMEOUT_AUTOLOAD MLTSTR ( \
	"set auto-booting timeout",					\
	"configure timeout auto-démarrage",				\
	"набор автоматическая загрузка тайм-аут",			\
	"descanso auto determinado del cargador",			\
	"definisci la temporizzazione della partenza automatica",	/* by Benny */	\
	"auto intervalo de parada ajustado do carregador",		\
	"Setze Sekundenlimit fürs automatische Starten",		/* jj */	\
	"vastgestelde autolaarsonderbreking"				\
	)

#define SMENU_SET_KEYBOARD MLTSTR ( \
	"change keyboard type",				\
	"configure le type du clavier",			\
	"Изменение типа клавиатуры",			\
	"cambie el tipo del teclado",			\
	"cambia il tipo di tastiera",	/* by Benny */	\
	"mude o tipo do teclado",			\
	"Ändere Tastaturtyp",		/* jj */	\
	"het type van veranderingstoetsenbord"		\
	)

#define SMENU_SET_COMMANDLINE MLTSTR ( \
	"change command line",			\
	"configure la ligne de commande",	\
	"изменить командной строки",		\
	"cambie la línea de comando",		\
	"cambia la linea di comando",	/* by Benny */	\
	"mude a linha de comando",		\
	"Ändere Kommandozeile",		/* jj */	\
	"verandering bevel lijn"		\
	)

#define MSG_DIRECTORY_NAME MLTSTR ( \
	"parsed directory: ",		\
	"répertoire analysé: ",		\
	"анализируется каталога: ",	\
	"directorio de analizar: ",	\
	"directory analizzata: ",	/* by Benny */	\
	"diretório parsed: ",		\
	"analysiertes Verzeichnis: ",	/* jj */	\
	"directory ontleed: "		\
	)

#define SMENU_SET_PARSED_DIRECTORY_NAME MLTSTR ( \
	"change name of parsed directory",		\
	"change le nom du répertoire analysé",		\
	"Изменение названия анализируется каталога",	\
	"cambio de nombre del directorio de analizar",	\
	"cambia il nome della directory analizzata",	/* by Benny */	\
	"mudança de nome do diretório parsed",		\
	"Ändere Namen vom analysierten Verzeichnis",	/* jj */ \
	"verandering naam van de directory ontleed"	\
	)

#define SMENU_SET_ENDEXTPART MLTSTR ( \
	"set the end of the extended partition",		\
	"configure la fin de la partition étendue",		\
	"установить к концу расширенный раздел",		\
	"fije el extremo de la partición extendida",		\
	"definisci la fine della partizione estesa",	/* by Benny */	\
	"ajuste a extremidade da divisória prolongada",		\
	"Setze das Ende der erweiterten Partition",	/* jj */ \
	"plaats het eind van de uitgebreide verdeling"		\
	)

#define SMENU_UNINSTALL MLTSTR ( \
	"uninstall Gujin MBR",		\
	"désinstalle Gujin MBR",	\
	"удалить Gujin MBR",		\
	"desinstale Gujin MBR",		\
	"disinstalla l'MBR di Gujin",	/* by Benny */	\
	"desinstale Gujin MBR",		\
	"Deinstalliere Gujin MBR",	/* jj */	\
	"desinstallatie Gujin MBR"	\
	)

#define MENU_UNKNOWN_KEY MLTSTR ( \
	"Unknown command (keycode 0x%X).",			\
	"Commande inconnue (code touche 0x%X).",		\
	"Неизвестный команды (код 0x%X).",			\
	"Comando desconocido (código del teclado 0x%X).",	\
	"Comando sconosciuto (codice della tastiera 0x%X).",	/* by Benny */	\
	"Comando desconhecido (código do teclado 0x%X).",	\
	"Unbekannter Befehl (Tastaturcode 0x%X).",		\
	"Onbekend bevel (toetsenbord code 0x%X)."		\
	)

#define MSG_ERROR_KEYCODE MLTSTR ( \
	"ERROR: keycode 0x%X" CRLF,			\
	"ERREUR: code touche 0x%X" CRLF,		\
	"Ошибка: код 0x%X" CRLF,			\
	"ERROR: código del teclado 0x%X" CRLF,		\
	"ERRORE: codice della tastiera 0x%X" CRLF,	/* by Benny ok */	\
	"ERRO: código do teclado 0x%X" CRLF,		\
	"Fehler: Tastaturcode 0x%X" CRLF,		/* jj */	\
	"FOUT: toetsenbord code 0x%X" CRLF		\
	)

#define MSG_STOP_CDROMEMUL MLTSTR ( \
	"stop CDROM emulation: [0:never 1:early 2:late]: ",			\
	"arrêt emulation CDROM: [0:jamais 1:tôt 2:tard]: ",			\
	"остановить CDROM эмуляции: [0: никогда не 1: начало 2: поздно]: ",	\
	"pare la emulación del CD-ROM: [0: nunca 1: temprano 2: tarde]: ",	\
	"arresta l'emulazione del CDROM: [0: mai 1: presto 2: ritardata]: ",	/* by Benny */	\
	"pare a emulation do CDROM: [0: nunca 1: cedo 2: tarde]: ",		\
	"Stoppe CD-ROM Emulation: [0:nie 1:früh 2:spät]: ",			/* jj */	\
	"de wedijver van eindeCD-rom: [0: nooit 1: vroeg 2: recent]: "		\
	)

#define MSG_MIN_NB_CHAR_INITRD MLTSTR ( \
	"Min nb of char for initrd [0..9]: ",			\
	"Nombre minimum charactères initrd [0..9]: ",		\
	"Минимальное количество символов для initrd [0..9]: ",	\
	"Minuto NOTA del carbón de leña para initrd [0..9]: ",	\
	"Numero minimo di caratteri per initrd [0..9]: ",	/* by Benny */	\
	"Número mínimo de carvão animal para initrd [0..9]: ",	\
	"Mindestanzahl der Zeichen für initrd [0..9]: ",	/* jj */	\
	"Min aantal klusje voor initrd [0..9]: "		\
	)

#define MSG_TIME_OFFSET MLTSTR ( \
	"time offset ('+' to add, '-' to subtract): ",					\
	"décalage horaire ('+' pour ajouter, '-' pour retrancher): ",			\
	"Смещение времени ('+' для добавления, '-' для вычитания): ",			\
	"compensación de tiempo ('+' para agregar, '-' para restar): ",			\
	"offset di tempo ('+' per per aggiungere, '-' per per sottrarre): ",	/* by Benny */	\
	"offset de tempo ('+' para adicionar, '-' para subtrair): ",			\
	"Stundenversatz ('+' hinzufügen, '-' abziehen): ",	/* jj only with german keyboard */	\
	"tijd compensatie ('+' om toe te voegen, '-' om af te trekken): "		\
	)

#define MSG_TIMEOUT_AUTOLOAD MLTSTR ( \
	"Timeout autoload [0..99] (in seconds, 0: none): ",					\
	"Timeout autochargement [0..99] (en secondes, 0: aucun): ",				\
	"Таймаут автоматическая загрузка [0..99] (в секундах, 0: none): ",			\
	"Carga automática del descanso [0..99] (en segundos, 0: ningunos): ",			\
	"Carica automatica di prespegnimento [0..99] (in secondi, 0: nessun): ",	/* by Benny */	\
	"Carregamento automático do intervalo de parada [0..99] (nos segundos, 0: nenhuns): ",	\
	"Zeitversatz fürs automatische Starten [0..99] (in Sekunden, 0: kein): ",	/* ?? */	\
	"Het automatisch laden van de onderbreking [0..99] (in seconden, 0: niets): "		\
	)

#define MSG_KEYBOARD_PRESS MLTSTR ( \
	"Press key: %c ",		\
	"Presser la touche: %c ",	\
	"Нажмите клавишу: %c ",		\
	"Llave de la prensa: %c ",	\
	"Premi il tasto: %c ",	/* by Benny */	\
	"Chave da imprensa: %c ",	\
	"Drücke Taste: %c ",	/* jj */	\
	"Duw op sleutel: %c "		\
	)

#define MSG_KBD_NOW_PRESS MLTSTR ( \
	", now press: %c ",		\
	", presser: %c ",		\
	", теперь нажмите: %c ",	\
	", ahora presiona: %c ",	\
	", ora premi: %c ",	/* by Benny */	\
	", pressionam agora: %c ",	\
	", Betätigen sie jetzt: %c ",	/* jj */	\
	", drukken nu: %c "		\
	)

#define MSG_COMMAND_LINE MLTSTR ( \
	"Command line: ",		\
	"Ligne de commande: ",		\
	"Командная строка: ",		\
	"Línea de comando: ",		\
	"Linea di comando: ",	/* by Benny */	\
	"linha de comando: ",		\
	"Kommandozeile: ",	/* jj */	\
	"Bevel lijn: "			\
	)

#define NO_MODE_FOUND MLTSTR ( \
	"No mode found.",			\
	"Pas de mode trouvé.",			\
	"Режим не найден.",			\
	"NinguÌn modo encontrado.",		\
	"Nessun modo trovato.",	/* by Benny */	\
	"Nenhuma modalidade encontrada.",	\
	"Kein Modus gefunden.",	/* jj */	\
	"Geen gevonden wijze."			\
	)

#define MODE_X_U_U_OVER_MONITOR_SPEC MLTSTR ( \
	"Mode 0x%X, %ux%u is over monitor specs.",				\
	"Mode 0x%X, %ux%u est au dessus des spéc. du moniteur.",		\
	"Режим 0x%X, %ux%u находится над монитором спецификации.",		\
	"El modo 0x%X, %ux%u está sobre especificaciones del monitor.",		\
	"Il modo 0x%X, %ux%u è superiore alle specifiche del monitor.",	/* by Benny */	\
	"A modalidade 0x%X, %ux%u está sobre especificações do monitor.",	\
	"Modus 0x%X, %ux%u ist über Monitorspezifikationen.",			\
	"De wijze 0x%X, %ux%u is over monitorspecificaties."			\
	)

#define ERROR_VGAVESA_SWITCH_FAILED MLTSTR ( \
	"ERROR: %s switch failed!" CRLF,			\
	"ERREUR: passage en %s raté !" CRLF,			\
	"Ошибка: %s коммутатора Неудача!" CRLF,			\
	"ERROR: ¡El interruptor de %s falló!" CRLF,		\
	"ERRORE: Deviazione di %s fallito" CRLF,	/* by Benny */	\
	"ERRO: O interruptor de %s falhou!" CRLF,		\
	"Fehler: %s Schalter gescheitert!" CRLF,	/* jj?? */	\
	"FOUT: Ontbroken schakelaar %s!" CRLF			\
	)

#define SETTING_MODE_X MLTSTR ( \
	"   Setting mode 0x%X",			\
	"   Passage au mode 0x%X",		\
	"   Режим 0x%X",			\
	"   Modo 0x%X del ajuste",		\
	"   Passaggio alla modalità 0x%X",	/* by Benny */	\
	"   Modalidade 0x%X do ajuste",		\
	"   Einstellungsmodus 0x%X",		/* ?? */ \
	"   Plaatsende wijze 0x%X"		\
	)

/*
 * Loader messages:
 */
#define ERROR_HIDE_UNHIDE_X MLTSTR2 ( \
	"Error 0x%X while partition hiding/unhiding ",			\
	"Erreur 0x%X pendant cache/montre partitions ",			\
	"Ошибка 0x%X хотя раздела скрытие/отображение ",		\
	"Erro 0x%X quando esconder da divisória/que mostra ",		\
	"Errore 0x%X nel nascondere/mostrare la partizione",	/* by Benny */	\
	"Erro 0x%X quando esconder da divisória/que mostra ",		\
	"Fehler 0x%X beim Verstecken/Aufdecken der Partition",	/* jj?? */	\
	"Fout 0x%X terwijl/verdeling die verbergt toont "		\
	)

#define ERROR_HIDE_UNHIDE_READONLY MLTSTR2 ( \
	"(check '%s')",			\
	"(vérifier '%s')",		\
	"(Проверка '%s')",		\
	"(compruébelo '%s')",		\
	"(controllilo '%s')",		\
	"(verifico '%s')",	/* by Benny */	\
	"(überprüfe '%s')",	/* jj */	\
	"(controleer het '%s')"		\
	)

/* Some old BIOS refuse to write sector 0 (MBR) of hard disk and call that antivirus: */
#define ERROR_HIDE_UNHIDE_VIRUS MLTSTR2 ( \
	"(check BIOS antivirus)",			\
	"(vérifier antivirus BIOS)",			\
	"(Проверьте BIOS антивирусных программ)",	\
	"(compruebe el antivirus del BIOS)",		\
	"(controllo l'antivirus del BIOS)",	/* by Benny */	\
	"(verific o antivirus do BIOS)",		\
	"(Überprüfen Sie Antivirus-Einstellungen im BIOS)",	/* jj */	\
	"(controleer BIOS antivirus)"			\
	)

#define ERROR_HIDE_UNHIDE_UNCHANGED MLTSTR2 ( \
	"(disk content unchanged)",			\
	"(contenu disques inchangés)",			\
	"(содержание диска без изменений)",		\
	"(sin cambios contento del disco)",		\
	"(contenuto del disco inalterato)",	/* by Benny */	\
	"(inalterado satisfeito do disco)",		\
	"(Laufwerksinhalt unverändert)",	/* jj */	\
	"(onveranderde schijfinhoud)"			\
	)

#define LOADING_KERNEL_S MLTSTR2 ( \
	"Loading kernel \"%s\",",		\
	"Chargement noyau \"%s\",",		\
	"Стержень нагрузки \"%s\",",		\
	"El núcleo \"%s\" del cargamento,",	\
	"Caricando il kernel \"%s\",",	/* by Benny */	\
	"A semente \"%s\" do carregamento,",	\
	"Lade Kernel \"%s\",",		/* jj */	\
	"Pit \"%s\" van de lading,"		\
	)

#define LOADING_INITRD_S MLTSTR2 ( \
	"loading initial RAM disk \"%s\",",				\
	"chargement disque RAM initial \"%s\",",			\
	"псевдодиск нагрузки начальный \"%s\",",			\
	"disco de RAM inicial \"%s\" del cargamento,",			\
	"caricando il RAM disk iniziale \"%s\",",	/* by Benny */	\
	"disco de RAM inicial \"%s\" do carregamento,",			\
	"Lade initial RAM disk \"%s\",",		/* jj?? */	\
	"het laden van aanvankelijke schijf \"%s\" van de RAM,"		\
	)

#define STARTING_KERNEL MLTSTR2 ( \
	"Starting kernel \"%s\"",	\
	"Lancement noyau \"%s\"",	\
	"Начиная стержень \"%s\"",	\
	"Comenzando el núcleo \"%s\"",	\
	"Inizializzando il kernel \"%s\"",	/* by Benny */	\
	"Começando a semente \"%s\"",	\
	"Starte Kernel \"%s\"",			/* jj */	\
	"Beginnende pit \"%s\""		\
	)

/* Last message displayed by Gujin: */
#define GO_KERNEL MLTSTR2 ( \
	"go!",				\
	"partit!",			\
	"идет!",			\
	"va!",				\
	"va!",				\
	"vai!",	/* by Benny ok */	\
	"Los!",	/* jj???? */		\
	"gaat!"				\
	)

#define ERROR_NOT_ENOUGH_RAM MLTSTR2 ( \
	"ERROR: not enough RAM.",		\
	"ERREUR: pas assez de mémoire.",	\
	"ОШИБКА: не достаточный RAM.",		\
	"ERROR: no bastante RAM.",		\
	"ERRORE: non abbastanza RAM.",	/* by Benny ok */	\
	"ERRO: não bastante RAM.",		\
	"Fehler: nicht genügend RAM.",	/* jj */		\
	"FOUT: niet genoeg RAM."		\
	)

#define ERROR_RELOCATE_TOO_HIGH MLTSTR2 ( \
	"ERROR: relocate over RAM limit.",				\
	"ERREUR: relocation memoire trop haute.",			\
	"Ошибка: переселиться за ограничение оперативной памяти.",	\
	"ERROR: vuelva a poner sobre límite del RAM.",			\
	"ERRORE: riassegnazione sopra il limite della RAM.",	/* by Benny */	\
	"ERRO: relocate sobre o limite do RAM.",			\
	"Fehler: Verlagerung über RAM-Limit.",			/* ?? */	\
	"FOUT: vestig me over de grens van de RAM opnieuw."		\
	)

/* i.e. going 4 Gbytes segments in real mode: */
#define ERROR_SEGMENT_DOOR MLTSTR2 ( \
	"ERROR: opening segment doors.",		\
	"ERREUR: ouverture des portes de segment.",	\
	"Ошибка: открытие дверей сегмента.",		\
	"ERROR: puertas del segmento de la abertura.",	\
	"ERRORE: aprendo le porte del segmento.",	/* by Benny to be checked */	\
	"ERRO: portas do segmento da abertura.",	\
	"Fehler: Öffnung von Segmenttüren.",		/* ???? */ \
	"FOUT: openings segmentdeuren."			\
	)

#define ERROR_TOO_MANY_INITRD MLTSTR2 ( \
	"ERROR: too many concated initrd.",		\
	"ERREUR: trop d'initrd concatenés.",		\
	"Ошибка: слишком много Объединенные initrd.",	\
	"ERROR: demasiado initrd concatenado.",		\
	"ERRORE: troppi initrd concatenati.",	/* by Benny */	\
	"ERRO: initrd concatenado demais.",		\
	"Fehler: zu viele verkettete initrd.",	/* jj */	\
	"FOUT: aaneengeschakeld teveel initrd."		\
	)

#define ERROR_XMS_ENABLE_A20 MLTSTR2 ( \
	"ERROR: HIMEM.SYS enabling A20.",		\
	"ERREUR: activation A20 par HIMEM.SYS.",	\
	"ОШИБКА: HIMEM.SYS включать A20.",		\
	"ERROR: HIMEM.SYS permisión de A20.",		\
	"ERRORE: HIMEM.SYS permettere a A20.",		\
	"ERRO: HIMEM.SYS permitindo A20.",		\
	"Fehler: HIMEM.SYS gibt A20 frei.",	/* jj?? */	\
	"FOUT: HIMEM.SYS het toelaten van A20."		\
	)

#define ERROR_LOADING_FILE MLTSTR2 ( \
	"ERROR: 0x%X loading file.",			\
	"ERREUR: 0x%X au chargement du fichier.",	\
	"ОШИБКА: 0x%X архив нагрузки.",			\
	"ERROR: 0x%X archivo del cargamento.",		\
	"ERRORE: 0x%X caricando il file.",	/* by Benny */	\
	"ERRO: 0x%X lima do carregamento.",		\
	"Fehler: 0x%X lade Datei.",		/* jj */	\
	"FOUT: 0x%X ladings dossier."			\
	)

#define ERROR_XMS_LOCK MLTSTR2 ( \
	"ERROR: 0x%X locking memory.",			\
	"ERREUR: 0x%X vérrouillage mémoire.",		\
	"Ошибка: 0x%X блокировки памяти.",		\
	"ERROR: 0x%X que traba memoria.",		\
	"ERRORE: 0x%X bloccando la memoria.",	/* by Benny */	\
	"ERRO: 0x%X que trava a memória.",		\
	"Fehler: 0x%X sperre Arbeitsspeicher.",	/* jj?? */	\
	"FOUT: 0x%X sluitengeheugen."			\
	)

#define ERROR_FILE_S_DOES_NOT_EXIST MLTSTR2 ( \
	"ERROR: file '%s' does not exist.",		\
	"ERREUR: le fichier '%s' n'existe pas.",	\
	"ОШИБКА: архив '%s' не существует.",		\
	"ERROR: archivo '%s' no existe.",		\
	"ERRORE: il file '%s' non esiste.",	/* by Benny */	\
	"ERRO: lima '%s' não existe.",			\
	"Fehler: Datei '%s' existiert nicht.",	/* jj */	\
	"FOUT: dossier '%s' bestaat niet."		\
	)

#define ERROR_LOADING_KERNEL MLTSTR2 ( \
	CRLF "ERROR loading: 0x%X ",		\
	CRLF "ERREUR chargement: 0x%X ",	\
	CRLF "Ошибка загрузки: 0x%X ",		\
	CRLF "Cargamento del ERROR: 0x%X ",	\
	CRLF "Errore caricando: 0x%X ",	/* by Benny */	\
	CRLF "Carregamento do ERRO: 0x%X ",	\
	CRLF "FEHLER beim Laden: 0x%X ",/* jj */	\
	CRLF "De lading van de FOUT: 0x%X "	\
	)

#define ERROR_STARTUP_ENABLE_A20 MLTSTR2 ( \
	"(enabling A20 at startup)",		\
	"(activation A20 au démarrage)",	\
	"(Включение A20 при запуске)",		\
	"(permisión de A20 en el arranque)",	\
	"(abilito A20 alla partenza)",	/* by Benny */	\
	"(permitindo A20 na partida)",		\
	"(Gebe A20 beim Start frei)",	/* jj?? */	\
	"(het toelaten van A20 bij opstarten)"	\
	)

#define ERROR_SWITCH_PROTECTED_MODE MLTSTR2 ( \
	"(switching to protected mode)",		\
	"(passage en mode protégé)",			\
	"(Переключение в защищенный режим)",		\
	"(el cambiar al modo protegido)",		\
	"(commutando a modalità protetta)",	/* by Benny */	\
	"(comutação à modalidade protegida)",		\
	"(Wechsel in den geschützten Modus)",	/* jj?? */	\
	"(het overschakelen op beschermde wijze)"	\
	)

#define ERROR_EXIT_V86_MODE MLTSTR2 ( \
	"(exiting V86 mode)",		\
	"(sortie du mode V86)",		\
	"(выход из режима V86)",	\
	"(dar salida al modo V86)",	\
	"(uscendo da modo V86)",	/* by Benny */	\
	"(retirando a modalidade V86)",	\
	"(Verlassen des V86-Modus)",	/* jj */	\
	"(het weggaan V86 wijze)"	\
	)

#define ERROR_AMOUNT_MEMORY MLTSTR2 ( \
	"(not enough memory)",		\
	"(pas assez de mémoire)",	\
	"(не достаточный RAM)",		\
	"(no bastante RAM)",		\
	"(non abbastanza RAM)",	/* by Benny */	\
	"(não bastante RAM)",		\
	"(nicht genügend RAM)",		\
	"(niet genoeg RAM)"		\
	)

#define ERROR_GUJIN_VERSION MLTSTR2 ( \
	"(too old Gujin version)",		\
	"(version de Gujin trop ancienne)",	\
	"(слишком старая версия Gujin)",	\
	"(demasiado vieja versión de Gujin)",	\
	"(versione troppo vecchia di Gujin)",	/* by Benny ok */	\
	"(versão demasiado velha de Gujin)",	\
	"(zu alte Gujin Version)",		\
	"(te oude versie Gujin)"		\
	)

#define ERROR_NOT_FROM_DOS MLTSTR2 ( \
	"(DOS environment)",		\
	"(environement DOS)",		\
	"(DOS окружающей среды)",	\
	"(ambiente DOS)",		\
	"(ambiente DOS)",	/* by Benny ok */	\
	"(ambiente DOS)",		\
	"(DOS Umgebung)",	/* jj?? */		\
	"(milieu DOS)"			\
	)

#define ERROR_NOT_FROM_VIRTUAL MLTSTR2 ( \
	"(virtual V8086 environment)",	\
	"(environement virtual V8086)",	\
	"(Виртуальная среда V8086)",	\
	"(ambiente virtual V8086)",	\
	"(ambiente virtuale V8086)",	/* by Benny ok */	\
	"(ambiente virtual V8086)",	\
	"(virtuelle V8086 Umgebung)",	/* jj */	\
	"(virtueel milieu V8086)"	\
	)

#define ERROR_BAD_CPU MLTSTR2 ( \
	"(incompatible CPU)",			\
	"(CPU incompatible)",			\
	"(несовместимые ЦП)",			\
	"(CPU incompatible)",			\
	"(CPU incompatibile)",	/* by Benny ok */	\
	"(processador central incompatível)",	\
	"(inkompatible CPU)",			\
	"(onverenigbare cpu)"			\
	)

#define ERROR_BAD_CPU_FLAGS MLTSTR2 ( \
	"(incompatible CPU flags)",				\
	"(flags CPU incompatibles)",				\
	"(несовместимые флаги ЦП)",				\
	"(banderas incompatibles de la CPU)",			\
	"(CPU flags incompatibili)",	/* by Benny */		\
	"(bandeiras incompatíveis do processador central)",	\
	"(inkompatible CPU-Flaggen)",	/* jj?? */	\
	"(de onverenigbare vlaggen van cpu)"			\
	)

#define ERROR_BAD_LICENSE MLTSTR2 ( \
	"(incompatible license)",		\
	"(license incompatible)",		\
	"(несовместимые лицензии)",		\
	"(licencia incompatible)",		\
	"(licenza incompatibile)",	/* by Benny */	\
	"(licença incompatível)",		\
	"(inkompatible Lizenz)",		\
	"(onverenigbare vergunning)"		\
	)

#define ERROR_BAD_ELF MLTSTR2 ( \
	"(ELF file without real mode section)",			\
	"(fichier ELF sans section en mode réel)",		\
	"(ELF файл без реального режима раздела)",		\
	"(ELF sin la sección del modo verdadero)",		\
	"(File ELF senza sezione in real mode)",	/* by Benny */	\
	"(Lima do ELF sem seção da modalidade real)",		\
	"(ELF Datei ohne Realmodus-Abschnitt)",		/* jj */	\
	"(Het dossier van het ELF zonder echte wijzesectie)"	\
	)

#define ERROR_CONTROL_BREAK MLTSTR2 ( \
	"(Control Break pressed)",		\
	"(Control Break demandé)",		\
	"(Управлени-Сломайте отжато)",		\
	"(Control-Rómpase presionado)",		\
	"(Control Break pressato)",	/* by Benny */	\
	"(Controle-Quebre pressionado)",	\
	"(STeuRunGs-Break betätigt)",	/* jj?? */	\
	"(Gedrukte controle-onderbreking)"	\
	)

#define ERROR_BAD_SCREEN_ACCESS MLTSTR2 ( \
	"(screen access type)",			\
	"(type d'accès écran)",			\
	"(Тип доступа экрана)",			\
	"(tipo del acceso de la pantalla)",	\
	"(tipo di accesso dello schermo)",	/* by Benny ok */	\
	"(tipo do acesso da tela)",		\
	"(Bildschirmzugangsart)",		/* jj?? */	\
	"(het type van het schermtoegang)"	\
	)

#define ERROR_BAD_SCREEN_RESOLUTION MLTSTR2 ( \
	"(screen resolution)",		\
	"(résolution écran)",		\
	"(разрешение экрана)",		\
	"(resolución de la pantalla)",	\
	"(risoluzione dello schermo)",	/* by Benny ok */	\
	"(definição da tela)",		\
	"(Bildschirmauflösung)",	\
	"(het scherm resolutie)"	\
	)

#define ERROR_EXTERNAL_SET_PARAMS MLTSTR2 ( \
	"(kernel own initialisation)",		\
	"(initialisation propre au noyau)",	\
	"(собственные инициализации ядра)",	\
	"(el núcleo posee la inicialización)",	\
	"(il kernel possiede l'inizializzazione)",	/* by Benny */	\
	"(a semente possui a iniciação)",	\
	"(Kernels eigene Initialisierung)",		/* jj */	\
	"(pit eigen initialisering)"		\
	)

#define ERROR_RECHECK_KERNEL_CRC32 MLTSTR2 ( \
	"(re-check kernel CRC32 (memory failure?))",				\
	"(re-vérification CRC32 du noyau (memoire défaillante?))",		\
	"(перепроверите стержень CRC32 (отказ памяти?))",			\
	"(vuelva a inspeccionar el núcleo CRC32 (la falta de la memoria?))",	\
	"(riverifichi il CRC32 del kernel (guasto di memoria?))",	/* by Benny */	\
	"(verific novamente a semente CRC32 (a falha da memória?))",		\
	"(Nachprüfung der Kernel CRC32 (Arbeitsspeicherdefekt?))",	/* jj?? */	\
	"(controleer pit CRC32 (geheugenmislukking?) opnieuw)"			\
	)

#define ERROR_RECHECK_INITRD_CRC32 MLTSTR2 ( \
	"(re-check initrd CRC32 (memory failure?))",						\
	"(re-vérification CRC32 du disque RAM initial (memoire défaillante?))",			\
	"(перепроверите начальный псевдодиск CRC32 (отказ памяти?))",				\
	"(vuelva a inspeccionar el disco de RAM inicial CRC32 (la falta de la memoria?))",	\
	"(riverifichi il CRC32 del RAM DISK iniziale (guasto di memoria?))",	/* by Benny */	\
	"(verific novamente o disco de RAM inicial CRC32 (a falha da memória?))",		\
	"(Nachprüfung der initrd CRC32 (Arbeitsspeicherdefekt?))",		/* jj?? */	\
	"(controleer de aanvankelijke schijf CRC32 van de RAM (geheugenmislukking?) opnieuw)"	\
	)

#define PRODUCT_X_SERIAL_X MLTSTR2 ( \
	"\010, product ID 0x%X, serial number 0x%X, ",				\
	"\010, produit ID 0x%X, numéro série 0x%X, ",				\
	"\010, удостоверение личности 0x%X продукта, серийный номер 0x%X, ",	\
	"\010, identificación 0x%X, número de serie 0x%X del producto, ",	\
	"\010, identificazione 0x%X, numero di serie 0x%X del prodotto, ",	/* by Benny ok */	\
	"\010, identificação 0x%X do produto, número de série 0x%X, ",		\
	"\010, Produkt Identifikation 0x%X, Seriennummer 0x%X, ",		\
	"\010, product identiteitskaart 0x%X, serienummer 0x%X, "		\
	)

/*
 * Other messages:
 */
#define PROCESSOR_MSG MLTSTR2 ( \
	"%s processor family %d",		\
	"Processeur %s famille %d",		\
	"Обработчика %s семья %d",		\
	"Procesador %s familia %d",		\
	"Processore %s famiglia %d",	/* by Benny */	\
	"Processador %s família %d",		\
	"Prozessor %s familie %d",		\
	"Bewerker %s familie %d"		\
	)

#define AT_FREQUENCY MLTSTR2 ( \
	" at %U MHz",		\
	" à %U MHz",		\
	" на %U MHz",		\
	" en %U megaciclos",	\
	" a %U MHz",	/* by Benny ok */	\
	" em %U MHz",		\
	" bei %U MHz",		\
	" bij %U Mhz"		\
	)

#define WITHOUT_FPU MLTSTR2 ( \
	" w/o FPU",	\
	" sans FPU",	\
	" без FPU",	\
	" sin FPU",	\
	" senza FPU",	/* by Benny ok */	\
	" sem o FPU",	\
	" ohne FPU",	\
	" zonder FPU"	\
	)

#define RUNNING_ON_BIOS MLTSTR2 ( \
	" on BIOS",	\
	" sous BIOS",	\
	" на BIOS",	\
	" en el BIOS",	\
	" sul BIOS",	/* by Benny ok */	\
	" no BIOS",	\
	" im BIOS",	/* ?? */ \
	" op BIOS"	\
	)

#define RUNNING_ON_DOS_UU MLTSTR2 ( \
	" on DOS-%u.%u",	\
	" sous DOS-%u.%u",	\
	" на DOS-%u.%u",	\
	" en el DOS-%u.%u",	\
	" sul DOS-%u.%u",	/* by Benny ok */	\
	" no DOS-%u.%u",	\
	" auf DOS-%u.%u",	/* unter DOS?? */ \
	" op DOS-%u.%u"		\
	)

#define RUNNING_ON_WINDOWS_UU	 MLTSTR2 ( \
	" on Windows-%u.%u",	\
	" sous Windows-%u.%u",	\
	" на Windows-%u.%u",	\
	" en el Windows-%u.%u",	\
	" su Windows-%u.%u",	/* by Benny */	\
	" no Windows-%u.%u",	\
	" auf Windows-%u.%u",	/* unter Windows?? */ \
	" op Windows-%u.%u"	\
	)

#define XMS_VERSION_FREE MLTSTR2 ( \
	"XMS-%u.%u: %u Kb free; ",		\
	"XMS-%u.%u: %u Ko libre; ",		\
	"XMS-%u.%u: %u Ko бесплатно; ",		\
	"XMS-%u.%u: %u Kb libera; ",		\
	"XMS-%u.%u: %u Kb libera; ",	/* by Benny to be checked */	\
	"XMS-%u.%u: %u Kb livra; ",		\
	"XMS-%u.%u: Kb %u frei; ",	/* jj */	\
	"XMS-%u.%u: %u vrij Kb; "		\
	)

#define VCPI_TOTAL_MAXFREE MLTSTR2 ( \
	"total %u Kb, free %u Kb" CRLF,			\
	"total %u Ko, libre %u Ko" CRLF,		\
	"всего %u КБ, бесплатно %u КБ" CRLF,		\
	"total de %u Kb, libera %u Kb" CRLF,	/* by Benny ok */	\
	"totale di %u Kb, il Kb %u libera" CRLF,	\
	"total de %u Kb, Kb %u livra" CRLF,		\
	"Gesamt %u Kb, frei %u Kb" CRLF,	/* jj */	\
	"%u Kb totaal, %u vrij Kb." CRLF		\
	)

#define BASE_MEMORY_U_EXTENDED_MEMORY_U_S MLTSTR2 ( \
	CRLF "base memory: %u Kb, extended memory: %u Kb [%s]" CRLF,			\
	CRLF "mémoire de base: %u Ko, étendue: %u Ko [%s]" CRLF,			\
	CRLF "базовый памяти: %u КБ, дополнительной памяти: %u КБ [%s]" CRLF,		\
	CRLF "memoria baja: Kb de %u, memoria extendida: Kb de %u [%s]" CRLF,		\
	CRLF "memoria bassa: di %u Kb, memoria estesa: di %u Kb [%s]" CRLF,	/* by Benny ok */	\
	CRLF "memória baixa: Kb de %u, memória prolongada: Kb de %u [%s]" CRLF,		\
	CRLF "konventioneller Speicher: %u Kb, Erweiterungsspeicher: %u Kb [%s]" CRLF,	/* jj */	\
	CRLF "basis geheugen: %u Kb, uitgebreid geheugen: %u Kb [%s]" CRLF		\
	)

#define KEYBOARD_122 MLTSTR2 ( \
	"122 key keyboard",		\
	"clavier 122 touches",		\
	"122 ключевых клавиатуры",	\
	"teclado de 122 llaves",	\
	"tastiera a 122 tasti",	/* by Benny */	\
	"teclado de 122 chaves",	\
	"Tastatur mit 122 Tasten",	/* jj */	\
	"122 sleutelstoetsenbord"	\
	)

#define KEYBOARD_EXT MLTSTR2 ( \
	"extended keyboard",		\
	"clavier étendu",		\
	"расширенной клавиатуры",	\
	"teclado extendido",		\
	"tastiera estesa",	/* by Benny ok */	\
	"teclado prolongado",		\
	"erweiterte Tastatur",	/* jj */		\
	"sleutelstoetsenbord"		\
	)

#define KEYBOARD_STD MLTSTR2 ( \
	"standard keyboard",		\
	"clavier standard",		\
	"стандартной клавиатуры",	\
	"teclado estándar",		\
	"tastiera standard",	/* by Benny ok */	\
	"teclado padrão",		\
	"Standardtastatur",		\
	"standaard toetsenbord"		\
	)

#define KEYBOARD_SERIAL MLTSTR2 ( \
	"serial keyboard",		\
	"clavier série",		\
	"последовательный клавиатуры",	\
	"teclado serial",		\
	"tastiera seriale",	/* by Benny */	\
	"teclado de série",		\
	"Serielle Tastatur",	/* jj */	\
	"periodiek toetsenbord"		\
	)

#define U_SERIAL_PORT MLTSTR2 ( \
	"%u serial port%s, ",		\
	"%u port%s série, ",		\
	"%u последовательных порта, ",	\
	"%u puerto%s seriale%s, ",	\
	"porta seriale %u, ",	/* by Benny */	\
	"%u portos de série, ",		\
	"%u serielle Schnittstelle(n), ",	/* jj %s=n ?? */ \
	"%u periodieke havens, "	\
	)

#define JOYSTICK_PRESENT MLTSTR2 ( \
	"joystick, ",		\
	"",			\
	"джойстик, ",		\
	"palanca de mando, ",	\
	"joystick, ",	/* by Benny */	\
	"manche, ",		\
	"Joystick, ",	/* ?? */ \
	"bedieningshendel, "	\
	)

// the %s could be "extended " for 5 buttons weel mouse:
#define BIOS_MOUSE_S_X MLTSTR2 ( \
	"%sBIOS mouse type 0x%X." CRLF,	\
	"sourie BIOS%s type 0x%X." CRLF,	\
	"BIOS мыши%s type 0x%X." CRLF,	\
	"ratón del BIOS%s type 0x%X." CRLF,	\
	"mouse BIOS%s di tipo 0x%X." CRLF,	/* by Benny */	\
	"rato do BIOS%s type 0x%X." CRLF,	\
	"%s BIOS-Maus Typ 0x%X." CRLF,		/* jj %s=?? */	\
	"BIOS muis%s type 0x%X." CRLF	\
	)

// %u has to be the last one, %s is one of the 2 following,
// i.e.: "serial "3 buttons "on COM1 mouse."
#define SERIAL_ON_COMX_MOUSE MLTSTR2 ( \
	"serial %son COM%u mouse." CRLF,	\
	"sourie série %ssur COM%u." CRLF,	\
	"последовательных %sCOM%u мыши." CRLF,	\
	"ratón serial %sen COM%u." CRLF,	\
	"mouse seriale %ssu COM%u." CRLF,	/* by Benny */	\
	"rato de série %sem COM%u." CRLF,	\
	"Serielle Maus %sauf COM%u."  CRLF,	/* jj */	\
	"periodieke muis %sop COM%u." CRLF	\
	)

#define MOUSE_3BUTTONS MLTSTR2 ( \
	"3 buttons ",	\
	"3 boutons ",	\
	"3 кнопки ",	\
	"3 botones ",	\
	"3 tasti ",	/* by Benny ok */	\
	"3 teclas ",	\
	"3 Tasten ",	/* jj */	\
	"3 knopen "	\
	)

#define MOUSE_MOUSESYSTEM MLTSTR2 ( \
	"MouseSystems ",		\
	"",				\
	MLTSTR_DEFAULT_RUSSIAN,		\
	"",				\
	"",	/* by Benny ok */	\
	"",				\
	"",				\
	""				\
	)

#define NO_MOUSE MLTSTR2 ( \
	"no mouse." CRLF,	\
	"pas de sourie." CRLF,	\
	"нет мыши." CRLF,	\
	"ninguÌn ratón." CRLF,	\
	"nessun mouse." CRLF,	/* by Benny ok */	\
	"nenhum rato." CRLF,	\
	"keine Maus." CRLF,	\
	"geen muis." CRLF	\
	)

#define ERROR_MOUSE MLTSTR2 ( \
	"error mouse." CRLF,	\
	"erreur sourie." CRLF,	\
	"ОШИБКА мыши." CRLF,	\
	"error ratón." CRLF,	\
	"ERRORE mouse." CRLF,	/* by Benny ok */	\
	"ERRO rato." CRLF,	\
	"Fehler Maus." CRLF,	/* jj */	\
	"FOUT muis." CRLF	\
	)

#define SERIAL_TERMINAL MLTSTR2 ( \
	"Serial terminal, ",		\
	"Terminal série, ",		\
	"Последовательный терминал, ",	\
	"Terminal serial, ",		\
	"Terminale seriale, ",	/* by Benny */	\
	"Terminal de série, ",		\
	"Serielles Terminal, ",	/* jj */	\
	"Periodieke terminal, "		\
	)

#define TERMINAL_MODES MLTSTR2 ( \
	"%s, modes: 0..%u." CRLF,	\
	"%s, modes: 0..%u." CRLF,	\
	"%s, режим: 0..%u." CRLF,	\
	"%s, modo: 0..%u." CRLF,	\
	"%s, modo: 0..%u." CRLF,	\
	"%s, modalidade: 0..%u." CRLF,	\
	"%s, modus: 0..%u." CRLF,	/* ?? */ \
	"%s, wijze: 0..%u." CRLF	\
	)

#define SERIAL_INIT_FAILED MLTSTR2 ( \
	"Serial port initialisation failed!",		\
	"ERREUR: initialisation port série !",		\
	"Сбой инициализации последовательного!",	\
	"¡Inicialización serial fallada!",		\
	"L'inizializzazione della seriale è fallita!",	/* by Benny */	\
	"A iniciação de série falhou!",			\
	"Initialisierung der seriellen Schnittstelle gescheitert!",	/* jj */	\
	"Periodieke ontbroken initialisering!"		\
	)

#define THE_RIGHT_KEY_PRESSED MLTSTR2 ( \
	"You asked to switch to a parallel world, please select your universe:",			\
	"Vous avez demandé le passage dans un monde parallèle, veuillez selectionner votre univers:",	\
	"Вам предложено перейти в параллельном мире, пожалуйста, выберите Ваш Вселенной:",		\
	"Usted pidió cambiar a un mundo paralelo, selecciona por favor su universo:",			\
	"Avete chiesto di commutare ad un mondo parallelo, prego selezionate il vostro universo:", /* by Benny ???? ok */	\
	"Você pediu para comutar a um mundo paralelo, seleciona por favor seu universo:",		\
	"Sie baten, zu einer parallelen Welt zu wechseln, wählen sie bitte Ihr Universum:",		/* jj??  */	\
	"U vroeg op een parallelle wereld overschakelen, alstublieft uw heelal selecteren:"		\
	)

#define CGA_MGA_HGC_CARD_PRESENT MLTSTR2 ( \
	"CGA/MGA/Hercule card present." CRLF,		\
	"Carte CGA/MGA/Hercule présente." CRLF,		\
	"Карта CGA/MGA/Hercule настоящий." CRLF,	\
	"Tarjeta CGA/MGA/Hercule presente." CRLF,	\
	"Scheda CGA/MGA/Hercule presente." CRLF,	/* by Benny */	\
	"Cartão do CGA/MGA/Hercule presente." CRLF,	\
	"CGA/MGA/Hercules-Karte vorhanden." CRLF,	/* jj Herkules?? */	\
	"CGA/MGA/Hercule aanwezige kaart." CRLF		\
	)

#define EGA_CARD_PRESENT MLTSTR2 ( \
	"EGA card present." CRLF,		\
	"Carte EGA présente." CRLF,		\
	"Карта EGA настоящий." CRLF,		\
	"Tarjeta EGA presente." CRLF,		\
	"Scheda EGA presente." CRLF,	/* by Benny */	\
	"Cartão do EGA presente." CRLF,		\
	"EGA-Karte vorhanden." CRLF,	/* jj */	\
	"EGA aanwezige kaart." CRLF		\
	)

#define VGA_CARD_PRESENT_MODES MLTSTR2 ( \
	"VGA card present (current mode 0x%X), modes: ",			\
	"Carte VGA présente (mode actuel 0x%X), modes: ",			\
	"Настоящий VGA карты (текущий режим 0x%X), режимы: ",			\
	"Presente de la tarjeta del VGA (modo actual 0x%X), modos: ",		\
	"Scheda VGA presente (modo corrente: 0x%X), modi: ",	/* by Benny */	\
	"Presente do cartão do VGA (modalidade atual 0x%X), modalidades: ",	\
	"VGA-Karte vorhanden (aktueller Modus 0x%X), Modi: ",	/* jj Modiarten */	\
	"VGA kaartheden (huidige wijze 0x%X), wijzen: "				\
	)

#define S_CARD_VESA_VERSION_U_U MLTSTR2 ( \
	"%s video card, VESA version %u.%u." CRLF,		\
	"Carte vidéo %s, version VESA %u.%u." CRLF,		\
	"%s видеокарты, версия VESA %u.%u." CRLF,		\
	"Tarjeta video %s, versión de VESA %u.%u." CRLF,	\
	"Scheda Video %s, versione di VESA: %u.%u." CRLF,	/* by Benny */	\
	"Cartão video %s, versão de VESA %u.%u." CRLF,		\
	"Videokarte %s, VESA-Version %u.%u." CRLF,		/* jj */	\
	"Videokaart %s, VESA-versie %u.%u." CRLF		\
	)

#define FORCE_VIDEO_MODE_3 MLTSTR2 ( \
	"Info: Control key pressed, video mode set to simple text.",							\
	"Info: Touche Control pressée, mode vidéo forcé en texte simple.",						\
	"Инфо: Управление клавиша нажата, набор видео режимов в простой текст.",					\
	"Info: La llave de control presionó, el modo video fijado al texto simple.",					\
	"Info: tasto Control premuto, video fissato in modalità testo semplice.",	/* by Benny */			\
	"Informação: A chave de controle pressionou, a modalidade video ajustada ao texto simples.",			\
	"Info: STeuRunGs-Taste betätigt, Videomodus auf einfachen Text gesetzt.",	/* jj?? */	\
	"Info: De zeer belangrijke gedrukte, videowijze van de controle die aan eenvoudige teksten wordt geplaatst."	\
	)

#define IMPORTANT_PARAMETERS_RESETED MLTSTR2 ( \
	"Info: Caps-Lock active, most important parameters reseted.",					\
	"Info: Maj-Lock actif, paramètres inportants ré-initialisés.",					\
	"Инфо: Caps LOCK активных, наиболее важные параметры reseted.",					\
	"Info: Casquillo-Cerradura activa, la mayoría de los parámetros importantes reseted.",		\
	"Info: Maiusc attivo, la maggior parte dei parametri importanti azzerata.",	/* by Benny */	\
	"Informação: Tampão-Fechamento ativo, a maioria de parâmetros importantes reseted.",		\
	"Info: Großbuchstaben-Taste aktiv, meisten wichtigen Parameter zurückgesetzt.",	/* jj?? */	\
	"Info: Actieve het kap-slot, de meeste belangrijke parameters reseted."				\
	)

/*
 * Only for the tiny_exe configuration:
 */
#define BASIC_LOADER_HELP_MESSAGE MLTSTR2 ( \
	"This is a simple loader of a kernel file under DOS." CRLF					\
   "USAGE: %s [/H] [/X=<cmd>] [/V[=]] C:\\path\\kernel [initrd=]{D:\\path\\initrd|-} <options>" CRLF,	\
	"Ce programme est un simple chargeur de noyau sous DOS." CRLF					\
   "USAGE: %s [/H] [/X=<cmd>] [/V[=]] C:\\path\\kernel [initrd=]{D:\\path\\initrd|-} <options>" CRLF,	\
	"Это простой загрузчик ядра-файла под DOS." CRLF						\
   "USAGE: %s [/H] [/X=<cmd>] [/V[=]] C:\\path\\kernel [initrd=]{D:\\path\\initrd|-} <options>" CRLF,	\
	"Se trata de un simple gestor de un fichero del kernel bajo DOS." CRLF				\
   "USO: %s [/H] [/X=<cmd>] [/V[=]] C:\\path\\kernel [initrd=]{D:\\path\\initrd|-} <options>" CRLF,	\
	"Questo è un semplice caricatore di un file del kernel sotto DOS." CRLF	/* by Benny */		\
   "USAGE: %s [/H] [/X=<cmd>] [/V[=]] C:\\path\\kernel [initrd=]{D:\\path\\initrd|-} <options>" CRLF,	\
	"Este é um carregador simples de um arquivo de kernel sob o DOS." CRLF				\
   "USAGE: %s [/H] [/X=<cmd>] [/V[=]] C:\\path\\kernel [initrd=]{D:\\path\\initrd|-} <options>" CRLF,	\
	"Dies ist ein einfacher Loader für eine Kernel-Datei unter DOS." CRLF	/* jj */		\
   "USAGE: %s [/H] [/X=<cmd>] [/V[=]] C:\\path\\kernel [initrd=]{D:\\path\\initrd|-} <options>" CRLF,	\
	"Dit is een eenvoudige lader van een kernel-bestand onder DOS." CRLF				\
   "USAGE: %s [/H] [/X=<cmd>] [/V[=]] C:\\path\\kernel [initrd=]{D:\\path\\initrd|-} <options>" CRLF	\
	)

#define BASIC_LOADER_HELP_MESSAGE_2 MLTSTR2 ( \
	"  parameter after kernel is initrd filename if not '-' and no '=' sign," CRLF	\
   "  it may be prepended by \"initrd=\". You can add \"/V\" to list" CRLF		\
   "  available VESA video modes or for instance \"/V=1024x768x24\"" CRLF		\
   "  to switch to that mode before starting the kernel." CRLF				\
   "  You can give parameter /X=<cmd> (for instance /X=%COMSPEC%) to" CRLF		\
   "  execute a command after loading, before switch to protected mode" CRLF		\
   "  <option> can also read files with: @filename; parameters are order dependant",	\
	"  parametre apres kernel est un initrd si pas '-' et pas de signe '='," CRLF	\
   "  il peut etre precede par \"initrd=\". On peut utiliser \"/V\"" CRLF		\
   "  pour lister les modes VESA disponibles et par exemple \"/V=1024x768x24\"" CRLF	\
   "  pour basculer dans ce mode avant de demarrer le noyau." CRLF			\
   "  On peut utiliser /X=<cmd> (par exemple /X=%COMSPEC%) pour executer" CRLF		\
   "  une commande apres chargement, avant le passage en mode protege." CRLF		\
   "  <option> peut aussi lire des fichiers par: @filename" CRLF			\
   "  les parametres doivent apparaitre dans cet ordre.",				\
	MLTSTR2_DEFAULT_RUSSIAN,	\
	MLTSTR2_DEFAULT_SPANISH,	\
	MLTSTR2_DEFAULT_ITALIAN,	\
	MLTSTR2_DEFAULT_PORTUGESE,	\
	MLTSTR2_DEFAULT_GERMAN,		\
	MLTSTR2_DEFAULT_DUTCH		\
	)

#define BASIC_VESA_NOTCOMPATIBLE MLTSTR2 ( \
	"Testing video mode: video card not VESA2 compatible",			\
	"Test mode video: carte video n'est pas compatible VESA2",		\
	"Тестирование видео режим: видеокарта не VESA2 совместимый",		\
	"Modo video de prueba: tarjeta video no VESA2 compatible",		\
	"Provando il video mode: scheda video non VESA2 compatibile",	/* by Benny */	\
	"Modalidade video de teste: cartão video não VESA2 compatível",		\
	"Prüfe Videomodus: Videokarte nicht VESA2 kompatibel",	/* jj */	\
	"Testende videowijze: video kaart niet compatibel systeem VESA2"	\
	)

#define BASIC_AVAILABLE_VESA_MODE_MESSAGE MLTSTR2 ( \
	"VESA %u.%u video card, option supported:" CRLF,		\
	"carte video VESA %u.%u, options supportees:" CRLF,		\
	"VESA %u.%u видео карту, параметр поддерживается:" CRLF,	\
	"La tarjeta video de VESA %u.%u, opción apoyó:" CRLF,		\
	"La scheda video di VESA %u.%u, opzione supportata:" CRLF,	/* by Benny */	\
	"Cartão video de VESA %u.%u, opção suportada:" CRLF,		\
	"VESA %u.%u Videokarte, Option unterstützt:" CRLF,		/* jj */	\
	"VESA %u.%u steunde de videokaart, optie:" CRLF			\
	)

/*
 * Only for ds, es large data modes:
 */
#if ASSEMBLY_TYPE == ASSEMBLY_DSES
#define EMM386_CANNOT_RUN MLTSTR2 ( \
	"EMM386 detected, cannot run in Virtual86 mode in this configuration" CRLF,			\
	"EMM386 détecté, mode Virtual86 refusé dans cette configuration" CRLF,				\
	"EMM386 обнаружен, не может работать в режиме Virtual86 в этой конфигурации" CRLF,		\
	"EMM386 detectado, no puede funcionar en el modo Virtual86 en esta configuración" CRLF,		\
	"rilevato EMM386, non può funzionare nel modo Virtual86 in questa configurazione" CRLF,	/* by Benny */	\
	"EMM386 detectado, não pode funcionar na modalidade Virtual86 nesta configuração" CRLF,		\
	"EMM386 erkannt, kann nicht im Virtual86-Modus in dieser Konfiguration laufen" CRLF,	/* jj */	\
	"Ontdekte EMM386, kan niet op wijze Virtual86 in deze configuratie lopen" CRLF			\
	)

#define OPENDOOR_CANNOT_RUN MLTSTR2 ( \
	"ERROR opening segment doors, incompatibility BIG_MALLOC/ASSEMBLY_DSES" CRLF			\
    "and memory manager EMM386/QEMM/Windows/DOSEMU." CRLF,						\
	"ERREUR ouverture porte segment, incompatibilité BIG_MALLOC/ASSEMBLY_DSES" CRLF			\
    "et gestionnaire de mémoire EMM386/QEMM/Windows/DOSEMU." CRLF,					\
	"Ошибка открытия дверей, сегмент, несовместимости BIG_MALLOC/ASSEMBLY_DSES" CRLF		\
    "и диспетчер памяти EMM386/QEMM/Windows/DOSEMU." CRLF,						\
	"Puertas del segmento de la abertura del ERROR, incompatibilidad BIG_MALLOC/ASSEMBLY_DSES" CRLF	\
    "y encargado EMM386/QEMM/Windows/DOSEMU de la memoria." CRLF,					\
	"ERRORE nell'aprire le porte del segmento, incompatibilità BIG_MALLOC/ASSEMBLY_DSES" CRLF	/* by Benny */	\
    "e gestore della memoria EMM386/QEMM/Windows/DOSEMU." CRLF,	/* by Benny */				\
	"Portas do segmento da abertura do ERRO, incompatibilidade BIG_MALLOC/ASSEMBLY_DSES" CRLF	\
    "e gerente EMM386/QEMM/Windows/DOSEMU da memória." CRLF,						\
	"FEHLER beim Öffnen der Segmenttüren, Unverträglichkeit BIG_MALLOC/ASSEMBLY_DSES" CRLF		\
    "und Speichermanager EMM386/QEMM/Windows/DOSEMU." CRLF,	/* jj?? */				\
	"Openings het segmentdeuren van de FOUT, onverenigbaarheid BIG_MALLOC/ASSEMBLY_DSES" CRLF	\
    "en geheugenmanager EMM386/QEMM/Windows/DOSEMU." CRLF						\
	)
#endif

/*
 * Freelist clearing, set extended partition length, Gujin self install, and IDE password management:
 */
#define INDEX_DISK_NAME MLTSTR2 ( \
	CRLF "%u name %s: ",		\
	CRLF "%u nom %s: ",		\
	CRLF "%u имя %s: ",		\
	CRLF "%u nombre %s: ",		\
	CRLF "%u nome %s: ",	/* by Benny ok */	\
	CRLF "%u nome %s: ",		\
	CRLF "%u Name %s: ",		\
	CRLF "%u naam %s: "		\
	)

/* Free sectors in between partitions, not inside filesystems: */
#define FL_FREELIST_DISK_0_N MLTSTR2 ( \
	"Free sector list (partition wise) of %u disks:",			\
	"Liste des secteurs libres (entre les partitions) des %u disques:",	\
	"Список (раздел мудрые) свободного сектора дисков, %u:",		\
	"Lista libre del sector (partición sabia) de discos de %u:",		\
	"Lista settore libero (secondo le partizioni) dei %u dischi:",	/* by Benny to be checked */	\
	"Lista livre do setor (divisória sábia) de discos de %u:",		\
	"Freie Sektorenliste (Partitionsweise) der %u Laufwerke:",	/* jj?? */		\
	"Vrije sectorlijst (wijze verdeling) van %u schijven:"			\
	)

#define FL_TOTAL_DISK_SIZE MLTSTR2 ( \
	"end disk at %llU" CRLF,		\
	"fin du disque à %llU" CRLF,		\
	"конец диск на %llU" CRLF,		\
	"disco del extremo en %llU" CRLF,	\
	"fine disco a %llU" CRLF,	/* by Benny */	\
	"disco da extremidade em %llU" CRLF,	\
	"Laufwerksende bei %llU" CRLF,	/* jj */	\
	"eind schijf bij %llU" CRLF		\
	)

#define FL_TYPE_DISK_INDEX MLTSTR2 ( \
	"Type disk index to check/clean (ESC to abort): ",					\
	"Entrer l'index du disque à vérifier/nettoyer (ESC pour annuler): ",			\
	"Введите индекс диска для проверки/очистки (ESC прервать): ",				\
	"Mecanografíe el índice del disco al cheque/limpie (salida a la interrupción): ",	\
	"Scrivi l'indice del disco per verificare/pulire (ESC per terminare): ",	/* by Benny */	\
	"Datilografe o índice do disco à verificação/limpe-o (ESC ao aborto): ",		\
	"Tippen sie Laufwerksindex zur Überprüfung/Säuberung ein (ESC zum Abbrechen): ",	/* ?? */	\
	"De te controleren de schijfindex van het type/maakt (te aborteren ESC) schoon: "	\
	)

#define FL_CHECKING_CONTENT_OF_DISK MLTSTR2 ( \
	CRLF "Searching non empty free sector of %s:" CRLF,	/* "non empty"="occupied" ?? */ \
	CRLF "Recherche des secteurs non vide et libres de %s:" CRLF,	\
	CRLF "Поиск не пустой свободного сектора %s:" CRLF,		\
	CRLF "Búsqueda del sector libre no vacío de %s:" CRLF,		\
	CRLF "Ricerca del settore libero non vuoto di %s:" CRLF,	/* by Benny */	\
	CRLF "Procurarando um setor livre não vazio de %s:" CRLF,	\
	CRLF "Suche belegten freien Sektor von %s:" CRLF,	/* jj?? */	\
	CRLF "Het zoeken van niet lege vrije sector van %s:" CRLF	\
	)

#define FL_CHECKING_SECTOR_AT_LBA MLTSTR2 ( \
	"\rChecking sector at LBA %llU: ",		\
	"\rVérification du secteur au LBA %llU: ",	\
	"\rПроверка сектора на %llU ЛАБ: ",		\
	"\rComprobación del sector en LBA %llU: ",	\
	"\rControllo del settore a LBA %llU: ",	/* by Benny ok */	\
	"\rVerific o setor em LBA %llU: ",		\
	"\rPrüfung des Sektors an LBA %llU: ",		\
	"\rHet controleren van sector bij LBA %llU: "	\
	)

#define FL_READ_SECTOR_FAILED MLTSTR2 ( \
	"read sector FAILED!",				\
	"erreur lors de la lecture du secteur!",	\
	"чтения сектора неудачно!",			\
	"¡lea el sector FALLADO!",			\
	"lettura del settore ERRATA!",	/* by Benny */	\
	"leia o setor FALHADO!",			\
	"Lesen des Sektors gescheitert!",	/* jj */	\
	"lees ONTBROKEN sector!"			\
	)

#define FL_NOT_EMPTY MLTSTR2 ( \
	"not empty!",		\
	"n'est pas vide!",	\
	"не пустой!",		\
	"no vacío!",		\
	"non vuoto!",	/* by Benny */	\
	"nao vazio!",		\
	"nicht leer!",	/* jj?? */		\
	"niet lege!"		\
	)

#define FL_AUTOCLEAR MLTSTR2 ( \
	"not empty, auto clearing.",			\
	"n'est pas vide, effacement automatique.",	\
	"не пустой, Автоматическая очистка.",		\
	"no vacío, claro automático.",			\
	"non vuoto, schiarimento automatico.",		\
	"nao vazio, esclarecimento automático.",	\
	"nicht leer, automatische Bereinigung.",	/* jj */	\
	"niet lege, automatische opheldering."		\
	)

#define FL_INTERRUPTED MLTSTR2 ( \
	"interrupt!",		\
	"interruption!",	\
	"прерывание!",		\
	"¡interrupción!",	\
	"interruzione!",	/* by Benny ok */	\
	"interrupção!",		\
	"Unterbrechung!",	/* ?? */ \
	"onderbreek!"		\
	)

#define FL_TYPE_SPACE_ENTER_TAB MLTSTR2 ( \
	"type SPACE to display, ENTER to clear, TAB to continue, other keys to stop",						\
	"ESPACE pour afficher, ENTRER pour effacer, TAB pour continuer, autre touche pour arreter",				\
	"введите пробел для отображения, ввод, чтобы очистить, TAB, чтобы продолжить, другие клавиши, чтобы остановить",	\
	"Mecanografíe el ESPACIO a la exhibición, ENTRE para despejar, TABÚLELO para continuar, otras llaves a parar",		\
	"Scrivi SPAZIO per mostrare, ENTER per eliminare, TAB per continuare, altre chiavi per fermare",	/* by Benny */	\
	"Datilografe o ESPAÇO à exposição, ENTRE-O para cancelar, TABULE-O para continuar, outras chaves a parar",		\
	"Betätigen sie Leer- zur Anzeige, Eingabe- zum Löschen, Tabulator-Taste zum fortzufahren, andere zum stoppen",	/* jj */		\
	"De type RUIMTE aan vertoning, GAAT ontruimen binnen, LUSJE om verder te gaan, andere tegen te houden sleutels"	\
	)

#define FL_CONFIRM_CLEAR_ALL MLTSTR2 ( \
	"Confirm clear all free sector by 'y' or 'Y'",				\
	"Confirmer par 'y' ou 'Y' l'effacement de tous les secteurs libres",	\
	"Снимите подтвердить все свободного сектора путем 'y' или 'Y'",		\
	"Confirme claramente todo el sector libre por 'y' o 'Y'",		\
	"Per cancellare tutto il settore libero conferma con 'y' o 'Y'",	/* by Benny */	\
	"Confirme claramente todo o setor livre por 'y' ou 'Y'",		\
	"Bestätigen sie Bereinigung aller freien Sektor durch 'y' oder 'Y'",	/* jj Yes=Ja adapted ?? */	\
	"Bevestig duidelijk al vrije sector door 'y' of 'Y'"			\
	)

#define FL_REREAD_DISK_FAILED MLTSTR2 ( \
	"Re-read disk %s LBA %llU FAILED!" CRLF,			\
	"ERREUR relecture disque %s LBA %llU!" CRLF,			\
	"Перечитайте диск %s ЛАБ %llU неудачно!" CRLF,			\
	"¡Relea el disco %s LBA %llU FALLADO!" CRLF,			\
	"Rilettura del disco %s LBA %llU FALLITA!" CRLF,	/* by Benny */	\
	"Releia o disco %s LBA %llU FALHADO!" CRLF,			\
	"Erneutes Lesen von Laufwerk %s LBA %llU GESCHEITERT!" CRLF,	/* jj?? */	\
	"Herlezen ONTBROKEN schijf %s LBA %llU!" CRLF			\
	)

#define FL_WRITING_DISK_FAILED MLTSTR2 ( \
	" Writing disk %s LBA %llU FAILED! (check Gujin read-only config)" CRLF,				\
	" ERREUR écriture disque %s LBA %llU! (vérifier l'autorisation d'écriture de Gujin)" CRLF,		\
	" Написание диск %s ЛАБ %llU неудачно! (Отметьте Gujin только для чтения config)" CRLF,			\
	" ¡El disco %s LBA %llU de la escritura FALLÓ! (config inalterables de Gujin del cheque)" CRLF,		\
	" Scrittura sul disco %s LBA %llU FALLITO! (controlla la configurazione a sola lettura di Gujin)" CRLF,	/* by Benny */	\
	" Disco %s LBA %llU da escrita FALHADO! (config de leitura apenas de Gujin da verificação)" CRLF,	\
	" Schreiben auf Laufwerk %s LBA %llU GESCHEITERT! (Überprüfe Schreibschutz der Gujin Konfiguration)" CRLF,	/* jj?? */	\
	" Schrijvend ONTBROKEN schijf %s LBA %llU! (read-only config van controleGujin)" CRLF			\
	)

#define FL_SKIP_TO_NEXT_BLOCK MLTSTR2 ( \
	"reading free sector list block index %u stopped, reading next block" CRLF,							\
	"lecture de la liste de secteur libre block No %u arretée, passage au bloc suivant" CRLF,					\
	"Чтение блока индекс свободного сектора списка %u остановлена, чтение следующего блока" CRLF,					\
	"la lectura del índice libre %u del bloque de la lista del sector paró, leyendo el bloque siguiente" CRLF,			\
	"lettura dell'indice della lista del settore libero %u fermata, leggo il prossimo blocco" CRLF,	/* by Benny */	\
	"ler o índice livre %u do bloco da lista do setor parou, lendo o bloco seguinte" CRLF,						\
	"Lesen des Blockindexes %u der freien Sektorliste gestoppt, lese nächsten Block" CRLF,	/* jj?? */			\
	"lezend vrije tegengehouden het blokindex van de sectorlijst %u, lezend volgende blok" CRLF			\
	)

#define FL_FINISHED_TREATMENT_DISK MLTSTR2 ( \
	CRLF "Finished treatment of disk %s" CRLF,		\
	CRLF "Traitement du disque %s finit" CRLF,		\
	CRLF "Готовые лечения диск %s" CRLF,			\
	CRLF "Tratamiento acabado del disco %s" CRLF,		\
	CRLF "Finito il trattamento del disco %s" CRLF,	/* by Benny */	\
	CRLF "Tratamento terminado do disco %s" CRLF,		\
	CRLF "Behandlung von Laufwerk %s beendet" CRLF,	/* jj */	\
	CRLF "Gebeëindigde behandeling van schijf %s" CRLF	\
	)

#define IN_LIST_DISK_0_N MLTSTR2 ( \
	"List of %u known disks to install Gujin:",			\
	"Liste des %u disques connus pour installer Gujin:",		\
	"Список известных дисков для установки Gujin %u:",		\
	"Lista de discos sabidos %u para instalar Gujin:",		\
	"Lista dei %u dischi conosciuti per installare Gujin:",	/* by Benny */	\
	"Lista de discos conhecidos %u para instalar Gujin:",		\
	"Liste der %u bekannten Laufwerke, zum Installieren von Gujin:",	/* jj */	\
	"Lijst van %u bekende schijven om Gujin te installeren:"	\
	)

#define IN_TYPE_DISK_INDEX MLTSTR2 ( \
	CRLF "Type disk index to install Gujin to (ESC to abort): ",					\
	CRLF "Entrer l'index du disque pour installer Gujin (ESC pour annuler): ",			\
	CRLF "Введите индекс диска для установки Gujin (ESC прервать): ",				\
	CRLF "Mecanografíe el índice del disco para instalar Gujin a (salida a la interrupción): ",	\
	CRLF "Scrivi l'indice del disco dove installare Gujin (ESC per terminare): ",	/* by Benny */	\
	CRLF "Datilografe o índice do disco para instalar Gujin a (ESC ao aborto): ",			\
	CRLF "Tippe Laufwerksindex ein, zum Installieren von Gujin (ESC zum Abbruch): ",	/* jj */	\
	CRLF "De schijfindex van het type om Gujin te installeren (te aborteren ESC): "			\
	)

#define PW_KEYBOARD_UNKNOWN MLTSTR2 ( \
	"Keyboard unknown, first define it!",				\
	"Clavier inconnu, commencer par le sélectionner!",		\
	"Клавиатура неизвестно, во-первых, определить его!",		\
	"¡El desconocido del teclado, primero lo define!",		\
	"Tastiera sconosciuta, per prima cosa definiscila!",	/* by Benny */	\
	"O desconhecido do teclado, define-o primeiramente!",		\
	"Tastatur unbekannt, definieren sie es zuerst!",	/* jj */	\
	"Onbekende het toetsenbord, bepaalt het eerst!"			\
	)

#define PW_KEYBOARD_PARTIALLY_KNOWN MLTSTR2 ( \
	"Keyboard only partially known, first define it!",				\
	"Clavier partiellement connu, commencer par le préciser!",			\
	"Клавиатура только частично известно, сначала определить его!",			\
	"¡El teclado sabido solamente parcialmente, primero lo define!",		\
	"La tastiera è parzialmente conosciuta per prima cosa definiscila!",	/* by Benny */	\
	"O teclado somente conhecido parcialmente, define-o primeiramente!",		\
	"Tastatur nur teilweise bekannt, definieren sie es zuerst!",	/* jj */	\
	"Het gedeeltelijk slechts gekende toetsenbord, bepaalt het eerst!"		\
	)

#define PW_UNLOCK MLTSTR2 ( \
	"unlock",		\
	"dévérouillage",	\
	"разблокировать",	\
	"abra",			\
	"sblocchaggio",	/* by Benny */	\
	"destrave",		\
	"entsperren",	/* entriegeln?? */	\
	"open"			\
	)

#define PW_LOCK MLTSTR2 ( \
	"lock",		\
	"vérouillage",	\
	"Блокировка",	\
	"cerradura",	\
	"bloccaggio",	/* by Benny */	\
	"fechamento",	\
	"sperren",	/* verschliessen ?? */ \
	"slot"		\
	)

#define PW_TYPE_DISK_INDEX MLTSTR2 ( \
	CRLF "Type disk number to %s (ESC to abort): ",					\
	CRLF "Sélectionner le numero du disque à %s (ESC pour annuler): ",		\
	CRLF "Введите номер диска для %s (ESC прервать): ",				\
	CRLF "Mecanografíe el número del disco a %s (salida a la interrupción): ",	\
	CRLF "Scrivi il numero del disc a %s (ESC per terminare): ",	/* by Benny */	\
	CRLF "Datilografe o número do disco a %s (ESC ao aborto): ",			\
	CRLF "Geben sie Laufwerkszahl ein zum %s (ESC zum Abbruch): ",	/* jj?? */	\
	CRLF "De schijfaantal van het type aan %s (te aborteren ESC): "			\
	)

#define PW_UNLOCKING MLTSTR2 ( \
	"unlocking",		\
	"dévérouiller",		\
	"разблокировать",	\
	"abra",			\
	"sbloccaggio",	/* by Benny */	\
	"destrave",		\
	"entsperren",	/* jj */	\
	"open"			\
	)

#define PW_LOCKING MLTSTR2 ( \
	"lock",		\
	"vérouiller",	\
	"Блокировка",	\
	"cerradura",	\
	"bloccaggio",	/* by Benny */	\
	"fechamento",	\
	"sperren",	/* ?? */ \
	"slot"		\
	)

#define PW_TREATING_DRIVE MLTSTR2 ( \
	CRLF "%s drive %s" CRLF,	\
	CRLF "%s disque %s" CRLF,	\
	CRLF "%s диск %s" CRLF,		\
	CRLF "%s disco %s" CRLF,	\
	CRLF "%s disco %s" CRLF,	/* by Benny ok */	\
	CRLF "%s disco %s" CRLF,	\
	CRLF "%s Laufwerk %s" CRLF,	/* ?? */ \
	CRLF "%s schijf %s" CRLF	\
	)

/* Disk access password frozen: cannot be changed or either unlocked: */
#define PW_DRIVE_FROZEN MLTSTR2 ( \
	CRLF "drive %s already frozen" CRLF,		\
	CRLF "disque %s déjà gelé" CRLF,		\
	CRLF "диск %s already frozen" CRLF,		\
	CRLF "disco %s already frozen" CRLF,		\
	CRLF "disco %s già congelato" CRLF,	/* by Benny */	\
	CRLF "disco %s already frozen" CRLF,		\
	CRLF "Festplatte %s schon gesperrt" CRLF,	\
	CRLF "schijf %s already frozen" CRLF		\
	)

#define PW_PLEASE_POWER_OFF MLTSTR2 ( \
	": OK." CRLF "  Now power off the PC (CTRL ALT DEL is not enough).",		\
	": OK." CRLF "  Maintenant éteindre le PC (CTRL ALT DEL n'est pas suffisant).",	\
	": OK." CRLF "  Теперь выключите ПК (CTRL-ALT DEL недостаточно).",		\
	": OK." CRLF "  Ahora energía apagado la PC (el Ctrl ALT DEL no es bastante).",	\
	": OK." CRLF "  Ora spegni il PC (Ctrl ALT DEL non è abbastanza).",	/* by Benny */	\
	": OK." CRLF "  Agora poder fora o PC (o CTRL ALT DEL não é bastante).",	\
	": OK." CRLF "  Jetzt PC ausschalten (STRG-ALT-ENTF genügt nicht).",	/* jj STeueRunG (de) ~ ConTRoL (en) */	\
	": OK." CRLF "  Nu macht van PC (alt DEL van CTRL is niet genoeg)."		\
	)

#define PW_MASTER_SUCCESS MLTSTR2 ( \
	": OK." CRLF "  You should now set user password or power-off.",		\
	": OK." CRLF "  Vous devez maintenant initialiser le mot de passe utilisateur ou éteindre.",	\
	": OK." CRLF "  You should now set user password or power-off.",	\
	": OK." CRLF "  You should now set user password or power-off.",	\
	": OK." CRLF "  Ora devi inserire la password o spegnere.",	/* by Benny */	\
	": OK." CRLF "  You should now set user password or power-off.",	\
	": OK." CRLF "  Sie sollten nun ein Benutzerpasswort setzen oder ausschalten.",	/* jj?? */	\
	": OK." CRLF "  You should now set user password or power-off."	\
	)

#define EP_SET_EXTENDED_PARTITION_SIZE MLTSTR2 ( \
	"Display/Set extended partition length for each disks:" CRLF,					\
	"Affiche/met à jour la taille de la partition étendue de chaque disque:" CRLF,			\
	"Отображение/набор расширен раздел длины для каждого дисков:" CRLF,				\
	"La exhibición/el sistema amplió la longitud de la partición para cada los discos:" CRLF,	\
	"L'esposizione/insieme ha esteso la lunghezza del divisorio per l'ogni disc:" CRLF,		\
	"A exposição/jogo estendeu o comprimento da divisória para o cada discos:" CRLF,		\
	"Anzeige/Setzen der erweiterten Partitionslänge für jedes Laufwerk:" CRLF,	/* jj */	\
	"De vertoning/de Reeks breidde verdelingslengte voor elke schijven uit:" CRLF			\
	)

#define EP_NO_EXTENDED_PARTITION_FOUND MLTSTR2 ( \
	"Disk %s does not have an extended partition!" CRLF,	\
	"Le disque %s n'a pas de partition étendue!" CRLF,	\
	"Диск %s не имеет расширенный раздел!" CRLF,		\
	"¡El disco %s no tiene una partición extendida!" CRLF,	\
	"Il disc %s non ha un divisorio esteso!" CRLF,		\
	"O disco %s não tem uma divisória prolongada!" CRLF,	\
	"Laufwerk %s hat keine erweiterte Partition!" CRLF,	/* jj */	\
	"De schijf %s heeft geen uitgebreide verdeling!" CRLF	\
	)

#define EP_CANNOT_READ_MBR MLTSTR2 ( \
	"Read MBR of %s failed or bad 0xAA55 signature!" CRLF,				\
	"Erreur lors de la lecture du MBR de %s ou mauvaise signature 0xAA55!" CRLF,	\
	"Чтение MBR %s сбой или плохой 0xAA55 подпись!" CRLF,				\
	"¡Lea MBR de la firma fallada o mala 0xAA55 de %s!" CRLF,			\
	"Legga MBR della firma guastata o difettosa 0xAA55 di %s!" CRLF,		\
	"Leia MBR da assinatura 0xAA55 falhada ou má de %s!" CRLF,			\
	"Lesen des MBRs von %s gescheitert oder fehlerhafte 0xAA55 Markierung!" CRLF,	/* jj */	\
	"Lees MBR van %s ontbroken of slechte handtekening 0xAA55!" CRLF		\
	)

#define EP_NO_CORRESPONDING_EXTENDED_PARTITION MLTSTR2 ( \
	"Disk %s without corresponding extended partition!" CRLF,		\
	"Le disque %s n'a pas la partition étendue correspondante!" CRLF,	\
	"Диск %s без соответствующего расширенный раздел!" CRLF,		\
	"¡Disco %s sin la partición extendida correspondiente!" CRLF,		\
	"Disc %s senza divisorio esteso corrispondente!" CRLF,			\
	"Disco %s sem a divisória prolongada correspondente!" CRLF,		\
	"Laufwerk %s ohne entsprechende erweiterte Partition!" CRLF,	/* jj */	\
	"Schijf %s zonder overeenkomstige uitgebreide verdeling!" CRLF		\
	)

#define EP_ENTER_NEW_VALUE_CURRENT_MIN_MAX MLTSTR2 ( \
	"disk %s: end extended partition at %llU (min %U, max %U), type new value or ESC: ",					\
	"disque %s: fin de la partition étendue à %llU (min %U, max %U), entrer la nouvelle valeur ou ESC: ",			\
	"диск %s: закончите выдвинутую перегородку на %llU (минута %U, максимальные %U), тип новое значение или ESC: ",		\
	"disco %s: termine la partición extendida en %llU (minuto %U, %U máximos), el tipo nuevo valor o salida: ",		\
	"disc %s: concluda il divisorio esteso a %llU (minuti %U, %U massimi), il tipo il nuovo valore o l'ESC: ",		\
	"disco %s: termine divisória prolongada em %llU (minuto %U, %U máximos), tipo valor novo ou ESC: ",			\
	"Laufwerk %s: Ende der erweiterten Partition bei %llU (minimal %U, maximal %U), Eingabe vom neuen Wert oder ESC: ",	/* jj */	\
	"schijf %s: het eind breidde verdeling bij %llU (min %U, maximum %U), type nieuwe waarde of ESC uit: "			\
	)

#define EP_OUT_OF_RANGE MLTSTR2 ( \
	" out of range, next disk.",			\
	" en dehors des limites, disque suivant.",	\
	" из ряда, следующий диск.",			\
	" fuera de gama, disco siguiente.",		\
	" fuori portata, disc seguente.",		\
	" fora da escala, disco seguinte.",		\
	" außerhalb des zulässigen Bereichs, nächstes Laufwerk.",	/* jj */	\
	" uit waaier, volgende schijf."			\
	)

#define EP_ROUND_VALUE_U_TO_U MLTSTR2 ( \
	"; round value given %U to %U? (Y/n) ",			\
	"; arrondir la valeur %U à %U? (Y/n) ",			\
	"; круглое значение, котор дали %U к %U? (Y/n) ",	\
	"; ¿valor redondo dado %U a %U? (Y/n) ",		\
	"; valore rotondo dato %U - %U? (Y/n) ",		\
	"; valor redondo dado %U a %U? (Y/n) ",			\
	"; Wert %U aufrunder zu %U ? (Y/n) ",	/* jj Yes=Ja adapted ?? */	\
	"; ronde waarde gegeven %U tot %U? (Y/n) "		\
	)

#define EP_USING_VALUE_U MLTSTR2 ( \
	", using value %U,",			\
	", utilise la valeur %U,",		\
	", используя значение %U,",		\
	", usando el valor %U,",		\
	", usando il valore %U,",		\
	", usando o valor %U,",			\
	", verwende Wert %U,",	/* jj */	\
	", die waarde %U gebruikt,"		\
	)

#define EP_WRITE_FAILED MLTSTR2 ( \
	" Write MBR failed! (check Gujin read-only config)",					\
	" Erreur lors de l'écriture du MBR! (vérifier l'autorisation d'écriture de Gujin)",	\
	" пишет ое MBR! (config только для чтения Gujin проверки)",				\
	" escribe MBR fallado! (config inalterables de Gujin del cheque)",			\
	" scrive MBR venuto a mancare! (config passivi di Gujin del controllo)",		\
	" escreve MBR falhado! (config de leitura apenas de Gujin da verificação)",		\
	" Schreiben vom MBR gescheitert! (Überprüfe Schreibschutz der Gujin Konfiguration)",	/* jj */	\
	" schrijft ontbroken MBR! (read-only config van controleGujin)"				\
	)

#define EP_DONE MLTSTR2 ( \
	" updated.",		\
	" mis à jour.",		\
	" обновленный.",	\
	" actualizado.",	\
	" aggiornato.",		\
	" actualizado.",	\
	" aktualisiert.",	\
	" bijgewerkte."		\
	)

/*
 * Following messages can have "\n" only, no need of "\r\n",
 * because they are used in centered_print()
 */
#define TURN_OFF_MONITOR_NBLINES 3
#define TURN_OFF_MONITOR MLTSTR2 ( \
	"It is better to turn OFF your monitor for these tests,\n"	\
    "until you hear the end beep, mostly if disks are R/W.\n"		\
    "This can take few minutes on slow PC.",				\
	"Il est préférable d'éteindre votre moniteur pour ces tests,\n"		\
    "et ce jusqu'au beep de fin, surtout si les disques sont écrivables.\n"	\
    "Cela peut prendre quelques minutes sur les anciens PCs.",			\
	"Более лучшее повернуть ваш монитор для этих испытаний, до тех пор пока\n"	\
    "вы не будете слышать bip конца, главным образом если диски R/W.\n"			\
    "Это может требовать немногих минут на медленном ПК.",				\
	"Es mejor dar vuelta APAGADO a su monitor para estas pruebas, hasta que\n"	\
    "usted oye el beep del extremo, sobre todo si los discos son R/W.\n"		\
    "Esto puede tomar pocos minutos en la PC lenta.",					\
	"È migliore spegnere il vostro video per queste prove, fino a che non\n"	\
    "sentiate il beep dell'estremità, principalmente se i disc sono R/W.\n"		\
    "Ciò può occorrere pochi minuti sul PC lento.",					\
	"É melhor desligar seu monitor para estes testes, até que você\n"	\
    "ouça o beep da extremidade, na maior parte se os discos são R/W.\n"		\
    "Isto pode fazer exame de poucos minutos no PC lento.",			\
	"Es ist besser, Ihren Monitor für diese Tests AUS zuschalten,\n"	/* jj?? */	\
    "bis Sie das letzte Piepsen hören, meistens wenn Laufwerke R/W sind.\n"	\
    "Dies kann wenige Minuten auf langsamem PC dauern.",		\
	"Het is beter om uw monitor voor deze tests uit te zetten, tot u\n"	\
    "het eind beep hoort, meestal als de schijven R/W.\n"			\
    "Dit kan weinig notulen op langzame PC nemen."				\
	)

#define IN_U_SECOND_AUTOLOAD_S MLTSTR2 ( \
	"In %u seconds, loading of:\n"       "%s\n" "Press any key to cancel",				\
	"Dans %u secondes, chargement de:\n" "%s\n" "Pressez n'importe quelle touche pour annuler",	\
	"В %u секундах, нагружать:\n"        "%s\n" "Отожмите любой ключа для того чтобы отменить",	\
	"En %u segundos, el cargar de:\n"    "%s\n" "Presione cualquier llave para cancelar",		\
	"In %u secondi, carico di:\n"        "%s\n" "Premi tutta la tasto per annullare",		\
	"Em %u segundos, carregamento de:\n" "%s\n" "Pressione toda a chave para cancelar",		\
	"In %u Sekunden laden von:\n"        "%s\n" "Drücken Sie eine Taste, zum Abbruch",	/* jj */	\
	"In %u seconden, die laden van:\n"   "%s\n" "Duw op om het even welke te annuleren sleutel"	\
	)

#define ADVERTISEMENT_BANNER_NBLINES 3
#define ADVERTISEMENT_BANNER_MINWIDTH	77 /* 40 colunms: not displayed */
#define ADVERTISEMENT_BANNER MLTSTR2 ( \
	"Welcome to the world of free, open-source software.\n"		\
    "Gujin is available under GPL v2, please read once the\n"		\
    "file GPL.TXT; for more information visit http://gujin.org.",	\
	"Bienvenue dans le monde du logiciel au source libre.\n"	\
    "Gujin est disponible sous license GPL v2, lisez sa traduction\n"	\
    "une fois, et pour plus d'information visitez http://gujin.org.",	\
	"Добро пожаловать к миру свободной, програмному обеспечению\n"		\
    "раскрывать-источника. Gujin имеющееся под GPL v2, пожалуйста читало\n"	\
    "раз архив GPL.TXT;для больше посещения http://gujin.org информации.",	\
	"Bienvenida en el mundo del programa informático a la fuente disponible.\n"	\
    "Gujin está disponible bajo lic GPL v2, lee su traducción una vez,\n"		\
    "y para más información visitan http://gujin.org.",					\
	"Benvenuto nel mondo del software alla fonte disponibile.\n"		\
    "Gujin è disponibile sotto license GPL v2, legge la sua traduzione\n"	\
    "una volta, e per più informazione visitate http://gujin.org.",		\
	"Boas-vindas no mundo do software à fonte disponível.\n"	\
    "Gujin está disponível sob license GPL v2, lê a sua tradução\n"	\
    "uma vez, e para mais informação visitam http://gujin.org.",	\
	"Willkommen in der Welt der freien, Quellcode verfügbaren Software.\n"	\
    "Gujin ist unter Lizenz GPL v2 verfügbar, Lesen sie bitte einmal die\n"	\
    "Datei GPL.TXT; für mehr Information besuche http://gujin.org.",	/* jj */	\
	"Welkom in de wereld van de software aan de beschikbare bron.\n"	\
    "Gujin is beschikbaar onder license LPG v2, leest zijn vertaling\n"		\
    "eens, en voor meer informatie bezoekt http://gujin.org."			\
	)

