/* kbd.h */
#ifndef KBD_H
#define KBD_H

/* Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 * This work is registered with the UK Copyright Service: Registration No:299755
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "make.h"

/**
 ** The functions:
 **/
unsigned short kbd_translate (unsigned short key);
awk_farcall (kbd_translate);
void kbd_setup (enum kbd_enum kbdmap);
awk_farcall (kbd_setup);
unsigned kbd_detect (void);
awk_farcall (kbd_detect);
unsigned get_line (char *buffer, unsigned maxlen, char display, unsigned char lowlimit, unsigned char highlimit);
awk_farcall (get_line);
unsigned get_number (unsigned deflt, unsigned max);
awk_farcall (get_number);
void adjust_extended_partition_length (void);
awk_farcall (adjust_extended_partition_length);

#endif /* KBD_H */
