/* hello_bios.c - public domain - no support whatsoever */

#ifndef __ELF__
#error Gujin can only load ELF files, and this compiler is not producing ELF files
#endif

/* Constant entry block, max 64 KB code+data+stack, do not touch: */
asm (
"	.code16gcc				\n"
"	.section .init,\"ax\",@progbits		\n"
"	.global _start				\n"
"_start:					\n"
//  "int $3 # if debugging with borland td.exe, started by mingujin.exe	\n"
"	pushw	%ds				\n"
"	pushw	%es				\n"
"	pushw	%fs				\n"
"	pushw	%gs				\n"
"	pushfl					\n"
"	pushal					\n"
"	movw	%ss,%cs:1f+1			\n"
"	movw	%sp,%cs:2f+2			\n"
//"	wbinvd					\n"
"	movw	%cs,%ax				\n"
"	movw	%ax,%ds				\n"
"	movw	%ax,%es				\n"
"	movw	%ax,%fs				\n"
"	movw	%ax,%gs				\n"
"	movw	%ax,%ss				\n"
"	movl	$0,%esp				\n"
"	cld					\n"
"	calll	main				\n"
"	mov	%ax,%fs				\n"
"	roll	$16,%eax			\n"
"	mov	%ax,%gs				\n"
"1:	movw	$0,%ax				\n"
"	movw	%ax,%ss				\n"
"2:	movl	$0,%esp				\n"
"	popal					\n"
"	mov	%gs,%ax				\n"
"	roll	$16,%eax			\n"
"	mov	%fs,%ax				\n"
"	popfl					\n"
"	popw	%gs				\n"
"	popw	%fs				\n"
"	popw	%es				\n"
"	popw	%ds				\n"
"	lretw					\n"
"	.previous				\n"
);

/* For information about asm() construct, see GCC manual:
http://gcc.gnu.org/onlinedocs/gcc-4.3.3/gcc/Extended-Asm.html
    For information about BIOS services, see
http://heim.ifi.uio.no/~stanisls/helppc/
*/
enum standard_color {
	black,		blue,		green,		cyan,
	red,		magenta,	brown,		lightgray,
	darkgray,	lightblue,	lightgreen,	lightcyan,
	lightred,	lightmagenta,	yellow,		white
	};

/* This assumes 16 colors modes, text or graphic - i.e. not 256 colors: */
static inline void
VGA_writestring (const char *string, unsigned char row, unsigned char col)
{
	unsigned short page_attribute = 16 * blue + lightgray, strlen_string;
	const char *endstring = string;

	/* We cannot rely on libc to provide strlen(): */
	while (*endstring)
		endstring++;
	strlen_string = endstring - string;

	asm (
"	xchgl	%%ebp,%4		\n"
"	int	$0x10 # writestring	\n"
"	xchgl	%%ebp,%4		\n"
		: : "a" (0x1301), "b" (page_attribute),
		"c" (strlen_string), "d" (((unsigned short)row << 8) | col),
		"r" (string)	/* in fact %es:%bp, but "B" (string) doesn't work */
		);
}

static inline void BIOS_wait (unsigned nb_microsecond)
{
	unsigned short status;

	/* Use volatile when there is at least one result, but even if the result
		is not used, the code has to be inserted (status is the result): */
	asm volatile ("	int	$0x15	"
		: "=a" (status)
		:  "a" (0x8600), "d" (nb_microsecond & 0xFFFF), "c" (nb_microsecond >> 16)
		);
}

int main (void)
{
	VGA_writestring ("Hello BIOS world! Please wait...\r\n", 0, 0);
	BIOS_wait (3 * 1000 * 1000); /* 3 seconds before returning to Gujin*/
//	return 0x80000000; /* to return to Gujin menu */
	return 0xA0000000; /* to return to Gujin menu, do not display "press a key to continue" */
}

