/* hello_64bits.c - public domain - no support whatsoever */

#ifndef __ELF__
#error Gujin can only load ELF files, and this compiler is not producing ELF files
#endif

/* EVEN if Gujin manages 64 bits ELF files (with 64 bits addresses
   and sizes), all the code/data loaded have to be below the 32 bits
   limit, and the entry point is entered in 32 bits mode and not
   64 bits mode. You have to jump yourself to 64bits to be able
   to execute the code generated by the C compiler, after setting
   the paging subsystem and the stack */

const char msg1[] = "Hello protected-mode text world! "; // .rodata
char msg2[] = "(ELF64 file) ... please reboot ... "
		"             _start=0x"; // .data

asm(
"	.text			\n"
"	.code32			\n"
"	.global	_start		\n"
"_start:			\n"
"	mov	$0xB8000,%edi	\n"
"	add	$640,%edi	\n" // 8 * 80 = 4 lines from screen top
"	mov	$msg1,%esi	\n"
"	mov	$0x17,%ah	\n" // 16 * blue + lightgray
"	1:			\n"
"	lodsb	%ds:(%esi),%al	\n"
"	cmpb	$0,%al		\n"
"	je	2f		\n" // display next message
"	stosw	%ax,%es:(%edi)	\n"
"	jmp	1b		\n"
"	2:			\n"
"	mov	$msg2,%esi	\n"
"	1:			\n"
"	lodsb	%ds:(%esi),%al	\n"
"	cmpb	$0,%al		\n"
"	je	3f		\n"
"	stosw	%ax,%es:(%edi)	\n"
"	jmp	1b		\n"
// display addr to check relocation in ELF64:
"	3:			\n"
"	mov	$_start,%ebx	\n"
"	mov	$8,%ecx		\n"
"	4:			\n"
"	roll	$4,%ebx		\n"
"	mov	%bl,%al		\n"
"	andw	$0x0F,%ax	\n"
"	sahf	# clear AF	\n"
"	aaa			\n"
"	aad	$0x11		\n"
"	add	$0x1730,%ax	\n"
"	stosw	%ax,%es:(%edi)	\n"
"	loop	4b		\n"
"	jmp	.		\n" // wait reboot
);

