/* hello_32bits.c - public domain - no support whatsoever */

#ifndef __ELF__
#error Gujin can only load ELF files, and this compiler is not producing ELF files
#endif

const char msg1[] = "Hello protected-mode text world! ";	// .rodata
char msg2[] = "(ELF32) ... please reboot ...";	//.data
static unsigned stack[64 * 1024 / 4] __attribute__ ((aligned(32)));

enum standard_color {
	black,		blue,		green,		cyan,
	red,		magenta,	brown,		lightgray,
	darkgray,	lightblue,	lightgreen,	lightcyan,
	lightred,	lightmagenta,	yellow,		white
	};

void _start (void)
{
	asm (" mov %0,%%esp " : : "i" (&stack[sizeof(stack)/sizeof(stack[0])]));
	/* We are flat non-paged memory and interrupt disabled */
	unsigned cpt1, cpt2;
	/* We want blue background color and lightgray foreground: */
	unsigned short color = 16 * blue + lightgray;
	/* This work only in text modes (assumed mode 3), video memory
	at real mode address 0xB800:0000
	At this address, we shall write two bytes per char, one containing
	the foreground and background color, the other containing the letter */
	volatile unsigned short *video_array = (volatile unsigned short *)0xB8000;
	video_array += 4 * 80;	/* few empty lines */
	for (cpt1 = 0; cpt1 < sizeof(msg1) - 1; cpt1++)
		video_array[cpt1] = (color << 8) + msg1[cpt1];
	for (cpt2 = 0; cpt2 < sizeof(msg2) - 1; cpt2++)
		video_array[cpt1++] = (color << 8) + msg2[cpt2];
	/* Clear few lines: */
	while (cpt1 < 10 * 80)
		video_array[cpt1++] = (color << 8) + ' ';
#if 1
	/* Display  some addresses to check relocations: */
	unsigned idx;
	for (idx = 0; idx < sizeof("_start = 0x") - 1; idx++)
		video_array[cpt1++] = 0x1700 + "_start = 0x"[idx];
	for (idx = 0; idx < 8; idx++)
		video_array[cpt1++] = 0x1700 + "0123456789ABCDEF"
			[((unsigned long)_start >> (28 - 4 * idx)) & 0x0F];
	for (idx = 0; idx < sizeof(", msg1 = 0x") - 1; idx++)
		video_array[cpt1++] = 0x1700 + ", msg1 = 0x"[idx];
	for (idx = 0; idx < 8; idx++)
		video_array[cpt1++] = 0x1700 + "0123456789ABCDEF"
			[((unsigned long)msg1 >> (28 - 4 * idx)) & 0x0F];
	for (idx = 0; idx < sizeof(", msg2 = 0x") - 1; idx++)
		video_array[cpt1++] = 0x1700 + ", msg2 = 0x"[idx];
	for (idx = 0; idx < 8; idx++)
		video_array[cpt1++] = 0x1700 + "0123456789ABCDEF"
			[((unsigned long)msg2 >> (28 - 4 * idx)) & 0x0F];
	for (idx = 0; idx < sizeof(", bottom stack = 0x") - 1; idx++)
		video_array[cpt1++] = 0x1700 + ", bottom stack = 0x"[idx];
	for (idx = 0; idx < 8; idx++)
		video_array[cpt1++] = 0x1700 + "0123456789ABCDEF"
			[((unsigned long)stack >> (28 - 4 * idx)) & 0x0F];
#endif

	/* wait for reboot, only GPL applications (GZIP comment) can return
		to Gujin */
	while (1)
		continue;
}

