/* gzlib.h */

/*
  The original source is the zlib library - but it has been heavily
  modified to save code space (begin with gcc -E), bugs are mine.

 *********  My changes are covered by the GPL license  *********
 ***************************************************************
 * Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 * This work is registered with the UK Copyright Service: Registration No:299755
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ***************************************************************

  zlib.h -- interface of the 'zlib' general purpose compression library
  version 1.1.3, July 9th, 1998

  Copyright (C) 1995-1998 Jean-loup Gailly and Mark Adler

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Jean-loup Gailly        Mark Adler
  jloup@gzip.org          madler@alumni.caltech.edu


  The data format used by the zlib library is described by RFCs (Request for
  Comments) 1950 to 1952 in the files ftp://ds.internic.net/rfc/rfc1950.txt
  (zlib format), rfc1951.txt (deflate format) and rfc1952.txt (gzip format).
*/

#ifndef GZLIB_H
#define GZLIB_H

/* The only compression method recognised by Gzip: */
#define Z_DEFLATED	8

/* The Gzip header: */
struct gzip_header_str {
    unsigned short      signature_0x8B1F;
    unsigned char       compression_method; /* =8, always deflate for gzip */
    struct gzip_header_flags_str {
	unsigned char   ascii       : 1; /* file probably ascii text */
	unsigned char   header_crc  : 1; /* header CRC present */
	unsigned char   extra_field : 1; /* extra field present */
	unsigned char   orig_name   : 1; /* original file name present */
	unsigned char   comment     : 1; /* file comment present */
	unsigned char   reserved    : 3;
	} __attribute__ ((packed)) flags;
    unsigned            modif_time;      /* nb second since 1/1/1970 */
    enum { max_compress = 2, fast_algo = 4 } extraflags : 8;
    unsigned char       operating_system;
    } __attribute__ ((packed));

/* Maximum size of dynamic tree.  The maximum found in a long but non-
   exhaustive search was 1004 huft structures (850 for length/literals
   and 154 for distances, the latter actually the result of an
   exhaustive search).  The actual maximum is not known, but the
   value below is more than safe. */
#define MANY		1440

/* If BMAX needs to be larger than 16, then h and x[] should be unsigned. */
#define BMAX		15         /* maximum bit length of any code */

/* Just if you want to waste data space
   (Athlon 1.4GHz kernel CRC32 in 100 ms without crc_table of 4 Kbytes):
   But on small processors CRC32 calculus is slow so: */
//#define GZLIB_USE_COMPILED_CRC_ARRAY
#define GZLIB_USE_PRECOMPILED_CRC_ARRAY

#if ASSEMBLY_TYPE != ASSEMBLY_DSES
#define GZLIB_USE_INTERMEDIATE_WINDOW
/* 32K LZ77 window: */
#define MAX_WBITS	15
#endif

/* Intermediate structures: */
typedef struct {
    unsigned char	exop;
    unsigned char	bits;
    unsigned short	base;
    } __attribute__ ((packed)) inflate_huft;

typedef struct {
    inflate_huft	*tree;
    unsigned char	need;
    } inflate_huft_size;

/* The main structure: */
typedef struct z_stream {
    enum {
	INIT = 0, SIGNATURE, METHOD, FLAGS,
	MODIF_TIME1, MODIF_TIME2, MODIF_TIME3, MODIF_TIME4,
	EXTRAFLAGS, OPERATING_SYSTEM,
	EXTRAFIELDLEN, EXTRAFIELD, ORIGNAME, COMMENT, HEADERCRC,
	TYPE,
	STORED_LENS, STORED_NOTLENS, STORED_COPY,
	TABLE, BTREE, DTREE1, DTREE2, DTREE3,
	CODES_START, CODES_LEN, CODES_LENEXT, CODES_DIST,
	CODES_DISTEXT, CODES_COPY,
	DONE, CRCCHK, ALLDONE,
	BAD
	} mode;

    unsigned		bitb;
    unsigned char	bitk;
    unsigned char	last;

#ifdef GZLIB_USE_INTERMEDIATE_WINDOW
    unsigned short	write;
    unsigned char	*window;
#endif

    unsigned char	*next_in;
    unsigned		avail_in;

    unsigned char	*next_out;
    unsigned		avail_out;
    unsigned		total_out;	/* also vmlinuz_header_treat::treat_start_bytes */

    unsigned		crc32;		/* also vmlinuz_header_treat::version_string */

    union {
	struct {
	    union {
		struct gzip_header_flags_str	flags;
		unsigned short			data;
		} sub;
	    unsigned short	len;
#define GZLIB_MAXBUF	640	/* see blens size later */
	    char		buffer[GZLIB_MAXBUF+1];
	    } gzip_header;
	struct {
	    /* patch 16->32 bits to load an uncompressed initrd */
	    unsigned /*short*/	left;
	    unsigned		load_uncompressed;
	    } stored;
	struct {
	    unsigned short	len;
	    inflate_huft_size	curhuft;

	    union {
		struct {
		    unsigned short	get; // nbbit
		    unsigned short	dist;
		    } copy;
		struct {
		    unsigned short	nbbit; // get
		    unsigned short	table;
		    unsigned short	index;
		    } trees;
		} sub;

	    inflate_huft_size	lbitstree;
	    inflate_huft_size	dbitstree;
	    /* 640 bytes here: */
	    unsigned short	blens[(258 + 0x1F + 0x1F)
					* sizeof (unsigned short)];
	    } cdtr; /* codes or trees, used at the same time */
	struct {
	    union {
		struct {
		    unsigned	crc32;
		    unsigned	length;
		    } data;
		unsigned short	array[4];
		} __attribute__ ((packed)) sub;
	    unsigned short	arrayindex;
	    } crcchk;
	} sub;

    /* 1440 * 4 = 5760 bytes here: */
    inflate_huft	hufts[MANY];
    } z_stream;

typedef enum {
    Z_OK = 0,
    Z_STREAM_END,
    Z_STREAM_ERROR,
    Z_DATA_ERROR,
    Z_MEM_ERROR,
    Z_BUF_ERROR,
    Z_OUPUT_FULL,
    Z_BAD_LENGTH,
    Z_BAD_CRC,
    Z_BASE_MEMCOPY_ERROR
    } zret_t;

#ifdef GZLIB_USE_INTERMEDIATE_WINDOW
//#define GZLIB_TEST_MEASURE
#endif

/*
 * At first entry, z->mode == INIT == 0 and all other
 * fields have to be null.
 * To abort, set "z->mode = BAD" and call inflate().
 */
zret_t inflate (z_stream *z);
awk_farcall (inflate);
unsigned crc32check (unsigned inhibit);
awk_farcall (crc32check);

#ifdef GZLIB_TEST_MEASURE
extern enum crc32state_e { load_kernel = 0, load_initrd,  load_restart } crc32state;
void crc32multicheck (void);
awk_farcall (crc32multicheck);
#define GZLIB_TEST_MEASURE_init()	crc32state = load_restart /* reinitialise CRC32 arrays */
#define GZLIB_TEST_MEASURE_do()		crc32multicheck ()
#else
#define GZLIB_TEST_MEASURE_init()	/* nothing */
#define GZLIB_TEST_MEASURE_do()		/* nothing */
#endif /* GZLIB_TEST_MEASURE */

#endif /* GZLIB_H */
