# gujin.cmd: the distributed Linux kernel description

#  The Gujin GPL bootloader (at gujin.org) will parse every file named
# "gujin.cmd" in every directory it scans (usually root and /boot of
# every filesystems of every disk detected), and keep these kernel
# descriptions in memory. It uses these descriptions mainly to
# add Linux kernel command line parameters, and present the
# Gujin user with a meaningfull click-able name to boot the kernel.
# Parsing every files with the name "gujin.cmd" enable to change the
# command line of the kernel of a CDROM live image, and ease the
# use of distributions installed on removeable medias.

# The syntax of this file is, first, '#' start a comment until the end of
# the line, those comments are stripped before anything else.
# The end of the line is either '\n' or '\r\n', former prefered.
# Empty line (or lines containing only spaces) are ignored, and
# identical lines (probably in multiple files) are stripped.
:filesystemlabel:kernelname:initrdname:timeout:menuname:commandline
:filesystemlabel:kernelname:initrdname:timeout:menuname:commandline
:filesystlabel:kern\elname:initrdname:timeout:menuname:commandline
:filesystlabel:kern\elname:initrdname:timeout:menuname:commandline

# Each line shall begin with a char from the list: "!$%&+/:=?@|\t",
# excluding quotes, this char defines the separator of fields for
# that line. Usually the colon will be used (like /etc/password),
# but if the Linux command line contains a colon, chose something else.
# Long lines can be cut by a backslash, but it may be wise not to use
# that feature if using automatic tools (sed/awk/uniq) to manipulate this file.
# The backslash is only interpreted if it is followed by an end-of-line,
# with possibly some spacing in between the '\' and the first char of
# the next line.
# ADD Gujin-v2.8.2: if the last char of the line is the delimiter
# (first char == last char), the command line is not to be modified at all
# by Gujin when loading that kernel.


# The first, second and third fields defines for which kernels this
# configuration is intended, the last three fields of the line define
# the configuration itself (so this line can be extended in the middle).
# Some of the first three fields can be terminated by a star '*' to specify
# that any ending will be accepted, but the star is not recognised
# anywhere else in those three fields.
# ADD Gujin-v2.8.2: The last star of the menuname (if present) will be
# replaced by the version part of the kernel and initrd filename,
# i.e. the part in between minus signs in vmlinuz-2.6.44_3-i386.
# An empty field "::" is equivalent to a single star ":*:", but for the
# filesystemlabel fields where it means: the label of the filesystem
# containing this "gujin.cmd". It is the label of the CDROM if Gujin
# is analysing an ISO image inside a filesystem.

# This current file do not enable you to define which files are kernels
# and initial RAM disks, the standard way of Gujin is used for that
# (i.e. vmlinuz*, bzImage* and linux* are kernels, initrd* and initra*
# (for intramfs) are initial RAM disks), but a line in this file matching
# one kernel found by Gujin will modify Gujin behaviour.
# For an initrd* to be associated to a kernel, it has to be in the
# same directory or iso image - no directory name appear in this file.
#
# So this file is not needed at all if the distribution you are using do
# not need complex Linux command line parameters that cannot be
# typed with Gujin command line interface. Parameters like "quite"
# or "debug" are better kept on the interactive command line to
# be added or removed when needed, parameter like vga=791 is
# not needed because Gujin will set the current graphic video
# mode (if "force textmode before running Linux" is not ticked),
# and parameter rw/ro may not be needed.
# For debug, you can display what Gujin stored by typing the
# letter 'C' (keyboard recognised), maybe temporary feature.

# In short, we have this format:
:filesystemlabel:kernelname:initrdname:timeout:menuname:commandline

# The "initrdname" field is mostly used to bypass the Gujin autoselection
# of initrd from kernel based on the end of the filename, it can be
# set to '-' to disable the loading of any initrd, it can be set to '*'
# to take the first initrd in that directory whatever the end of its name,
# it can be used to be able to load the same kernel with two different
# initrds,  but most of the time it should not be specified to use the
# standard Gujin association.
# The timeout (if present and not null) is the time before auto-booting
# that kernel/initrd file (if found) in seconds, but only if Gujin is not
# already setup to autoload a kernel from the hard disk.

# If we want to always use parameter "nomodeset" to any Linux
# kernel named vmlinux-bluehat* in the filesystem named bluehat,
# we just have:
:bluehat:vmlinuz-bluehat*:::blue hat kernel without nomodeset:nomodeset

# We can also have all yellowhat kernel whatever the filesystem label
# to have the same parameter with:
::bzImage-yellowhat*:::yellow hat kernel with nomodeset:nomodeset

# And we can have two choices for every pinkhat kernel, on the pinkhat
# filesystem with or witout acpi, by the lines:
:pinkhat:vmlinuz-*:::pink hat kernel without acpi:nomodeset noacpi
:pinkhat:vmlinuz-*:::pink hat kernel with acpi:nomodeset

# To set filesystem name, use e2label, genisoimage -V or dosfslabel
# or even mlabel from mtools. In an ISO image, the label is at offset 0x8028:
# $ xxd -s 0x8028 -l 0x20 G:/linuxmint-9-gnome-cd-i386.iso
# 0008028: 4c69 6e75 7820 4d69 6e74 2039 2049 7361  Linux Mint 9 Isa
# 0008038: 646f 7261 2020 2020 2020 2020 2020 2020  dora
# If the filesystem name is not set, Gujin will chose a default like "floppy",
# and display that default in its menu at boot. They are case-sensitive.

# Real world examples:
###############

# File sidux-2009-04-moros-kde-lite-i386-200912310312.iso fsname "sidux" internal directory "/boot"
# Ignore "quiet" because it is usually in internal command line, and "vga=791" because it is
# automatically generated (when Gujin is not forced to start kernels in text mode)
:sidux:vmlinuz0.686:initrd0.686::sidux 686:boot=fll
:sidux:vmlinuz0.686:initrd0.686::sidux 686 Extra Options Text Mode:boot=fll 3

# File sidux-2009-03-momos-xfce-i386-200911110039.iso fsname "sidux" internal directory "/boot"
# Displays in the Gujin menu the choice: "sidux 686 (2.6.31)"
:sidux:vmlinuz-2.6.31-6.slh.1-sidux-686:initrd.img-2.6.31-6.slh.1-sidux-686::sidux 686 (*):boot=fll
:sidux:vmlinuz-2.6.31-6.slh.1-sidux-686:initrd.img-2.6.31-6.slh.1-sidux-686::sidux 686 (*) Text Mode:boot=fll 3

# File NimbleX-2008.iso fsname "NimbleX" internal directory "/boot"
:NimbleX:vmlinuz-nx08:initrd-nx08.gz::NimbleX 2008 - Boot in KDE:ramdisk_size=7120 root=/dev/ram0 rw splash=silent changes=nimblex.data autoexec=startx

# File NimbleX-2010.iso fsname "NimbleX" internal directory "/boot"
:NimbleX:vmlinuz-nx10:initrd-nx10.gz::NimbleX 2010 - Boot in KDE:ramdisk_size=7000 root=/dev/ram0 rw autoexec=startx

# File elive_2.0_Topaz_new-kernel_up001.iso fsname "Elive 2010-03-03" internal directory "/boot"
# Accept any ISOFS label starting with "Elive"
:Elive*:vmlinuz-2.6.30.9-elive-686:initrd.img-2.6.30.9-elive-686::Elive Normal Mode:boot=eli resolution
:Elive*:vmlinuz-2.6.30.9-elive-686:initrd.img-2.6.30.9-elive-686::Elive Graphical Problems:boot=eli hardscreen
# For those two accept any kernel starting with "vmlinuz", and accept the default initrd automagically
# found by Gujin; and display in the menu the string "(2.6.30.9)":
:Elive*:vmlinuz*:::Elive No Bluetooth (*):boot=eli resolution nobluetooth
:Elive*:vmlinuz*:::Elive No Mount Partitions Automatically (*):boot=eli resolution nomount

# File /ubuntu-9.10-desktop-i386.iso fsname "Ubuntu 9.10 i386" internal directory "/casper"
# Should also work unmodified for ubuntu-9.10-desktop-amd64.iso:
:Ubuntu*:vmlinuz:::Try Ubuntu without any change to your computer:boot=casper noeject noprompt file=/cdrom/preseed/ubuntu.seed splash
:Ubuntu*:vmlinuz:::Install Ubuntu:boot=casper noeject noprompt file=/cdrom/preseed/ubuntu.seed splash only-ubiquity
# Command line forced (ending semicolon) so ubuntu-9.10-desktop-i386.iso need to be in root:
:Ubuntu*:vmlinuz:initrd.lz::Ubuntu Live 9.10 32bit cmdforced:boot=casper noeject noprompt iso-scan/filename=/ubuntu-9.10-desktop-i386.iso:
# Command line for ubuntu-9.10-desktop-i386.iso (iso-scan/filename=) automatically generated from FROMISO=:
:Ubuntu*:vmlinuz:initrd.lz::Ubuntu Live 9.10 32bit cmdadvised:boot=casper noeject noprompt FROMISO=iso-scan
# Command line for ubuntu-9.10-desktop-i386.iso (iso-scan/filename=) automagically generated from FS label:
:Ubuntu*:vmlinuz:initrd.lz::Ubuntu Live 9.10 32bit cmdauto:boot=casper noeject noprompt

# File eeebuntu-3.0-standard.iso fsname "eeebuntu-3.0-standard" internal directory "/casper"
:eeebuntu*:vmlinuz:initrd.gz:7:Try eeebuntu without any change to your computer:file=/cdrom/preseed/ubuntu.seed boot=casper splash

# File /F13-Alpha-i686-Live.iso fsname "F13-Alpha-i686-Live" internal directory "/isolinux"
# In these lines we use '|' as a field separator because the command line contains a ':'...
#:F13-Alpha-i686-Live:vmlinuz0:initrd0.img::Fedora Live:rootfstype=auto ro liveimg initrd=initrd0.img rhgb rd_NO_LUKS rd_NO_MD noiswmd
|F13*|vmlinuz0|initrd0.img||Fedora Live cmdforced|root=live:LABEL=EL-BOOT-28:/F13-Alpha-i686-Live.iso rootfstype=auto ro liveimg rhgb rd_NO_LUKS rd_NO_MD noiswmd|
|F13*|vmlinuz0|initrd0.img||Fedora Live cmdauto|rootfstype=auto ro liveimg rhgb rd_NO_LUKS rd_NO_MD noiswmd
|F13*|vmlinuz0|initrd0.img||Fedora Live cmdadvised|FROMISO=root rootfstype=auto ro liveimg rhgb rd_NO_LUKS rd_NO_MD noiswmd

# File /bt4-final.iso fsname "BT4" internal directory "/boot"
:BT4:vmlinuz:initrd.gz::BackTrack 4:boot=casper noeject noprompt nopersistent rw

# File /LinuxMint-8.iso or linuxmint-9-gnome-cd-i386.iso (iso-scan/filename=) internal directory "/casper"
:Linux Mint*:vmlinuz:initrd.lz::LinuxMint:boot=casper noeject noprompt splash
#:Linux Mint*:vmlinuz:initrd.lz::LinuxMint:boot=casper noeject noprompt splash file=/cdrom/preseed/mint.seed

# File /xbmc-9.11-live-repack.iso fsname "XBMC_Live" internal directory "/" (isofrom=/dev/sda1/boot/xbmc-9.11-live-repack.iso)
:XBMC_Live:vmlinuz:initrd.img::XBMC Live Intel GPU, SAFE MODE:FROMISO=iso-scan boot=live xbmc=tempfs,nodiskmount,setvolume loglevel=0 persistent quickreboot quickusbmodules notimezone noaccessibility noapparmor noaptcdrom noautologin noxautologin noconsolekeyboard nofastboot nognomepanel nohosts nokpersonalizer nolanguageselector nolocales nonetworking nopowermanagement noprogramcrashes nojockey nosudo noupdatenotifier nouser nopolkitconf noxautoconfig noxscreensaver nopreseed union=aufs

# File /archlinux.iso    PROBLEM: initrd not name initrd* but archiso_pata.img, will not work
# File /grml-small_2009.10.iso   PROBLEM: kernel&initrd not in a 1st layer directory but in /boot/grmlsmall, will not work
