/* gujin-cmdline.c */

/* Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <string.h>
#include <stdio.h>

int main (int argc, char **argv)
  {
  FILE *vml;
  int ch, cptmatch = 0;
  unsigned len = 0;

  if (argc == 1 || argc > 3 || (argv[1][0] == '-' && argv[1][1] == 'h')) {
      char *name = argv[0];
      if (strchr (name, '/'))
	  name = strrchr(argv[0], '/') + 1;
      printf ("%s is a small utility to display or insert an embedded\n"
			" command line into a Linux vmlinuz file.\n", name);
      printf ("USAGE: %s vmlinuz_filename : to display the embedded command line\n", name);
      printf ("USAGE: %s vmlinuz_filename \"command line parameters\" : to set it\n", name);
      return 0;
      }
  if ((vml = fopen (argv[1], (argc > 2)? "r+" : "r")) == NULL) {
      perror (argv[1]);
      return -1;
      }

  while ((ch = fgetc (vml)) != EOF) {
      if (ftell(vml) > 0x1F0) {
	  printf ("No embedded command line detected in %s\n", argv[1]);
	  break;
	  }
      if (ch == "cmdline:"[cptmatch]) {
	  if (++cptmatch == strlen ("cmdline:")) {
	      char buffer[2048];
	      unsigned pos = ftell(vml) - strlen ("cmdline:");
	      printf ("Embedded command line signature detected at offset %u in %s:\n", pos, argv[1]);
	      while ((buffer[len] = fgetc (vml)) != EOF) {
		  if (buffer[len] == '\0')
		      break;
		  if (++len >= sizeof(buffer)) {
		      puts ("But embedded command line terminator not found");
		      break;
		      }
		  }
	      if (len < sizeof(buffer)) {
		  puts (buffer);
		  if (argc > 2) {
		      unsigned cpt;
		      if (fseek (vml, pos, SEEK_SET) != 0) {
			  perror (argv[1]);
			  fclose (vml);
			  return -2;
			  }
		      for (cpt = 0; cpt < len + strlen ("cmdline:"); cpt++)
			  if (fputc ('\0', vml) == EOF) {
			      perror (argv[1]);
			      fclose (vml);
			      return -3;
			      }
		      //printf ("Previous embedded command line at %u len %u cleared, ", pos, len);
		      }
		  }
	      break;
	      }
	  }
	else
	  cptmatch = 0;
      }
  if (argc > 2) {
      unsigned cpt, start = 0, stop = 0x1F0;
      if (fseek (vml, 0, SEEK_SET) != 0) {
	  perror (argv[1]);
	  fclose (vml);
	  return -4;
	  }
      for (cpt = 0; cpt < 0x1F0 / 2; cpt++)
	  if (fgetc (vml) != '\0')
	      start = ftell(vml);
      for (cpt = 0; cpt < 0x1F0 / 2; cpt++)
	  if (fgetc (vml) != '\0') {
	      stop = ftell(vml);
	      break;
	      }
      //printf ("Empty space from %u to %u\n", start, stop);
      len = strlen (argv[2]);
      if (len == 0) {
	  if (cptmatch != 0)
	      printf ("Embedded command line and marker erased from file %s.\n", argv[1]);
	  }
	else {
	  if (stop - start - strlen ("cmdline:") < len) {
	      printf ("Error: new command line too long (length %u, available %u)\n", len, (unsigned)(stop - start - strlen ("cmdline:")));
	      /* FIXME? maybe should not have cleared it then */
	      fclose (vml);
	      return -5;
	      }
	  if (fseek (vml, start + (stop - start - len - strlen ("cmdline:")) / 2, SEEK_SET) != 0) {
	      perror (argv[1]);
	      fclose (vml);
	      return -6;
	      }
	  if (fwrite ("cmdline:", strlen ("cmdline:"), 1, vml) != 1 || fwrite (argv[2], len, 1, vml) != 1) {
	      perror (argv[1]);
	      fclose (vml);
	      return -7;
	      }
	  printf ("Embedded command line \"%s\" written at %u\n", argv[2], (unsigned)(start + (stop - start - len - strlen ("cmdline:") / 2)));
	  }
      }

  if (fclose (vml) != 0) {
      perror (argv[1]);
      return -8;
      }
  return len;
  }
