/* font.h */
#ifndef FONT_H
#define FONT_H

/* Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 * This work is registered with the UK Copyright Service: Registration No:299755
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "make.h"

#if USER_SUPPORT != 0

extern const unsigned char font8x8[256][8], font8x14[256][14];
#if !(SETUP & UNICODE_FONT)
extern const unsigned char font8x16[256][16];
extern const unsigned short font10x20[256][20];
#define NBCHAR8x16	(sizeof(font8x16)/sizeof(font8x16[0]))
#define NBCHAR10x20	(sizeof(font10x20)/sizeof(font10x20[0]))
#else
/* To undefine/redefine those two, you need to regenerate 8x16 and 10x20 fonts
    as described in README.htm */
#define GAPSTART 0x200
#define GAPLENGTH 0x200
extern const unsigned char font8x16[0x500 - GAPLENGTH][16];
extern const unsigned short font10x20[0x500 - GAPLENGTH][20];
#define NBCHAR8x16	(sizeof(font8x16)/sizeof(font8x16[0]) + GAPLENGTH)
#define NBCHAR10x20	(sizeof(font10x20)/sizeof(font10x20[0]) + GAPLENGTH)
#endif

#endif /* USER_SUPPORT != 0 */
#endif /* FONT_H */

