/* font.c *** THIS FILE SHOULD BE EDITED WITH AN UTF-8 AWARE EDITOR *** */

/* Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 * This work is registered with the UK Copyright Service: Registration No:299755
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* For the 8x16 font, we start from the Internet file unifont-5.1.20080820.hex, see http://www.unifont.org/,
and thanks to Roman Czyborra, see http://en.wikipedia.org/wiki/Free_software_Unicode_typefaces:
make fnthex2h
./fnthex2h -m=0x500 -g=0x200 -l=0x200 unifont-5.1.20080820.hex unifont.h
Insert that unmodified file after comment "// start unifont-5.1.20080820.hex" and before "// end unifont-5.1.20080820.hex"

For the 10x20 font, we use the X font: http://www.cl.cam.ac.uk/~mgk25/download/ucs-fonts.tar.gz , see also:
http://www.cl.cam.ac.uk/~mgk25/ucs-fonts.html
Then get from Internet gbdfed-1.5.tbz2 (http://www.math.nmsu.edu/~mleisher/Software/gbdfed/), untar and compile,
for me I had to rename all getline() into Getline() to get it compiled, run it and load the font 10x20.bdf,
then export to hex file 10x20.hex. Then type:
./fnthex2h -w=10 -h=20 -m=0x500 -g=0x200 -l=0x200 10x20.hex 10x20.h
Insert that unmodified file after comment "// start ucs-fonts-10x20.hex" and before "// end ucs-fonts-10x20.hex"

In this file, a warning about redefinition of GAPSTART/GAPLENGTH (in between the different font) would be a real error!
*/

#include "make.h"
#include "font.h"

#if !defined (INCLUDE_FONT_8x8) && !defined (INCLUDE_FONT_8x14) && !defined (INCLUDE_FONT_8x16) && !defined (INCLUDE_FONT_10x20)
#define INCLUDE_FONT_8x8
#define INCLUDE_FONT_8x14
#define INCLUDE_FONT_8x16
#define INCLUDE_FONT_10x20
#endif

#if SETUP & XDATA_SEGMENT
#define FILEPREFIX	__attribute__ ((section (".xdata")))
#else
#define FILEPREFIX	/* */
#endif

#if USER_SUPPORT != 0

#define _ 0
#define X 1
#define W16(p15, p14, p13, p12, p11, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0) \
	(p15 << 15) | (p14 << 14) | (p13 << 13) | (p12 << 12) | (p11 << 11) | (p10 << 10) | (p9 << 9) | (p8 << 8) \
	| (p7 << 7) | (p6 << 6) | (p5 << 5) | (p4 << 4) | (p3 << 3) | (p2 << 2) | (p1 << 1) | (p0 << 0)
#define W15(p14, p13, p12, p11, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0) W16(0, p14, p13, p12, p11, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0)
#define W14(p13, p12, p11, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0) W15(0, p13, p12, p11, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0)
#define W13(p12, p11, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0) W14(0, p12, p11, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0)
#define W12(p11, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0) W13(0, p11, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0)
#define W11(p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0) W12(0, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0)
#define W10(p9, p8, p7, p6, p5, p4, p3, p2, p1, p0) W11(0, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0)
#define W9(p8, p7, p6, p5, p4, p3, p2, p1, p0) W10(0, p8, p7, p6, p5, p4, p3, p2, p1, p0)
#define B(p7, p6, p5, p4, p3, p2, p1, p0) W9(0, p7, p6, p5, p4, p3, p2, p1, p0)

#ifdef INCLUDE_FONT_10x20
FILEPREFIX
// start ucs-fonts-10x20.hex, see comment at top of this file
#define GAPSTART 0x200
#define GAPLENGTH 0x200
#if !(SETUP & UNICODE_FONT)
const unsigned short font10x20[256][20] = {
#else
const unsigned short font10x20[0x500 - 0x200][20] = {
#endif
    [0x0] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,_,_,_,_,_,_,X,_),
	W10 (_,X,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,_,_,_,_,_,X,_),
	W10 (_,X,_,_,_,_,_,_,X,_),
	W10 (_,X,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,_,_,_,_,_,X,_),
	W10 (_,X,_,_,_,_,_,_,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x2] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x3] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x5] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x6] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x7] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x10] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x11] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x12] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x13] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x14] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x15] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x16] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x17] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x18] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x19] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1A] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1C] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1E] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1F] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x81] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x82] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x83] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x84] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x85] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x86] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x87] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x88] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x89] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8A] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8B] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8C] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8D] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8E] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8F] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x90] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x91] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x92] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x93] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x94] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x95] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x96] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x97] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x98] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x99] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9A] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9B] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9C] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9D] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9E] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9F] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x7F] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,X,_,_,X,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,_,_,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB9] = { /* UTF-8: '¹' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB2] = { /* UTF-8: '²' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB3] = { /* UTF-8: '³' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xBC] = { /* UTF-8: '¼' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,X,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,X,X,X,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,X,_,_,X,_,_),
	W10 (_,_,_,X,_,_,X,X,_,_),
	W10 (_,_,X,_,_,X,_,X,_,_),
	W10 (_,X,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xBD] = { /* UTF-8: '½' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,X,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,X,X,X,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,X,_,X,X,_,_),
	W10 (_,_,_,X,_,X,_,_,X,_),
	W10 (_,_,X,_,_,_,_,_,X,_),
	W10 (_,X,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xBE] = { /* UTF-8: '¾' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,X,_),
	W10 (_,_,_,_,X,_,_,X,_,_),
	W10 (_,X,X,X,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,X,_,_,X,_,_),
	W10 (_,_,_,X,_,_,X,X,_,_),
	W10 (_,_,X,_,_,X,_,X,_,_),
	W10 (_,X,_,_,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['%'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,_,X,X,X,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,X,X),
	W10 (_,_,X,X,_,X,X,_,X,X),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xAA] = { /* UTF-8: 'ª' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xBA] = { /* UTF-8: 'º' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB0] = { /* UTF-8: '°' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB7] = { /* UTF-8: '·' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['.'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [':'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [','] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [';'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['\''] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['"'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['`'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['^'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['~'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA8] = { /* UTF-8: '¨' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB4] = { /* UTF-8: '´' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB8] = { /* UTF-8: '¸' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	},
    [0xAB] = { /* UTF-8: '«' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xBB] = { /* UTF-8: '»' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,X,X,_,X,X),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xAC] = { /* UTF-8: '¬' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD7] = { /* UTF-8: '×' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,_,_,_,_,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB5] = { /* UTF-8: 'µ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,_,X,X,X,_,_),
	W10 (_,X,X,X,X,X,_,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['&'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,X,X),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,_,X,X,X,X,_),
	W10 (_,_,X,X,X,X,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA7] = { /* UTF-8: '§' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB6] = { /* UTF-8: '¶' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['['] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [']'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['{'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['}'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['('] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [')'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['<'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['>'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['#'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,X),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['@'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['?'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xBF] = { /* UTF-8: '¿' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['!'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA1] = { /* UTF-8: '¡' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA6] = { /* UTF-8: '¦' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['|'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['+'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['-'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB1] = { /* UTF-8: '±' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF7] = { /* UTF-8: '÷' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['/'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['\\'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['_'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xAD] = { /* UTF-8: '­' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xAF] = { /* UTF-8: '¯' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['*'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['='] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA4] = { /* UTF-8: '¤' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,_,_,_,_,_,_,_,X,_),
	W10 (X,X,_,X,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (X,X,_,X,X,X,_,X,X,_),
	W10 (X,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA3] = { /* UTF-8: '£' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,_,X,_,X,X,_,X,X),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['$'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA2] = { /* UTF-8: '¢' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA5] = { /* UTF-8: '¥' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,_,_,_,_,_,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['0'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['1'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['2'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['3'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['4'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['5'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['6'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['7'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['8'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['9'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [' '] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA0] = { /* UTF-8: ' ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xAE] = { /* UTF-8: '®' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,_,X,X,X,X,_,X,_),
	W10 (_,X,_,X,_,_,X,_,X,_),
	W10 (_,X,_,X,X,X,X,_,X,_),
	W10 (_,X,_,X,_,X,_,_,X,_),
	W10 (_,X,_,X,_,X,X,_,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA9] = { /* UTF-8: '©' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,_,X,X,X,X,_,X,_),
	W10 (_,X,_,X,_,_,X,_,X,_),
	W10 (_,X,_,X,_,_,_,_,X,_),
	W10 (_,X,_,X,_,_,X,_,X,_),
	W10 (_,X,_,X,X,X,X,_,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xDE] = { /* UTF-8: 'Þ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xFE] = { /* UTF-8: 'þ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	},
    ['A'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC0] = { /* UTF-8: 'À' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC1] = { /* UTF-8: 'Á' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC2] = { /* UTF-8: 'Â' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC3] = { /* UTF-8: 'Ã' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC4] = { /* UTF-8: 'Ä' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC5] = { /* UTF-8: 'Å' */
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC6] = { /* UTF-8: 'Æ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['B'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['C'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC7] = { /* UTF-8: 'Ç' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	},
    ['D'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD0] = { /* UTF-8: 'Ð' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (X,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['E'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC8] = { /* UTF-8: 'È' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC9] = { /* UTF-8: 'É' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xCA] = { /* UTF-8: 'Ê' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xCB] = { /* UTF-8: 'Ë' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['F'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['G'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['H'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['I'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xCC] = { /* UTF-8: 'Ì' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xCD] = { /* UTF-8: 'Í' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xCE] = { /* UTF-8: 'Î' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xCF] = { /* UTF-8: 'Ï' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['J'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,X),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['K'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['L'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['M'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['N'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD1] = { /* UTF-8: 'Ñ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['O'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD2] = { /* UTF-8: 'Ò' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD3] = { /* UTF-8: 'Ó' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD4] = { /* UTF-8: 'Ô' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD5] = { /* UTF-8: 'Õ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD6] = { /* UTF-8: 'Ö' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD8] = { /* UTF-8: 'Ø' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,_,X,X,_),
	W10 (_,X,X,_,_,X,_,X,X,_),
	W10 (_,X,X,_,_,X,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['P'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['Q'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['R'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['S'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xDF] = { /* UTF-8: 'ß' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['T'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['U'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD9] = { /* UTF-8: 'Ù' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xDA] = { /* UTF-8: 'Ú' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xDB] = { /* UTF-8: 'Û' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xDC] = { /* UTF-8: 'Ü' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['V'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['W'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['X'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['Y'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xDD] = { /* UTF-8: 'Ý' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['Z'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['a'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE0] = { /* UTF-8: 'à' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE1] = { /* UTF-8: 'á' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE2] = { /* UTF-8: 'â' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE3] = { /* UTF-8: 'ã' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE4] = { /* UTF-8: 'ä' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE5] = { /* UTF-8: 'å' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE6] = { /* UTF-8: 'æ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,_,X,X,_,_),
	W10 (_,X,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,X,_),
	W10 (_,_,X,X,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['b'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['c'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE7] = { /* UTF-8: 'ç' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	},
    ['d'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF0] = { /* UTF-8: 'ð' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,_,_,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,_,_,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['e'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE8] = { /* UTF-8: 'è' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE9] = { /* UTF-8: 'é' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xEA] = { /* UTF-8: 'ê' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xEB] = { /* UTF-8: 'ë' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['f'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['g'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	},
    ['h'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['i'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xEC] = { /* UTF-8: 'ì' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xED] = { /* UTF-8: 'í' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xEE] = { /* UTF-8: 'î' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xEF] = { /* UTF-8: 'ï' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['j'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	},
    ['k'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['l'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['m'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,X,X,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['n'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF1] = { /* UTF-8: 'ñ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['o'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF2] = { /* UTF-8: 'ò' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF3] = { /* UTF-8: 'ó' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF4] = { /* UTF-8: 'ô' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF5] = { /* UTF-8: 'õ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF6] = { /* UTF-8: 'ö' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF8] = { /* UTF-8: 'ø' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,_,X,X,_),
	W10 (_,X,X,_,_,X,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['p'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	},
    ['q'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	},
    ['r'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,_,X,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['s'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['t'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['u'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF9] = { /* UTF-8: 'ù' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xFA] = { /* UTF-8: 'ú' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xFB] = { /* UTF-8: 'û' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xFC] = { /* UTF-8: 'ü' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['v'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['w'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['x'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    ['y'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0xFD] = { /* UTF-8: 'ý' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0xFF] = { /* UTF-8: 'ÿ' */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    ['z'] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
#if SETUP & UNICODE_FONT
    [0x100] = { /* Ā */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x101] = { /* ā */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x102] = { /* Ă */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x103] = { /* ă */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x104] = { /* Ą */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x105] = { /* ą */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,X),
	},
    [0x106] = { /* Ć */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x107] = { /* ć */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x108] = { /* Ĉ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x109] = { /* ĉ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x10A] = { /* Ċ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x10B] = { /* ċ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x10C] = { /* Č */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x10D] = { /* č */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x10E] = { /* Ď */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x10F] = { /* ď */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x110] = { /* Đ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (X,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x111] = { /* đ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,X,X,X,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x112] = { /* Ē */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x113] = { /* ē */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x114] = { /* Ĕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x115] = { /* ĕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x116] = { /* Ė */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x117] = { /* ė */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x118] = { /* Ę */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	},
    [0x119] = { /* ę */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	},
    [0x11A] = { /* Ě */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x11B] = { /* ě */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x11C] = { /* Ĝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x11D] = { /* ĝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	},
    [0x11E] = { /* Ğ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x11F] = { /* ğ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	},
    [0x120] = { /* Ġ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x121] = { /* ġ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	},
    [0x122] = { /* Ģ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x123] = { /* ģ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	},
    [0x124] = { /* Ĥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x125] = { /* ĥ */
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x126] = { /* Ħ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (X,X,X,X,X,X,X,X,X,X),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x127] = { /* ħ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (X,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x128] = { /* Ĩ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x129] = { /* ĩ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x12A] = { /* Ī */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x12B] = { /* ī */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x12C] = { /* Ĭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x12D] = { /* ĭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x12E] = { /* Į */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	},
    [0x12F] = { /* į */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	},
    [0x130] = { /* İ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x131] = { /* ı */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x132] = { /* Ĳ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (X,X,X,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x133] = { /* ĳ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,_,X,X,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (X,X,X,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	},
    [0x134] = { /* Ĵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (X,X,_,_,_,_,X,X,_,_),
	W10 (X,X,_,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x135] = { /* ĵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	},
    [0x136] = { /* Ķ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	},
    [0x137] = { /* ķ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	},
    [0x138] = { /* ĸ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x139] = { /* Ĺ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x13A] = { /* ĺ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x13B] = { /* Ļ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	},
    [0x13C] = { /* ļ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	},
    [0x13D] = { /* Ľ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x13E] = { /* ľ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x13F] = { /* Ŀ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x140] = { /* ŀ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (X,X,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x141] = { /* Ł */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (X,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x142] = { /* ł */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x143] = { /* Ń */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x144] = { /* ń */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x145] = { /* Ņ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	},
    [0x146] = { /* ņ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	},
    [0x147] = { /* Ň */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x148] = { /* ň */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x149] = { /* ŉ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	W10 (_,X,_,_,_,_,_,_,_,_),
	W10 (X,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x14A] = { /* Ŋ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	},
    [0x14B] = { /* ŋ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	},
    [0x14C] = { /* Ō */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x14D] = { /* ō */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x14E] = { /* Ŏ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x14F] = { /* ŏ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x150] = { /* Ő */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x151] = { /* ő */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x152] = { /* Œ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x153] = { /* œ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x154] = { /* Ŕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x155] = { /* ŕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,_,X,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x156] = { /* Ŗ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	},
    [0x157] = { /* ŗ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,_,X,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	},
    [0x158] = { /* Ř */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x159] = { /* ř */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,_,X,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x15A] = { /* Ś */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x15B] = { /* ś */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x15C] = { /* Ŝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x15D] = { /* ŝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x15E] = { /* Ş */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	},
    [0x15F] = { /* ş */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	},
    [0x160] = { /* Š */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x161] = { /* š */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x162] = { /* Ţ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	},
    [0x163] = { /* ţ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	},
    [0x164] = { /* Ť */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x165] = { /* ť */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x166] = { /* Ŧ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x167] = { /* ŧ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x168] = { /* Ũ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x169] = { /* ũ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x16A] = { /* Ū */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x16B] = { /* ū */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x16C] = { /* Ŭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x16D] = { /* ŭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x16E] = { /* Ů */
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,_,_,X,_,_,_),
	W10 (_,_,_,X,_,_,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x16F] = { /* ů */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,_,_,X,_,_,_),
	W10 (_,_,_,X,_,_,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x170] = { /* Ű */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x171] = { /* ű */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x172] = { /* Ų */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	},
    [0x173] = { /* ų */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	},
    [0x174] = { /* Ŵ */
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x175] = { /* ŵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x176] = { /* Ŷ */
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x177] = { /* ŷ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0x178] = { /* Ÿ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x179] = { /* Ź */
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x17A] = { /* ź */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x17B] = { /* Ż */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x17C] = { /* ż */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x17D] = { /* Ž */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x17E] = { /* ž */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x17F] = { /* ſ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x180] = { /* ƀ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (X,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x181] = { /* Ɓ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (X,_,X,X,_,X,X,_,_,_),
	W10 (X,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x182] = { /* Ƃ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x183] = { /* ƃ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x184] = { /* Ƅ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (X,X,X,_,_,_,_,_,_,_),
	W10 (X,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x185] = { /* ƅ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x186] = { /* Ɔ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x187] = { /* Ƈ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x188] = { /* ƈ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x189] = { /* Ɖ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (X,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x18A] = { /* Ɗ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (X,_,X,X,_,_,X,X,_,_),
	W10 (X,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x18B] = { /* Ƌ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x18C] = { /* ƌ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,X,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x18D] = { /* ƍ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	},
    [0x18E] = { /* Ǝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x18F] = { /* Ə */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x190] = { /* Ɛ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x191] = { /* Ƒ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x192] = { /* ƒ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x193] = { /* Ɠ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x194] = { /* Ɣ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x195] = { /* ƕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x196] = { /* Ɩ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x197] = { /* Ɨ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x198] = { /* Ƙ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,_,X,X),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x199] = { /* ƙ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x19A] = { /* ƚ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x19B] = { /* ƛ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x19C] = { /* Ɯ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x19D] = { /* Ɲ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	},
    [0x19E] = { /* ƞ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	},
    [0x19F] = { /* Ɵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1A0] = { /* Ơ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,_,_,X,X),
	W10 (_,_,X,X,_,X,X,_,X,X),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1A1] = { /* ơ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,_,_,X,X),
	W10 (_,_,X,X,_,X,X,_,X,X),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1A2] = { /* Ƣ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,X,X,X,_,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	},
    [0x1A3] = { /* ƣ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,X,X,X,_,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	},
    [0x1A4] = { /* Ƥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (X,_,X,X,_,_,X,X,_,_),
	W10 (X,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1A5] = { /* ƥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	},
    [0x1A6] = { /* Ʀ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1A7] = { /* Ƨ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1A8] = { /* ƨ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1A9] = { /* Ʃ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1AA] = { /* ƪ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,_,_,_,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	},
    [0x1AB] = { /* ƫ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0x1AC] = { /* Ƭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1AD] = { /* ƭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1AE] = { /* Ʈ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	},
    [0x1AF] = { /* Ư */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,X,X),
	W10 (_,X,X,_,_,X,X,_,X,X),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B0] = { /* ư */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,X,X),
	W10 (_,X,X,_,_,X,X,_,X,X),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B1] = { /* Ʊ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,_,_,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B2] = { /* Ʋ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B3] = { /* Ƴ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B4] = { /* ƴ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,X,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	},
    [0x1B5] = { /* Ƶ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B6] = { /* ƶ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B7] = { /* Ʒ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B8] = { /* Ƹ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B9] = { /* ƹ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0x1BA] = { /* ƺ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	},
    [0x1BB] = { /* ƻ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1BC] = { /* Ƽ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1BD] = { /* ƽ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,X,X,X,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1BE] = { /* ƾ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1BF] = { /* ƿ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	},
    [0x1C0] = { /* ǀ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1C1] = { /* ǁ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1C2] = { /* ǂ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1C3] = { /* ǃ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1C4] = { /* Ǆ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,X,X),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,_,_,X,X,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,X,X,_,_,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1C5] = { /* ǅ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,_,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,X,X,_,X,X),
	W10 (X,X,_,X,X,_,X,X,X,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,_,X,X,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,X,X,_,_,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1C6] = { /* ǆ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,X,X),
	W10 (_,_,_,X,X,_,X,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,X,X,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (_,X,X,X,X,_,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1C7] = { /* Ǉ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,X,X,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,X,X,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1C8] = { /* ǈ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,X,X,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,_,_,_,_,_,X,X,_),
	W10 (X,X,X,X,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	},
    [0x1C9] = { /* ǉ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,X,X,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (X,X,X,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	},
    [0x1CA] = { /* Ǌ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,X,_,X,X,_,X,X,_),
	W10 (X,X,X,_,X,X,_,X,X,_),
	W10 (X,X,X,_,X,X,_,X,X,_),
	W10 (X,X,X,X,X,X,_,X,X,_),
	W10 (X,X,_,X,X,X,_,X,X,_),
	W10 (X,X,_,X,X,X,_,X,X,_),
	W10 (X,X,_,X,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1CB] = { /* ǋ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,X,_,X,X,_,X,X,_),
	W10 (X,X,X,_,X,X,_,_,_,_),
	W10 (X,X,X,_,X,X,_,X,X,_),
	W10 (X,X,X,X,X,X,_,X,X,_),
	W10 (X,X,_,X,X,X,_,X,X,_),
	W10 (X,X,_,X,X,X,_,X,X,_),
	W10 (X,X,_,X,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	},
    [0x1CC] = { /* ǌ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,X,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	},
    [0x1CD] = { /* Ǎ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1CE] = { /* ǎ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1CF] = { /* Ǐ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D0] = { /* ǐ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D1] = { /* Ǒ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D2] = { /* ǒ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D3] = { /* Ǔ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D4] = { /* ǔ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D5] = { /* Ǖ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D6] = { /* ǖ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D7] = { /* Ǘ */
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D8] = { /* ǘ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D9] = { /* Ǚ */
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1DA] = { /* ǚ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1DB] = { /* Ǜ */
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1DC] = { /* ǜ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1DD] = { /* ǝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1DE] = { /* Ǟ */
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1DF] = { /* ǟ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1E0] = { /* Ǡ */
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1E1] = { /* ǡ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1E2] = { /* Ǣ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1E3] = { /* ǣ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,_,X,X,_,_),
	W10 (_,X,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,X,_),
	W10 (_,_,X,X,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1E4] = { /* Ǥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,X),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1E5] = { /* ǥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,X),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	},
    [0x1E6] = { /* Ǧ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1E7] = { /* ǧ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	},
    [0x1E8] = { /* Ǩ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1E9] = { /* ǩ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1EA] = { /* Ǫ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	},
    [0x1EB] = { /* ǫ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	},
    [0x1EC] = { /* Ǭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	},
    [0x1ED] = { /* ǭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	},
    [0x1EE] = { /* Ǯ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1EF] = { /* ǯ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0x1F0] = { /* ǰ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,X,X),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	},
    [0x1F1] = { /* Ǳ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,_,_,X,X,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,X,X,_,_,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1F2] = { /* ǲ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,_,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,_,X,X,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,X,X,_,_,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1F3] = { /* ǳ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,X,X,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,_,X,X),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (X,X,_,X,X,_,X,X,_,_),
	W10 (_,X,X,X,X,_,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1F4] = { /* Ǵ */
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1F5] = { /* ǵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	},
    [0x1F6] = { /* Ƕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1F7] = { /* Ƿ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,X,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1F8] = { /* Ǹ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1F9] = { /* ǹ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1FA] = { /* Ǻ */
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,_,_,X,_,_,_),
	W10 (_,_,_,X,_,_,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1FB] = { /* ǻ */
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,_,_,X,_,_,_),
	W10 (_,_,_,X,_,_,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1FC] = { /* Ǽ */
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1FD] = { /* ǽ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,_,X,X,_,_),
	W10 (_,X,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,X,_),
	W10 (_,_,X,X,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1FE] = { /* Ǿ */
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,_,X,X,_),
	W10 (_,X,X,_,_,X,_,X,X,_),
	W10 (_,X,X,_,_,X,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1FF] = { /* ǿ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,_,X,X,_),
	W10 (_,X,X,_,_,X,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x400 - 0x200] = { /* Ѐ */
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x401 - 0x200] = { /* Ё */
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x402 - 0x200] = { /* Ђ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x403 - 0x200] = { /* Ѓ */
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x404 - 0x200] = { /* Є */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x405 - 0x200] = { /* Ѕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x406 - 0x200] = { /* І */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x407 - 0x200] = { /* Ї */
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x408 - 0x200] = { /* Ј */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x409 - 0x200] = { /* Љ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,_,_),
	W10 (X,X,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x40A - 0x200] = { /* Њ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,_,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x40B - 0x200] = { /* Ћ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x40C - 0x200] = { /* Ќ */
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x40D - 0x200] = { /* Ѝ */
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,X,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x40E - 0x200] = { /* Ў */
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x40F - 0x200] = { /* Џ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x410 - 0x200] = { /* А */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x411 - 0x200] = { /* Б */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x412 - 0x200] = { /* В */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x413 - 0x200] = { /* Г */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x414 - 0x200] = { /* Д */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x415 - 0x200] = { /* Е */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x416 - 0x200] = { /* Ж */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x417 - 0x200] = { /* З */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x418 - 0x200] = { /* И */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,X,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x419 - 0x200] = { /* Й */
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,X,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x41A - 0x200] = { /* К */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x41B - 0x200] = { /* Л */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x41C - 0x200] = { /* М */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x41D - 0x200] = { /* Н */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x41E - 0x200] = { /* О */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x41F - 0x200] = { /* П */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x420 - 0x200] = { /* Р */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x421 - 0x200] = { /* С */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x422 - 0x200] = { /* Т */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x423 - 0x200] = { /* У */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x424 - 0x200] = { /* Ф */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x425 - 0x200] = { /* Х */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x426 - 0x200] = { /* Ц */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x427 - 0x200] = { /* Ч */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x428 - 0x200] = { /* Ш */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x429 - 0x200] = { /* Щ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x42A - 0x200] = { /* Ъ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x42B - 0x200] = { /* Ы */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x42C - 0x200] = { /* Ь */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x42D - 0x200] = { /* Э */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x42E - 0x200] = { /* Ю */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x42F - 0x200] = { /* Я */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x430 - 0x200] = { /* а */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x431 - 0x200] = { /* б */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x432 - 0x200] = { /* в */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x433 - 0x200] = { /* г */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x434 - 0x200] = { /* д */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x435 - 0x200] = { /* е */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x436 - 0x200] = { /* ж */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x437 - 0x200] = { /* з */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x438 - 0x200] = { /* и */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x439 - 0x200] = { /* й */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x43A - 0x200] = { /* к */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x43B - 0x200] = { /* л */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x43C - 0x200] = { /* м */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x43D - 0x200] = { /* н */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x43E - 0x200] = { /* о */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x43F - 0x200] = { /* п */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x440 - 0x200] = { /* р */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	},
    [0x441 - 0x200] = { /* с */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x442 - 0x200] = { /* т */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x443 - 0x200] = { /* у */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0x444 - 0x200] = { /* ф */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	},
    [0x445 - 0x200] = { /* х */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x446 - 0x200] = { /* ц */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x447 - 0x200] = { /* ч */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x448 - 0x200] = { /* ш */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x449 - 0x200] = { /* щ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x44A - 0x200] = { /* ъ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x44B - 0x200] = { /* ы */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x44C - 0x200] = { /* ь */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x44D - 0x200] = { /* э */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x44E - 0x200] = { /* ю */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x44F - 0x200] = { /* я */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x450 - 0x200] = { /* ѐ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x451 - 0x200] = { /* ё */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x452 - 0x200] = { /* ђ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	},
    [0x453 - 0x200] = { /* ѓ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x454 - 0x200] = { /* є */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x455 - 0x200] = { /* ѕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x456 - 0x200] = { /* і */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x457 - 0x200] = { /* ї */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x458 - 0x200] = { /* ј */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	},
    [0x459 - 0x200] = { /* љ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x45A - 0x200] = { /* њ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x45B - 0x200] = { /* ћ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (X,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x45C - 0x200] = { /* ќ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x45D - 0x200] = { /* ѝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x45E - 0x200] = { /* ў */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0x45F - 0x200] = { /* џ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x460 - 0x200] = { /* Ѡ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x461 - 0x200] = { /* ѡ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x462 - 0x200] = { /* Ѣ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,X,_,X,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x463 - 0x200] = { /* ѣ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x464 - 0x200] = { /* Ѥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x465 - 0x200] = { /* ѥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x466 - 0x200] = { /* Ѧ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x467 - 0x200] = { /* ѧ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x468 - 0x200] = { /* Ѩ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,_,_,X,_,_,_,_),
	W10 (_,X,_,_,X,X,X,_,_,_),
	W10 (_,X,_,_,X,_,X,_,_,_),
	W10 (_,X,_,X,X,_,X,X,_,_),
	W10 (_,X,_,X,_,_,_,X,_,_),
	W10 (_,X,_,X,_,_,_,X,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x469 - 0x200] = { /* ѩ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,_,_,X,_,_,_,_),
	W10 (_,X,_,_,X,X,X,_,_,_),
	W10 (_,X,_,_,X,_,X,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x46A - 0x200] = { /* Ѫ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x46B - 0x200] = { /* ѫ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x46C - 0x200] = { /* Ѭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,X,X,X,X,X,_,_),
	W10 (_,X,_,X,_,_,_,X,_,_),
	W10 (_,X,_,X,_,_,_,X,_,_),
	W10 (_,X,_,X,X,_,X,X,_,_),
	W10 (_,X,_,_,X,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,_,_,X,X,X,_,_,_),
	W10 (_,X,_,X,X,X,X,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x46D - 0x200] = { /* ѭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,X,X,X,X,X,_,_),
	W10 (_,X,_,X,_,_,_,X,_,_),
	W10 (_,X,_,_,X,_,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,_,_,X,X,X,_,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,X,_,X,_,X,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x46E - 0x200] = { /* Ѯ */
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x46F - 0x200] = { /* ѯ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x470 - 0x200] = { /* Ѱ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x471 - 0x200] = { /* ѱ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x472 - 0x200] = { /* Ѳ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x473 - 0x200] = { /* ѳ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x474 - 0x200] = { /* Ѵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x475 - 0x200] = { /* ѵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x476 - 0x200] = { /* Ѷ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x477 - 0x200] = { /* ѷ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x478 - 0x200] = { /* Ѹ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,_,_,_,_,_),
	W10 (X,X,_,X,X,X,X,_,X,X),
	W10 (X,X,_,X,X,X,X,_,X,X),
	W10 (X,X,_,X,X,X,X,_,X,X),
	W10 (X,X,_,X,X,_,X,_,X,X),
	W10 (X,X,_,X,X,_,X,X,X,X),
	W10 (X,X,_,X,X,_,_,X,X,X),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x479 - 0x200] = { /* ѹ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,_,X,X,_,X,X),
	W10 (X,X,_,X,X,X,X,_,X,X),
	W10 (X,X,_,X,X,X,X,_,X,X),
	W10 (X,X,_,X,X,_,X,_,X,X),
	W10 (X,X,_,X,X,_,X,X,X,X),
	W10 (X,X,_,X,X,_,_,X,X,X),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x47A - 0x200] = { /* Ѻ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x47B - 0x200] = { /* ѻ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x47C - 0x200] = { /* Ѽ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x47D - 0x200] = { /* ѽ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x47E - 0x200] = { /* Ѿ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,_,_,X,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x47F - 0x200] = { /* ѿ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,_,_,X,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x480 - 0x200] = { /* Ҁ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x481 - 0x200] = { /* ҁ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x482 - 0x200] = { /* ҂ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,X,_,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x483 - 0x200] = { /* ҃ */
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x484 - 0x200] = { /* ҄ */
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (X,X,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x485 - 0x200] = { /* ҅ */
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x486 - 0x200] = { /* ҆ */
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x487 - 0x200] = { /* ҇ */
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x488 - 0x200] = { /* ҈ */
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,X,_,_,X,_,X,_,_,_),
	W10 (X,_,X,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,_,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,_,_,_,_,_,_,_,_),
	W10 (X,_,X,_,_,_,_,_,X,_),
	W10 (_,_,_,_,X,_,_,X,_,X),
	W10 (_,_,_,X,_,X,_,_,_,_),
	},
    [0x489 - 0x200] = { /* ҉ */
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,X),
	W10 (X,_,_,_,X,X,_,_,X,_),
	W10 (X,X,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,X,X),
	W10 (_,X,_,_,X,X,_,_,_,X),
	W10 (X,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	},
    [0x48A - 0x200] = { /* Ҋ */
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,X,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x48B - 0x200] = { /* ҋ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x48C - 0x200] = { /* Ҍ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (X,X,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x48D - 0x200] = { /* ҍ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (X,X,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x48E - 0x200] = { /* Ҏ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x48F - 0x200] = { /* ҏ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,_,_,_),
	W10 (_,X,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,_,X,X,X,_,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	},
    [0x490 - 0x200] = { /* Ґ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x491 - 0x200] = { /* ґ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x492 - 0x200] = { /* Ғ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x493 - 0x200] = { /* ғ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x494 - 0x200] = { /* Ҕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x495 - 0x200] = { /* ҕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x496 - 0x200] = { /* Җ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x497 - 0x200] = { /* җ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x498 - 0x200] = { /* Ҙ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x499 - 0x200] = { /* ҙ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x49A - 0x200] = { /* Қ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x49B - 0x200] = { /* қ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x49C - 0x200] = { /* Ҝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,X,_,X,X,_,_),
	W10 (_,X,X,_,X,_,X,X,_,_),
	W10 (_,X,X,_,X,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,X,_,X,X,_,_),
	W10 (_,X,X,_,X,_,X,X,_,_),
	W10 (_,X,X,_,X,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x49D - 0x200] = { /* ҝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,_,X,_,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,_,X,X,_,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x49E - 0x200] = { /* Ҟ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (X,X,X,X,X,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x49F - 0x200] = { /* ҟ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (X,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4A0 - 0x200] = { /* Ҡ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,_,_,_,_,_,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4A1 - 0x200] = { /* ҡ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4A2 - 0x200] = { /* Ң */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4A3 - 0x200] = { /* ң */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4A4 - 0x200] = { /* Ҥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,X,X,X,X,X,X),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,X,X,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4A5 - 0x200] = { /* ҥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4A6 - 0x200] = { /* Ҧ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,_,_,_,_),
	W10 (X,X,_,_,X,X,X,X,_,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (X,X,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4A7 - 0x200] = { /* ҧ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4A8 - 0x200] = { /* Ҩ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,_,_,_,_,_),
	W10 (X,X,_,_,_,X,X,_,_,_),
	W10 (X,X,_,_,X,X,X,X,_,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,X,X,_,_,X,X,_),
	W10 (X,X,_,_,X,X,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4A9 - 0x200] = { /* ҩ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4AA - 0x200] = { /* Ҫ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4AB - 0x200] = { /* ҫ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4AC - 0x200] = { /* Ҭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4AD - 0x200] = { /* ҭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4AE - 0x200] = { /* Ү */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4AF - 0x200] = { /* ү */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4B0 - 0x200] = { /* Ұ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4B1 - 0x200] = { /* ұ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4B2 - 0x200] = { /* Ҳ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4B3 - 0x200] = { /* ҳ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4B4 - 0x200] = { /* Ҵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,X,X,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4B5 - 0x200] = { /* ҵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (X,X,X,X,X,X,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4B6 - 0x200] = { /* Ҷ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4B7 - 0x200] = { /* ҷ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4B8 - 0x200] = { /* Ҹ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,_,_,X,X,_),
	W10 (_,_,_,_,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4B9 - 0x200] = { /* ҹ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,X,X,_,X,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,_,_,X,X,_),
	W10 (_,_,_,_,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4BA - 0x200] = { /* Һ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4BB - 0x200] = { /* һ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4BC - 0x200] = { /* Ҽ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (X,_,X,X,_,_,_,X,X,_),
	W10 (X,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4BD - 0x200] = { /* ҽ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (X,_,_,X,X,_,_,X,X,_),
	W10 (X,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4BE - 0x200] = { /* Ҿ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (X,_,X,X,_,_,_,X,X,_),
	W10 (X,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4BF - 0x200] = { /* ҿ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (X,_,_,X,X,_,_,X,X,_),
	W10 (X,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,_,_,X,X,_,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4C0 - 0x200] = { /* Ӏ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4C1 - 0x200] = { /* Ӂ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4C2 - 0x200] = { /* ӂ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4C3 - 0x200] = { /* Ӄ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4C4 - 0x200] = { /* ӄ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4C5 - 0x200] = { /* Ӆ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4C6 - 0x200] = { /* ӆ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4C7 - 0x200] = { /* Ӈ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4C8 - 0x200] = { /* ӈ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4C9 - 0x200] = { /* Ӊ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4CA - 0x200] = { /* ӊ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4CB - 0x200] = { /* Ӌ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4CC - 0x200] = { /* ӌ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4CD - 0x200] = { /* Ӎ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4CE - 0x200] = { /* ӎ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,_,_,X,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,X),
	W10 (_,_,_,_,_,_,_,_,X,X),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4CF - 0x200] = { /* ӏ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4D0 - 0x200] = { /* Ӑ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4D1 - 0x200] = { /* ӑ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4D2 - 0x200] = { /* Ӓ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4D3 - 0x200] = { /* ӓ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4D4 - 0x200] = { /* Ӕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,X,X,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,_,X,X,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,_,_,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4D5 - 0x200] = { /* ӕ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,_,X,X,_,_),
	W10 (_,X,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,X,X,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,_,X,X,_,_,X,_),
	W10 (_,_,X,X,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4D6 - 0x200] = { /* Ӗ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4D7 - 0x200] = { /* ӗ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4D8 - 0x200] = { /* Ә */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4D9 - 0x200] = { /* ә */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4DA - 0x200] = { /* Ӛ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4DB - 0x200] = { /* ӛ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,_,_,_),
	W10 (_,X,X,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4DC - 0x200] = { /* Ӝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4DD - 0x200] = { /* ӝ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4DE - 0x200] = { /* Ӟ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4DF - 0x200] = { /* ӟ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,X,X,X,X,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4E0 - 0x200] = { /* Ӡ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4E1 - 0x200] = { /* ӡ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0x4E2 - 0x200] = { /* Ӣ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,X,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4E3 - 0x200] = { /* ӣ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4E4 - 0x200] = { /* Ӥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,X,X,X,_),
	W10 (_,X,X,X,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4E5 - 0x200] = { /* ӥ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,X,X,X,_),
	W10 (_,X,X,_,_,X,X,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,X,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4E6 - 0x200] = { /* Ӧ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4E7 - 0x200] = { /* ӧ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4E8 - 0x200] = { /* Ө */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4E9 - 0x200] = { /* ө */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4EA - 0x200] = { /* Ӫ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4EB - 0x200] = { /* ӫ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4EC - 0x200] = { /* Ӭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4ED - 0x200] = { /* ӭ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4EE - 0x200] = { /* Ӯ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4EF - 0x200] = { /* ӯ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0x4F0 - 0x200] = { /* Ӱ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4F1 - 0x200] = { /* ӱ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0x4F2 - 0x200] = { /* Ӳ */
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4F3 - 0x200] = { /* ӳ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,X,_),
	W10 (_,_,_,X,X,X,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	},
    [0x4F4 - 0x200] = { /* Ӵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4F5 - 0x200] = { /* ӵ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,X,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4F6 - 0x200] = { /* Ӷ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4F7 - 0x200] = { /* ӷ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,_,_,_),
	W10 (_,X,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4F8 - 0x200] = { /* Ӹ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4F9 - 0x200] = { /* ӹ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,_,X,X,_,X,X,_),
	W10 (_,X,X,X,X,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4FA - 0x200] = { /* Ӻ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (X,X,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4FB - 0x200] = { /* ӻ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,X,X,X,X,X,X,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (_,_,_,X,X,_,_,_,_,_),
	W10 (X,X,X,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4FC - 0x200] = { /* Ӽ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4FD - 0x200] = { /* ӽ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,X,X,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4FE - 0x200] = { /* Ӿ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4FF - 0x200] = { /* ӿ */
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,_,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,X,X,X,_),
	W10 (_,_,_,X,X,X,X,_,_,_),
	W10 (_,_,X,X,_,_,X,X,_,_),
	W10 (_,X,X,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
#endif /* SETUP & UNICODE_FONT */
    }; /* font10x20 */
// end ucs-fonts-10x20.hex, see comment at top of this file
#endif /* INCLUDE_FONT_10x20 */

#ifdef INCLUDE_FONT_8x16
FILEPREFIX
// start unifont-5.1.20080820.hex, see comment at top of this file
#define GAPSTART 0x200
#define GAPLENGTH 0x200
#if !(SETUP & UNICODE_FONT)
const unsigned char font8x16[256][16] = {
#else
const unsigned char font8x16[0x500 - 0x200][16] = {
#endif
    [0x0] = {
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	},
    [0x1] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,X,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x2] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x3] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x5] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x6] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x7] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x10] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x11] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x12] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x13] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x14] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x15] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x16] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x17] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x18] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x19] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x81] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,X,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x82] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x83] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x84] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x85] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x86] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x87] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x88] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x89] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8A] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8B] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8C] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8D] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8E] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8F] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x90] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x91] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x92] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x93] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x94] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x95] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x96] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x97] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x98] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x99] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9A] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9B] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9C] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9D] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9E] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9F] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x7F] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,X,X,X,_,_),
	B (X,_,_,X,X,X,_,_),
	B (X,X,_,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB9] = { /* UTF-8: '¹' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB2] = { /* UTF-8: '²' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB3] = { /* UTF-8: '³' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBC] = { /* UTF-8: '¼' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBD] = { /* UTF-8: '½' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,X,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBE] = { /* UTF-8: '¾' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,_,X,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['%'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,X),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,X,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,X,X,_),
	B (_,_,X,_,X,_,_,X),
	B (_,_,X,_,X,_,_,X),
	B (_,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAA] = { /* UTF-8: 'ª' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBA] = { /* UTF-8: 'º' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB0] = { /* UTF-8: '°' */
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB7] = { /* UTF-8: '·' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['.'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [':'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [','] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	},
    [';'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['\''] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['"'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['`'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['^'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['~'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA8] = { /* UTF-8: '¨' */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB4] = { /* UTF-8: '´' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB8] = { /* UTF-8: '¸' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0xAB] = { /* UTF-8: '«' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBB] = { /* UTF-8: '»' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAC] = { /* UTF-8: '¬' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD7] = { /* UTF-8: '×' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB5] = { /* UTF-8: 'µ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,_,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	},
    ['&'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,X,_,_,X),
	B (_,X,_,_,_,X,_,X),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA7] = { /* UTF-8: '§' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB6] = { /* UTF-8: '¶' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,X,X,_,X,_),
	B (_,X,X,X,X,_,X,_),
	B (_,X,X,X,X,_,X,_),
	B (_,X,X,X,X,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['['] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [']'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['{'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['}'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['('] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [')'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['<'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['>'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['#'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['@'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,X,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['?'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBF] = { /* UTF-8: '¿' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['!'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA1] = { /* UTF-8: '¡' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA6] = { /* UTF-8: '¦' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['|'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	},
    ['+'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['-'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB1] = { /* UTF-8: '±' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF7] = { /* UTF-8: '÷' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['/'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['\\'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['_'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAD] = { /* UTF-8: '­' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAF] = { /* UTF-8: '¯' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['*'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,_,X,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['='] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA4] = { /* UTF-8: '¤' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA3] = { /* UTF-8: '£' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,_,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['$'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA2] = { /* UTF-8: '¢' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA5] = { /* UTF-8: '¥' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['0'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['1'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['2'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['3'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['4'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['5'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['6'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['7'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['8'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['9'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [' '] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA0] = { /* UTF-8: ' ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAE] = { /* UTF-8: '®' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (X,_,X,X,X,_,_,X),
	B (X,_,X,_,_,X,_,X),
	B (X,_,X,_,_,X,_,X),
	B (X,_,X,X,X,_,_,X),
	B (X,_,X,_,X,_,_,X),
	B (X,_,X,_,_,X,_,X),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA9] = { /* UTF-8: '©' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (X,_,_,X,X,_,_,X),
	B (X,_,X,_,_,X,_,X),
	B (X,_,X,_,_,_,_,X),
	B (X,_,X,_,_,_,_,X),
	B (X,_,X,_,_,X,_,X),
	B (X,_,_,X,X,_,_,X),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDE] = { /* UTF-8: 'Þ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFE] = { /* UTF-8: 'þ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	},
    ['A'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC0] = { /* UTF-8: 'À' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC1] = { /* UTF-8: 'Á' */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC2] = { /* UTF-8: 'Â' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC3] = { /* UTF-8: 'Ã' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC4] = { /* UTF-8: 'Ä' */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC5] = { /* UTF-8: 'Å' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC6] = { /* UTF-8: 'Æ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,X,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['B'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['C'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC7] = { /* UTF-8: 'Ç' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    ['D'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD0] = { /* UTF-8: 'Ð' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (X,X,X,X,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['E'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC8] = { /* UTF-8: 'È' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC9] = { /* UTF-8: 'É' */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCA] = { /* UTF-8: 'Ê' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCB] = { /* UTF-8: 'Ë' */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['F'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['G'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['H'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['I'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCC] = { /* UTF-8: 'Ì' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCD] = { /* UTF-8: 'Í' */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCE] = { /* UTF-8: 'Î' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCF] = { /* UTF-8: 'Ï' */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['J'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['K'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['L'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['M'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['N'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD1] = { /* UTF-8: 'Ñ' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['O'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD2] = { /* UTF-8: 'Ò' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD3] = { /* UTF-8: 'Ó' */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD4] = { /* UTF-8: 'Ô' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD5] = { /* UTF-8: 'Õ' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD6] = { /* UTF-8: 'Ö' */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD8] = { /* UTF-8: 'Ø' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['P'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['Q'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,X,X),
	B (_,_,_,_,_,_,_,_),
	},
    ['R'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['S'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDF] = { /* UTF-8: 'ß' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['T'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['U'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD9] = { /* UTF-8: 'Ù' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDA] = { /* UTF-8: 'Ú' */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDB] = { /* UTF-8: 'Û' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDC] = { /* UTF-8: 'Ü' */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['V'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['W'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['X'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['Y'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDD] = { /* UTF-8: 'Ý' */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['Z'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['a'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE0] = { /* UTF-8: 'à' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE1] = { /* UTF-8: 'á' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE2] = { /* UTF-8: 'â' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE3] = { /* UTF-8: 'ã' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE4] = { /* UTF-8: 'ä' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE5] = { /* UTF-8: 'å' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE6] = { /* UTF-8: 'æ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['b'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['c'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE7] = { /* UTF-8: 'ç' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    ['d'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF0] = { /* UTF-8: 'ð' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['e'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE8] = { /* UTF-8: 'è' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE9] = { /* UTF-8: 'é' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEA] = { /* UTF-8: 'ê' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEB] = { /* UTF-8: 'ë' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['f'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['g'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    ['h'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['i'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEC] = { /* UTF-8: 'ì' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xED] = { /* UTF-8: 'í' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEE] = { /* UTF-8: 'î' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEF] = { /* UTF-8: 'ï' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['j'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    ['k'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['l'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['m'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['n'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF1] = { /* UTF-8: 'ñ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['o'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF2] = { /* UTF-8: 'ò' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF3] = { /* UTF-8: 'ó' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF4] = { /* UTF-8: 'ô' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF5] = { /* UTF-8: 'õ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF6] = { /* UTF-8: 'ö' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF8] = { /* UTF-8: 'ø' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['p'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    ['q'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	},
    ['r'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['s'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['t'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['u'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF9] = { /* UTF-8: 'ù' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFA] = { /* UTF-8: 'ú' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFB] = { /* UTF-8: 'û' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFC] = { /* UTF-8: 'ü' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['v'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['w'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['x'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['y'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,X,_),
	B (_,_,_,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0xFD] = { /* UTF-8: 'ý' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,X,_),
	B (_,_,_,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0xFF] = { /* UTF-8: 'ÿ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,X,_),
	B (_,_,_,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    ['z'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
#if SETUP & UNICODE_FONT
    [0x100] = { /* Ā */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x101] = { /* ā */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x102] = { /* Ă */
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x103] = { /* ă */
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x104] = { /* Ą */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,X),
	},
    [0x105] = { /* ą */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,X),
	},
    [0x106] = { /* Ć */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x107] = { /* ć */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x108] = { /* Ĉ */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x109] = { /* ĉ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x10A] = { /* Ċ */
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x10B] = { /* ċ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x10C] = { /* Č */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x10D] = { /* č */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x10E] = { /* Ď */
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x10F] = { /* ď */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x110] = { /* Đ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (X,X,X,X,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x111] = { /* đ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x112] = { /* Ē */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x113] = { /* ē */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x114] = { /* Ĕ */
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x115] = { /* ĕ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x116] = { /* Ė */
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x117] = { /* ė */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x118] = { /* Ę */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,X,X,_),
	},
    [0x119] = { /* ę */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x11A] = { /* Ě */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x11B] = { /* ě */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x11C] = { /* Ĝ */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x11D] = { /* ĝ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x11E] = { /* Ğ */
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x11F] = { /* ğ */
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x120] = { /* Ġ */
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x121] = { /* ġ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x122] = { /* Ģ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x123] = { /* ģ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x124] = { /* Ĥ */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x125] = { /* ĥ */
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x126] = { /* Ħ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (X,X,X,X,X,X,X,X),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x127] = { /* ħ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,X,X,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x128] = { /* Ĩ */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x129] = { /* ĩ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x12A] = { /* Ī */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x12B] = { /* ī */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x12C] = { /* Ĭ */
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x12D] = { /* ĭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x12E] = { /* Į */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,X,X,_),
	},
    [0x12F] = { /* į */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,X,X,_),
	},
    [0x130] = { /* İ */
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x131] = { /* ı */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x132] = { /* Ĳ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x133] = { /* ĳ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	},
    [0x134] = { /* Ĵ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x135] = { /* ĵ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x136] = { /* Ķ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	},
    [0x137] = { /* ķ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	},
    [0x138] = { /* ĸ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x139] = { /* Ĺ */
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x13A] = { /* ĺ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x13B] = { /* Ļ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x13C] = { /* ļ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x13D] = { /* Ľ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x13E] = { /* ľ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x13F] = { /* Ŀ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x140] = { /* ŀ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x141] = { /* Ł */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x142] = { /* ł */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x143] = { /* Ń */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x144] = { /* ń */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x145] = { /* Ņ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	},
    [0x146] = { /* ņ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	},
    [0x147] = { /* Ň */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x148] = { /* ň */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x149] = { /* ŉ */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x14A] = { /* Ŋ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x14B] = { /* ŋ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x14C] = { /* Ō */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x14D] = { /* ō */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x14E] = { /* Ŏ */
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x14F] = { /* ŏ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x150] = { /* Ő */
	B (_,_,X,X,_,_,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x151] = { /* ő */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x152] = { /* Œ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,X,_,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x153] = { /* œ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x154] = { /* Ŕ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x155] = { /* ŕ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x156] = { /* Ŗ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	},
    [0x157] = { /* ŗ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	},
    [0x158] = { /* Ř */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x159] = { /* ř */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x15A] = { /* Ś */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x15B] = { /* ś */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x15C] = { /* Ŝ */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x15D] = { /* ŝ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x15E] = { /* Ş */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x15F] = { /* ş */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x160] = { /* Š */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x161] = { /* š */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x162] = { /* Ţ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x163] = { /* ţ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x164] = { /* Ť */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x165] = { /* ť */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x166] = { /* Ŧ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x167] = { /* ŧ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x168] = { /* Ũ */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x169] = { /* ũ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x16A] = { /* Ū */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x16B] = { /* ū */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x16C] = { /* Ŭ */
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x16D] = { /* ŭ */
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x16E] = { /* Ů */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x16F] = { /* ů */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x170] = { /* Ű */
	B (_,_,X,X,_,_,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x171] = { /* ű */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x172] = { /* Ų */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x173] = { /* ų */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,X),
	},
    [0x174] = { /* Ŵ */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x175] = { /* ŵ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x176] = { /* Ŷ */
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x177] = { /* ŷ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,X,_),
	B (_,_,_,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x178] = { /* Ÿ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x179] = { /* Ź */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x17A] = { /* ź */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x17B] = { /* Ż */
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x17C] = { /* ż */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x17D] = { /* Ž */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x17E] = { /* ž */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x17F] = { /* ſ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x180] = { /* ƀ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,X,X,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x181] = { /* Ɓ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,_,X,_,_,_,X,_),
	B (X,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x182] = { /* Ƃ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x183] = { /* ƃ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x184] = { /* Ƅ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x185] = { /* ƅ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x186] = { /* Ɔ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x187] = { /* Ƈ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,X),
	B (_,_,_,_,_,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x188] = { /* ƈ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,X),
	B (_,_,_,_,_,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x189] = { /* Ɖ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (X,X,X,X,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x18A] = { /* Ɗ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (X,_,X,_,_,X,_,_),
	B (X,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x18B] = { /* Ƌ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x18C] = { /* ƌ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x18D] = { /* ƍ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	},
    [0x18E] = { /* Ǝ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x18F] = { /* Ə */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x190] = { /* Ɛ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x191] = { /* Ƒ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x192] = { /* ƒ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x193] = { /* Ɠ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,X),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,X,X,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x194] = { /* Ɣ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x195] = { /* ƕ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x196] = { /* Ɩ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x197] = { /* Ɨ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x198] = { /* Ƙ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x199] = { /* ƙ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x19A] = { /* ƚ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x19B] = { /* ƛ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x19C] = { /* Ɯ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,_,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x19D] = { /* Ɲ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,_,_,X,_),
	B (_,_,X,X,_,_,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,_,X,X,_),
	B (_,_,X,_,_,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x19E] = { /* ƞ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	},
    [0x19F] = { /* Ɵ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A0] = { /* Ơ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A1] = { /* ơ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A2] = { /* Ƣ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,X,X,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	},
    [0x1A3] = { /* ƣ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,X,X,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	},
    [0x1A4] = { /* Ƥ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A5] = { /* ƥ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,X),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,_,_,X,_,_),
	B (_,X,_,X,X,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    [0x1A6] = { /* Ʀ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A7] = { /* Ƨ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A8] = { /* ƨ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A9] = { /* Ʃ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1AA] = { /* ƪ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1AB] = { /* ƫ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	},
    [0x1AC] = { /* Ƭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1AD] = { /* ƭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1AE] = { /* Ʈ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1AF] = { /* Ư */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B0] = { /* ư */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,X,X,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B1] = { /* Ʊ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B2] = { /* Ʋ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B3] = { /* Ƴ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B4] = { /* ƴ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	},
    [0x1B5] = { /* Ƶ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B6] = { /* ƶ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B7] = { /* Ʒ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B8] = { /* Ƹ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B9] = { /* ƹ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x1BA] = { /* ƺ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x1BB] = { /* ƻ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1BC] = { /* Ƽ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1BD] = { /* ƽ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1BE] = { /* ƾ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1BF] = { /* ƿ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    [0x1C0] = { /* ǀ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C1] = { /* ǁ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C2] = { /* ǂ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C3] = { /* ǃ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C4] = { /* Ǆ */
	B (_,_,_,_,_,X,_,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,X,_,_,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C5] = { /* ǅ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,_,X),
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,X,_,X,X,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,X,_,_,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C6] = { /* ǆ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,_,X),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,_,X,X,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,_,X,X,_,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C7] = { /* Ǉ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C8] = { /* ǈ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,X,X,X,_,_,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x1C9] = { /* ǉ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,X),
	B (_,X,X,_,_,_,_,X),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,X,X),
	B (_,_,X,_,_,_,_,X),
	B (_,_,X,_,_,_,_,X),
	B (_,_,X,_,_,_,_,X),
	B (_,_,X,_,_,_,_,X),
	B (_,_,X,_,_,_,_,X),
	B (_,_,X,_,_,_,_,X),
	B (X,X,X,X,X,_,_,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x1CA] = { /* Ǌ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,X,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,X,_,X,_,_,X),
	B (_,X,X,_,X,_,_,X),
	B (_,X,_,X,X,_,_,X),
	B (_,X,_,X,X,_,_,X),
	B (_,X,_,_,X,X,_,X),
	B (_,X,_,_,X,X,_,X),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1CB] = { /* ǋ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,X,_,X,_,X,X),
	B (_,X,X,_,X,_,_,X),
	B (_,X,X,_,X,_,_,X),
	B (_,X,_,X,X,_,_,X),
	B (_,X,_,X,X,_,_,X),
	B (_,X,_,X,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x1CC] = { /* ǌ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,_,_,X,X),
	B (_,X,X,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x1CD] = { /* Ǎ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1CE] = { /* ǎ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1CF] = { /* Ǐ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D0] = { /* ǐ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D1] = { /* Ǒ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D2] = { /* ǒ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D3] = { /* Ǔ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D4] = { /* ǔ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D5] = { /* Ǖ */
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D6] = { /* ǖ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D7] = { /* Ǘ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D8] = { /* ǘ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D9] = { /* Ǚ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1DA] = { /* ǚ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1DB] = { /* Ǜ */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1DC] = { /* ǜ */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1DD] = { /* ǝ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1DE] = { /* Ǟ */
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1DF] = { /* ǟ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E0] = { /* Ǡ */
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E1] = { /* ǡ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E2] = { /* Ǣ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,X,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E3] = { /* ǣ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E4] = { /* Ǥ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,X,X,X,X),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E5] = { /* ǥ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,X,X,X,X),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x1E6] = { /* Ǧ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E7] = { /* ǧ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x1E8] = { /* Ǩ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E9] = { /* ǩ */
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1EA] = { /* Ǫ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x1EB] = { /* ǫ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x1EC] = { /* Ǭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x1ED] = { /* ǭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x1EE] = { /* Ǯ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1EF] = { /* ǯ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x1F0] = { /* ǰ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x1F1] = { /* Ǳ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,X,_,_,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F2] = { /* ǲ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,X,_,X,X,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,X,_,_,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F3] = { /* ǳ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,_,X,X,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,_,X,X,_,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F4] = { /* Ǵ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F5] = { /* ǵ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x1F6] = { /* Ƕ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,X,X,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F7] = { /* Ƿ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F8] = { /* Ǹ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F9] = { /* ǹ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1FA] = { /* Ǻ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1FB] = { /* ǻ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1FC] = { /* Ǽ */
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,X,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1FD] = { /* ǽ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1FE] = { /* Ǿ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1FF] = { /* ǿ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x400 - 0x200] = { /* Ѐ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x401 - 0x200] = { /* Ё */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x402 - 0x200] = { /* Ђ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x403 - 0x200] = { /* Ѓ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x404 - 0x200] = { /* Є */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x405 - 0x200] = { /* Ѕ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x406 - 0x200] = { /* І */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x407 - 0x200] = { /* Ї */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x408 - 0x200] = { /* Ј */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x409 - 0x200] = { /* Љ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (X,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x40A - 0x200] = { /* Њ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x40B - 0x200] = { /* Ћ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x40C - 0x200] = { /* Ќ */
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x40D - 0x200] = { /* Ѝ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x40E - 0x200] = { /* Ў */
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x40F - 0x200] = { /* Џ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x410 - 0x200] = { /* А */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x411 - 0x200] = { /* Б */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x412 - 0x200] = { /* В */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x413 - 0x200] = { /* Г */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x414 - 0x200] = { /* Д */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (X,X,X,X,X,X,X,X),
	B (X,_,_,_,_,_,_,X),
	B (X,_,_,_,_,_,_,X),
	},
    [0x415 - 0x200] = { /* Е */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x416 - 0x200] = { /* Ж */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x417 - 0x200] = { /* З */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x418 - 0x200] = { /* И */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x419 - 0x200] = { /* Й */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x41A - 0x200] = { /* К */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x41B - 0x200] = { /* Л */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x41C - 0x200] = { /* М */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x41D - 0x200] = { /* Н */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x41E - 0x200] = { /* О */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x41F - 0x200] = { /* П */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x420 - 0x200] = { /* Р */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x421 - 0x200] = { /* С */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x422 - 0x200] = { /* Т */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x423 - 0x200] = { /* У */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x424 - 0x200] = { /* Ф */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x425 - 0x200] = { /* Х */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x426 - 0x200] = { /* Ц */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x427 - 0x200] = { /* Ч */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x428 - 0x200] = { /* Ш */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x429 - 0x200] = { /* Щ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,X,X,X,X,X,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x42A - 0x200] = { /* Ъ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x42B - 0x200] = { /* Ы */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x42C - 0x200] = { /* Ь */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x42D - 0x200] = { /* Э */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x42E - 0x200] = { /* Ю */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x42F - 0x200] = { /* Я */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x430 - 0x200] = { /* а */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x431 - 0x200] = { /* б */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x432 - 0x200] = { /* в */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x433 - 0x200] = { /* г */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x434 - 0x200] = { /* д */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	},
    [0x435 - 0x200] = { /* е */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x436 - 0x200] = { /* ж */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,_,X,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x437 - 0x200] = { /* з */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x438 - 0x200] = { /* и */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x439 - 0x200] = { /* й */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x43A - 0x200] = { /* к */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x43B - 0x200] = { /* л */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x43C - 0x200] = { /* м */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x43D - 0x200] = { /* н */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x43E - 0x200] = { /* о */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x43F - 0x200] = { /* п */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x440 - 0x200] = { /* р */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    [0x441 - 0x200] = { /* с */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x442 - 0x200] = { /* т */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x443 - 0x200] = { /* у */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	},
    [0x444 - 0x200] = { /* ф */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x445 - 0x200] = { /* х */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x446 - 0x200] = { /* ц */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x447 - 0x200] = { /* ч */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x448 - 0x200] = { /* ш */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x449 - 0x200] = { /* щ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,_,_,X,_,_,X,_),
	B (X,X,X,X,X,X,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x44A - 0x200] = { /* ъ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x44B - 0x200] = { /* ы */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x44C - 0x200] = { /* ь */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x44D - 0x200] = { /* э */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x44E - 0x200] = { /* ю */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x44F - 0x200] = { /* я */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x450 - 0x200] = { /* ѐ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x451 - 0x200] = { /* ё */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x452 - 0x200] = { /* ђ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x453 - 0x200] = { /* ѓ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x454 - 0x200] = { /* є */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x455 - 0x200] = { /* ѕ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x456 - 0x200] = { /* і */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x457 - 0x200] = { /* ї */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x458 - 0x200] = { /* ј */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x459 - 0x200] = { /* љ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (X,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x45A - 0x200] = { /* њ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x45B - 0x200] = { /* ћ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,X,X,_,_),
	B (_,_,X,X,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x45C - 0x200] = { /* ќ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x45D - 0x200] = { /* ѝ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x45E - 0x200] = { /* ў */
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	},
    [0x45F - 0x200] = { /* џ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	},
    [0x460 - 0x200] = { /* Ѡ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x461 - 0x200] = { /* ѡ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x462 - 0x200] = { /* Ѣ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x463 - 0x200] = { /* ѣ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x464 - 0x200] = { /* Ѥ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x465 - 0x200] = { /* ѥ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x466 - 0x200] = { /* Ѧ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,_,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x467 - 0x200] = { /* ѧ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x468 - 0x200] = { /* Ѩ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,X,_,X,X,_),
	B (_,X,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x469 - 0x200] = { /* ѩ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,X,_,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x46A - 0x200] = { /* Ѫ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x46B - 0x200] = { /* ѫ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x46C - 0x200] = { /* Ѭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,X,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,_,X,_,X,_),
	B (_,X,X,X,_,X,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,X,_,X,_,X),
	B (_,X,_,X,_,X,_,X),
	B (_,X,_,X,_,X,_,X),
	B (_,X,_,X,_,X,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x46D - 0x200] = { /* ѭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,X,X),
	B (_,X,_,X,_,_,_,X),
	B (_,X,_,_,X,_,X,_),
	B (_,X,X,X,_,X,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,X,_,X,_,X),
	B (_,X,_,X,_,X,_,X),
	B (_,X,_,X,_,X,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x46E - 0x200] = { /* Ѯ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    [0x46F - 0x200] = { /* ѯ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    [0x470 - 0x200] = { /* Ѱ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x471 - 0x200] = { /* ѱ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	},
    [0x472 - 0x200] = { /* Ѳ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x473 - 0x200] = { /* ѳ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x474 - 0x200] = { /* Ѵ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x475 - 0x200] = { /* ѵ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x476 - 0x200] = { /* Ѷ */
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x477 - 0x200] = { /* ѷ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x478 - 0x200] = { /* Ѹ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,X,X,_,_,X),
	B (_,X,_,X,X,_,_,X),
	B (_,X,_,X,X,_,_,X),
	B (_,X,_,X,_,X,_,X),
	B (_,X,_,X,_,X,X,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	},
    [0x479 - 0x200] = { /* ѹ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,X,_,_,X),
	B (_,X,_,X,X,_,_,X),
	B (_,X,_,X,X,_,_,X),
	B (_,X,_,X,_,X,_,X),
	B (_,X,_,X,_,X,X,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	},
    [0x47A - 0x200] = { /* Ѻ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x47B - 0x200] = { /* ѻ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x47C - 0x200] = { /* Ѽ */
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x47D - 0x200] = { /* ѽ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x47E - 0x200] = { /* Ѿ */
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x47F - 0x200] = { /* ѿ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x480 - 0x200] = { /* Ҁ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x481 - 0x200] = { /* ҁ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x482 - 0x200] = { /* ҂ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,_,X,_,_,_,X),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x483 - 0x200] = { /* ҃ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x484 - 0x200] = { /* ҄ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (X,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x485 - 0x200] = { /* ҅ */
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x486 - 0x200] = { /* ҆ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x487 - 0x200] = { /* ҇ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (X,_,_,_,_,_,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x488 - 0x200] = { /* ҈ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,X,_,_,X),
	B (_,_,_,_,_,_,X,_),
	},
    [0x489 - 0x200] = { /* ҉ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,_,_,X),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	},
    [0x48A - 0x200] = { /* Ҋ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x48B - 0x200] = { /* ҋ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x48C - 0x200] = { /* Ҍ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x48D - 0x200] = { /* ҍ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x48E - 0x200] = { /* Ҏ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x48F - 0x200] = { /* ҏ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,X,_,_,X,_,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    [0x490 - 0x200] = { /* Ґ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x491 - 0x200] = { /* ґ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x492 - 0x200] = { /* Ғ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x493 - 0x200] = { /* ғ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x494 - 0x200] = { /* Ҕ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x495 - 0x200] = { /* ҕ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x496 - 0x200] = { /* Җ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x497 - 0x200] = { /* җ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,_,X,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x498 - 0x200] = { /* Ҙ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x499 - 0x200] = { /* ҙ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    [0x49A - 0x200] = { /* Қ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	},
    [0x49B - 0x200] = { /* қ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	},
    [0x49C - 0x200] = { /* Ҝ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,X),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x49D - 0x200] = { /* ҝ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,X),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,X,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x49E - 0x200] = { /* Ҟ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,X,_,_,X,X),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x49F - 0x200] = { /* ҟ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,X),
	B (_,X,X,X,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4A0 - 0x200] = { /* Ҡ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,X,X),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4A1 - 0x200] = { /* ҡ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,X,X),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4A2 - 0x200] = { /* Ң */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x4A3 - 0x200] = { /* ң */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x4A4 - 0x200] = { /* Ҥ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4A5 - 0x200] = { /* ҥ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4A6 - 0x200] = { /* Ҧ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,X,X,_),
	},
    [0x4A7 - 0x200] = { /* ҧ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,X,X,_),
	},
    [0x4A8 - 0x200] = { /* Ҩ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,_,X,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4A9 - 0x200] = { /* ҩ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,_,X,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4AA - 0x200] = { /* Ҫ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x4AB - 0x200] = { /* ҫ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x4AC - 0x200] = { /* Ҭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4AD - 0x200] = { /* ҭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4AE - 0x200] = { /* Ү */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4AF - 0x200] = { /* ү */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	},
    [0x4B0 - 0x200] = { /* Ұ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4B1 - 0x200] = { /* ұ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4B2 - 0x200] = { /* Ҳ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x4B3 - 0x200] = { /* ҳ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x4B4 - 0x200] = { /* Ҵ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,X,X,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x4B5 - 0x200] = { /* ҵ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,X,X,X,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x4B6 - 0x200] = { /* Ҷ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x4B7 - 0x200] = { /* ҷ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,X),
	B (_,_,_,_,_,_,_,X),
	B (_,_,_,_,_,_,_,X),
	},
    [0x4B8 - 0x200] = { /* Ҹ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4B9 - 0x200] = { /* ҹ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4BA - 0x200] = { /* Һ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4BB - 0x200] = { /* һ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4BC - 0x200] = { /* Ҽ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4BD - 0x200] = { /* ҽ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4BE - 0x200] = { /* Ҿ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,X,X,_),
	},
    [0x4BF - 0x200] = { /* ҿ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,X,X,_),
	},
    [0x4C0 - 0x200] = { /* Ӏ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4C1 - 0x200] = { /* Ӂ */
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4C2 - 0x200] = { /* ӂ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,_,X,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4C3 - 0x200] = { /* Ӄ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x4C4 - 0x200] = { /* ӄ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x4C5 - 0x200] = { /* Ӆ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4C6 - 0x200] = { /* ӆ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4C7 - 0x200] = { /* Ӈ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x4C8 - 0x200] = { /* ӈ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,_,_),
	},
    [0x4C9 - 0x200] = { /* Ӊ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4CA - 0x200] = { /* ӊ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4CB - 0x200] = { /* Ӌ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4CC - 0x200] = { /* ӌ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4CD - 0x200] = { /* Ӎ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4CE - 0x200] = { /* ӎ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,X),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4CF - 0x200] = { /* ӏ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4D0 - 0x200] = { /* Ӑ */
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4D1 - 0x200] = { /* ӑ */
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4D2 - 0x200] = { /* Ӓ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4D3 - 0x200] = { /* ӓ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4D4 - 0x200] = { /* Ӕ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,X,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4D5 - 0x200] = { /* ӕ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,X),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4D6 - 0x200] = { /* Ӗ */
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4D7 - 0x200] = { /* ӗ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4D8 - 0x200] = { /* Ә */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4D9 - 0x200] = { /* ә */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4DA - 0x200] = { /* Ӛ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4DB - 0x200] = { /* ӛ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4DC - 0x200] = { /* Ӝ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4DD - 0x200] = { /* ӝ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,X,_,X,_,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,_,_,X),
	B (_,X,_,_,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4DE - 0x200] = { /* Ӟ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4DF - 0x200] = { /* ӟ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4E0 - 0x200] = { /* Ӡ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4E1 - 0x200] = { /* ӡ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0x4E2 - 0x200] = { /* Ӣ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4E3 - 0x200] = { /* ӣ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4E4 - 0x200] = { /* Ӥ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4E5 - 0x200] = { /* ӥ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,_,X,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,X,X,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4E6 - 0x200] = { /* Ӧ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4E7 - 0x200] = { /* ӧ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4E8 - 0x200] = { /* Ө */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4E9 - 0x200] = { /* ө */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4EA - 0x200] = { /* Ӫ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4EB - 0x200] = { /* ӫ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4EC - 0x200] = { /* Ӭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4ED - 0x200] = { /* ӭ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4EE - 0x200] = { /* Ӯ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4EF - 0x200] = { /* ӯ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	},
    [0x4F0 - 0x200] = { /* Ӱ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4F1 - 0x200] = { /* ӱ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	},
    [0x4F2 - 0x200] = { /* Ӳ */
	B (_,_,X,X,_,_,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,X),
	B (_,X,_,_,_,_,_,X),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4F3 - 0x200] = { /* ӳ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,X,X),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	},
    [0x4F4 - 0x200] = { /* Ӵ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4F5 - 0x200] = { /* ӵ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,X,_),
	B (_,_,X,X,X,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4F6 - 0x200] = { /* Ӷ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	},
    [0x4F7 - 0x200] = { /* ӷ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	},
    [0x4F8 - 0x200] = { /* Ӹ */
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4F9 - 0x200] = { /* ӹ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4FA - 0x200] = { /* Ӻ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	},
    [0x4FB - 0x200] = { /* ӻ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	},
    [0x4FC - 0x200] = { /* Ӽ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4FD - 0x200] = { /* ӽ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,_,_),
	},
    [0x4FE - 0x200] = { /* Ӿ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4FF - 0x200] = { /* ӿ */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
#endif /* SETUP & UNICODE_FONT */
    }; /* font8x16 */
// end unifont-5.1.20080820.hex, see comment at top of this file
#endif /* INCLUDE_FONT_8x16 */

#ifdef INCLUDE_FONT_8x14
FILEPREFIX
const unsigned char font8x14[256][14] = {
    [0x0] = {
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	},
    [0x1] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,X,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x2] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x3] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x5] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x6] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x7] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x10] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x11] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x12] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x13] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x14] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x15] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x16] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x17] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x18] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x19] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x81] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,X,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x82] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x83] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x84] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x85] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x86] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x87] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x88] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x89] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8A] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8B] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8C] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8D] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8E] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8F] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x90] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x91] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x92] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x93] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x94] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x95] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x96] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x97] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x98] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x99] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9A] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9B] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9C] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9D] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9E] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9F] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x7F] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,X,X,X,_,_),
	B (X,_,_,X,X,X,_,_),
	B (X,X,_,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB9] = { /* UTF-8: '¹' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB2] = { /* UTF-8: '²' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB3] = { /* UTF-8: '³' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBC] = { /* UTF-8: '¼' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBD] = { /* UTF-8: '½' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBE] = { /* UTF-8: '¾' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['%'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,_,X,X,X,_),
	B (X,X,_,_,X,_,X,_),
	B (X,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAA] = { /* UTF-8: 'ª' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBA] = { /* UTF-8: 'º' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB0] = { /* UTF-8: '°' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB7] = { /* UTF-8: '·' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['.'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [':'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [','] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    [';'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    ['\''] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['"'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['`'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['^'] = {
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['~'] = {
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,X,_,X,X,_),
	B (X,X,_,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA8] = { /* UTF-8: '¨' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB4] = { /* UTF-8: '´' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB8] = { /* UTF-8: '¸' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,_,_,_,_),
	},
    [0xAB] = { /* UTF-8: '«' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,_,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBB] = { /* UTF-8: '»' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAC] = { /* UTF-8: '¬' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD7] = { /* UTF-8: '×' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB5] = { /* UTF-8: 'µ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['&'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,X,X,X,_,_,X),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA7] = { /* UTF-8: '§' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB6] = { /* UTF-8: '¶' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,X,_,X,_,_),
	B (X,X,_,X,_,X,_,_),
	B (X,X,X,X,_,X,_,_),
	B (_,X,X,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['['] = {
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [']'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['{'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['}'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['('] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [')'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['<'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['>'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['#'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['@'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,X,X),
	B (X,X,_,X,X,X,_,X),
	B (X,X,_,X,_,X,_,X),
	B (X,X,_,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['?'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBF] = { /* UTF-8: '¿' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['!'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA1] = { /* UTF-8: '¡' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA6] = { /* UTF-8: '¦' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['|'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['+'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['-'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB1] = { /* UTF-8: '±' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF7] = { /* UTF-8: '÷' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['/'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['\\'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['_'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	},
    [0xAD] = { /* UTF-8: '­' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAF] = { /* UTF-8: '¯' */
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['*'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (X,X,_,X,X,_,X,X),
	B (X,X,_,X,X,_,X,X),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,_,X,X,_,X,X),
	B (X,X,_,X,X,_,X,X),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['='] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA4] = { /* UTF-8: '¤' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA3] = { /* UTF-8: '£' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,X,X,_),
	B (_,_,X,X,_,_,X,_),
	B (_,_,X,X,_,_,X,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['$'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,X,_,_,_,_),
	B (X,X,_,X,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,X,_,X,X,_),
	B (_,_,_,X,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA2] = { /* UTF-8: '¢' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,X,_,_,_),
	B (_,X,X,_,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA5] = { /* UTF-8: '¥' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['0'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['1'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['2'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['3'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['4'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['5'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['6'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['7'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['8'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['9'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [' '] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA0] = { /* UTF-8: ' ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAE] = { /* UTF-8: '®' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,_,_,_,_,_,X,_),
	B (X,_,X,X,X,_,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,_,X,X,X,_,X,_),
	B (X,_,X,X,_,_,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA9] = { /* UTF-8: '©' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,_,_,_,_,_,X,_),
	B (X,_,X,X,X,_,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,_,X,X,X,_,X,_),
	B (X,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDE] = { /* UTF-8: 'Þ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFE] = { /* UTF-8: 'þ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['A'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC0] = { /* UTF-8: 'À' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC1] = { /* UTF-8: 'Á' */
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC2] = { /* UTF-8: 'Â' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC3] = { /* UTF-8: 'Ã' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC4] = { /* UTF-8: 'Ä' */
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC5] = { /* UTF-8: 'Å' */
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC6] = { /* UTF-8: 'Æ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,X,X,_,_,_),
	B (X,X,_,X,X,_,_,_),
	B (X,X,_,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,_,_,_),
	B (X,X,_,X,X,_,_,_),
	B (X,X,_,X,X,X,X,_),
	B (X,X,_,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['B'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['C'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC7] = { /* UTF-8: 'Ç' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,_,_,_,_),
	},
    ['D'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD0] = { /* UTF-8: 'Ð' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (X,X,X,X,_,X,X,_),
	B (X,X,X,X,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['E'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC8] = { /* UTF-8: 'È' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC9] = { /* UTF-8: 'É' */
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCA] = { /* UTF-8: 'Ê' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCB] = { /* UTF-8: 'Ë' */
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['F'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['G'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['H'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['I'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCC] = { /* UTF-8: 'Ì' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCD] = { /* UTF-8: 'Í' */
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCE] = { /* UTF-8: 'Î' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCF] = { /* UTF-8: 'Ï' */
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['J'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['K'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,X,X,_,_,_),
	B (X,X,X,X,_,_,_,_),
	B (X,X,X,X,_,_,_,_),
	B (X,X,_,X,X,_,_,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['L'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['M'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,_,_,_,_,_,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['N'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD1] = { /* UTF-8: 'Ñ' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['O'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD2] = { /* UTF-8: 'Ò' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD3] = { /* UTF-8: 'Ó' */
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD4] = { /* UTF-8: 'Ô' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD5] = { /* UTF-8: 'Õ' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD6] = { /* UTF-8: 'Ö' */
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD8] = { /* UTF-8: 'Ø' */
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,_,X,X,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,X,X,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,X,X,_,_,_),
	B (X,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['P'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['Q'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,X,X,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['R'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['S'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDF] = { /* UTF-8: 'ß' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	},
    ['T'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['U'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD9] = { /* UTF-8: 'Ù' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDA] = { /* UTF-8: 'Ú' */
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDB] = { /* UTF-8: 'Û' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDC] = { /* UTF-8: 'Ü' */
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['V'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['W'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['X'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['Y'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDD] = { /* UTF-8: 'Ý' */
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['Z'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['a'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE0] = { /* UTF-8: 'à' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE1] = { /* UTF-8: 'á' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE2] = { /* UTF-8: 'â' */
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE3] = { /* UTF-8: 'ã' */
	B (_,_,X,_,_,_,X,_),
	B (_,X,X,X,_,X,X,_),
	B (X,X,_,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE4] = { /* UTF-8: 'ä' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE5] = { /* UTF-8: 'å' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE6] = { /* UTF-8: 'æ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,X,X,_,_,X,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,X,X,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['b'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['c'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE7] = { /* UTF-8: 'ç' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    ['d'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF0] = { /* UTF-8: 'ð' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,_,X,X,X,X,X),
	B (_,_,_,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['e'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE8] = { /* UTF-8: 'è' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE9] = { /* UTF-8: 'é' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEA] = { /* UTF-8: 'ê' */
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEB] = { /* UTF-8: 'ë' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['f'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['g'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	},
    ['h'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['i'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEC] = { /* UTF-8: 'ì' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xED] = { /* UTF-8: 'í' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEE] = { /* UTF-8: 'î' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEF] = { /* UTF-8: 'ï' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['j'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	},
    ['k'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['l'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['m'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['n'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF1] = { /* UTF-8: 'ñ' */
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,X,_,X,X,_),
	B (X,X,_,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['o'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF2] = { /* UTF-8: 'ò' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF3] = { /* UTF-8: 'ó' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF4] = { /* UTF-8: 'ô' */
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF5] = { /* UTF-8: 'õ' */
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,X,_,X,X,_),
	B (X,X,_,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF6] = { /* UTF-8: 'ö' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF8] = { /* UTF-8: 'ø' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,X),
	B (_,_,_,_,_,X,X,X),
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['p'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	},
    ['q'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	},
    ['r'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['s'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['t'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['u'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF9] = { /* UTF-8: 'ù' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFA] = { /* UTF-8: 'ú' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFB] = { /* UTF-8: 'û' */
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFC] = { /* UTF-8: 'ü' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['v'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['w'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['x'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['y'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0xFD] = { /* UTF-8: 'ý' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0xFF] = { /* UTF-8: 'ÿ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    ['z'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    }; /* font8x14 */
#endif /* INCLUDE_FONT_8x14 */

#ifdef INCLUDE_FONT_8x8
FILEPREFIX
const unsigned char font8x8[256][8] = {
    [0x0] = {
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	B (X,X,X,X,X,X,X,X),
	},
    [0x1] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,X,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x2] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x3] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x5] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x6] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x7] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x10] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x11] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x12] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x13] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x14] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x15] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x16] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x17] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x18] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x19] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F] = {
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x80] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x81] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,X,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x82] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x83] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x84] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x85] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x86] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x87] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x88] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x89] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8A] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8B] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8C] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8D] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8E] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8F] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x90] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x91] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x92] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x93] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x94] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x95] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x96] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x97] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x98] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x99] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9A] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9B] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9C] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9D] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9E] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9F] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x7F] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,X,_),
	B (X,_,_,X,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	},
    [0xB9] = { /* UTF-8: '¹' */
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB2] = { /* UTF-8: '²' */
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB3] = { /* UTF-8: '³' */
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBC] = { /* UTF-8: '¼' */
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	},
    [0xBD] = { /* UTF-8: '½' */
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,X,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,X,_,X,X,X),
	B (_,_,X,_,_,_,_,X),
	B (_,X,_,_,_,X,X,X),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,X,X),
	},
    [0xBE] = { /* UTF-8: '¾' */
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,_,_,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,X,_,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (_,X,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	},
    ['%'] = {
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,X,X,_),
	B (X,X,X,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,_,X,X,X,_),
	B (X,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	},
    [0xAA] = { /* UTF-8: 'ª' */
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBA] = { /* UTF-8: 'º' */
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB0] = { /* UTF-8: '°' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB7] = { /* UTF-8: '·' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['.'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [':'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [','] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    [';'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	},
    ['\''] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['"'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['`'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['^'] = {
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['~'] = {
	B (_,_,X,_,_,_,_,_),
	B (_,X,X,X,_,X,X,_),
	B (X,X,_,X,X,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA8] = { /* UTF-8: '¨' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB4] = { /* UTF-8: '´' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB8] = { /* UTF-8: '¸' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,_,_,_,_),
	},
    [0xAB] = { /* UTF-8: '«' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,_,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xBB] = { /* UTF-8: '»' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,X,_,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAC] = { /* UTF-8: '¬' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD7] = { /* UTF-8: '×' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB5] = { /* UTF-8: 'µ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['&'] = {
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,X,X),
	B (_,_,X,X,X,_,_,X),
	},
    [0xA7] = { /* UTF-8: '§' */
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB6] = { /* UTF-8: '¶' */
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,X,_,X,_,_),
	B (X,X,X,X,_,X,_,_),
	B (_,X,X,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,_,X,_,X,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['['] = {
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,X,X,X,_,_),
	},
    [']'] = {
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,X,X,X,_,_),
	},
    ['{'] = {
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	},
    ['}'] = {
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    ['('] = {
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	},
    [')'] = {
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    ['<'] = {
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['>'] = {
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['#'] = {
	B (_,X,X,_,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['@'] = {
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,X,X),
	B (X,X,_,X,X,X,_,X),
	B (X,X,_,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	},
    ['?'] = {
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	},
    [0xBF] = { /* UTF-8: '¿' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['!'] = {
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA1] = { /* UTF-8: '¡' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA6] = { /* UTF-8: '¦' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['|'] = {
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	},
    ['+'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['-'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB1] = { /* UTF-8: '±' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF7] = { /* UTF-8: '÷' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['/'] = {
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['\\'] = {
	B (_,X,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['_'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	},
    [0xAD] = { /* UTF-8: '­' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAF] = { /* UTF-8: '¯' */
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['*'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (X,X,_,X,X,_,X,X),
	B (X,X,X,X,X,X,X,X),
	B (_,_,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,X),
	B (X,X,_,X,X,_,X,X),
	B (_,_,_,X,X,_,_,_),
	},
    ['='] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA4] = { /* UTF-8: '¤' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA3] = { /* UTF-8: '£' */
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,_,_,X,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['$'] = {
	B (_,_,_,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,X,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,X,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA2] = { /* UTF-8: '¢' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,X,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA5] = { /* UTF-8: '¥' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['0'] = {
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['1'] = {
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['2'] = {
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['3'] = {
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['4'] = {
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['5'] = {
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['6'] = {
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['7'] = {
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,X,X,X,_,_),
	B (_,X,X,X,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['8'] = {
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['9'] = {
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [' '] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA0] = { /* UTF-8: ' ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xAE] = { /* UTF-8: '®' */
	B (_,X,X,X,X,X,_,_),
	B (X,_,_,_,_,_,X,_),
	B (X,_,X,X,X,_,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,_,X,X,_,_,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	},
    [0xA9] = { /* UTF-8: '©' */
	B (_,X,X,X,X,X,_,_),
	B (X,_,_,_,_,_,X,_),
	B (X,_,X,X,X,_,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,_,X,X,X,_,X,_),
	B (X,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDE] = { /* UTF-8: 'Þ' */
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFE] = { /* UTF-8: 'þ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['A'] = {
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC0] = { /* UTF-8: 'À' */
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,X),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC1] = { /* UTF-8: 'Á' */
	B (_,_,X,X,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC2] = { /* UTF-8: 'Â' */
	B (_,X,X,X,X,X,_,_),
	B (X,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC3] = { /* UTF-8: 'Ã' */
	B (_,X,X,_,_,X,_,_),
	B (X,_,_,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC4] = { /* UTF-8: 'Ä' */
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC5] = { /* UTF-8: 'Å' */
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC6] = { /* UTF-8: 'Æ' */
	B (_,_,X,_,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,_,X,X,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,X,X,_,_,_),
	B (X,X,_,X,X,X,X,_),
	B (X,X,_,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['B'] = {
	B (X,X,X,X,X,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['C'] = {
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC7] = { /* UTF-8: 'Ç' */
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,X,_,_,_,_),
	},
    ['D'] = {
	B (X,X,X,X,X,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD0] = { /* UTF-8: 'Ð' */
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (X,X,X,X,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['E'] = {
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC8] = { /* UTF-8: 'È' */
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,X),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC9] = { /* UTF-8: 'É' */
	B (_,_,X,X,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCA] = { /* UTF-8: 'Ê' */
	B (_,X,X,X,X,X,_,_),
	B (X,_,_,_,_,_,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCB] = { /* UTF-8: 'Ë' */
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['F'] = {
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['G'] = {
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (X,X,X,_,_,_,_,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['H'] = {
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['I'] = {
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCC] = { /* UTF-8: 'Ì' */
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCD] = { /* UTF-8: 'Í' */
	B (_,_,X,X,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCE] = { /* UTF-8: 'Î' */
	B (_,X,X,X,X,_,_,_),
	B (X,_,_,_,_,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xCF] = { /* UTF-8: 'Ï' */
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['J'] = {
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['K'] = {
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,X,X,_,_),
	B (X,X,_,X,X,_,_,_),
	B (X,X,X,X,_,_,_,_),
	B (X,X,X,X,_,_,_,_),
	B (X,X,_,X,X,X,_,_),
	B (X,X,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['L'] = {
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['M'] = {
	B (X,_,_,_,_,_,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['N'] = {
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD1] = { /* UTF-8: 'Ñ' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	},
    ['O'] = {
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD2] = { /* UTF-8: 'Ò' */
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,X,X),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD3] = { /* UTF-8: 'Ó' */
	B (_,_,X,X,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD4] = { /* UTF-8: 'Ô' */
	B (_,X,X,X,X,X,_,_),
	B (X,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD5] = { /* UTF-8: 'Õ' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD6] = { /* UTF-8: 'Ö' */
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD8] = { /* UTF-8: 'Ø' */
	B (_,_,_,_,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,X,_,_,X,X,_),
	B (_,X,X,X,X,_,_,_),
	B (X,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['P'] = {
	B (X,X,X,X,X,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['Q'] = {
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	},
    ['R'] = {
	B (X,X,X,X,X,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['S'] = {
	B (_,X,X,X,X,X,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDF] = { /* UTF-8: 'ß' */
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	},
    ['T'] = {
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['U'] = {
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD9] = { /* UTF-8: 'Ù' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	},
    [0xDA] = { /* UTF-8: 'Ú' */
	B (_,_,_,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	},
    [0xDB] = { /* UTF-8: 'Û' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	},
    [0xDC] = { /* UTF-8: 'Ü' */
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,X,_,X,X,X,_),
	B (_,X,X,X,X,X,_,_),
	},
    ['V'] = {
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['W'] = {
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['X'] = {
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['Y'] = {
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xDD] = { /* UTF-8: 'Ý' */
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,X,X,_,_,_),
	},
    ['Z'] = {
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['a'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE0] = { /* UTF-8: 'à' */
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE1] = { /* UTF-8: 'á' */
	B (_,X,X,X,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE2] = { /* UTF-8: 'â' */
	B (_,X,X,X,X,_,_,_),
	B (X,_,_,_,_,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE3] = { /* UTF-8: 'ã' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE4] = { /* UTF-8: 'ä' */
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE5] = { /* UTF-8: 'å' */
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,X,X,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE6] = { /* UTF-8: 'æ' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,X,_,_,X,_),
	B (X,X,X,X,X,X,X,_),
	B (X,X,_,X,X,_,_,_),
	B (_,X,X,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['b'] = {
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['c'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE7] = { /* UTF-8: 'ç' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	},
    ['d'] = {
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF0] = { /* UTF-8: 'ð' */
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,X,X,X),
	B (_,_,_,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['e'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE8] = { /* UTF-8: 'è' */
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,X),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE9] = { /* UTF-8: 'é' */
	B (_,X,X,X,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEA] = { /* UTF-8: 'ê' */
	B (_,_,X,X,X,X,_,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEB] = { /* UTF-8: 'ë' */
	B (_,_,X,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['f'] = {
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['g'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    ['h'] = {
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['i'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEC] = { /* UTF-8: 'ì' */
	B (_,_,X,X,X,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xED] = { /* UTF-8: 'í' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEE] = { /* UTF-8: 'î' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xEF] = { /* UTF-8: 'ï' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['j'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,X,X,X,X,_,_),
	},
    ['k'] = {
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['l'] = {
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['m'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,X,X,X,_,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['n'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF1] = { /* UTF-8: 'ñ' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['o'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF2] = { /* UTF-8: 'ò' */
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF3] = { /* UTF-8: 'ó' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF4] = { /* UTF-8: 'ô' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF5] = { /* UTF-8: 'õ' */
	B (_,_,X,X,_,_,X,_),
	B (_,X,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF6] = { /* UTF-8: 'ö' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF8] = { /* UTF-8: 'ø' */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,X),
	B (_,_,X,X,X,X,X,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,X,X,_,X,_),
	B (_,X,X,X,_,_,X,_),
	B (_,X,X,X,X,X,_,_),
	B (X,X,_,_,_,_,_,_),
	},
    ['p'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	},
    ['q'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	},
    ['r'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,X,X,X,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['s'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['t'] = {
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['u'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF9] = { /* UTF-8: 'ù' */
	B (_,_,_,X,X,X,_,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFA] = { /* UTF-8: 'ú' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFB] = { /* UTF-8: 'û' */
	B (_,_,X,X,X,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xFC] = { /* UTF-8: 'ü' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['v'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['w'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,_,_,X,X,_),
	B (X,X,_,X,_,X,X,_),
	B (X,X,X,X,X,X,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['x'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,_,_,_,X,X,_),
	B (_,X,X,_,X,X,_,_),
	B (_,_,X,X,X,_,_,_),
	B (_,X,X,_,X,X,_,_),
	B (X,X,_,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    ['y'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0xFD] = { /* UTF-8: 'ý' */
	B (_,_,_,X,X,X,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    [0xFF] = { /* UTF-8: 'ÿ' */
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,_,_,X,X,_),
	B (_,X,X,_,_,X,X,_),
	B (_,_,X,X,X,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,X,X,X,X,_,_),
	},
    ['z'] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,X,X,X,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	},
    }; /* font8x8 */
#endif /* INCLUDE_FONT_8x8 */

#undef W
#undef B
#undef X
#undef _

#endif /* USER_SUPPORT != 0 */

