/* fnthex2h.c */

/* Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#define _GNU_SOURCE
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/**  more info at : http://en.wikipedia.org/wiki/UTF-8
 ** So the first 128 characters (US-ASCII) need one byte.
 ** The next 1,920 characters need two bytes to encode.
 ** Only those 0x7FF bytes are recognised and present in the font, in 8x16 it is 32 Kbytes data.
 ** Two bytes char are encoded as: 110yyyxx 10xxxxxx
 ** Three bytes char are encoded as: 1110yyyy 10yyyyxx 10xxxxxx  but not recognised
 ** Four bytes char are encoded as: 11110zzz 10zzyyyy 10yyyyxx 10xxxxxx but not recognised
 ** Not recognised and invalid UTF8 (like 1yyyyyyy 0xxxxxxx) displayed as ISO-8859-1 or current ISO-8859- page
 **/
#define UTF8(Char)	(0xC0 | (((unsigned)Char) >> 6)), (0x80 | (((unsigned)Char) & 0x3F))

/* Define some default chars: */
#define _ 0
#define X 1
#define B(p7, p6, p5, p4, p3, p2, p1, p0) \
	((p7 << 7) | (p6 << 6) | (p5 << 5) | (p4 << 4) | (p3 << 3) | (p2 << 2) | (p1 << 1) | (p0 << 0))

#define W10(p9, p8, p7, p6, p5, p4, p3, p2, p1, p0) \
	((p9 << 9) | (p8 << 8) | (p7 << 7) | (p6 << 6) | (p5 << 5) | (p4 << 4) | (p3 << 3) | (p2 << 2) | (p1 << 1) | (p0 << 0))

/* 0x7F: box ticker, and '\0' is the "full" char used by mouse in text mode (so only 8 bit wide fonts) */
const unsigned short font8x16_del[16] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,_,X,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,X,X,X,_,_),
	B (X,_,_,X,X,X,_,_),
	B (X,X,_,X,X,_,_,_),
	B (_,X,X,X,X,_,_,_),
	B (_,_,X,X,_,_,_,_),
	B (_,_,X,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	};

const unsigned short font10x20_del[20] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,_,X,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,X,X,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,X,_,_,_),
	W10 (_,X,_,_,X,X,X,_,_,_),
	W10 (_,X,X,_,X,X,_,_,_,_),
	W10 (_,X,X,X,X,X,_,_,_,_),
	W10 (_,_,X,X,X,_,_,_,_,_),
	W10 (_,_,_,X,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	};

const unsigned short font8x16_lowctrl[32][16] = {
    [0x0] = { /* this one is never used */
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,X,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x2] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x3] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x4] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x5] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x6] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x7] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xA] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xB] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xC] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xD] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xE] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0xF] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x10] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x11] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x12] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x13] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x14] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x15] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x16] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x17] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,_,_,X,_),
	B (_,X,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x18] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x19] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1A] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1B] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1C] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1D] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,_,_),
	B (_,X,_,_,X,_,X,_),
	B (_,X,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1E] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x1F] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (X,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,_,_,_,_),
	B (_,X,_,_,X,X,X,_),
	B (_,X,_,_,X,_,_,_),
	B (_,X,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	}
    };

/* Nothing special: */
const unsigned short font8x16_highctrl[32][16] = {
    [0x80 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x81 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,X,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x82 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x83 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x84 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x85 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x86 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x87 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x88 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x89 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8A - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8B - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8C - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8D - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,_,_),
	B (X,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8E - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x8F - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,X,X,X,_),
	B (X,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x90 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x91 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,_,X,_,_),
	B (_,_,X,_,X,X,_,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x92 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x93 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x94 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x95 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x96 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x97 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,_,_,X,_),
	B (X,X,X,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,_,X,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x98 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x99 - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,_,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9A - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9B - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9C - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9D - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,_,_),
	B (_,_,X,_,X,_,X,_),
	B (X,X,X,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,_,X,_),
	B (_,_,_,_,X,X,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9E - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    [0x9F - 0x80] = {
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,_,X,_,_,_,_,_),
	B (X,X,X,_,_,_,_,_),
	B (_,_,X,_,X,X,X,_),
	B (_,_,X,_,X,_,_,_),
	B (X,X,X,_,X,_,_,_),
	B (_,_,_,_,X,X,X,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,X,_,_,_),
	B (_,_,_,_,_,_,_,_),
	B (_,_,_,_,_,_,_,_),
	},
    };

const unsigned short font10x20_lowctrl[32][20] = {
    [0x0] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x2] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x3] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x4] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x5] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x6] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x7] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xA] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xB] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xC] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xD] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xE] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0xF] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x10] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x11] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x12] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x13] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x14] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x15] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x16] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x17] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x18] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x19] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1A] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1B] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1C] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1D] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1E] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x1F] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,X,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	}    };

const unsigned short font10x20_highctrl[32][20] = {
    [0x80 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x81 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x82 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x83 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x84 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x85 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x86 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x87 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x88 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x89 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8A - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8B - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8C - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8D - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8E - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x8F - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x90 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x91 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x92 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x93 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x94 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,_,X,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x95 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x96 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x97 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,_,X,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,_,X,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x98 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x99 - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9A - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9B - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9C - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9D - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,_,_,X,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9E - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	},
    [0x9F - 0x80] = {
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,_,_,_,X,_,_,_,_,_),
	W10 (_,X,X,X,X,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,X,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,X,X,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,X,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	W10 (_,_,_,_,_,_,_,_,_,_),
	}    };

int main (int argc, char **argv)
  {
  FILE *fin, *fout;
  struct stat statbuf;
  unsigned fntheigh = 16, fntwidth = 8, maxchar = 0x7FF, gapstart = 0, gaplength = 0;
  time_t srctime;

  if (argc <= 1) {
      printf (  " Quick and dirty software to tranform a hex font file as exported by\n"
	" gbdfed to a font include file for the Gujin bootloader.\n"
	" See http://www.math.nmsu.edu/~mleisher/Software/gbdfed/ and rename 'getline' by 'Getline'.\n"
	" gbdfed can import some of the formats of Fontforge.\n"
	" Another source of 16x8 hex is http://www.unicodecharacter.com/unifont/unifont.hex.gz\n"
	" It accepts UTF8 up to char 'maxchar', and an optional gap in the sequence.\n"
	" USAGE: fnthex2h -h=heigh -w=width -m=maxchar -g=gapstart -l=gaplength <srcfile> <dstfile>\n"
	" Defaults: -h=16 -w=8 -m=0x7FF . Maximum char width 16 bits (or points).\n");
      return 0;
      }

  while (argv[1][0] == '-') {
      if (argv[1][1] == 'h' && argv[1][2] == '=' && argv[1][3] >= '0' && argv[1][3] <= '9') {
	  fntheigh = argv[1][3] - '0';
	  if (argv[1][4] >= '0' && argv[1][4] <= '9')
	      fntheigh = 10 * fntheigh + argv[1][4] - '0';
	  }
	else if (argv[1][1] == 'w' && argv[1][2] == '=' && argv[1][3] >= '0' && argv[1][3] <= '9') {
	  fntwidth = argv[1][3] - '0';
	  if (argv[1][4] >= '0' && argv[1][4] <= '9')
	      fntwidth = 10 * fntwidth + argv[1][4] - '0';
	  }
	else if (argv[1][1] == 'g' && argv[1][2] == '=' && argv[1][3] >= '0' && argv[1][3] <= '9') {
	  if (argv[1][3] == '0' && argv[1][4] == 'x') {
	      gapstart = 0;
	      char *ptr;
	      for (ptr = &argv[1][5]; *ptr; ptr++)
		  if (*ptr >= '0' && *ptr <= '9')
		      gapstart = (gapstart << 4) + *ptr - '0';
		  else if (*ptr >= 'A' && *ptr <= 'F')
		      gapstart = (gapstart << 4) + *ptr - 'A' + 10;
		  else if (*ptr >= 'a' && *ptr <= 'f')
		      gapstart = (gapstart << 4) + *ptr - 'a' + 10;
		  else {
		      printf ("Error malformed hexa number for -g=\n");
		      return -1;
		      }
	      }
	    else {
	      gapstart = 0;
	      char *ptr;
	      for (ptr = &argv[1][3]; *ptr; ptr++)
		  if (*ptr >= '0' && *ptr <= '9')
		      gapstart = 10 * gapstart + *ptr - '0';
		  else {
		      printf ("Error malformed decimal number for -g=\n");
		      return -1;
		      }
	      }
	  if (gapstart < 255) {
	      printf ("Error -g= parameter too small: %u\n", gapstart);
	      return -1;
	      }
	  }
	else if (argv[1][1] == 'l' && argv[1][2] == '=' && argv[1][3] >= '0' && argv[1][3] <= '9') {
	  if (argv[1][3] == '0' && argv[1][4] == 'x') {
	      gaplength = 0;
	      char *ptr;
	      for (ptr = &argv[1][5]; *ptr; ptr++)
		  if (*ptr >= '0' && *ptr <= '9')
		      gaplength = (gaplength << 4) + *ptr - '0';
		  else if (*ptr >= 'A' && *ptr <= 'F')
		      gaplength = (gaplength << 4) + *ptr - 'A' + 10;
		  else if (*ptr >= 'a' && *ptr <= 'f')
		      gaplength = (gaplength << 4) + *ptr - 'a' + 10;
		  else {
		      printf ("Error malformed hexa number for -l=\n");
		      return -1;
		      }
	      }
	    else {
	      gaplength = 0;
	      char *ptr;
	      for (ptr = &argv[1][3]; *ptr; ptr++)
		  if (*ptr >= '0' && *ptr <= '9')
		      gaplength = 10 * gaplength + *ptr - '0';
		  else {
		      printf ("Error malformed decimal number for -l=\n");
		      return -1;
		      }
	      }
	  if (gaplength % 128) {
	      printf ("Error -l= parameter not a multiple of 128 pagesize: %u\n", gaplength);
	      return -1;
	      }
	  }
	else if (argv[1][1] == 'm' && argv[1][2] == '=' && argv[1][3] >= '0' && argv[1][3] <= '9') {
	  if (argv[1][3] == '0' && argv[1][4] == 'x') {
	      maxchar = 0;
	      char *ptr;
	      for (ptr = &argv[1][5]; *ptr; ptr++)
		  if (*ptr >= '0' && *ptr <= '9')
		      maxchar = (maxchar << 4) + *ptr - '0';
		  else if (*ptr >= 'A' && *ptr <= 'F')
		      maxchar = (maxchar << 4) + *ptr - 'A' + 10;
		  else if (*ptr >= 'a' && *ptr <= 'f')
		      maxchar = (maxchar << 4) + *ptr - 'a' + 10;
		  else {
		      printf ("Error malformed hexa number for -m=\n");
		      return -1;
		      }
	      }
	    else {
	      maxchar = 0;
	      char *ptr;
	      for (ptr = &argv[1][3]; *ptr; ptr++)
		  if (*ptr >= '0' && *ptr <= '9')
		      maxchar = 10 * maxchar + *ptr - '0';
		  else {
		      printf ("Error malformed decimal number for -m=\n");
		      return -1;
		      }
	      }
	  if (maxchar < 255) {
	      printf ("Error -m= parameter too small: %u\n", maxchar);
	      return -1;
	      }
	  }
	else {
	  printf ("Did not understand parameter '%s', try without any parameter for help\n", argv[1]);
	  return 1;
	  }
      argv++;
      }

  if (stat(argv[1], &statbuf) != 0) {
      printf ("Error: cannot stat input file: \"%s\"\n", argv[1]);
      return 1;
      }
  srctime = statbuf.st_mtime;
  printf ("Generating a .h file for font width %u, heigh %u, max char %u\n", fntwidth, fntheigh, maxchar);

  {
//  unsigned char font[256][fntheigh * (fntwidth + 7)/8]; accept unifont 'maxchar' first chars:
//  unsigned char font[maxchar][fntheigh * (fntwidth + 7)/8];
  unsigned short font[maxchar][fntheigh];
  unsigned maxfontchar = 0;
  char * line = NULL;
  size_t len = 0;
  ssize_t read;
  unsigned idx, cpt;

  memset (font, 0, sizeof(font));
  /* Initialise the default control chars, in case they are not present in the font, or too wide: */
  if (fntwidth <= 8) {
      for (idx = 0; idx < 0x20; idx++)
	  for (cpt = 0; cpt < fntheigh; cpt++)
	      font[idx][cpt] = font8x16_lowctrl[idx][cpt];
      for (idx = 0x80; idx < 0xA0; idx++)
	  for (cpt = 0; cpt < fntheigh; cpt++)
	      font[idx][cpt] = font8x16_highctrl[idx-0x80][cpt];
      }
    else {
      for (idx = 0; idx < 0x20; idx++)
	  for (cpt = 0; cpt < fntheigh; cpt++)
	      font[idx][cpt] = font10x20_lowctrl[idx][cpt];
      for (idx = 0x80; idx < 0xA0; idx++)
	  for (cpt = 0; cpt < fntheigh; cpt++)
	      font[idx][cpt] = font10x20_highctrl[idx-0x80][cpt];
      }
  /* we need a full mouse cursor if we want text mode, i.e. 8 bits wide chars: */
  if (fntwidth <= 8)
      for (cpt = 0; cpt < fntheigh; cpt++)
	  font[0][cpt] = 0xFF;
  /* we need a tick box at index 0x7F, i.e. DEL: */
  if (fntwidth <= 8)
      for (cpt = 0; cpt < fntheigh; cpt++)
	  font[0x7F][cpt] = font8x16_del[cpt];
    else
      for (cpt = 0; cpt < fntheigh; cpt++)
	  font[0x7F][cpt] = font10x20_del[cpt];

  if ((fin = fopen (argv[1], "r")) == NULL) {
      printf ("Error: cannot open input file: \"%s\"\n", argv[1]);
      return 1;
      }

  while ((read = getline (&line, &len, fin)) != -1) {
      const char *ptr = line;
      unsigned nbchar;
      idx = 0;
      for (;;) {
	  if (*ptr >= '0' && *ptr <= '9')
	      idx = 16 * idx + *ptr++ - '0';
	  else if (*ptr >= 'A' && *ptr <= 'F')
	      idx = 16 * idx + *ptr++ - 'A' + 10;
	  else if (*ptr >= 'a' && *ptr <= 'f')
	      idx = 16 * idx + *ptr++ - 'a' + 10;
	  else if (*ptr != ':') {
	      printf ("Bad format char '%c'!\n", *ptr);
	      fclose (fin);
	      return 1;
	      }
	    else {
	      ptr++;
	      break;
	      }
	  }
      if (idx >= sizeof(font)/sizeof(font[0]))
	  continue;
      if (maxfontchar < idx)
	  maxfontchar = idx;
      if (read - (ptr - line) == 2 * fntheigh + 1) /* all 8x?? , with \0 */
	  nbchar = 2;
	else if (read - (ptr - line) == 4 * fntheigh + 1) /* with \0 */
	  nbchar = 4;
	else {
	  unsigned datalen = read - (ptr - line) - 1;
	  printf ("Bad length of data: %u! (font heigh either %u or %u)\n", datalen, datalen, datalen/2);
	  fclose (fin);
	  return 1;
	  }
      if (fntwidth <= 8 && idx == 0) {
	  printf ("Ignore char shape for char index 0x00, we need a mouse in text mode\n");
	  continue;
	  }
      if (idx == 0x7F) {
	  printf ("Ignore char shape for char index 0x7F, we need a tick box\n");
	  continue;
	  }
      unsigned char truncated = 0;
      for (cpt = 0; cpt < fntheigh; cpt++) {
	  unsigned short data = 0;
	  unsigned i;
	  for (i = 0; i < nbchar; i++)
	      if (*ptr >= '0' && *ptr <= '9')
		  data = 16 * data + *ptr++ - '0';
		else if (*ptr >= 'A' && *ptr <= 'F')
		  data = 16 * data + *ptr++ - 'A' + 10;
		else if (*ptr >= 'a' && *ptr <= 'f')
		  data = 16 * data + *ptr++ - 'a' + 10;
		else {
		  printf ("Bad number char '%c' on index 0x%X!\n", *ptr, idx);
		  fclose (fin);
		  return 1;
		  }
	  if (nbchar == 2)
	      data <<= 8;
	  if (data & ((1 << (16 - fntwidth)) - 1) && !truncated) {
	      if (idx < 0x20 || (idx >= 0x80 && idx < 0xA0)) {
		  printf ("Warning: need to truncate control font char 0x%X, use instead embedded drawing\n", idx);
		  if (fntwidth <= 8) {
		      if (idx < 0x20)
			  for (cpt = 0; cpt < fntheigh; cpt++)
			      font[idx][cpt] = font8x16_lowctrl[idx][cpt];
			else
			  for (cpt = 0; cpt < fntheigh; cpt++)
			      font[idx][cpt] = font8x16_highctrl[idx-0x80][cpt];
		      }
		    else {
		      if (idx < 0x20)
			  for (cpt = 0; cpt < fntheigh; cpt++)
			      font[idx][cpt] = font10x20_lowctrl[idx][cpt];
			else
			  for (cpt = 0; cpt < fntheigh; cpt++)
			      font[idx][cpt] = font10x20_highctrl[idx-0x80][cpt];
		      }
		  break;
		  }
		else {
		  printf ("Warning: need to truncate font char 0x%X\n", idx);
		  truncated = 1;
		  }
	      }
	  font[idx][cpt] = data >> (16 - fntwidth);
	  }
      }
  if (line)
      free (line);

  if (fclose (fin) == EOF) {
      printf ("Error: cannot close input file: %s\n", argv[1]);
      return 1;
      }

  if (stat(argv[2], &statbuf) == 0 && statbuf.st_mtime >= srctime) {
      printf ("Error: output file \"%s\" exists and is newer than input file \"%s\".\n",
		argv[2], argv[1]);
      return 1;
      }

  if ((fout = fopen (argv[2], "w")) == NULL) {
      printf ("Error: cannot open output file: \"%s\"\n", argv[2]);
      return 1;
      }

  if (!gapstart || !gaplength) {
      gapstart = gaplength = 0;
      fprintf (fout,	"#if !(SETUP & UNICODE_FONT)\n"
			"const unsigned %s font%ux%u[256][%u] = {\n"
			"#else\n"
			"const unsigned %s font%ux%u[0x%X][%u] = {\n"
			"#endif\n",
		(fntwidth > 8)? "short" : "char", fntwidth, fntheigh, fntheigh,
		(fntwidth > 8)? "short" : "char", fntwidth, fntheigh, maxfontchar + 1, fntheigh);
      }
    else {
      fprintf (fout,			"#define GAPSTART 0x%X\n#define GAPLENGTH 0x%X\n", gapstart, gaplength);
      fprintf (fout,	"#if !(SETUP & UNICODE_FONT)\n"
			"const unsigned %s font%ux%u[256][%u] = {\n"
			"#else\n"
			"const unsigned %s font%ux%u[0x%X - 0x%X][%u] = {\n"
			"#endif\n",
		(fntwidth > 8)? "short" : "char", fntwidth, fntheigh, fntheigh,
		(fntwidth > 8)? "short" : "char", fntwidth, fntheigh, maxfontchar + 1, gaplength, fntheigh);
      }

  {
  unsigned font_index;
  const unsigned char font_order[256] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,

	0x7F,  '',  '',  '',  '',  '',  '',  '%',
	 '',  '',  '',  '',  '.',  ':',  ',',  ';',
	'\'',  '"',  '`',  '^',  '~',  '',  '',  '',
	 '',  '',  '',  '',  '',  '&',  '',  '',
	 '[',  ']',  '{',  '}',  '(',  ')',  '<',  '>',
	 '#',  '@',  '?',  '',	 '!',  '',  '',  '|',
	 '+',  '-',  '',  '',  '/', '\\',  '_',  '',
	 '',  '*',  '=',  '',  '',  '$',  '',  '',
	 '0',  '1',  '2',  '3',  '4',  '5',  '6',  '7',
	 '8',  '9',  ' ', 0xA0,	 '',  '',  '',  '', /* NBSP, big/small islandic thorn */

	/* Accented letter order:
		grave, acute, circumflex, tilda, trema, round */
	 'A',  '',  '',  '',  '',  '',  '',  '',
	 'B',  'C',  '',  'D',  '',  'E',  '',  '',
	 '',  '',  'F',  'G',  'H',  'I',  '',  '',
	 '',  '',  'J',  'K',  'L',  'M',  'N',  '',
	 'O',  '',  '',  '',  '',  '',  '',  'P',
	 'Q',  'R',  'S',  '',  'T',  'U',  '',  '',
	 '',  '',  'V',  'W',  'X',  'Y',  '',  'Z',

	 'a',  '',  '',  '',  '',  '',  '',  '',
	 'b',  'c',  '',  'd',  '',  'e',  '',  '',
	 '',  '',  'f',  'g',  'h',  'i',  '',  '',
	 '',  '',  'j',  'k',	 'l',  'm',  'n',  '',
	 'o',  '',  '',  '',  '',  '',  '',  'p',
	 'q',  'r',  's',  't',	 'u',  '',  '',  '',
	 '',  'v',  'w',  'x',  'y',  '',  '',  'z'
	};

  for (font_index = 0; font_index <= maxfontchar; font_index++) {
      unsigned cpt;
      if (font_index == 256)
	  fprintf (fout, "#if SETUP & UNICODE_FONT\n");
      if (font_index >= gapstart && font_index < gapstart + gaplength)
	  continue;
      if (gapstart && font_index >= gapstart && font_index  >= sizeof(font_order)/sizeof(font_order[0]))
	  fprintf (fout, "    [0x%X - 0x%X] = { /* %c%c */ \n", font_index, gapstart, UTF8 (font_index));
	else if (font_index >= sizeof(font_order)/sizeof(font_order[0]))
	  fprintf (fout, "    [0x%X] = { /* %c%c */ \n", font_index, UTF8 (font_index));
	else if (   font_order[font_index] < 0x20
	  || (font_order[font_index] >= 0x7F && font_order[font_index] < 0xA0))
	  fprintf (fout, "    [0x%X] = {\n", font_order[font_index]);
	else if (font_order[font_index] == '\'' || font_order[font_index] == '\\')
	  fprintf (fout, "    ['\\%c'] = {\n", font_order[font_index]);
	else if (font_order[font_index] < 0x7F)
	  fprintf (fout, "    ['%c'] = {\n", font_order[font_index]);
	else // do not display 8 bits latin in file, it prevent editors like vi to load in UTF-8 mode:
//	  fprintf (fout, "    [0x%X] = { /* 8bits: '%c' UTF-8: '%c%c' */ \n", font_order[font_index], font_order[font_index], UTF8 (font_order[font_index]));
	  fprintf (fout, "    [0x%X] = { /* UTF-8: '%c%c' */ \n", font_order[font_index], UTF8 (font_order[font_index]));

      for (cpt = 0; cpt < fntheigh; cpt++) {
//	  unsigned tmp, mask = (fntwidth > 8)? 0x10000 : 0x100, width = fntwidth - 1;
	  unsigned tmp, mask = 1 << fntwidth, width = fntwidth - 1;
	  if (fntwidth <= 8)
	      fprintf (fout, "\tB (");
	    else
	      fprintf (fout, "\tW%d (", fntwidth);
	  if (font_index  >= sizeof(font_order)/sizeof(font_order[0]))
	      tmp = font[font_index][cpt];
	    else
	      tmp = font[font_order[font_index]][cpt];
	  while (width--)
	      fprintf (fout, "%c,", (tmp & (mask >>= 1))? 'X' : '_');
	  fprintf (fout, "%c),\n", (tmp & (mask >>= 1))? 'X' : '_');
	  }
      fprintf (fout, "\t},\n");
      }
  fprintf (fout, "#endif /* SETUP & UNICODE_FONT */\n");
  fprintf (fout, "    }; /* font%ux%u */\n", fntwidth, fntheigh);
  } /* font_order */

  if (fclose (fout) == EOF) {
      printf ("Error: cannot close output file: %s\n", argv[2]);
      return 1;
      }

  } /* font */
  return 0;
  }
