/* e2fs.h */
#ifndef E2FS_H
#define E2FS_H

/*
 * This code is a complete rewrite of the read-only part of E2FS
 * library, done to reduce code size and memory requirements, and
 * also increase speed in my particular conditions.
 *
 * So I need to include this for the common structure description:
 *
 * Copyright (C) 1992, 1993, 1994, 1995
 * Remy Card (card@masi.ibp.fr)
 * Laboratoire MASI - Institut Blaise Pascal
 * Universite Pierre et Marie Curie (Paris VI)
 *
 *  from
 *
 *  linux/include/linux/minix_fs.h
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *
 * And I also have to point to the complete e2fsprogs suite
 * at: http://sourceforge.net/projects/e2fsprogs/
 * or: http://e2fsprogs.sourceforge.net
 * by Theodore Ts'o (http://thunk.org/tytso/) (tytso@mit.edu).
 *
 * This rewrite is based on the structure found in e2fsprogs-1.26.
 *
 * Note that some parts of e2fsprogs may be available under LGPL,
 * my added work is only available under the GPL - not LGPL.
 */

/* Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 * This work is registered with the UK Copyright Service: Registration No:299755
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
typedef unsigned char		__u8;
typedef short			__s16;
typedef unsigned short		__u16;
typedef int			__s32;
typedef unsigned int		__u32;
typedef unsigned long long int	__u64;

typedef __u16 __le16;
typedef __u32 __le32;
typedef __u64 __le64;

/*
 * Where the master copy of the superblock is located, and how big
 * superblocks are supposed to be.  We define SUPERBLOCK_SIZE because
 * the size of the superblock structure is not necessarily trustworthy
 * (some versions have the padding set up so that the superblock is
 * 1032 bytes long).
 */
#define SUPERBLOCK_OFFSET	1024
#define SUPERBLOCK_SIZE		1024
#define EXT2_MIN_BLOCK_SIZE	1024
#define EXT2_MAX_BLOCK_SIZE	4096

/*
 * Special inodes numbers
 */
#define	EXT2_BAD_INO		 1	/* Bad blocks inode */
#define EXT2_ROOT_INO		 2	/* Root inode */
#define EXT2_ACL_IDX_INO	 3	/* ACL inode */
#define EXT2_ACL_DATA_INO	 4	/* ACL inode */
#define EXT2_BOOT_LOADER_INO	 5	/* Boot loader inode */
#define EXT2_UNDEL_DIR_INO	 6	/* Undelete directory inode */
#define EXT2_RESIZE_INO		 7	/* Reserved group descriptors inode */
#define EXT2_JOURNAL_INO	 8	/* Journal inode */

/*
 * First non-reserved inode for old ext2 filesystems
 */
#define EXT2_GOOD_OLD_FIRST_INO	11

/*
 * The second extended file system magic number
 */
#define EXT2_SUPER_MAGIC	0xEF53

/*
 * Revision levels
 */
#define EXT2_GOOD_OLD_REV	0	/* The good old (original) format */
#define EXT2_DYNAMIC_REV	1	/* V2 format w/ dynamic inode sizes */

#define EXT2_CURRENT_REV	EXT2_GOOD_OLD_REV
#define EXT2_MAX_SUPP_REV	EXT2_DYNAMIC_REV

#define EXT2_GOOD_OLD_INODE_SIZE 128

#define EXT2_NAME_LEN 255

/*
 * Structure of the super block
 */
struct ext_super_block {
/*00*/	__le32	s_inodes_count;		/* Inodes count */
	__le32	s_blocks_count_lo;	/* Blocks count */
	__le32	s_r_blocks_count_lo;	/* Reserved blocks count */
	__le32	s_free_blocks_count_lo;	/* Free blocks count */
/*10*/	__le32	s_free_inodes_count;	/* Free inodes count */
	__le32	s_first_data_block;	/* First Data Block */
	__le32	s_log_block_size;	/* Block size */
	__le32	s_obso_log_frag_size;	/* Obsoleted fragment size */
/*20*/	__le32	s_blocks_per_group;	/* # Blocks per group */
	__le32	s_obso_frags_per_group;	/* Obsoleted fragments per group */
	__le32	s_inodes_per_group;	/* # Inodes per group */
	__le32	s_mtime;		/* Mount time */
/*30*/	__le32	s_wtime;		/* Write time */
	__le16	s_mnt_count;		/* Mount count */
	__le16	s_max_mnt_count;	/* Maximal mount count */
	__le16	s_magic;		/* Magic signature */
	__le16	s_state;		/* File system state */
	__le16	s_errors;		/* Behaviour when detecting errors */
	__le16	s_minor_rev_level;	/* minor revision level */
/*40*/	__le32	s_lastcheck;		/* time of last check */
	__le32	s_checkinterval;	/* max. time between checks */
	__le32	s_creator_os;		/* OS */
	__le32	s_rev_level;		/* Revision level */
/*50*/	__le16	s_def_resuid;		/* Default uid for reserved blocks */
	__le16	s_def_resgid;		/* Default gid for reserved blocks */
	/*
	 * These fields are for EXT4_DYNAMIC_REV superblocks only.
	 *
	 * Note: the difference between the compatible feature set and
	 * the incompatible feature set is that if there is a bit set
	 * in the incompatible feature set that the kernel doesn't
	 * know about, it should refuse to mount the filesystem.
	 *
	 * e2fsck's requirements are more strict; if it doesn't know
	 * about a feature in either the compatible or incompatible
	 * feature set, it must abort and not try to meddle with
	 * things it doesn't understand...
	 */
	__le32	s_first_ino;		/* First non-reserved inode */
	__le16	s_inode_size;		/* size of inode structure */
	__le16	s_block_group_nr;	/* block group # of this superblock */
//	__le32	s_feature_compat;	/* compatible feature set */
	struct feature_compat_str {
		unsigned	dir_prealloc	: 1;
		unsigned	imagic_inodes	: 1;
		unsigned	has_journal	: 1;
		unsigned	ext_attr	: 1;
		unsigned	resize_inode	: 1;
		unsigned	dir_index	: 1;
		unsigned	reserved	: 26;
		} __attribute__ ((packed)) s_feature_compat; /* compatible feature set */
///*60*/	__le32	s_feature_incompat;	/* incompatible feature set */
	struct feature_incompat_str {
		unsigned	compression	: 1;
		unsigned	filetype	: 1;
		unsigned	recover		: 1;
		unsigned	journal_dev	: 1;
		unsigned	meta_bg	: 1;
		unsigned	unknown	: 1;
		unsigned	extents	: 1;
		unsigned	bit64	: 1;
		unsigned	mmp	: 1;
		unsigned	flex_bg	: 1;
		unsigned	reserved	: 22;
		} __attribute__ ((packed)) s_feature_incompat; /* incompatible feature set */
//	__le32	s_feature_ro_compat;	/* readonly-compatible feature set */
	struct feature_ro_compat_str {
		unsigned	sparse_super	: 1;
		unsigned	large_file	: 1;
		unsigned	btree_dir	: 1;
		unsigned	huge_file	: 1;
		unsigned	gdt_csum	: 1;
		unsigned	dir_nlink	: 1;
		unsigned	extra_isize	: 1;
		unsigned	reserved	: 25;
		} __attribute__ ((packed)) s_feature_ro_compat; /* readonly-compatible feature set */
/*68*/	__u8	s_uuid[16];		/* 128-bit uuid for volume */
/*78*/	char	s_volume_name[16];	/* volume name */
/*88*/	char	s_last_mounted[64];	/* directory where last mounted */
/*C8*/	__le32	s_algorithm_usage_bitmap; /* For compression */
	/*
	 * Performance hints.  Directory preallocation should only
	 * happen if the EXT4_FEATURE_COMPAT_DIR_PREALLOC flag is on.
	 */
	__u8	s_prealloc_blocks;	/* Nr of blocks to try to preallocate*/
	__u8	s_prealloc_dir_blocks;	/* Nr to preallocate for dirs */
	__le16	s_reserved_gdt_blocks;	/* Per group desc for online growth */
	/*
	 * Journaling support valid if EXT4_FEATURE_COMPAT_HAS_JOURNAL set.
	 */
/*D0*/	__u8	s_journal_uuid[16];	/* uuid of journal superblock */
/*E0*/	__le32	s_journal_inum;		/* inode number of journal file */
	__le32	s_journal_dev;		/* device number of journal file */
	__le32	s_last_orphan;		/* start of list of inodes to delete */
	__le32	s_hash_seed[4];		/* HTREE hash seed */
	__u8	s_def_hash_version;	/* Default hash version to use */
	__u8	s_reserved_char_pad;
	__le16	s_desc_size;		/* size of group descriptor */
/*100*/	__le32	s_default_mount_opts;
	__le32	s_first_meta_bg;	/* First metablock block group */
	__le32	s_mkfs_time;		/* When the filesystem was created */
	__le32	s_jnl_blocks[17];	/* Backup of the journal inode */
	/* 64bit support valid if EXT4_FEATURE_COMPAT_64BIT */
/*150*/	__le32	s_blocks_count_hi;	/* Blocks count */
	__le32	s_r_blocks_count_hi;	/* Reserved blocks count */
	__le32	s_free_blocks_count_hi;	/* Free blocks count */
	__le16	s_min_extra_isize;	/* All inodes have at least # bytes */
	__le16	s_want_extra_isize;	/* New inodes should reserve # bytes */
	__le32	s_flags;		/* Miscellaneous flags */
	__le16	s_raid_stride;		/* RAID stride */
	__le16	s_mmp_interval;         /* # seconds to wait in MMP checking */
	__le64	s_mmp_block;            /* Block for multi-mount protection */
	__le32	s_raid_stripe_width;    /* blocks on all data disks (N*stride)*/
	__u8	s_log_groups_per_flex;  /* FLEX_BG group size */
	__u8	s_reserved_char_pad2;
	__le16	s_reserved_pad;
	__u32	s_reserved[162];        /* Padding to the end of the block */
};

#define EXT4_EXT_MAGIC		0xf30a

/*
 * Structure of an inode on the disk
 */
struct ext_inode {
//	__le16	i_mode;		/* File mode */
    struct i_mode_str {
#if 0
	struct {
		unsigned short execute	: 1;
		unsigned short write	: 1;
		unsigned short read		: 1;
		} __attribute__ ((packed)) other, group, user;
#else
	unsigned short execute_other	: 1;
	unsigned short write_other	: 1;
	unsigned short read_other	: 1;
	unsigned short execute_group	: 1;
	unsigned short write_group	: 1;
	unsigned short read_group	: 1;
	unsigned short execute_user	: 1;
	unsigned short write_user	: 1;
	unsigned short read_user	: 1;
#endif
	unsigned short vtx		: 1;
	unsigned short gid		: 1;
	unsigned short uid		: 1;
	enum {
		fmt_fifo = 1,
		fmt_chr = 2,
		fmt_dir = 4,
		fmt_blk = 6,
		fmt_reg = 8,
		fmt_lnk = 10,
		fmt_sock = 12
		} fmt : 4;
	} __attribute__ ((packed)) i_mode;	/* File mode */
	__le16	i_uid;		/* Low 16 bits of Owner Uid */
	__le32	i_size_lo;	/* Size in bytes */
	__le32	i_atime;	/* Access time */
	__le32	i_ctime;	/* Inode Change time */
	__le32	i_mtime;	/* Modification time */
	__le32	i_dtime;	/* Deletion Time */
	__le16	i_gid;		/* Low 16 bits of Group Id */
	__le16	i_links_count;	/* Links count */
	__le32	i_blocks_lo;	/* Blocks count */
//	__le32	i_flags;	/* File flags */
	struct {
		unsigned	EXT4_SECRM_FL	: 1;
		unsigned	EXT4_UNRM_FL	: 1;
		unsigned	EXT4_COMPR_FL	: 1;
		unsigned	EXT4_SYNC_FL	: 1;
		unsigned	EXT4_IMMUTABLE_FL	: 1;
		unsigned	EXT4_APPEND_FL	: 1;
		unsigned	EXT4_NODUMP_FL	: 1;
		unsigned	EXT4_NOATIME_FL	: 1;
		unsigned	EXT4_DIRTY_FL	: 1;
		unsigned	EXT4_COMPRBLK_FL	: 1;
		unsigned	EXT4_NOCOMPR_FL	: 1;
		unsigned	EXT4_ECOMPR_FL	: 1;
		unsigned	EXT4_INDEX_FL	: 1;
		unsigned	EXT4_IMAGIC_FL	: 1;
		unsigned	EXT4_JOURNAL_DATA_FL	: 1;
		unsigned	EXT4_NOTAIL_FL	: 1;
		unsigned	EXT4_DIRSYNC_FL	: 1;
		unsigned	EXT4_TOPDIR_FL	: 1;
		unsigned	EXT4_HUGE_FILE_FL	: 1;
		unsigned	EXT4_EXTENTS_FL	: 1;
		unsigned	EXT4_EXT_MIGRATE	: 1;
		unsigned	EXT4_reserved	: 10;
		unsigned	EXT4_RESERVED_FL	: 1;
		} i_flags;
	union {
		struct {
			__le32  l_i_version;
		} linux1;
		struct {
			__u32  h_i_translator;
		} hurd1;
		struct {
			__u32  m_i_reserved1;
		} masix1;
	} osd1;				/* OS dependent 1 */
//	__le32	i_block[EXT4_N_BLOCKS];/* Pointers to blocks */
	union {
		struct {
			__u32	i_direct_block[12];
			__u32	i_simple_indirect_block;
			__u32	i_double_indirect_block;
			__u32	i_triple_indirect_block;
		} std_block;
		struct extent_block_s {
			struct ext4_extent_header {
				__le16	eh_magic;	/* probably will support different formats */
				__le16	eh_entries;	/* number of valid entries */
				__le16	eh_max;		/* capacity of store in entries */
				__le16	eh_depth;	/* has tree real underlying blocks? */
				__le32	eh_generation;	/* generation of the tree */
			} header;
			union {
				struct ext4_extent  {
					__le32	ee_block;	/* first logical block extent covers */
					__le16	ee_len;		/* number of blocks covered by extent */
					__le16	ee_start_hi;	/* high 16 bits of physical block */
					__le32	ee_start_lo;	/* low 32 bits of physical block */
				} array[4];
				struct ext4_extent_idx {
					__le32  ei_block;       /* index covers logical blocks from 'block' */
					__le32  ei_leaf_lo;     /* pointer to the physical block of the next *
				 * level. leaf or next index could be there */
					__le16  ei_leaf_hi;     /* high 16 bits of physical block */
					__u16   ei_unused;
				} array_idx[4];
			} data;
		} extent_block;
	} blocks;
	__le32	i_generation;	/* File version (for NFS) */
	__le32	i_file_acl_lo;	/* File ACL */
	__le32	i_size_high;
	__le32	i_obso_faddr;	/* Obsoleted fragment address */
	union {
		struct {
			__le16	l_i_blocks_high; /* were l_i_reserved1 */
			__le16	l_i_file_acl_high;
			__le16	l_i_uid_high;	/* these 2 fields */
			__le16	l_i_gid_high;	/* were reserved2[0] */
			__u32	l_i_reserved2;
		} linux2;
		struct {
			__le16	h_i_reserved1;	/* Obsoleted fragment number/size which are removed in ext4 */
			__u16	h_i_mode_high;
			__u16	h_i_uid_high;
			__u16	h_i_gid_high;
			__u32	h_i_author;
		} hurd2;
		struct {
			__le16	h_i_reserved1;	/* Obsoleted fragment number/size which are removed in ext4 */
			__le16	m_i_file_acl_high;
			__u32	m_i_reserved2[2];
		} masix2;
	} osd2;				/* OS dependent 2 */
	__le16	i_extra_isize;
	__le16	i_pad1;
	__le32	i_ctime_extra;  /* extra Change time      (nsec << 2 | epoch) */
	__le32	i_mtime_extra;  /* extra Modification time(nsec << 2 | epoch) */
	__le32	i_atime_extra;  /* extra Access time      (nsec << 2 | epoch) */
	__le32	i_crtime;       /* File Creation time */
	__le32	i_crtime_extra; /* extra FileCreationtime (nsec << 2 | epoch) */
	__le32	i_version_hi;	/* high 32 bits for 64-bit version */
};

struct ext_group_desc
{
	__le32	bg_block_bitmap_lo;	/* Blocks bitmap block */
	__le32	bg_inode_bitmap_lo;	/* Inodes bitmap block */
	__le32	bg_inode_table_lo;	/* Inodes table block */
	__le16	bg_free_blocks_count;	/* Free blocks count */
	__le16	bg_free_inodes_count;	/* Free inodes count */
	__le16	bg_used_dirs_count;	/* Directories count */
	__le16	bg_flags;		/* EXT4_BG_flags (INODE_UNINIT, etc) */
	__u32	bg_reserved[2];		/* Likely block/inode bitmap checksum */
	__le16	bg_itable_unused;	/* Unused inodes count */
	__le16	bg_checksum;		/* crc16(sb_uuid+group+desc) */
	__le32	bg_block_bitmap_hi;	/* Blocks bitmap block MSB */
	__le32	bg_inode_bitmap_hi;	/* Inodes bitmap block MSB */
	__le32	bg_inode_table_hi;	/* Inodes table block MSB */
	__le16	bg_free_blocks_count_hi;/* Free blocks count MSB */
	__le16	bg_free_inodes_count_hi;/* Free inodes count MSB */
	__le16	bg_used_dirs_count_hi;	/* Directories count MSB */
	__le16	bg_itable_unused_hi;	/* Unused inodes count MSB */
	__u32	bg_reserved2[3];
};

struct ext_dir_entry {
    __u32	inode;			/* Inode number */
    __u16	rec_len;		/* Directory entry length */
    __u8	name_len;		/* Name length */
    enum E2FS_file_type {
	e2fs_ft_unknown		= 0,
	e2fs_ft_reg_file	= 1,
	e2fs_ft_dir		= 2,
	e2fs_ft_chrdev		= 3,
	e2fs_ft_blkdev		= 4,
	e2fs_ft_fifo		= 5,
	e2fs_ft_sock		= 6,
	e2fs_ft_symlink		= 7
	} file_type : 8;
    char	name[EXT2_NAME_LEN];	/* File name (variable array) */
    };

#endif /* E2FS_H */

