/* debug.h */
#ifndef DEBUG_H
#define DEBUG_H

/* Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 * This work is registered with the UK Copyright Service: Registration No:299755
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "make.h"

#if DEBUG & DEBUG_OUTPUT

void dbg_init (void);
awk_farcall (dbg_init);
#define DBG_INIT()	dbg_init()

void dbg_end (void);
awk_farcall (dbg_end);
#define DBG_END()	dbg_end()

void dbg_printf (const char *format, ...) __attribute__ ((format (printf, 1, 2)));
awk_farcall (dbg_printf);

#if !(SETUP & XDATA_SEGMENT)
#define DBG(X)		dbg_printf X /* to be used as DBG (("%d", 4)); */
#else
#define DBGstring(str)		#str
#define DBGSTRING(str)		DBGstring(str)
#define DBG(X)		dbg_xdata X /* to be used as DBG (("%d", 4)); */
#define dbg_xdata(xdatastr, ...) do { \
	static const char DBG ## __LINE__ [] __attribute__((section(".xdata.str"))) = xdatastr;		\
	static const struct { char marker; const char *str; } __attribute__((packed)) fptr = { '\xff', DBG ## __LINE__ };	\
	dbg_printf (&fptr.marker, ## __VA_ARGS__);							\
	} while (0)
//	unsigned data = 0xFF000000 | (unsigned)(DBG ## __LINE__);
//	dbg_printf ((char *)&data, ## __VA_ARGS__);
#endif
#define DBGVAR(X)		dbg_printf X /* to be used as DBG ((VARiableformat, 4)); */

#if DEBUG & DEBUG_DISK
#define DDBG DBG
#define DDBGVAR DBGVAR
#else
#define DDBG(X) /* */
#define DDBGVAR(X) /* */
#endif

#if DEBUG & DEBUG_VIDEO
#define VDBG DBG
#else
#define VDBG(X) /* */
#endif

#if DEBUG & DEBUG_SERIAL
#define SDBG DBG
#else
#define SDBG(X) /* */
#endif

#if DEBUG & DEBUG_FS
#define FDBG DBG
#else
#define FDBG(X) /* */
#endif

#if DEBUG & DEBUG_MOUSE
#define PDBG DBG
#else
#define PDBG(X) /* */
#endif

#if DEBUG & DEBUG_LOADER
#define ZDBG DBG
#define ZDBGVAR DBGVAR
#else
#define ZDBG(X) /* */
#define ZDBGVAR(X) /* */
#endif

#else	/* DEBUG_OUTPUT */

#define DBG_INIT()	/* */
#define DBG_END()	/* */
#define DBG(X)		/* */

#define UDBG(X) /* */
#define DDBG(X) /* */
#define DDBGVAR(X) /* */
#define VDBG(X) /* */
#define SDBG(X) /* */
#define FDBG(X) /* */
#define PDBG(X) /* */
#define ZDBG(X) /* */
#define ZDBGVAR(X) /* */

#endif	/* DEBUG_OUTPUT */

/*
 * The stack and bad pointer protection:
 */

extern inline void bound_stack (void)
  {
#if DEBUG & DEBUG_STACK
/*
 * limit included - but add 2 to high limit for reg16, and 4 for reg32
 * if not in bound, exception #BR generated (INT5).
 * iret from INT5 will retry the bound instruction.
 */
  asm volatile (" bound %%esp,%0 " : : "m" (STATE.stack_limit) );
#endif
  }

#if DEBUG & DEBUG_ADDR

extern inline void checkptr (const void *ptr, const char *msg)
  {
  asm volatile (
"	movl	%3,%2	\n"
"	boundl	%1,%0	\n"
"	movl	$0,%2	\n"
	:
	: "m" (STATE.data_limit), "r" (ptr),
	  "m" (STATE.BoundMsg), "ri" (msg)
	);
  }

#else /* DEBUG_ADDR */

/* Using this would leave the constant message in the code:
extern inline void checkptr (const void *ptr, char *msg) {}
   so we simply: */
#define checkptr(ptr, msg) /* */

#endif /* DEBUG_ADDR */

#endif /* DEBUG_H */
