/* cleandisk.ld */

/* The link file to create "cleandisk.kgz" utility.
 *
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

MEMORY { ram : ORIGIN = 0, LENGTH = 64K }

/* Force a link error if function __ERROR() is ever called: */
EXTERN(__ERROR)

SECTIONS {
	.text_init 0 : AT (0) {
		*(.init.text)
		. = ALIGN (32) ;
		} > ram = 0

	_sdata16 = .;
	.data : {
		*(.rodata* .data*)
		. = ALIGN (32) ;
		} > ram = 0
	.bss : {
		*(.bss*)
		*(COMMON)
		. = ALIGN (32) ;
		} > ram = 0
	_edata16 = .; /* maximum 0x1000 i.e. 4 Kb limit */

	.text 0x1000 : {
		*(.text*)
		. = ALIGN (32) ;
		} > ram = 0
	_end16 = .;

	.data_end : {
		/* This may be used one day - keep a 16 bytes block at end of file: */
		LONG(0)
		LONG(_end16)
		LONG(0)
		BYTE(0x42) /* 'B' */
		BYTE(0x49) /* 'I' */
		BYTE(0x4F) /* 'O' */
		BYTE(0x53) /* 'S' */
		} > ram = 0
	_gujin_size = .;

	.note (NOLOAD) : {
		*(.note*)
		}
	.comment (NOLOAD) : {
		*(.comment*)
		}
	.rel.dyn (NOLOAD) : {
		*(.rel.dyn*)
		}
	.eh_frame (NOLOAD) : {
		*(.eh_frame*)
		} > ram
	}
