/* boot.ld */

/* Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
 * Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
 *   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
 * E-Mail: etienne@gujin.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "make.h"

/*
 * The linker file (man/info ld):
 */
MEMORY { ram : ORIGIN = 0, LENGTH = 64K }

/* Alignment of 32 bytes, i.e. 0x20 is forced by ld after output sections */

/* Force a link error if function __ERROR() is ever called: */
EXTERN(__ERROR)

SECTIONS {
	.text 0 : AT (0) {
		/* STARTUP(boot.o)	=> gives double definition */
		boot.o(SORT(.text_start*))
		KEEP (boot.o(.text_start*));
		*(.text*)		/* GCC-3.1+ */

		__sizeof_gujin_code_in_text = . ;

#if !(SETUP & XCODE_SEGMENT)
		. = ALIGN (32) ;
		_etext = . ;
		} > ram = 0

	__sizeof_code = SIZEOF(.text);
#else /* XCODE_SEGMENT */
		. = ALIGN (32) ;
		_etext = . ;
		} > ram = 0

	.diskcode 0 : AT(SIZEOF(.text)) {
		boot.o (.diskcode_start)
		KEEP (boot.o(.diskcode_start));
		*(.diskcode*)
		__sizeof_gujin_code_in_disk = . ;
		. = ALIGN (32) ;
		} > ram = 0

	.fscode 0 : AT(SIZEOF(.text) + SIZEOF(.diskcode)) {
		boot.o (.fscode_start)
		KEEP (boot.o(.fscode_start));
		*(.fscode*)
		__sizeof_gujin_code_in_fs = . ;
		. = ALIGN (32) ;
		} > ram = 0

	.loadcode 0 : AT(SIZEOF(.text) + SIZEOF(.diskcode) + SIZEOF(.fscode)) {
		boot.o (.loadcode_start)
		KEEP (boot.o(.loadcode_start));
		*(.loadcode*)
		__sizeof_gujin_code_in_load = . ;
		. = ALIGN (32) ;
		} > ram = 0

	.usercode 0 : AT(SIZEOF(.text) + SIZEOF(.diskcode) + SIZEOF(.fscode) + SIZEOF(.loadcode)) {
		boot.o (.usercode_start)
		KEEP (boot.o(.usercode_start));
		*(.usercode*)
		__sizeof_gujin_code_in_user = . ;
		. = ALIGN (32) ;
		} > ram = 0

	__sizeof_code = SIZEOF(.text) + SIZEOF(.diskcode) + SIZEOF(.fscode) + SIZEOF(.loadcode) + SIZEOF(.usercode);
#endif /* XCODE_SEGMENT */

#if SETUP & CODE_SEGMENT

#if SETUP & XDATA_SEGMENT
	.xdata 0 : AT(__sizeof_code) {
		main.o(.xdatacode*)
		gzlib.o(.xdata*)
		font.o(.xdata*)
		. = ALIGN (8);
		*(.xdata*)
		. = ALIGN (32);
		_exdata = . ;
		__sizeof_xdata = . ;
		} > ram = 0
#else
#define __sizeof_xdata 0
#endif

#if SETUP & XSTRING_SEGMENT
	.xstring1 0 : AT(__sizeof_code + __sizeof_xdata) {
		*(.xstring1*)
		. = ALIGN (32);
		_exstring1 = . ;
		__sizeof_xstring1 = . ;
		} > ram = 0
	.xstring2 0 : AT(__sizeof_code + __sizeof_xdata + __sizeof_xstring1) {
		*(.xstring2*)
		. = ALIGN (32);
		_exstring2 = . ;
		__sizeof_xstring2 = . ;
		} > ram = 0
#define __sizeof_xstring (__sizeof_xstring1 + __sizeof_xstring2)
#else
#define __sizeof_xstring 0
#endif

	.data 0 : AT(__sizeof_code + __sizeof_xdata + __sizeof_xstring) {
		*(.fourKsegment*)

#else  /* CODE_SEGMENT */
	.data : {
#endif /* CODE_SEGMENT */
		_srodata = . ;

		reloc_text_start = . ;
		*(reloc_text_section_*)
		reloc_text_nb = (. - reloc_text_start) / 4;
		reloc_diskcode_start = . ;
		*(reloc_diskcode_section_*)
		reloc_diskcode_nb = (. - reloc_diskcode_start) / 4;
		reloc_fscode_start = . ;
		*(reloc_fscode_section_*)
		reloc_fscode_nb = (. - reloc_fscode_start) / 4;
		reloc_loadcode_start = . ;
		*(reloc_loadcode_section_*)
		reloc_loadcode_nb = (. - reloc_loadcode_start) / 4;
		reloc_usercode_start = . ;
		*(reloc_usercode_section_*)
		reloc_usercode_nb = (. - reloc_usercode_start) / 4;
		reloc_xdata_start = . ;
		*(reloc_xdata_section_*)
		reloc_xdata_nb = (. - reloc_xdata_start) / 4;
		*(reloc_paramcode_section)
		__sizeof_reloc_table = . - reloc_text_start ;

		*(.rodata*)
		. = ALIGN (32) ;
		_erodata = . ;

		__sizeof_constants = _erodata - _srodata ;

		_end = . ;
		_sdata = . ;
		*(.data)
		. = ALIGN (32);
		_sbss = . ;

		__sizeof_inited_data = _sbss - _sdata ;

		} > ram = 0

	.bss ALIGN(0x10) (NOLOAD) : {
		*(COMMON) *(.bss)
		. = ALIGN (8);
		_edata = . ;
		} > ram = 0

		__sizeof_zeroed_data = SIZEOF (.bss) ;

	.note (NOLOAD) : {
		*(.note)
		}
	.comment (NOLOAD) : {
		*(.comment)
		}
	.stab (NOLOAD) : {
		*(.stab)
		}
	.stabstr (NOLOAD) : {
		*(.stabstr)
		}
	/* no memory region specified for loadable section `.rel.dyn' ; section size null: */
	.rel.dyn : {
		*(.rel.dyn*)
		} > ram = 0
	}

#if SETUP & XCODE_SEGMENT
NOCROSSREFS (.text .diskcode .fscode .loadcode .usercode);

diskcodeseg = SIZEOF(.text) >> 4 ;
fscodeseg = (SIZEOF(.text) + SIZEOF(.diskcode)) >> 4 ;
loadcodeseg = (SIZEOF(.text) + SIZEOF(.diskcode) + SIZEOF(.fscode)) >> 4 ;
usercodeseg = (SIZEOF(.text) + SIZEOF(.diskcode) + SIZEOF(.fscode) + SIZEOF(.loadcode)) >> 4 ;

_edisktext = SIZEOF(.diskcode);	/* used in .text, defined here because NOCROSSREFS */
_efstext = SIZEOF(.fscode);	/* used in .text, defined here because NOCROSSREFS */
_eloadtext = SIZEOF(.loadcode);	/* used in .text, defined here because NOCROSSREFS */
_eusertext = SIZEOF(.usercode);	/* used in .text, defined here because NOCROSSREFS */
#endif /* XCODE_SEGMENT */

#if SETUP & XDATA_SEGMENT
xdataseg = __sizeof_code >> 4;
#endif

#if SETUP & XSTRING_SEGMENT
xstring1seg = (__sizeof_code + __sizeof_xdata) >> 4;
xstring2seg = (__sizeof_code + __sizeof_xdata + __sizeof_xstring1) >> 4;
#endif

#if SETUP & CODE_SEGMENT
deltaseg = (__sizeof_code + __sizeof_xdata + __sizeof_xstring) >> 4;
#endif
