# awk.cmd

# Gujin is a bootloader, it loads a Linux kernel from cold boot or DOS.
# Copyright (C) 1999-2013 Etienne Lorrain, fingerprint (2D3AF3EA):
#   2471 DF64 9DEE 41D4 C8DB 9667 E448 FF8C 2D3A F3EA
# E-Mail: etienne@gujin.org
# This work is registered with the UK Copyright Service: Registration No:299755
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2, as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# For an introduction to awk, look at http://www.ibm.com/developerworks/linux/library/l-awk1.html

BEGIN {
	nb_function_list = 0;
	nb_indirect_function_list = 0;

# Put here forced lcallw'ed functions:
	function_ptr[nb_function_list] = "fptr_memcpy"; function_list[nb_function_list++] = "memcpy";
	function_ptr[nb_function_list] = "fptr_memset"; function_list[nb_function_list++] = "memset";

# Put here indirect function pointers:
#	indirect_function_list[nb_indirect_function_list++] = "\*UI"	# UI.getkey();
}

/awk farcall/ || /awk farret/ {
	function_list[nb_function_list] = $3;
	if ($4 != "")
		function_ptr[nb_function_list] = $4;
	else
		function_ptr[nb_function_list] = "fptr_" $3;
#	if ($2 == "farret")	# keep for local calls
#		section_ptr_done_once[nb_function_list] = 1;
	nb_function_list++;
	sub ("awk", "#awk");
#	for (i in function_list) print ">>>" function_list[i] " --> " function_ptr[i];
}

/awk farptr/ {
	indirect_function_list[nb_indirect_function_list++] = "*" $3;
	sub ("awk", "#awk");
#	for (i in indirect_function_list) print ">>>" indirect_function_list[i];
}

/\.section/ {	#pattern: .section .xcode.BIOSDISK_gettype,"ax",@progbits
	split ($2, array_section, ",");
	section = array_section[1];	#pattern: .xcode.BIOSDISK_gettype
	sub (".paramcode_", ".paramcode.", section);
#	sub (".text.codeseg_memcpy", ".text.memcpy", section);	# only for GCC-2.95.3
#	sub (".text.codeseg_memset", ".text.memset", section);	# only for GCC-2.95.3
	split (section, array_function, ".");
	seg = array_function[2];	#pattern: xcode (or xdata or text or paramcode)
	fct = array_function[3];	#pattern: BIOSDISK_gettype
	for (i in function_list)
		if (function_list[i] == fct && section_ptr_done_once[i] == 0) {
			section_ptr_done_once[i] = 1;
			print "\t.section\treloc_" seg "_section_" i
#			print "\t.globl " function_ptr[i];
			print "\t.weak " function_ptr[i];
			print function_ptr[i] ":\t.long " fct;
			print "\t.previous";
			}
#	print ">>>Change to function " fct " in segment " seg;
}

/.globl/ {
	for (i in function_list)
		if (function_list[i] == $2)
			sub (".globl", "#awk .globl");
}

{
	if ($1 == "call" || $1 == "ret") {
		for (i in function_list) {
			if (function_list[i] == $2) {
				sub ("call", "lcallw");
				sub ($2, "*" function_ptr[i]);
				}
			if (function_list[i] == fct)
				sub ("ret", "lretw");
			}
		for (i in indirect_function_list)
			if (indirect_function_list[i] == $2)
				sub ("call", "lcallw");
		}
	sub ( "\t.align 32" , "\t.align 4" );
	print $0;
}
